/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * X-range series
 *
 * (c) 2010-2021 Torstein Honsi, Lars A. V. Cabrera
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/xrange",["highcharts"],function(e){return t(e),t.Highcharts=e,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var e=t?t._modules:{};function i(t,e,i,s){t.hasOwnProperty(e)||(t[e]=s.apply(null,i),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:t[e]}})))}i(e,"Series/XRange/XRangeSeriesDefaults.js",[e["Core/Utilities.js"]],function(t){let{correctFloat:e,isNumber:i,isObject:s}=t;return{colorByPoint:!0,dataLabels:{formatter:function(){let t=this.point.partialFill;if(s(t)&&(t=t.amount),i(t)&&t>0)return e(100*t)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 0.8em">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0}}),i(e,"Series/XRange/XRangePoint.js",[e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"]],function(t,e){let{column:{prototype:{pointClass:i}}}=t.seriesTypes,{extend:s}=e;class o extends i{constructor(){super(...arguments),this.options=void 0,this.series=void 0}static getColorByCategory(t,e){let i=t.options.colors||t.chart.options.colors,s=i?i.length:t.chart.options.chart.colorCount,o=e.y%s,r=i&&i[o];return{colorIndex:o,color:r}}resolveColor(){let t=this.series;if(t.options.colorByPoint&&!this.options.color){let e=o.getColorByCategory(t,this);t.chart.styledMode||(this.color=e.color),this.options.colorIndex||(this.colorIndex=e.colorIndex)}else this.color||(this.color=t.color)}init(){return super.init.apply(this,arguments),this.y||(this.y=0),this}setState(){super.setState.apply(this,arguments),this.series.drawPoint(this,this.series.getAnimationVerb())}getLabelConfig(){let t=super.getLabelConfig.call(this),e=this.series.yAxis.categories;return t.x2=this.x2,t.yCategory=this.yCategory=e&&e[this.y],t.key=this.category||this.name,t}isValid(){return"number"==typeof this.x&&"number"==typeof this.x2}}return s(o.prototype,{ttBelow:!1,tooltipDateKeys:["x","x2"]}),o}),i(e,"Series/XRange/XRangeSeries.js",[e["Core/Globals.js"],e["Core/Color/Color.js"],e["Core/Series/SeriesRegistry.js"],e["Core/Utilities.js"],e["Series/XRange/XRangeSeriesDefaults.js"],e["Series/XRange/XRangePoint.js"]],function(t,e,i,s,o,r){let{noop:a}=t,{parse:l}=e,{column:n}=i.seriesTypes,{addEvent:h,clamp:p,defined:d,extend:c,find:u,isNumber:g,isObject:f,merge:x,pick:y,relativeLength:m}=s,C=[];function A(){let t,e;if(this.isXAxis){for(let i of(t=y(this.dataMax,-Number.MAX_VALUE),this.series))if(i.x2Data)for(let s of i.x2Data)s&&s>t&&(t=s,e=!0);e&&(this.dataMax=t)}}class b extends n{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0}static compose(t){s.pushUnique(C,t)&&h(t,"afterGetSeriesExtremes",A)}init(){super.init.apply(this,arguments),this.options.stacking=void 0}getColumnMetrics(){let t=()=>{for(let t of this.chart.series){let e=t.xAxis;t.xAxis=t.yAxis,t.yAxis=e}};t();let e=super.getColumnMetrics();return t(),e}cropData(t,e,i,s){let o=super.cropData(this.x2Data,e,i,s);return o.xData=t.slice(o.start,o.end),o}findPointIndex(t){let e;let{cropStart:i,points:s}=this,{id:o}=t;if(o){let t=u(s,t=>t.id===o);e=t?t.index:void 0}if(void 0===e){let i=u(s,e=>e.x===t.x&&e.x2===t.x2&&!e.touched);e=i?i.index:void 0}return this.cropped&&g(e)&&g(i)&&e>=i&&(e-=i),e}alignDataLabel(t){let e=t.plotX;t.plotX=y(t.dlBox&&t.dlBox.centerX,t.plotX),super.alignDataLabel.apply(this,arguments),t.plotX=e}translatePoint(t){let e=this.xAxis,i=this.yAxis,s=this.columnMetrics,o=this.options,r=o.minPointLength||0,a=(t.shapeArgs&&t.shapeArgs.width||0)/2,l=this.pointXOffset=s.offset,n=y(t.x2,t.x+(t.len||0)),h=o.borderRadius,c=this.chart.plotTop,u=this.chart.plotLeft,C=t.plotX,A=e.translate(n,0,0,0,1),b=Math.abs(A-C),R=this.chart.inverted,M=y(o.borderWidth,1),v=M%2/2,w,X,S=s.offset,P=Math.round(s.width),j,D,L,B;r&&((w=r-b)<0&&(w=0),C-=w/2,A+=w/2),C=Math.max(C,-10),A=p(A,-10,e.len+10),d(t.options.pointWidth)&&(S-=(Math.ceil(t.options.pointWidth)-P)/2,P=Math.ceil(t.options.pointWidth)),o.pointPlacement&&g(t.plotY)&&i.categories&&(t.plotY=i.translate(t.y,0,1,0,1,o.pointPlacement));let F=Math.floor(Math.min(C,A))+v,I=Math.floor(Math.max(C,A))+v,E=I-F,T=Math.min(m("object"==typeof h?h.radius:h||0,P),Math.min(E,P)/2),U={x:F,y:Math.floor(t.plotY+S)+v,width:E,height:P,r:T};t.shapeArgs=U,R?t.tooltipPos[1]+=l+a:t.tooltipPos[0]-=a+l-U.width/2,D=(j=U.x)+U.width,j<0||D>e.len?(j=p(j,0,e.len),L=(D=p(D,0,e.len))-j,t.dlBox=x(U,{x:j,width:D-j,centerX:L?L/2:null})):t.dlBox=null;let V=t.tooltipPos,H=R?1:0,N=R?0:1,O=this.columnMetrics?this.columnMetrics.offset:-s.width/2;R?V[H]+=U.width/2:V[H]=p(V[H]+(e.reversed?-1:0)*U.width,e.left-u,e.left+e.len-u-1),V[N]=p(V[N]+(R?-1:1)*O,i.top-c,i.top+i.len-c-1),(X=t.partialFill)&&(f(X)&&(X=X.amount),g(X)||(X=0),t.partShapeArgs=x(U),B=Math.max(Math.round(b*X+t.plotX-C),0),t.clipRectArgs={x:e.reversed?U.x+b-B:U.x,y:U.y,width:B,height:U.height})}translate(){for(let t of(super.translate.apply(this,arguments),this.points))this.translatePoint(t)}drawPoint(t,e){let i=this.options,s=this.chart.renderer,o=t.shapeType,r=t.shapeArgs,a=t.partShapeArgs,n=t.clipRectArgs,h=t.state,p=i.states[h||"normal"]||{},d=void 0===h?"attr":e,c=this.pointAttribs(t,h),u=y(this.chart.options.chart.animation,p.animation),g=t.graphic,m=t.partialFill;if(t.isNull||!1===t.visible)g&&(t.graphic=g.destroy());else if(g?g.rect[e](r):(t.graphic=g=s.g("point").addClass(t.getClassName()).add(t.group||this.group),g.rect=s[o](x(r)).addClass(t.getClassName()).addClass("highcharts-partfill-original").add(g)),a&&(g.partRect?(g.partRect[e](x(a)),g.partialClipRect[e](x(n))):(g.partialClipRect=s.clipRect(n.x,n.y,n.width,n.height),g.partRect=s[o](a).addClass("highcharts-partfill-overlay").add(g).clip(g.partialClipRect))),!this.chart.styledMode&&(g.rect[e](c,u).shadow(i.shadow),a)){f(m)||(m={}),f(i.partialFill)&&(m=x(i.partialFill,m));let e=m.fill||l(c.fill).brighten(-.3).get()||l(t.color||this.color).brighten(-.3).get();c.fill=e,g.partRect[d](c,u).shadow(i.shadow)}}drawPoints(){let t=this.getAnimationVerb();for(let e of this.points)this.drawPoint(e,t)}getAnimationVerb(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"}isPointInside(t){let e=t.shapeArgs,i=t.plotX,s=t.plotY;if(!e)return super.isPointInside.apply(this,arguments);let o=void 0!==i&&void 0!==s&&s>=0&&s<=this.yAxis.len&&(e.x||0)+(e.width||0)>=0&&i<=this.xAxis.len;return o}}return b.defaultOptions=x(n.defaultOptions,o),c(b.prototype,{pointClass:r,pointArrayMap:["x2","y"],getExtremesFromAll:!0,parallelArrays:["x","x2","y"],requireSorting:!1,type:"xrange",animate:i.series.prototype.animate,autoIncrement:a,buildKDTree:a}),i.registerSeriesType("xrange",b),b}),i(e,"masters/modules/xrange.src.js",[e["Core/Globals.js"],e["Series/XRange/XRangeSeries.js"]],function(t,e){e.compose(t.Axis)})});//# sourceMappingURL=xrange.js.map