<?php
/**
 * Page module
 * 
 * Page detail page.
 * 
 * @package linea21\modules\page
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

if (isset($_GET['id'])) $id = $_GET['id'];
if (isset($_POST['id'])) $id = $_POST['id'];

$req_det = SQL_getoneCompletePage($id);
$result = $sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['page_title'])) redirect_to('@module_default');

$page_id = '<span class="page-id">['. $id. ']</span>';
$display_title = formatText($result[0]['page_title'], '2HTML');
$display_header = formatText(empty_none($result[0]['page_header']), '2HTML');
$display_body = formatText($result[0]['page_body'], '2HTML');
$display_heading = formatText($result[0]['page_heading'], '2HTML');
$display_user = formatText($result[0]['user_login'], '2HTML');
$display_date_crea = $result[0]['page_date_crea_display'];
$display_last_modify = $result[0]['page_last_modify_display'];
$page_owner = $result[0]['page_posted_by'];

if($result[0]['page_homepage']=='Y') {
	$display_homepage = _t('divers', 'yes');
} else {
	$display_homepage = _t('divers', 'no');
}
$display_statut = display_statut($result[0]['page_status']);
if (formatDate($result[0]['page_published_date_display'], true) == formatDate('0001-01-01', true)) $display_published_date = mb_ucfirst(_t('statut','draft'));
else $display_published_date = $result[0]['page_published_date_display'];

if(MOD_REWRITE == 1) $display_url = SITE_ROOT_URL. 'public/'.$GLOBALS['links'][U_L]['page']['linkvalue'].'/'. Stringy\Stringy::create($display_title, CHARSET)->slugify(). ','. $id. '.html';
else $display_url = SITE_ROOT_URL. 'public/index.php?rub=' . $GLOBALS['links'][U_L]['page']['linkvalue'] .'&amp;id='.$id;

$link_sup = $rub_link . "&amp;todo=sup&amp;id=";
$link_mod = $rub_link . "&amp;todo=mod&amp;id=";

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"> <?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','page'); ?> </a></li>
	<li><span><?php echo formatNavTitle(_t('page','det') . " : " . $display_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

footerAddJS('../lib/js/clipboard.js-2.0.10/dist/clipboard.min.js');

$str = "
        var clipboard = new ClipboardJS('.copy-public-url');
     
    clipboard.on('success', function(e) {
        alertify.success(\"" . _t('copy', 'url_copy_succeed') . "\");
    });
    
    clipboard.on('error', function(e) {
        alertify.error(\"" . _t('copy', 'url_copy_failed') . "\");
    });";

footerAddInlineJS($str);
?>
<div id="content"><?php
echo "<h2>";
echo formatTitleh2($display_title . $page_id);
echo "</h2>\n";
echo "\t<a href=\"" . $link_sup . $id . "\" class=\"ico_sup2\" title=\"" . _t('page','sup') . "\"><i class=\"fa fa-trash\"></i><span>" . _t('page','sup') . "</span></a>\n";
echo "\t<a href=\"" . $link_mod . $id . "\" class=\"ico_mod2\" title=\"" . _t('page','mod') . "\"><i class=\"fa fa-pencil-square-o\"></i><span>" . _t('page','mod') . "</span></a>\n";
echo "<dl class=\"summary\">\n";
echo "<dt>" . mb_ucfirst(_t('page','title')) . " :</dt>\n";
echo "<dd>" . $display_title . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('page','public-url')) . " :</dt>\n";
echo "<dd><span id=\"public-url\" class=\"small\">" . $display_url . "</span> <button class=\"copy-public-url button small\" data-clipboard-action=\"copy\" data-clipboard-text=\"" . $display_url ."\"><i class=\"fa fa-copy\"></i> ". _t('copy', 'url') . "</button></dd>\n";
echo "<dt>" . mb_ucfirst(_t('page','header')) . " :</dt>\n";
echo "<dd>" . $display_header . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('page','body')) . " :</dt>\n";
echo "<dd>" . $display_body . "</dd>\n";
echo "<dt>".mb_ucfirst(_t('page','heading'))." :</dt>\n";
echo "<dd>".$headingEntries[$display_heading]."</dd>\n";
echo "<dt>" . mb_ucfirst(_t('page','author')) . " :</dt>\n";
echo '<dd><a href="?rub=user&amp;todo=det&amp;id='.$page_owner.'">' . $display_user . '</a></dd>'.PHP_EOL;
echo "<dt>" . mb_ucfirst(_t('page','is_homepage'))." :</dt>\n";
echo "<dd>" . $display_homepage."</dd>\n";
echo "<dt>" . mb_ucfirst(_t('statut','published_on')) . " :</dt>\n";
echo "<dd>" . $display_published_date . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','date_crea')) . " :</dt>\n";
echo "<dd>" . $display_date_crea . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','last_modify')) . " :</dt>\n";
echo "<dd>" . $display_last_modify . "</dd>\n";
echo "<dt>" . mb_ucfirst(_t('divers','statut')) . " :</dt>\n";
echo "<dd>" . $display_statut . "</dd>\n";
echo "</dl>\n";
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->