<?php
/**
 * Public index page
 * 
 * Container file - to implement with plugins or iframes
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


// IMPORTANT - how it works !!!!!!
// Ability to pass page from plugin or from current theme (if plugin not passed)
// At least $_GET['view'] should be passed - $_GET['plugin'] is optional
// Possible value /linea21/public/container.php?plugin=l21_pcaet&view=public --> file must be plugins/l21_pcaet/view/public.php
// Possible value /linea21/public/container.php?view=my-page --> file must be THEME_PUBLIC_PATH/view/my-page.php
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

if(!isset($_GET['view'])) die ('Nothing to see here !');
isset($_GET['plugin']) ? $path = '../plugins/'.htmlentities($_GET['plugin']).'/' : $path = '';
$path .= 'view/'.htmlentities($_GET['view'].'.php');
if(!file_exists($path)) die ('Nothing to see here !');

function optimize($buffer) {
	
	$html = str_get_html($buffer, true, true, CHARSET, false);

    # we set the title
    if(isset($GLOBALS['current_title'])) {
		$current_title = implode(' - ', $GLOBALS['current_title']);
		$title = $html->find('title', 0);
		$title->innertext = $current_title;
	}
	
	# we set the description meta tag or remove it if does not exists
	$desc = $html->find('meta[name=description]', 0);
	if(defined('META_DESCRIPTION') && META_DESCRIPTION != '') {
	    $desc->content = META_DESCRIPTION;
	} else {
	    $desc->outertext = '';
	}

    # we set the breadcrumb
    if (defined('BREADCRUMB_CONTAINER')) $container = BREADCRUMB_CONTAINER;
    else $container = 'id=main-container';
    if (isset($GLOBALS['breadcrumb'])) {
        $e = $html->find('div[' . $container . ']', 0);
        $e->innertext = getBreadcrumb() . $e->innertext;
    }
    $buffer = $html;
  
    // return $buffer is $_SERVER['HTTP_ACCEPT_ENCODING'] does not exist - could happen
    if(!isset($_SERVER['HTTP_ACCEPT_ENCODING'])) return $buffer;
    if(function_exists ('ob_gzhandler') && substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')) return ob_gzhandler($buffer, 5);
  
    return $buffer;
}



include_once('../config/define.php');


// by default, if rub is not set, takes homepage value
if(!isset($_REQUEST['rub'])) $_REQUEST['rub'] = $GLOBALS['links'][U_L]['home']['linkvalue'];

// we do set dynamic var vy calling 'optimize' function
ob_start('optimize', 0, PHP_OUTPUT_HANDLER_STDFLAGS);



// check if session is not expired
$l21auth->isActive();

distInclude(THEME_PUBLIC_PATH.SQL.'.inc.php', THEME_PUBLIC_DIST);
include_once('../admin/'.SQL.'.inc.php');
distInclude(THEME_PUBLIC_PATH.'filters.php', THEME_PUBLIC_DIST);
distInclude(THEME_PUBLIC_PATH.'display.php', THEME_PUBLIC_DIST);
ActiveItem();
securityCheck();
IncludeLang();



if(isset($debugbar)) {
  $debugbar['time']->stopMeasure('sqlfiles');
}

// update workgroups ID if needed - only if workgroup section and user logged-in
if(isset($_REQUEST['rub']) && isset($_SESSION['authenticated']) && $_REQUEST['rub'] == $GLOBALS['links'][U_L]['workgroup']['linkvalue']) $GLOBALS['l21auth']->updateCookieWorkshop();

// we include comment functions
include_once(override('../comment/display.php'));
// we include vote functions
include_once(override('../vote/display.php'));
// we include level functions
include_once(override('../level/display.php'));
?>
<!DOCTYPE html>
<!--[if lte IE 7 ]><html class="no-js ie67 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 8 ]><html class="no-js ie8 ie678" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if IE 9]><html class="no-js ie9" lang="<?php echo U_L; ?>"> <![endif]-->
<!--[if gt IE 9]> <!--><html class="no-js" lang="<?php echo U_L; ?>"> <!--<![endif]-->
<?php distInclude(THEME_PUBLIC_PATH.'header.php', THEME_PUBLIC_DIST); ?>
<body id="iframe-body">
<script>
		var SITE_ROOT_URL= "<?php echo SITE_ROOT_URL; ?>";
		var lang = "fr";
</script>
<?php 
include_once(override($path));
$GLOBALS['sql_object'] -> DBClose();
?>
<?php AddDynamicFooter(); ?>
</body>
</html>
