<?php
/**
 * Default front-office functions
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


include_once('../user/'.SQL.'.inc.php');
require_once ('../news/mysql.inc.php');

// import the Intervention Image Manager Class
use Intervention\Image\ImageManagerStatic as Image;


if (! function_exists ( 'getLatestContrib' )) {
    function getLatestContrib($nb, $module_id, $chars = 100) {
        
        global $sql_object;
        
        $loop = '';
        
        $options = array('module' => 'contribute', 'module_id' => $module_id, 'order_by' => 'DESC', 'limit' => $nb);
        
        $data = $sql_object->DBSelect(SQL_getComments($options));
        
        if(is_array($data)) {
            foreach ($data as $c) {
                
                // get fullname
                if($c['comment_user_id'] != 0) {
                    $fullname = $c['user_login'];
                    if(!empty($c['profile_firstname']) || !empty($c['profile_lastname'])) $fullname .= ' ('.$c['profile_firstname']. ' '.$c['profile_lastname'].')';
                } else {
                    $fullname = $c['comment_name'];
                }
                $link = HrefMaker(array('rub' => $GLOBALS['links'][U_L]['contribute']['linkvalue'], '#' => 'com-' . $c['comment_id']));;
                
                $loop .= '<div class="contrib mtm pas">';
                if(!empty($c['comment_title'])) $loop .= '<div class="c-title">'.formatText(cutText(strip_tags($c['comment_title']), 100, 1), '2HTML').'</div>';
                $loop .= '<div class="c-body">'.formatText(cutText(strip_tags($c['comment_body']), $chars), '2HTML').'</div>';
                $loop .= '<div class="published_by">'.mb_ucfirst(_t('published', 'on')).' '. substr($c['comment_date_crea_display'], 0, 10). ' '._t('published', 'by').' ' .$fullname.'</div>';
                $loop .= '<div class="c-link"><a href="'.$link.'" class="readmore">'. _t('btn', 'read_more').'</a></div>';
                $loop .= '</div>';
            }
        } else {
            $loop .= '<p>'._t('divers', 'nodata').'</p>';
        }
        
        return sprintf('<div id="latest-contribs"><h2>'._t('public', 'latest_contribs').'</h2><div id="latest-contribs-content" class="slick-responsive grid-3">%s</div></div>', $loop);
        
    }
}

if(!function_exists('prepareAjaxLogin')) {
	
	function prepareAjaxLogin() {
		
		global $l21auth;
		
		$str = '';
		
		
		if(!$l21auth->isAuthenticated()) {
		    
		    if(empty($_SERVER['QUERY_STRING'])) $link = $_SERVER['SCRIPT_NAME']; else $link = $_SERVER['SCRIPT_NAME'] . '?'. htmlspecialchars($_SERVER['QUERY_STRING'], ENT_QUOTES, CHARSET);
			
			$str .= '<div id="loginmodal" style="display:none;">'.PHP_EOL;
			$str .= '<h2>'._t('divers','auth').'</h2>'.PHP_EOL;
			$str .= '<a class="modal_close" href=""><span class="visually-hidden">' . mb_ucfirst(_t('divers', 'close')) . '</span></a>'.PHP_EOL;
			$str .= AuthForm('LOGON', (isset($_SERVER['HTTPS']) ? "https" : "http") . "://".$_SERVER['HTTP_HOST'] . $link);
			$str .= '</div>'.PHP_EOL;
			
			
			$js = "$('.login-link').attr('href', '#loginmodal'); // on remplace le lien par défaut
						 $('.login-link').leanModal({ top : 200, overlay : 0.4, closeButton: '.modal_close' });";

			footerAddInlineJS($js);

			}

		echo $str;
	}
	
}

if(!function_exists('getPastEvents')) {
  function getPastEvents($nb) {

    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_pastEvents($nb));

    if($data!=0)
    {
      $content= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']));
        $workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
        $workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

        // no link if shared event
        if($data[$i]['workcal_workshop_id'] == 999999999) {
          $link = $_SERVER["PHP_SELF"].'#';
          $workshop_title =  _t('workshop_mod', 'event_common');
        }

        $content.= '<li><a href="'.$link.'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';
      }
      $content.= '</ul>';
    } else {
      $content= '<p>'._t('divers', 'nodata').'</p>';
    }
    return $content;
  }
}

if(!function_exists('getIncomingEvents')) {
  function getIncomingEvents($nb) {
    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_incomingEvents($nb));

    if($data!=0)
    {
      $content= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']));
        $workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
        $workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

        // no link if shared event
        if($data[$i]['workcal_workshop_id'] == 999999999) {
          $link = $_SERVER["PHP_SELF"].'#';
          $workshop_title =  _t('workshop_mod', 'event_common');
        }

        $content.= '<li><a href="'.$link.'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';

      }
      $content.= '</ul>';
    } else {
      $content= '<p>'._t('divers', 'nodata').'</p>';
    }
    return $content;
  }
}

if(!function_exists('getEvents')) {
	function getEvents($nb) {

		global $sql_object;

		$data= $sql_object->DBSelect(SQLget_Events($nb));

		if($data!=0)
		{
			$content= '<ul>';
			for($i=0; $i<count($data); $i++) {

				$link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['calendar']['linkvalue'],'id'=>$data[$i]['workcal_workshop_id'], '#' => 'cal-'.$data[$i]['workcal_id']));
				$workshop_title =  _t('name', 'workshop_module') .' : '.formatText($data[$i]['workshop_denomination'], '2ATT');
				$workshop_task= formatText($data[$i]['workcal_task'], '2HTML');

				// no link if shared event
				if($data[$i]['workcal_workshop_id'] == 999999999) {
					$link = $_SERVER["PHP_SELF"].'#';
					$workshop_title =  _t('workshop_mod', 'event_common');
				}

				$content.= '<li><a href="'.$link.'" title="'.$workshop_title.'" class="tips">'.$data[$i]['task_date'].' : '.$workshop_task.'</a></li>';
			}
			$content.= '</ul>';
		} else {
			$content= '<p>'._t('divers', 'nodata').'</p>';
		}
		return $content;
	}
}

if(!function_exists('getWorkgroupList')) {
  function getWorkgroupList($nb) {

    global $sql_object;

    $data= $sql_object->DBSelect(SQLget_WorkshopList($nb));

    if($data!=0)
    {
      $content= '<ul id="vnav">';
      for($i=0; $i<count($data); $i++) {

        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        $content.='<li><a href="#tabs-'.$i.'" class="selected" title="'.formatText($workshop_title, '2ATT').'">'.$workshop_title.'</a></li>'.PHP_EOL;

      }
      $content.='</ul>';

      for($i=0; $i<count($data); $i++) {

        $link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[$i]['workshop_id'],'name'=>$data[$i]['workshop_denomination']);
        $workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
        $workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
        $content.= '<div id="tabs-'.$i.'" class="ie6bugfix">';
        $content.= '<h3>'.$workshop_title.'</h3>'.PHP_EOL;
        $content.= '<div>'.$workshop_resume.'</div>';
        $content.= '<p><a href="'.HrefMaker($link).'" title="'.formatText($workshop_title, '2ATT').'" class="readmore">'._t('workshop', 'access_to').'</a></p>';
        $content.= '</div>';

      }
    }
    else
    {
      $content='<p class="info">'._t('divers','nodata').'</p>';
    }

    return $content;

  }
}
if (! function_exists ( 'DisplayLastNews' )) {
	function DisplayLastNews($nb) {
	    
	    $display_comments = true;
		
		$link = HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue']));
		
		$data = $GLOBALS ['sql_object']->DBSelect ( SQL_getNewsList ( 0, $nb, 'public' ) );
		
		$content = '';
		
		$content .= '<h1>'._t('public','last_news_title').'</h1>';
		$content .= '<div class="grid-3 has-gutter-xl pointbreak-med">';
		if ($data != 0) {
			
		for($i=0; $i<count($data); $i++) {
      
      	// get image with SIMPLEHTMLDOM
      
      	$html = new simple_html_dom();
      
      	$html->load($data[$i]['news_header']. $data[$i]['news_body']);
      
      	// we get the image with thumbnail class if provided
      	if($html->find('img.thumbnail, img.miniature, img.vignette', 0)) $imgsrc = $html->find('img.thumbnail, img.miniature, img.vignette', 0)->src;
      	else $imgsrc = false;
      
      	// if img.thumbnail does not exist we get the first image
      	if(!$imgsrc) {
      		// we get the first image if provided
      		if($html->find('img', 0)) $imgsrc = $html->find('img', 0)->src;
      		// prevent embed chart to generate errors - see issue #852
      		// and try to find another image as thumbnail
      		$path_parts = pathinfo ( $imgsrc );
      		if(empty($path_parts ['extension'])) {
      		    $imgsrc = '../library/userfiles/no-image.png';
      		    if($html->find('img', 1)) $imgsrc = $html->find('img', 1)->src;
      		    $path_parts = pathinfo ( $imgsrc );
      		    if(empty($path_parts ['extension'])) $imgsrc = '../library/userfiles/no-image.png';
      		}
      	}
      	
      	// if there is still no image, we take default app image
      	if(!$imgsrc) {
      		$imgsrc = '../library/userfiles/no-image.png';
      	}
      
      	$thumbpath = '../library/userfiles/_thumbs/';
      	
				$path_parts = pathinfo ( $imgsrc );
				list($width, $height) = explode('x', THUMBNAIL_SIZE);
				
				$thumbname = $path_parts ['filename'] . '_' . $width . 'x' . $height . 'px.' . $path_parts ['extension'];
				
				$thumb_fullpath = $thumbpath . $thumbname;
				
				// if thumbnail does not exist
				if (!file_exists($thumb_fullpath)) {
					
				    // replace SITE_ROOT_URL by '../'
				    $imgsrc = str_replace(SITE_ROOT_URL, '../', $imgsrc);
				    
				    // open an image file, crop / resize and save !
				    // https://image.intervention.io/v2/api/fit
				    $img = Image::make($imgsrc)->fit($width, $height);
				    $img->save($thumb_fullpath);

					chmod($thumb_fullpath, 0755);
					$imgsrc = $thumb_fullpath;
				} else {
					$imgsrc = $thumb_fullpath;
				}
      
      	$title=formatText($data[$i]['complete_news_title'],'2HTML');
      
      	// we remove all images contained in header
      	$html->load($data[$i]['news_header']);
      
      	foreach($html->find('img') as $element) {
      		$images = $element->outertext = '';
      	}
      
      
      
      	$link_table= array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue'],'id'=>$data[$i]['news_id'], 'name' => $data[$i]['news_title']);
      	$link_user = array('rub' => $GLOBALS['links'][U_L]['user-profile']['linkvalue'], 'id' => $data[$i]['news_posted_by'], 'name' => $data[$i]['user_login']);
      	$link_detail = array('rub' => $GLOBALS['links'][U_L]['news']['linkvalue'], 'id' => $data[$i]['news_id'], 'name' => $data[$i]['news_title']);
      
      	$news_posted_on = formatText($data[$i]['news_published_date_display'], '2HTML');
      	$news_posted_on_long = formatText($data[$i]['news_published_date_display_long'], '2ATT');
      	$news_posted_by = formatText($data[$i]['user_login'], '2HTML');
      
      	$content .= '<div class="onenews line mtm">'.PHP_EOL;
      	$content .= '<img src="' . str_replace('../', SITE_ROOT_URL, $imgsrc) . '" alt="' .sprintf(_t('divers', 'content_visual'), formatText(cutText($title, 50), '2ATT')). '" class="left nomouseover" />';
      	$content .= '<div class="mod">';
      	$content .= '<h2><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['news']['desc'].' : '.$title, '2ATT').'">'.$title.'</a></h2>';
      	$content .= '<div class="onenews-chapo">'.formatText($html, '2HTML').'</div>'.PHP_EOL;
      	
      	$content .= '<p class="published_by">' . PHP_EOL;
      	if(commentEnabled('news') && $display_comments == true) {
      	    $content .= getCommentsNumbers(array('module'=> 'news', 'module_id'=> $data[$i]['news_id'], 'link_to_comments'=> $link_detail + array('#' => 'comments')));
      	}
      	$content .= '<span class="published-on">'._t('statut','published_on') . '</span> <span class="date" data-published-date="'.$news_posted_on_long.'">' . $news_posted_on . '</span> ';
      	$content .= _t('divers','by').' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links'][U_L]['user-profile']['desc'] . ' (' . $news_posted_by . ')">' . $news_posted_by . '</a>';
      	$content .= '</p>' . PHP_EOL;
      	
      	$content .= '<a class="readmore" href="'.HrefMaker($link_detail).'">'._t('btn', 'read_more').'</a>';
      	$content .= '</div>';
      	$content .= '</div>'.PHP_EOL;
      
      	// we clear SimpleHTMLDom to prevent memory leaks
      	$html->clear();
      	unset($html);
      }
            
    } else {
      $content .= '<p class="info">' . _t('divers','nodata') . '</p>';
    }
    $content .= '</div>';
    
    $content .= '<div class="txtright mtm mbl"><a href="'.$link.'" class="newsmore"><i class="fa fa-arrow-right" aria-hidden="true"></i> '._t('common', 'see-news').'</a></div>';

    
		
		echo $content;
	}
}

if(!function_exists('DisplayLastPublications')) {

  function DisplayLastPublications($nb, $plaintext = false) {
    $data=$GLOBALS['sql_object']->DBSelect(SQL_Get_LastPublications($nb));

    if(!isset($data[0]['publi_id'])) return false;
    
    $content ='<div id="home_publication">'.PHP_EOL;
    $content.='<h2>'._t('public','last_publications_title').'</h2>'.PHP_EOL;
    $content .= '<div class="grid-2 has-gutter-xl">';

    $link_publi= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue']);

    
    
	    for($i=0; $i<count($data); $i++) {
	      $publi_id=$data[$i]['publi_id'];
	      $publi_title=formatText($data[$i]['publi_title'],'2HTML');
	      $publi_resume=formatText($data[$i]['publi_resume'],'2HTML');
	      
	      if($plaintext) $publi_resume = strip_tags($publi_resume);
	      $link_this= array('rub'=> $GLOBALS['links'][U_L]['publication']['linkvalue'], 'id'=>$publi_id, 'name'=> $data[$i]['publi_title']);
	
	      $content.= '<div class="onenews mtm pbl">';
	      $content.= '<h2><a href="'.HrefMaker($link_this).'" title="'.formatText($GLOBALS['links'][U_L]['publication']['desc'].' : '.$publi_title, '2ATT').'">' . $publi_title .'</a></h2>';
	      $content.= '<div>' . $publi_resume . '</div>';
	      $content.= '<a class="readmore" href="'.HrefMaker($link_this).'">'._t('btn', 'read_more').'</a>';
	      $content.= '</div>';
	    }

	$content.= '</div>	'.PHP_EOL;
    $content.= '</div>	'.PHP_EOL;

    echo $content;
  }
}

if(!function_exists('DisplayEdito')) {

  function DisplayEdito() {
    $content ='<div id="home_edito">'.PHP_EOL;
    $content.='<h1>'._t('header', 'welcome').'</h1>'.PHP_EOL;
    $content.='<p>';
    $content.=_t('public','edito');
    $content.='</p>'.PHP_EOL;
    $content.='</div>';
    echo $content;
  }
}

if(!function_exists('DisplayGDT')) {

  function DisplayGDT() {
    $link_gdt= array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue']);

    $content ='<div class="icon-block">'.PHP_EOL;
    $content.='<h2>'._t('public','workgroup_h1').'</h2>'.PHP_EOL;
    $content.='<p class="txtcenter">';
    $content.='<a href="'.HrefMaker($link_gdt).'" title="'.formatText($GLOBALS['links'][U_L]['workgroup']['desc'], '2ATT').'">';
    //$content.=_t('public','workgroup_edito');
    $content .= '<i class="fa fa-users" aria-hidden="true">&nbsp;</i>';
    $content.='</a>';
    $content.='</p>'.PHP_EOL;
    $content.='</div>';
    echo $content;
  }
}

if(!function_exists('DisplayIDD')) {

  function DisplayIDD() {
    $link_idd= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue']);
    $content ='<div class="icon-block">'.PHP_EOL;
    $content.='<h2>'._t('public','dashboard_h1').'</h2>'.PHP_EOL;
    $content.='<p class="txtcenter">';
    $content.='<a href="'.HrefMaker($link_idd).'" title="'.formatText($GLOBALS['links'][U_L]['dashboard']['desc'], '2ATT').'">';
    // $content.=_t('public','dashboard_edito');
    $content.= '<i class="fa fa-line-chart" aria-hidden="true">&nbsp;</i>';
    $content.='</a>';
    $content.='</p>'.PHP_EOL;
    $content.='</div>';
    echo $content;
  }
}


/**
 * DisplayMenu()
 * Affichage du menu
 *
 * @return void ( echo string )
 */
if(!function_exists('DisplayMenu')) {

  function DisplayMenu($accesskey = false)
  {
    //$content .= '<a href="#contenu" class="visually-hidden" title="'._t('header','goto_contents').'" accesskey="2">'._t('header','goto_contents').'</a>'.PHP_EOL;
    $content = '<ul class="clearfix">'.PHP_EOL;
    foreach($GLOBALS['menuitems'] as $key => $value) {

      (get_menu_item($GLOBALS['activeitem']) == $value) ? $classe = ' class="actif"' : $classe = '' ;
      
      if($accesskey || $value == 'home') $accesskeytxt =' accesskey="' . $GLOBALS['links'][U_L][$value]['accesskey'] . '"';
      else $accesskeytxt ='';
          
      $current_link = array('rub' => $GLOBALS['links'][U_L][$value]['linkvalue']);
      $content .= '<li id="menu_'.$value.'"'.$classe.'>';
      $content .= '<a href="' . HrefMaker($current_link) . '" title="' . $GLOBALS['links'][U_L][$value]['desc'] . '" id="amenu_'.$value.'"'. $accesskeytxt.'>' . mb_ucfirst($GLOBALS['links'][U_L][$value]['title']) . '</a>';
      $content .= '</li>' . PHP_EOL;
    }
    $content .= "</ul>";
    echo $content;
  }
}

/**
 * MyAccountLink()
 * Renvoie les liens de creation de compte ou de déconnexion
 * suivant le statut de l'utilisateur
 *
 * @return string content
 */
if(!function_exists('MyAccountLink')) {

	function MyAccountLink()
	{
		global $l21auth;

		$link_account = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);
		$link_contribs = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue'], '#' => 'my-contribs');
		$link_create = array('rub' => $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
		
		if($l21auth->isAuthenticated()) $link_logout = array('rub' => $GLOBALS['links'][U_L]['logout']['linkvalue'], 'token' => $l21auth->GetSessionElement('logout_token'), 'no_url_rewriting' => 1);
		if($l21auth->isAuthenticated()) $c = ' logged-in'; else $c = '';
		
		$content  = '<div class="myaccount'.$c.'">';
		if ($l21auth->isAuthenticated()) {
			if(isset($_SESSION['userfirstname'])) $title= ucfirst($_SESSION['userfirstname']);
			else $title= $_SESSION['userlogin'];
			$str = ucfirst(_t('divers','myprofile'));
			$class = "profile-link";
			
			$content .= '<div class="user-panel">';
			$content .= '<div id="user-identity"><i class="fa fa-user fa-lg"></i> ';
			$content .= _t('header','welcome'). ' '.$title;
			$content .= '</div>';
			$content .= '<div class="user-panel-over pam">';
			$content .= '<div class="grid has-gutter">';
			
			$groups = MyGroups();
			if($groups !== false) {
				$content .= '<div class="txtleft">';
				$content .= $groups;
				$content .= '</div><!-- closing internal div -->';
			}
			
			$content .= '<div class="txtleft">';
			$content .= '<h3>'._t('header', 'preferences').'</h3>';
			$content .= '<ul>';
			$content .= '<li><a href="' . HrefMaker($link_account) . '" title="'._t('header','myaccount_title').'" class="'.$class.'"><i class="fa fa-bars"></i> ' . $str . '</a></li>';
			if(commentEnabled('contribute')) $content .= '<li><a href="' . HrefMaker($link_contribs) . '" title="'._t('contribs','mine').'"><i class="fa fa-comments" aria-hidden="true"></i> ' . mb_ucfirst(_t('contribs','mine')) . '</a></li>';
			
			if(!$l21auth->isSimpleUser()) {
				$content .= '<li><a href="'.SITE_ROOT_URL.'admin/" title="'._t('divers','title_login').'"><i class="fa fa-cog"></i> ' . mb_ucfirst(_t('admin','console')) . '</a></li>';
			}
			
			$content .= '<li><a href="' . HrefMaker($link_logout) . '" title="'._t('header','deconnexion_title').'"><i class="fa fa-sign-out"></i> ' . mb_ucfirst(_t('header','deconnexion')) . '</a></li>';
			$content .= '</ul></div><!-- closing internal div -->';
			
			$content .= '</div><!-- closing grid div -->';
			$content .= '</div><!-- closing user-panel-over div -->';
			$content .= '</div><!-- closing user-panel div -->';
		} else {
			$str = ucfirst(_t('divers','auth'));
			$class = "login-link";
			$content .= '<div class="account-links">';
			$content .= '<a href="' . HrefMaker($link_account) . '" title="'._t('header','myaccount_title').'" class="'.$class.'">' . $str . '</a>';
			if(defined('FREE_REGISTRATION') && FREE_REGISTRATION == 1) $content .= ' / <a href="' . HrefMaker($link_create) . '" title="'._t('divers','user_inscription_title').'">' . _t('divers','user_inscription') . '</a>';
			$content .= '</div>';
			
		}

// 		if ($l21auth->isAuthenticated()) {
// 			if($l21auth->isSuperAdmin()) {
// 				$content .= '<li><a href="../admin/" title="'._t('divers','title_login').'">' . mb_ucfirst(_t('admin','console')) . '</a></li>';
// 			}
// 			$content .= '<li><a href="' . HrefMaker($link_logout) . '" title="'._t('header','deconnexion_title').'">' . mb_ucfirst(_t('header','deconnexion')) . '</a></li>';

// 		}

		$content .= '</div>' . PHP_EOL;
		echo $content;
	}
}


/**
 * MyAccount()
 * Renvoie les liens de creation de compte ou de déconnexion
 * suivant le statut de l'utilisateur
 *
 * @return string content
 */
if(!function_exists('MyAccount')) {

  function MyAccount()
  {
  	global $l21auth;

    $link_account = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);
    $link_create = array('rub' => $GLOBALS['links'][U_L]['user-registration']['linkvalue']);
    $link_logout = array('rub' => $GLOBALS['links'][U_L]['logout']['linkvalue']);

    $content  = '<div id="myaccount">';
    if ($l21auth->isAuthenticated()) {
      if(isset($_SESSION['userfirstname'])) $title= ucfirst($_SESSION['userfirstname']);
      else $title= $_SESSION['userlogin'];
      $content .= '<h2>'._t('header','welcome'). ' '.$title.',</h2>';
      $str = ucfirst(_t('divers','myprofile'));
      $class = "profile-link";
    } else {
      $content .= '<h2>'._t('header','myaccount').'</h2>';
      $str = ucfirst(_t('divers','auth'));
      $class = "login-link";
    }
    $content .= '<ul>' . PHP_EOL;
    $content .= '<li><a href="' . HrefMaker($link_account) . '" title="'._t('header','myaccount_title').'" class="'.$class.'">' . $str . '</a></li>';

    if ($l21auth->isAuthenticated()) {
    	if($l21auth->isSuperAdmin()) {
    		$content .= '<li><a href="../admin/" title="'._t('divers','title_login').'">' . mb_ucfirst(_t('admin','console')) . '</a></li>';
    	}
    	$content .= '<li><a href="' . HrefMaker($link_logout) . '" title="'._t('header','deconnexion_title').'">' . mb_ucfirst(_t('header','deconnexion')) . '</a></li>';

    }

    else {
    	$content .= '<li><a href="' . HrefMaker($link_create) . '" title="'._t('divers','user_inscription_title').'">' . _t('divers','user_inscription') . '</a></li>';
    }
    $content .= '</ul></div>' . PHP_EOL;
    echo $content;
  }
}

/**
 * forgotPass()
 * Formulaire envoi d'un mot de passe
 *
 * @param string $todo
 * @return void (echo string)
 */
if(!function_exists('forgotPass')) {

  function forgotPass($back = 1 )
  {
    
    if(isset($_POST['user-input'])) $_POST['user-input']  = htmlspecialchars(strip_tags($_POST['user-input']), ENT_QUOTES, CHARSET);
    
  	include_once(override('../mail/mail_actions.php'));
  	include_once(override('../mail/send.php'));
  	$a = array();
  	
    if($back=== 1) $back=get_referer(true);
    $input_hidden = $GLOBALS['links'][U_L]['forgot-password']['linkvalue'];

    if(isset($_POST['valid'])) {
        // if email is provided we handle it, else with login only
        if(strpos($_POST['user-input'], '@')  === false) $r = $GLOBALS['l21auth']->identifyWithLogin($_POST['user-input']);
        else $r = $GLOBALS['l21auth']->identifyWithEmail($_POST['user-input']);
      if(!($r)) {
        $msg = '<div class="error">'.sprintf(_t('auth', 'no_user'), $_POST['user-input']).'</div>';
      } else {

      	if($r['user_password'] == '@ldap_forward') {

      		$msg = '<div class="info">'.sprintf(_t('auth', 'ldap_user')).'</div>';

      	} else {

	        include_once('../class/class.user.php');
	        $user = new user;
	        $key = $user->generateNewPasskey($r['user_id'], $GLOBALS['sql_object']);

	        if($key != false) {
	          $a['action'] = 'forgot_pass';
	          $a['recipient'] = $r['profile_email'];
	          $a['linkpassword'] = array('rub' => $GLOBALS['links'][U_L]['forgot-password']['linkvalue'], 'token' => $key);
	          
	          $emailContainer = prepare_email($a);
	          $r = send_email($emailContainer);
	          
	          $msg =  '<div class="info">'.sprintf(_t('auth', 'sending_mail'), $a['recipient']).'</div>';
	        }
      	}

      }
    }

    $form = '<p>'. _t('auth','note') . '</p>' . PHP_EOL;
    if(isset($msg)) $form .= $msg . PHP_EOL;
    $form .= '<form action="index.php" method="post">' . PHP_EOL;
    $form .= '<div id="forgot_pass">' . PHP_EOL;
    $form .= '<p><label for="user-input" class="labelised">' . _t('divers','login') . ' / ' . _t('divers','email') .' : </label>' . PHP_EOL;
    $form .= '<input type="text" maxlength="100" class="tinytextfield" name="user-input" id="user-input" /></p>' . PHP_EOL;
    $form .= '<br />'.PHP_EOL;

    $form .= '<br />'.PHP_EOL;
    $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . PHP_EOL;
    $form .= '<input type="hidden" name="referer" id="referer" value="' . $back . '" />' . PHP_EOL;
    $form .= '<input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="valid" id="valid" />'.PHP_EOL;
    $form .= '</div>' . PHP_EOL;
    $form .= '</form>' . PHP_EOL;

    return $form;
  }
}

/**
 * AuthForm()
 * Formulaire d'authentification pour login ou inscription
 *
 * @param string $todo
 * @return void (echo string)
 */
if(!function_exists('AuthForm')) {

  function AuthForm($todo = 'LOGON', $back = 1 , $usero = null)
  {

      // if back == 1 but there is no redirect page we get it
    if($back === 1) $back = get_referer(true);
    else {
	    // handle redirect when user is not authenticated
        if(isset($_GET['refer'])) {
            
            $back = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://".$_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
            if(!empty($_SERVER['QUERY_STRING'])) $back .= '?' . htmlspecialchars($_SERVER['QUERY_STRING'], ENT_QUOTES, CHARSET);
        }
	    // if redirect page is set we go to it
	    elseif(is_string($back)) $back = $back;
	    // else only, we go to public page
	    else $back = CURRENT_APP_URL;
    }
    

    isset($_POST['login']) ? $form_login = formatText($_POST['login'], '2FIELD') : $form_login = '';
    isset($_POST['email']) ? $form_email = formatText($_POST['email'], '2FIELD') : $form_email = '';
    isset($_POST['firstname']) ? $form_firstname = formatText(trim($_POST['firstname']), '2FIELD') : $form_firstname = '';
    isset($_POST['lastname']) ? $form_lastname = formatText(trim($_POST['lastname']), '2FIELD') : $form_lastname = '';
    $form_password = '';

    if ($todo == 'LOGON') {
      $input_hidden = $GLOBALS['links'][U_L]['user-prefs']['linkvalue'];
      $div_id = 'logon';
    } else {
      $input_hidden = $GLOBALS['links'][U_L]['user-registration']['linkvalue'];
      $div_id = 'subscribe';
      
      $pwdsec = [];
      if (defined('PASSWD_STRENGTH')) {
          if (strpos(PASSWD_STRENGTH, 'a') !== false) array_push($pwdsec, _t('user', 'lowercase_char') );
          if (strpos(PASSWD_STRENGTH, 'A') !== false) array_push($pwdsec, _t('user', 'uppercase_char') ) . '<br>';
          if (strpos(PASSWD_STRENGTH, '0') !== false) array_push($pwdsec, _t('user', 'digit_char') ) . '<br>';
          if (strpos(PASSWD_STRENGTH, '/') !== false) array_push($pwdsec, sprintf(_t('user', 'symbol_char'), $usero->SYMBOL_LIST) ) . '<br>';
          
          $security_msg = '<p class="password-policy label-leftmargin"><strong>' . _t('user', 'security_policy') . '</strong>'. sprintf(_t('user', 'security_policy_msg'), join(', ', $pwdsec)) .'<p>';
      }
    }
    $link_pass = array('rub' => $GLOBALS['links'][U_L]['forgot-password']['linkvalue']);
    $form = '<form action="'. CURRENT_APP_URL  . 'index.php" method="post">' . PHP_EOL;
    $form .= '<div id="' . $div_id . '">' . PHP_EOL;
    $form .= '<p><label for="login" class="labelised">' . _t('divers','login') . ' : </label>' . PHP_EOL;
    $form .= '<input type="text" maxlength="35" class="tinytextfield" name="login" id="login" value="'.$form_login.'" required />' . PHP_EOL;
    $form .= '</p>'.PHP_EOL;
    if ($todo == 'LOGON') {
      $form .= '<p><label for="password" class="labelised">' . _t('divers','password') . ' : </label>' . PHP_EOL;
      $form .= '<input type="password" maxlength="100" class="tinytextfield" name="password" id="password" required /></p>' . PHP_EOL;
      
      if(defined('REMEMBER_ME') && REMEMBER_ME != 0) {
      	$form .= '<p class="login-remember">'. PHP_EOL;
      	$form .= '<input type="checkbox" class="checkbox" name="rememberme" id="rememberme" />' . PHP_EOL;
      	$form .= '<label for="rememberme" class="labelised autowidth">' . _t('auth','rememberme') . '</label>' . PHP_EOL;
      }
      
      $form .= '<p class="forgot_pass"><a href="'.HrefMaker($link_pass).'">'._t('auth', 'forgot_password').'</a></p>' . PHP_EOL;
    } else {
      $form .= '<p><label for="email" class="labelised">' . mb_ucfirst(_t('divers','email')) . ' : </label>' . PHP_EOL;
      $form .= '<input type="email" maxlength="100" class="tinytextfield" name="email" id="email" value="'.$form_email.'" required /></p>' . PHP_EOL;
      $form .= '<p><label for="password" class="labelised">' . ucfirst(_t('user','password')) . ' : <br /><span class="italic">(' . sprintf(_t('password', 'minimum'), PASSWD_MINLENGTH) . ')</span></label>' . PHP_EOL;
      $form .= '<input type="password" maxlength="100" class="tinytextfield" name="password" id="password" value="'.$form_password.'" required /></p>' . PHP_EOL;
      if(defined('PASSWD_CONFIRM') && PASSWD_CONFIRM != 0) {
          $form .= '<p><label for="password_check" class="labelised">' . ucfirst(_t('user','password-check')) . ' : <br /></label>' . PHP_EOL;
          $form .= '<input type="password" maxlength="100" class="tinytextfield" name="password_check" id="password_check" value="'.$form_password.'" required /></p>' . PHP_EOL;
      }
      if(isset($security_msg)) $form .=  $security_msg;
      $form .= '<p><label for="firstname" class="labelised">' . ucfirst(_t('user','first_name')) . ' ('. _t('divers','optional') .') : </label>' . PHP_EOL;
      $form .= '<input type="text" maxlength="200" class="tinytextfield" name="firstname" id="firstname" value="'.$form_firstname.'" /></p>' . PHP_EOL;
      $form .= '<p><label for="lastname" class="labelised">' . ucfirst(_t('user','last_name')) . ' ('. _t('divers','optional') .') : </label>' . PHP_EOL;
      $form .= '<input type="text" maxlength="200" class="tinytextfield" name="lastname" id="lastname" value="'.$form_lastname.'" /></p>' . PHP_EOL;

      if(defined('REGISTRATION_ANTISPAM') && REGISTRATION_ANTISPAM ==1) {
          $form.='<p class="antispam">'.PHP_EOL;
          $form.='<span class="labelmargin labelised">&nbsp;</span>';
          $form.='<img src="../lib/securitycode.php" alt="' .mb_ucfirst( _t('security','info2')) .'" id="securityimg" /><span class="labelised antispam-notice">'.  mb_ucfirst(_t('security','info2')).'</span>';
          $form.='</p>'.PHP_EOL;
          $form.='<p><label for="securitycode" class="labelised">' . mb_ucfirst(_t('antispam','info')) . ' * : </label>';
          $form.='<input type="text" class="textfield" id="securitycode" maxlength="5" name="securitycode" /></p> ';
      }
      
      	$form .= '<div class="info">';
      	$form .= '<p>' . sprintf(_t('user', 'gdpr_notice'), 'index.php?rub=page&id=1') . '</p>';
      	if(NEWSLETTER_AUTO_SUB == 1 && MOD_NEWSLETTER == 1) $form .= '<p>' . _t('user', 'newsletter_subscription_info') . '</p>';
      	$form .= '<p class="gdpr-accepted"><input type="checkbox" class="switch" name="gdpr-ok" id="gdpr-ok" value="true" required /><label for="gdpr-ok" class="autowidth">' . sprintf(_t('user', 'gdpr_acceptation'), 'index.php?rub=page&id=1') . '</a></p>';
      	$form .= '</div>' . PHP_EOL;
      
    }
    $form .= '<br />'.PHP_EOL;
    $form .= '<div class="submit-container">';
    $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . PHP_EOL;
    $form .= '<input type="hidden" name="referer" id="referer" value="' . $back . '" />' . PHP_EOL;
    $form .= '<input type="submit" class="submitbut" value="'._t('btn','valid').'" title="'._t('btn','valid').'" name="valid" id="valid" />'.PHP_EOL;
    $form .= '</div>' . PHP_EOL;
    $form .= '</div>' . PHP_EOL;
    $form .= '</form>' . PHP_EOL;

    return $form;
  }
}

/**
 * MyGroups()
 * Return groups user has subscribed to
 * nothing if no groups
 * @return string
 */
if(!function_exists('MyGroups')) {
  function MyGroups()
  {

    if(!isset($_COOKIE['linea21']['workshop']) || !isset($_SESSION['authenticated'])) return false;

    global $sql_object;

    $link_account = array('rub' => $GLOBALS['links'][U_L]['user-prefs']['linkvalue']);

    // get and prepare user groups
    $groups = base64_decode($_COOKIE['linea21']['workshop']);
    if($groups[0]=='/') $groups = substr($groups, 1); // removing first separator
    if(!empty($groups)) {
      $groups = @explode('/',$groups);
      $data= $sql_object->DBSelect(SQL_Get_WorkshopsNames($groups));
    } else {
      $data=0;
    }

    $content  = '<div id="mygroups">'.PHP_EOL;
    $content .= '<h3>'._t('groups', 'mine').'</h3>'.PHP_EOL;
    if($data!=0)
    {
      $content .= '<ul>';
      for($i=0; $i<count($data); $i++) {

        $link = array('rub'=> $GLOBALS['links'][U_L]['workgroup']['linkvalue'],'id'=>$data[$i]['workshop_id']);
        $workshop_title =  formatText($data[$i]['workshop_denomination'], '2HTML');

        $content .= '<li><a href="'.HrefMaker($link).'" title="'.formatText($data[$i]['workshop_denomination'], '2ATT').'">'.$workshop_title.'</a></li>';

      }
      $content .= '</ul>';
    } else {
      return false;
    }
    $content .= '</div>';

    return $content;
  }
}

if(!function_exists('DisplayProjectBoard')) {
  function DisplayProjectBoard() {
    $content ='';
    if(ActiveItemKey($GLOBALS['activeitem']) == 'home') {
      $content .= '<a href="'.HrefMaker(array('rub' => $GLOBALS['links'][U_L]['project']['linkvalue'])).'" title="'.$GLOBALS['links'][U_L]['project']['title'].'">'.$GLOBALS['links'][U_L]['project']['title'].'</a>';
      $content .= '<br />';
    }
    echo $content;
  }
}

if(!function_exists('display_newsletter_form')) {
	function display_newsletter_form() {
		$action=$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'];

		$form  = '<div id="newsletter-form">' . PHP_EOL;
		$form .= '<form action="'. CURRENT_APP_URL  . 'index.php" method="post">' . PHP_EOL;
		$form .= '<h3>'.mb_ucfirst(_t('menu_alt','newsletter')).'</h3>';
		$form .= '<div>' . PHP_EOL;
		$form .='<p class="mbs"><a class ="access-newsletter" href="'.HrefMaker(array('rub' => $GLOBALS['links'][U_L]['newsletter']['linkvalue'])).'" title="'.mb_ucfirst(formatText($GLOBALS['links'][U_L]['newsletter']['desc'], '2ATT')).'">' . mb_ucfirst(_t('divers','see-newsletters')) . '</a><p>';
		
		$form .= '<label for="newsletteremail" class="visually-hidden" id="newsletteremailLabel">' . mb_ucfirst(_t('divers','email')) . ' : </label>' . PHP_EOL;
		$form .= '<input type="text" maxlength="200" size="19" class="tinytextfield" aria-labelledby="newsletteremailLabel" name="newsletteremail" id="newsletteremail" required />' . PHP_EOL;
		$form .= '<input type="submit" value="'.mb_ucfirst(_t('btn','valid')).'" title="'._t('btn','valid').'" name="valid"  id="valid_newsletter" />'.PHP_EOL;
		$form .='<br />';
		$form .= '<input type="hidden" name="rub" id="rub_newsletter" value='.$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'].' />' . PHP_EOL;
		$form .='<p class="newsletter-unsubscribe">';
		$form .= '<input type="checkbox" class="checkbox" name="del_action" id="del_action" style="float:left;margin:0em 1em 0 3.2em" />';
		$form .= '<label for="del_action" class="autowidth">'.mb_ucfirst(_t('newsletter','unsubscribe')).'</label>' . PHP_EOL;
		$form .='</p>';
		$form .= '</div>' . PHP_EOL;
		$form .= '</form>' . PHP_EOL;
		$form .= '</div>' . PHP_EOL;

		echo $form;
	}
}

if(!function_exists('DisplayNewsletterForm')) {
  function DisplayNewsletterForm() {
    $action=$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'];

    $form  = '<div id="newsletter-form">' . PHP_EOL;
    $form .= '<form action="'. CURRENT_APP_URL  . 'index.php" method="post">' . PHP_EOL;
    $form .= '<h2>'.mb_ucfirst(_t('menu_alt','newsletter')).'</h2>';
    $form .= '<div class="sidebar-content">' . PHP_EOL;
    $form .= '<label for="newsletteremail">' . mb_ucfirst(_t('divers','email')) . ' : </label>' . PHP_EOL;
    $form .= '<input type="text" maxlength="200" size="19" class="tinytextfield" name="newsletteremail" id="newsletteremail" required />' . PHP_EOL;
    $form .= '<input type="submit" value="'.mb_ucfirst(_t('btn','valid')).'" title="'._t('btn','valid').'" name="valid"  id="valid_newsletter" />'.PHP_EOL;
    $form .='<br />';
    $form .= '<input type="hidden" name="rub" id="rub_newsletter" value='.$GLOBALS['links'][U_L]['subscribe-newsletter']['linkvalue'].' />' . PHP_EOL;
    $form .='<p class="newsletter-unsubscribe">';
    $form .= '<input type="checkbox" class="checkbox" name="del_action" id="del_action" style="float:left;margin:0em 1em 0 3.2em" />';
    $form .= '<label for="del_action" class="checkboxlab">'.mb_ucfirst(_t('newsletter','unsubscribe')).'</label>' . PHP_EOL;
    $form .='</p>';
    $form .= '</div>' . PHP_EOL;
    $form .= '</form>' . PHP_EOL;
    $form .= '</div>' . PHP_EOL;

    echo $form;
  }
}

if(!function_exists('DisplayBoardLastNews')) {
  function DisplayBoardLastNews($nb) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_NewsBoard($nb));

    $content = '<div id="recentNews">'.PHP_EOL;
    //$content.= '<p>'._t('divers','actu_left').'</p>';
    $content.= '<h2>'._t('divers','actu_left').'</h2>';
    if($data!=0)
    {
      $content.= '<ul>'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $title=formatText($data[$i]['news_title'],'2HTML');
        $link_table= array('rub'=> $GLOBALS['links'][U_L]['news']['linkvalue'],'id'=>$data[$i]['news_id'], 'name' => $data[$i]['news_title']);
        $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['news']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
        #$content.='<em>'._t('statut', 'published_on').' '.$data[$i]['news_published_date_display'].'</em>'.PHP_EOL;
        $content.='</li>'.PHP_EOL;
      }
      $content.= '</ul>'.PHP_EOL;
    }
    else
    {
      $content.='<p>'._t('divers','nodata').'</p>';
    }
    $content.= '</div>'.PHP_EOL;

    echo $content;
  }
}

if(!function_exists('DisplayBoardLastSdi')) {
  function DisplayBoardLastSdi($nb = 3) {
    $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_SdiBoard($nb));

    $content = '<div id="recentIndicators">'.PHP_EOL;
    $content.= '<h2>'._t('divers','sdi_left').'</h2>';
    if($data!=0)
    {
      $content.= '<ul>'.PHP_EOL;
      $test=array();
      for($i=0; $i<count($data); $i++) {
        if (!in_array($data[$i]['sdii_id'], $test) && count($test)< $nb){
          $test[$i]=$data[$i]['sdii_id'];
          $title=formatText($data[$i]['sdii_name'],'2HTML');
          $link_table= array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'],'id'=>$data[$i]['sdii_id'], 'parentid'=>$data[$i]['sdiv_scale'], 'name' => $data[$i]['sdii_name'] );
          $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][U_L]['dashboard']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
          $content.='</li>'.PHP_EOL;
        }
      }
      $content.= '</ul>'.PHP_EOL;
    }
    else
    {
      $content.=_t('divers','nodata');
    }
    $content.= '</div>'.PHP_EOL;

    echo $content;
  }
}

if(!function_exists('get_search_form')) {
	function get_search_form() {

		$action=$GLOBALS['links'][U_L]['search-result']['linkvalue'];

		$form ='<div id="search-input">'.PHP_EOL;
		$form.='<form action="'. CURRENT_APP_URL  . 'index.php" method="get">'.PHP_EOL;
		$form.='<i class="fa fa-search" aria-hidden="true"></i>'.PHP_EOL;
        $form.='<label for="search" class="visually-hidden" id="searchLabel">'._t('menu','search').' </label>'.PHP_EOL;
		$form.='<input type="text" maxlength="100" name="search" aria-labelledby="searchLabel" id="search" accesskey="4" class="tinytextfield" required  />'.PHP_EOL;
		$form.='<input type="hidden" name="rub" id="rub_search" value="'.$GLOBALS['links'][U_L]['search-result']['linkvalue'].'" />' . PHP_EOL;
		$form.='<input type="submit" value="'.mb_ucfirst(_t('btn','valid')).'" name="valid" id="validsearch" />'.PHP_EOL;
		$form.='<span class="sb-icon-search"></span>';
		$form.='<p id="searchadv">';
		$form.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['search']['linkvalue'])).'" title="'.formatText($GLOBALS['links'][U_L]['search']['title'], '2ATT').'">';
		$form.=mb_ucfirst(_t('menu','advancedsearch'));
		$form.='</a>';
		$form.='</p>';
		$form.='</form>'.PHP_EOL;
		$form.='</div>'.PHP_EOL;


		return $form;
	}
}

if(!function_exists('DisplaySearchForm')) {
  function DisplaySearchForm() {

    $action=$GLOBALS['links'][U_L]['search-result']['linkvalue'];

    $form ='<div id="search-input">'.PHP_EOL;
    $form.='<form action="'. CURRENT_APP_URL  . 'index.php" method="get">'.PHP_EOL;
    $form.= '<h2>'._t('menu','search').'</h2>';
    $form.= '<div class="sidebar-content">' . PHP_EOL;
    $form.='<label for="search">'._t('menu','search').' </label>'.PHP_EOL;
    $form.='<input type="text" maxlength="100" name="search" id="search" accesskey="4" class="tinytextfield" required />'.PHP_EOL;
    $form.='<input type="hidden" name="rub" id="rub_search" value="'.$GLOBALS['links'][U_L]['search-result']['linkvalue'].'" />' . PHP_EOL;
    $form.='<input type="submit" value="'.mb_ucfirst(_t('btn','valid')).'" name="valid" id="validsearch" />'.PHP_EOL;
    $form.='<p id="searchadv">';
    $form.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['search']['linkvalue'])).'" title="'.formatText($GLOBALS['links'][U_L]['search']['title'], '2ATT').'">';
    $form.=mb_ucfirst(_t('menu','advancedsearch'));
    $form.='</a>';
    $form.='</p>';
    $form.='</div>'.PHP_EOL;
    $form.='</form>'.PHP_EOL;
    $form.='</div>'.PHP_EOL;


    echo $form;
  }
}

if(!function_exists('displayDefaultFooter')) {
  function displayDefaultFooter($list = false) {
  	$a = array();
    
  	$a[1] ='<a href="mailto:'.SITE_MAIL.'" title="'.SITE_MAIL.'" >'._t('divers','contact').' </a>';
    $a[2] ='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['accessibility']['linkvalue'])).'" title="'.formatText(_t('divers','accessibility'), '2ATT').'" accesskey="0">'._t('divers','accessibility').' </a>';
    $a[3] ='<a href="rss2.php" title="RSS">RSS</a>';
    if(isset($_SESSION['authenticated']) && !$GLOBALS['l21auth']->isSimpleUser())  {
      	$a[4] ='<a href="'.SITE_ROOT_URL.'admin/index.php" title="'. _t('header','title').'">'. _t('admin','console').'</a>';
    }
    if($list === false) $content = join(' | ', $a);
    else {
    	$content = "<ul>";
    	foreach ($a as $item) {
    		$content .= "<li>".$item."</li>";
    	}
    	$content .= "</ul>";
    }
    
    echo $content;
  }
}

?>