<?php
/**
 * Publication module
 * 
 * Set-up module related menu in back-office
 * 
 * @package linea21\modules\publication
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
////////////

$rub_link_add=$rub_link."&amp;todo=add";
$rub_link_list=$rub_link."&amp;todo=list";
$rub_link_mod=$rub_link."&amp;todo=mod";
$rub_link_det=$rub_link."&amp;todo=det";

$search="search.php?rub=".$rub;
if($todo=='add') $title=_t('publication','add');
if($todo=='list') $title=_t('publication','list');
if($todo=='mod') $title=_t('publication','mod');
if($todo=='sup') $title=_t('publication','sup');
if($todo=='det') $title=_t('publication','det');
?>
<div id="itemenu">
	<h1><?php echo $title; ?></h1>
	<div class="contentlink">
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_publication.menu_start'));?>
		<?php
		if($l21auth->isSuperAdmin()) {
		  ?> <a href="<?php echo $rub_link_add; ?>" title="<?php echo _t('publication','add');?>" class="add-link"><?php echo _t('publication','add');?></a>
		<?php } ?> <a href="<?php echo $rub_link_list; ?>" title="<?php echo _t('publication','list');?>" class="list-link"><?php echo _t('publication','list');?></a>
		<a href="<?php echo $search; ?>" title="<?php echo _t('menu','search');?>" class="search-link"><?php echo _t('menu','search');?></a>
		<?php $dispatcher->notify(new sfEvent('secondary_menu', 'admin_publication.menu_end'));?>
	</div>
</div>