<?php
/**
 * Indicator / SDI module
 * 
 * Add indicator page
 * 
 * @package linea21\modules\sdi
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////
include_once("../lib/input_helpers.php");
include_once("../class/class.tag.php");
include_once("../dashboard/common.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('sdi')) ReloadIndex('admin');
////////////

if(defined('API_RETRIEVE') && API_RETRIEVE == 1) $apiclass = 'api-container-enabled';
else $apiclass = 'api-container-disabled';

// TextboxList CSS/JS inclusion
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.css');
addDynamicCSS(THEME_ADMIN_PATH.'css/TextboxList.Autocomplete.css');
footerAddJS('../lib/js/TextboxList-jQuery/Source/GrowingInput.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.js');
footerAddJS('../lib/js/TextboxList-jQuery/Source/TextboxList.Autocomplete.js');
unit_javascript_validation();

// we get available tags list to display to user when hovering 'tags' label
$alltags = new tag();
$availableTags = $alltags->getTags('indicator', -1, false, ',', true);
$tags_list = '';
if(count($availableTags) > 0) {
	$l = '';
	foreach($availableTags as $item) {
		$l .= '<span class="tag">'.$item['tag_name'].'</span>';
	}
	$tags_list = '<div class="tags-list">'.$l.'</div>';
}
?>

<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','sdi')?></a></li>
  	<li><span><?php echo formatnavTitle(_t('sdi','add')) ?></span></li>
  </ul>
</div>
<!--end barre haute -->
<?php

if(isset($_REQUEST['light-ui'])) $http_params = '?light-ui'; else $http_params ='';



include_once("../lib/input_helpers.php");
$sdi_object= new sdi;

if (isset($_POST['enregistrer'])) {
  $integrity = 1;
  $integrity2 = 1;
  $integrity3 = 1;
  $integrity4 = 1;
  $integrity5 = 1;
  $data_table = unserialize(urldecode($_POST['data_table']));
  $j=0;
  // from $data_table[0] to $data_table[12], it goes on Info
  for ($i=0;$i<13;$i++){
    $data_table_sdi[$j]=$data_table[$i];
    $j++;
  }
  // ugly but was added after ... Need to fill up array with
  // threshold_relative and attached_to_dashboard values
  // type, dashboard_viz, detail_viz
  $data_table_sdi[13]=$data_table[32];
  $data_table_sdi[14]=$data_table[33];
  $data_table_sdi[15]=$data_table[34];
  $data_table_sdi[16]=$data_table[35];
  $data_table_sdi[17]=$data_table[36];
  $data_table_sdi[18]=$data_table[37];
  $data_table_sdi['nature']=$data_table['nature'];
    $data_table_sdi['multiple_type']=$data_table['multiple_type'];
  $data_table_sdi['mcolor']=$data_table['mcolor'];
  $data_table_sdi['tcolor']=$data_table['tcolor'];
  $data_table_sdi['api-enabled']=$data_table['api-enabled'];
  $data_table_sdi['api-url']=$data_table['api-url'];
  $data_table_sdi['api-date-field']=$data_table['api-date-field'];
  $data_table_sdi['api-value-field']=$data_table['api-value-field'];
  $data_table_sdi['api-decimal']=$data_table['api-decimal'];
  $data_table_sdi['api-get-values']=$data_table['api-get-values'];
  $data_table_sdi['api-get-values-since']=$data_table['api-get-values-since'];

  
  // from $data_table[13] to $data_table[18], it goes on Evaluation
  $j=0;
  for ($i=13;$i<19;$i++){
    $data_table_e[$j]=$data_table[$i];
    $j++;
  }
  // from $data_table[19] to $data_table[26], it goes on Provider
  $j=0;
  for ($i=19;$i<27;$i++){
    $data_table_p[$j]=$data_table[$i];
    $j++;
  }
  // from $data_table[27] to $data_table[30], it goes on Rules
  $j=0;
  for ($i=27;$i<=30;$i++){
    $data_table_r[$j]=$data_table[$i];
    $j++;
  }

  $result=$sdi_object->AddSdi($data_table_sdi, $sql_object);
  $result_e=$sdi_object->ModifyParam($result, $data_table_e, "E", $sql_object);
  $result_p=$sdi_object->ModifyParam($result, $data_table_p, "P", $sql_object);
  $result_r=$sdi_object->ModifyParam($result, $data_table_r, "R", $sql_object);
  
  // if attached tags are provided we store them in db
  if(!empty($data_table['tags']) && is_numeric($result)) {
  	
  	$otag = new tag();
  	
  	$otag->addTags('indicator', $result, $data_table['tags']);
  }
  
  // finally, we import initial values if asked
  if(is_numeric($result) && $data_table_sdi['api-get-values'] == 'Y') {
      $sdi = $sql_object->DBSelect(SQL_getInfoSdi($result));
      api_update_indicators($sdi, true);
  }

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) {
	// light-ui mode, we close the iframe
	if(!empty($http_params)) {
	  echo "<script>parent.$.fn.colorbox.close(); </script>";
	} else {
	  header("Location: ".safe_redirect($link_confirm));
	  exit;
    }
  } else  system_error();
}

$form_type = -1;
$form_nature = -1;
$form_dashboard_viz = -1;
$form_detail_viz = -1;
$form_value_type = -1;
$form_multiple_type = $GLOBALS['lang']['sdi']['select_multiple_type']['sum'];
$form_mcolor = $sdi_object->get_ValuesColor(); // main value color
$form_tcolor = $sdi_object->get_thresholdColor(); // threshold color
$form_name = '';
$form_level = '';
$form_tags='';
$form_statut = '';
$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';
$mask_dashboard="checked=\"checked\"";
$mask_threshold_relative = "";


$mask_api_enabled = '';
$form_api_url = '';
$form_api_datefield = '';
$form_api_valuefield = '';
$form_api_decimal = 0;
$mask_api_getvalues = '';
$form_api_values_since = '';


//$form_range = '';
$form_description = '';
$form_comment = '';
$form_goal = '';
$form_consulting = '';
$form_unit = '';
$form_max_value = '';
$form_min_value = '';
$form_threshold_value = '';
$form_frequency = '';

$form_e_scale_compare = 0;
$form_e_fiability = 0;
$form_e_accessibility = 0;
$form_e_lisibility = 0;
$form_e_relevance = 0;
$form_e_global_performance = 0;

// assessments values
$assessment_inputs = [0 => zero_asNC(0), 1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5];

$form_p_name = '';
$form_p_service = '';
$form_p_description = '';
$form_p_incharge = '';
$form_p_address = '';
$form_p_phone = '';
$form_p_fax = '';
$form_p_email = '';

$form_r_title = '';
$form_r_body = '';
$form_r_referer_uri = '';
$form_r_mask_uri = '';

if (isset($_POST['valider1'])) {

  $table = array();
  $table[0] = $_POST['sdi_name'];
  $table[1] = $_POST['description'];
  $table[2] = $_POST['comment'];
  $table[3] = $_POST['sdi_level'];
  //$table[4] = $_POST['range'];
  $table[4] = 0;
  $table[5] = $_POST['goal'];
  $table[6] = $_POST['consulting'];
  $table[7] = $_POST['unit'];
  $table[8] = $_POST['max_value'];
  $table[9] = $_POST['min_value'];
  $table[10]= $_POST['threshold_value'];
  $table[11]= $_POST['frequency'];
  $table[12]= $_POST['sdi_statut'];

  if (isset($_POST['threshold_relative'])) {
    $table[32] = "Y";
  	$mask_threshold_relative="checked=\"checked\"";
  } else {
    $table[32] = "N";
  	$mask_threshold_relative="";
  }

  if (isset($_POST['attached_to_dashboard'])) {
  	$table[33]="Y";
  	$mask_dashboard="checked=\"checked\"";
  } else {
  	$table[33]="N";
  	$mask_dashboard="";
  }
  $table[34]=$_POST['sdi_type'];
  $table['nature']=$_POST['sdi_nature'];
  $table[35] = $table['dashboard_viz'] = $_POST['sdi_dashboard_viz'];
  $table[36]=$_POST['sdi_detail_viz'];
  $table[37]=$_POST['sdi_value_type'];
  $table['multiple_type']=$_POST['sdi_multiple_type'];
  $table['tags']=$_POST['tags'];
  $table['mcolor']=$_POST['sdi_mcolor'];
  $table['tcolor']=$_POST['sdi_tcolor'];
  $table['api-url'] = $_POST['api-url'];
  $table['api-date-field'] = $_POST['api-date-field'];
  $table['api-value-field'] = $_POST['api-value-field'];
  $table['api-decimal'] = $_POST['api-decimal'];
  $table['api-get-values-since'] = $_POST['api-get-values-since'];
  
  // API forms fields handling
  if (isset($_POST['api-enabled'])) {
      $table['api-enabled']="Y";
      $mask_api_enabled="checked=\"checked\"";
  } else {
      $table['api-enabled']="N";
      $mask_api_enabled="";
  }
  if (isset($_POST['api-get-values'])) {
      $table['api-get-values']="Y";
      $mask_api_getvalues="checked=\"checked\"";
  } else {
      $table['api-get-values']="N";
      $mask_api_getvalues="";
  }

  $integrity = $sdi_object -> CheckDataIntegrity_info($table, true, 'nature');

  $form_nature = $_POST['sdi_nature'];
  $form_type = $_POST['sdi_type'];
  $form_dashboard_viz = $_POST['sdi_dashboard_viz'];
  $form_detail_viz = $_POST['sdi_detail_viz'];
  $form_value_type = $_POST['sdi_value_type'];
  $form_multiple_type =$_POST['sdi_multiple_type'];
  $form_name = formatText($_POST['sdi_name'], '2FIELD');
  $form_level = $_POST['sdi_level'];
  $form_statut= $_POST['sdi_statut'];
  //$form_range = $_POST['range'];
  $form_description = formatText($_POST['description'], '2FIELD');
  $form_comment = formatText($_POST['comment'], '2FIELD');
  $form_goal = formatText($_POST['goal'], '2FIELD');
  $form_consulting = formatText($_POST['consulting'], '2FIELD');
  $form_unit = formatText($_POST['unit'], '2FIELD');
  $form_max_value =$_POST['max_value'];
  $form_min_value = $_POST['min_value'];
  $form_threshold_value = $_POST['threshold_value'];
  $form_frequency = $_POST['frequency'];
  $form_tags=$_POST['tags'];
  $form_mcolor = $_POST['sdi_mcolor'];
  $form_tcolor = $_POST['sdi_tcolor'];
  
  $form_api_url = formatText($_POST['api-url'], '2FIELD');
  $form_api_datefield = formatText($_POST['api-date-field'], '2FIELD');
  $form_api_valuefield = formatText($_POST['api-value-field'], '2FIELD');
  $form_api_decimal = formatText($_POST['api-decimal'], '2FIELD');
  $form_api_values_since = formatText($_POST['api-get-values-since'], '2FIELD');
  
  if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';

  $table = urlencode(serialize($table));

}

if (isset($_POST['enregistrer2'])) {

  //intégrité des étapes 2,3,4 OK
  $integrity2 = 1;
  $integrity3 = 1;
  $integrity4 = 1;

  $table[0] = $_POST['sdi_name'];
  $table[1] = $_POST['description'];
  $table[2] = $_POST['comment'];
  $table[3] = $_POST['sdi_level'];
  //$table[4] = $_POST['range'];
  $table[4] = 0;
  $table[5] = $_POST['goal'];
  $table[6] = $_POST['consulting'];
  $table[7] = $_POST['unit'];
  $table[8] = $_POST['max_value'];
  $table[9] = $_POST['min_value'];
  $table[10]= $_POST['threshold_value'];
  $table[11]= $_POST['frequency'];
  $table[12]= $_POST['sdi_statut'];

  if (isset($_POST['threshold_relative'])) {
  	$table[32]="Y";
  	$mask_threshold_relative="checked=\"checked\"";
  } else {
  	$table[32]="N";
  	$mask_threshold_relative="";
  }
  
  if (isset($_POST['attached_to_dashboard'])) {
  	$table[33]="Y";
  	$mask_dashboard="checked=\"checked\"";
  } else {
  	$table[33]="N";
  	$mask_dashboard="";
  }

  $table[34]=$_POST['sdi_type'];
  $table['nature']=$_POST['sdi_nature'];
  $table[35] = $table['dashboard_viz'] = $_POST['sdi_dashboard_viz'];
  $table[36]=$_POST['sdi_detail_viz'];
  $table[37]=$_POST['sdi_value_type'];
  $table['multiple_type']=$_POST['sdi_multiple_type'];
  $table['tags']=$_POST['tags'];
  $table['mcolor']=$_POST['sdi_mcolor'];
  $table['tcolor']=$_POST['sdi_tcolor'];
  
  $table['api-url'] = $_POST['api-url'];
  $table['api-date-field'] = $_POST['api-date-field'];
  $table['api-value-field'] = $_POST['api-value-field'];
  $table['api-decimal'] = $_POST['api-decimal'];
  $table['api-get-values-since'] = $_POST['api-get-values-since'];
  
  
  // API forms fields handling
  if (isset($_POST['api-enabled'])) {
      $table['api-enabled']="Y";
      $mask_api_enabled="checked=\"checked\"";
  } else {
      $table['api-enabled']="N";
      $mask_api_enabled="";
  }
  if (isset($_POST['api-get-values'])) {
      $table['api-get-values']="Y";
      $mask_api_getvalues="checked=\"checked\"";
  } else {
      $table['api-get-values']="N";
      $mask_api_getvalues="";
  }

  // ugly array fill-up with 0 values for assessement values
  for ($z=13;$z<19;$z++){
    $table[$z]=0;
  }
  // ugly array fill-up
  for ($z=19;$z<31;$z++){
      $table[$z]="";
  }

  $integrity = $sdi_object -> CheckDataIntegrity_info($table);

  $form_nature = $_POST['sdi_nature'];
  $form_type = $_POST['sdi_type'];
  $form_dashboard_viz = $_POST['sdi_dashboard_viz'];
  $form_detail_viz = $_POST['sdi_detail_viz'];
  $form_value_type = $_POST['sdi_value_type'];
  $form_multiple_type =$_POST['sdi_multiple_type'];
  $form_name = formatText($_POST['sdi_name'], '2FIELD');
  $form_level = $_POST['sdi_level'];
  $form_statut= $_POST['sdi_statut'];
  //$form_range = $_POST['range'];
  $form_description = formatText($_POST['description'], '2FIELD');
  $form_comment = formatText($_POST['comment'], '2FIELD');
  $form_goal = formatText($_POST['goal'], '2FIELD');
  $form_consulting = formatText($_POST['consulting'], '2FIELD');
  $form_unit = formatText($_POST['unit'], '2FIELD');
  $form_tags=$_POST['tags'];
  $form_max_value =$_POST['max_value'];
  $form_min_value = $_POST['min_value'];
  $form_threshold_value = $_POST['threshold_value'];
  $form_frequency = $_POST['frequency'];
  $form_mcolor = $_POST['sdi_mcolor'];
  $form_tcolor = $_POST['sdi_tcolor'];
  
  $form_api_url = formatText($_POST['api-url'], '2FIELD');
  $form_api_datefield = formatText($_POST['api-date-field'], '2FIELD');
  $form_api_valuefield = formatText($_POST['api-value-field'], '2FIELD');
  $form_api_decimal = formatText($_POST['api-decimal'], '2FIELD');
  $form_api_values_since = formatText($_POST['api-get-values-since'], '2FIELD');
  
  if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';

  $table = urlencode(serialize($table));
}

if (isset($_POST['valider2'])) {

  $integrity = 1;
  $table = unserialize(urldecode($_POST['table']));
  $table[13] = $_POST['e_scale_compare'];
  $table[14] = $_POST['e_fiability'];
  $table[15] = $_POST['e_accessibility'];
  $table[16] = $_POST['e_lisibility'];
  $table[17] = $_POST['e_relevance'];
  $table[18] = $_POST['e_global_performance'];
  $integrity2 = $sdi_object -> CheckDataIntegrity_eval($table);
  $form_e_scale_compare = $_POST['e_scale_compare'];
  $form_e_fiability = $_POST['e_fiability'];
  $form_e_accessibility = $_POST['e_accessibility'];
  $form_e_lisibility = $_POST['e_lisibility'];
  $form_e_relevance = $_POST['e_relevance'];
  $form_e_global_performance = $_POST['e_global_performance'];

  $table = urlencode(serialize($table));
}

if (isset($_POST['valider3'])) {
  $integrity = 1;
  $integrity2 = 1;
  $table = unserialize(urldecode($_POST['table']));
  $table[19] = $_POST['p_name'];
  $table[20] = $_POST['p_service'];
  $table[21] = $_POST['p_description'];
  $table[22] = $_POST['p_incharge'];
  $table[23] = $_POST['p_address'];
  $table[24] = str_replace(' ', '', $_POST['p_phone']);
  $table[25] = str_replace(' ', '', $_POST['p_fax']);
  $table[26] = $_POST['p_email'];
  $integrity3 = $sdi_object -> CheckDataIntegrity_provider($table);

  $form_p_name = formatText($_POST['p_name'], '2FIELD');
  $form_p_service = formatText($_POST['p_service'], '2FIELD');
  $form_p_description = formatText($_POST['p_description'], '2FIELD');
  $form_p_incharge = formatText($_POST['p_incharge'], '2FIELD');
  $form_p_address = formatText($_POST['p_address'], '2FIELD');
  $form_p_phone = str_replace(' ', '', $_POST['p_phone']);
  $form_p_fax = str_replace(' ', '', $_POST['p_fax']);
  $form_p_email = $_POST['p_email'];

  $table = urlencode(serialize($table));
}

if (isset($_POST['valider4'])) {

  $integrity = 1;
  $integrity2 = 1;
  $integrity3 = 1;
  $table = unserialize(urldecode($_POST['table']));
  $table[27] = $_POST['r_title'];
  $table[28] = $_POST['r_body'];
  $table[29] = $_POST['r_referer_uri'];
  if ($_POST['r_mask_uri']=="")$table[30] = $table[29];
  else $table[30]=$_POST['r_mask_uri'];
  $integrity4 = $sdi_object -> CheckDataIntegrity_reglementation($table);

  $form_r_title = formatText($_POST['r_title'], '2FIELD');
  $form_r_body = formatText($_POST['r_body'], '2FIELD');
  $form_r_referer_uri = $_POST['r_referer_uri'];
  if ($_POST['r_mask_uri']=="")$form_r_mask_uri = $form_r_referer_uri;
  else $form_r_mask_uri =$_POST['r_mask_uri'];

  $table = urlencode(serialize($table));
}

// select-box des niveaux
$data=$sql_object->DBSelect(SQL_getLevelsList());
$select_level=LevelSelectBox($data, "sdi_level", $form_level);

$select_type=selectBox($lang['sdi']['select_type'], "sdi_type", $form_type);
$select_nature=selectBox($lang['sdi']['select_nature'], "sdi_nature", $form_nature);
$select_dashboard_viz = selectBox($lang['sdi']['select_dashboard_viz'], "sdi_dashboard_viz", $form_dashboard_viz, INDICATOR_DASHBOARD_VIZ);
$select_detail_viz = selectBox($lang['sdi']['select_detail_viz'], "sdi_detail_viz", $form_detail_viz);
$select_value_type = selectBox($lang['sdi']['select_value_type'], "sdi_value_type", $form_value_type);
$select_multiple_type = selectBox($lang['sdi']['select_multiple_type'], "sdi_multiple_type", $form_multiple_type);
?>

<?php
if (!isset($integrity) || is_string($integrity)) {
	
	?>
	<script>
	$(document).ready( function() {

		$('#api-enabled').change(function() {
			if($(this).is(":checked")) $( ".api-child" ).prop( "readonly", false );
			else $( ".api-child" ).prop( "readonly", true );
		}); 
		$("#api-enabled").trigger("change");

		$("div.see-tags").hover(
			function() {
				$('.tags-list', this).fadeIn();
			},
			function() {
				$('.tags-list', this).hide();
		});
				
		// Autocomplete initialization
		var t1 = new $.TextboxList('#tags', {unique: true, plugins: {autocomplete: {onlyFromValues: false, placeholder:"<?php echo _t('textbox_js', 'placeholder')?>"}}});
		
		$.ajax({url: '../admin/_ajax_tag_autocomplete.php', dataType: 'json', success: function(r){
			t1.plugins['autocomplete'].setValues(r);
		}});
				
		$("div.textboxlist").each(function() {
			$(this).append('<p class="soft-emphase"><?php echo _t('msg','textboxlist_notice') ?><\/p>');
		});

	});
	</script>
			
	<?php 
	
	$js = '
	$("#sdi_nature").change(function() {
		
	if($(this).val() == "boolean" || $(this).val() == "qualitative") {

 		if($(this).val() == "qualitative") var text = "'.sprintf(_t('sdi','qualindicator_notice'), '#attached_to_dashboard').'";
 		else var text = "'.sprintf(_t('sdi','boolindicator_notice'), '#attached_to_dashboard').'";
		
		$("#boolean-indic-notice").remove();
		$("#sdi_dashboard_viz option[value=\'sparkline\']").attr("disabled", "disabled");
	
		if($("#sdi_dashboard_viz").val() == "sparkline") $("#sdi_dashboard_viz option[value=\'raw\']").attr("selected", "selected");
		$("#sdi_nature").after("<span class=\"soft-emphase input-notice\" id=\"boolean-indic-notice\">" + text + "<\/span>");
		
	} else {
	
		$("#sdi_dashboard_viz option[value=\'sparkline\']").removeAttr("disabled");
		$("#boolean-indic-notice").remove();
	}
		
	});
	
	// we call the function on loading page
	$("#sdi_nature").change();

    $("#sdi_value_type").change(function() {
		
	if($(this).val() == "multiple") {

 		var text = "'.sprintf(_t('sdi','multipleindicator_notice'), '#attached_to_dashboard').'";
		
		$("#multiple-indic-notice").remove();	
		$("#sdi_value_type").after("<span class=\"soft-emphase input-notice\" id=\"multiple-indic-notice\">" + text + "<\/span>");
		$("#sdi_multiple_type_cont").fadeIn();
		
	} else {
		$("#multiple-indic-notice").remove();
		$("#sdi_multiple_type_cont").hide();
	}
		
	});
    // we call the function on loading page
    $("#sdi_value_type").change();
	';
	
	footerAddInlineJS($js);
	
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if (isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<div class="stepper-wrapper">
  <div class="stepper-item active">
    <div class="step-counter">1</div>
    <div class="step-name"><?php echo _t('sdi','add_step1'); ?></div>
  </div>
  <div class="stepper-item">
    <div class="step-counter">2</div>
    <div class="step-name"><?php echo _t('sdi','add_step2'); ?></div>
  </div>
  <div class="stepper-item">
    <div class="step-counter">3</div>
    <div class="step-name"><?php echo _t('sdi','add_step3'); ?></div>
  </div>
  <div class="stepper-item">
    <div class="step-counter">4</div>
    <div class="step-name"><?php echo _t('sdi','add_step4'); ?></div>
  </div>
</div>
<br class="mtm" />

<h2><?php echo _t('sdi','add_title1') ?></h2>

<form id="addsdi" action="<?php echo $_SERVER['SCRIPT_NAME'].$http_params; ?>" method="post">
<p>
  	<label for="sdi_name"><?php echo mb_ucfirst(_t('sdi','name2')) ?>&nbsp;:&nbsp;*</label>
  	<input name="sdi_name" type="text" class="textfield" id="sdi_name" maxlength="400" value="<?php echo $form_name; ?>" required />
</p>
<p>
  	<label for="sdi_type"><?php echo mb_ucfirst(_t('sdi','type')) ?> : </label>
  	<?php echo $select_type; ?>
</p>
<p>
  	<label for="sdi_nature"><?php echo mb_ucfirst(_t('sdi','nature')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_nature; ?>
</p>
<p>
  	<label for="sdi_dashboard_viz"><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_dashboard_viz; ?>
</p>
<p>
  	<label for="sdi_detail_viz"><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_detail_viz; ?>
</p>
<div class="label"><?php echo mb_ucfirst(_t('sdi','colors')); ?> :</div>
<div class="rightpanel">
  <input name="sdi_mcolor" type="color" id="sdi_mcolor" value="<?php echo $form_mcolor; ?>" required />
  <label for="sdi_mcolor" class="mrl"><?php echo mb_ucfirst(_t('dashboard','value')); ?></label>
  <input name="sdi_tcolor" type="color" id="sdi_tcolor" value="<?php echo $form_tcolor; ?>" required />
  <label for="sdi_tcolor"><?php echo mb_ucfirst(_t('dashboard','threshold_value')); ?></label>
</div>
<p>
  	<label for="sdi_value_type"><?php echo mb_ucfirst(_t('sdi','value_type')) ?>&nbsp;:&nbsp;*</label>
  	<?php echo $select_value_type; ?>
</p>
<p id="sdi_multiple_type_cont">
   <label for="sdi_multiple_type"><?php echo mb_ucfirst(_t('sdi','multiple_type')) ?>&nbsp;:&nbsp;*</label>
   <?php echo $select_multiple_type; ?>
</p>
<p>
	<label for="sdi_level"><?php echo mb_ucfirst(_t('sdi','level')) ?>&nbsp;:&nbsp;*</label>
    <?php echo $select_level; ?>
</p>

<div class="label"><?php echo mb_ucfirst(_t('divers','statut')); ?> :</div>
<div class="rightpanel">
  <input name="sdi_statut" type="radio" class="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> required />
  <label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
  <input name="sdi_statut" type="radio" class="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
  <label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
</div>
<?php
/** ?><p>
<label for="range" ><?php echo _t('sdi','range') ?> * :</label>
<input name="range" type="text" size="47" id="range" maxlength="150" value="<?php echo $form_range;
?>" />
</p>
<?php */?>
<p>
	<label for="description"><?php echo mb_ucfirst(_t('sdi','description')) ?>&nbsp;:&nbsp;*</label>
	<textarea id="description" name="description" class="largetextfield" required><?php echo $form_description; ?></textarea>
</p>
<p>
	<label for="goal"><?php echo mb_ucfirst(_t('sdi','goal')); ?> :</label>
	<textarea id="goal" name="goal" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_goal; ?></textarea>
</p>
<p>
	<label for="consulting"><?php echo mb_ucfirst(_t('sdi','consulting')); ?> :</label>
	<textarea id="consulting" name="consulting" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_consulting; ?></textarea>
</p>
<p class="mts">
	<label for="attached_to_dashboard"><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard')); ?> :</label>
	<input type="checkbox" class="switch" name="attached_to_dashboard" value="1" id="attached_to_dashboard" <?php echo $mask_dashboard; ?> />
</p>
<div>
  <div class="see-tags label">
	<label for="tags"><i class="fa fa-tag" aria-hidden="true"></i> <?php echo mb_ucfirst(_t('tag','name')); ?> : </label>
	<?php echo $tags_list; ?>
  </div>
  <input name="tags" type="text" maxlength="800" id="tags" class="textfield" value="<?php echo $form_tags; ?>" />
</div>
<p>
	<label for="comment"><?php echo mb_ucfirst(_t('sdi','comment')); ?> :</label>
	<textarea id="comment" name="comment" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_comment; ?></textarea>
</p>

<h3 class="part"><?php echo mb_ucfirst(_t('sdi','info_mesure')); ?></h3>

<p>
	<label for="unit"><?php echo mb_ucfirst(_t('sdi','unit')); ?>&nbsp;:&nbsp;*</label>
	<input name="unit" type="text" class="textfield" id="unit" maxlength="100" value="<?php echo $form_unit; ?>" required />
</p>
<p>
	<label for="min_value"><?php echo mb_ucfirst(_t('sdi','min_value')); ?> :</label>
	<input name="min_value" type="text" class="textfield" id="min_value" maxlength="100" value="<?php echo $form_min_value; ?>" />
</p>
<p>
	<label for="max_value"><?php echo mb_ucfirst(_t('sdi','max_value')); ?> :</label>
	<input name="max_value" type="text" class="textfield" id="max_value" maxlength="100" value="<?php echo $form_max_value; ?>" />
</p>
<p>
	<label for="threshold_value"><?php echo mb_ucfirst(_t('sdi','initial_threshold_value')); ?> :</label>
	<input name="threshold_value" type="text" class="textfield" id="threshold_value" maxlength="100" value="<?php echo $form_threshold_value; ?>" />
</p>
<p>
	<label for="frequency"><?php echo mb_ucfirst(_t('sdi','frequency')); ?>&nbsp;:&nbsp;*</label>
	<input name="frequency" type="text" class="textfield" id="frequency" maxlength="11" value="<?php echo $form_frequency; ?>" required />
</p>

<div class="label"><?php echo mb_ucfirst(_t('sdi','threshold_relative')); ?>&nbsp;:&nbsp;*</div>
<div class="rightpanel">
  <input type="checkbox" class="switch" name="threshold_relative" value="1" id="threshold_relative" <?php echo $mask_threshold_relative; ?> />
  <label for="threshold_relative"><?php echo mb_ucfirst(_t('sdi','threshold_relative_comment')); ?></label>
</div>
<div class="<?php echo $apiclass; ?>">
<h3 class="part"><?php echo mb_ucfirst(_t('sdi','api')); ?></h3>

<p class="mts">
	<label for="api-enabled"><?php echo mb_ucfirst(_t('sdi','api-enabled')); ?> :</label>
	<input type="checkbox" class="switch" name="api-enabled" value="1" id="api-enabled" <?php echo $mask_api_enabled; ?> />
</p>
<p>
	<label for="api-url"><?php echo mb_ucfirst(_t('sdi','api-url')); ?>&nbsp;:&nbsp;*</label>
	<input name="api-url" type="text" class="textfield api-child" id="unit" value="<?php echo $form_api_url; ?>" />
</p>
<p>
	<label for="api-date-field"><?php echo mb_ucfirst(_t('sdi','api-date-field')); ?> :</label>
	<input name="api-date-field" type="text" class="textfield api-child" id="api-date-field" maxlength="150" value="<?php echo $form_api_datefield; ?>" />
</p>
<p>
	<label for="api-value-field"><?php echo mb_ucfirst(_t('sdi','api-value-field')); ?> :</label>
	<input name="api-value-field" type="text" class="textfield api-child" id="api-value-field" maxlength="150" value="<?php echo $form_api_valuefield; ?>" />
</p>
<p>
	<label for="api-decimal"><?php echo mb_ucfirst(_t('sdi','api-decimal')); ?> :</label>
	<input name="api-decimal" type="number" class="api-child" id="api-decimal" min="0" max="5" step="1" value="<?php echo $form_api_decimal; ?>" />
</p>
<p class="mts">
	<label for="api-get-values"><?php echo mb_ucfirst(_t('sdi','api-get-values')); ?> :</label>
	<input type="checkbox" class="switch api-child" name="api-get-values" value="1" id="api-get-values" <?php echo $mask_api_getvalues; ?> />
</p>
<p>
	<label for="api-get-values-since"><?php echo mb_ucfirst(_t('sdi','api-get-values-since')); ?> :</label>
	<input name="api-get-values-since" type="text" class="textfield api-child" id="api-get-values-since" maxlength="100" value="<?php echo $form_api_values_since; ?>" />
</p>
</div>

<div>
	<input name="rub" type="hidden" value="<?php echo $rub; ?>"	id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <?php if(empty($http_params)) echo cancel_button($rub_link."&amp;todo=list"); else echo cancel_button_close_parent(); ?>
    <input name="enregistrer2" type="submit" value="<?php echo _t('sdi','btn_fin') ?>" class="button" id="enregistrer2" />
    <input name="valider1" type="submit" value="<?php echo _t('sdi','btn_step1') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else {
  if (!isset($integrity2) || is_string($integrity2)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if (isset($integrity2) && is_string($integrity2)) display_errors($integrity2);
?>
<div class="stepper-wrapper">
  <div class="stepper-item completed">
    <div class="step-counter">1</div>
    <div class="step-name"><?php echo _t('sdi','add_step1'); ?></div>
  </div>
  <div class="stepper-item active">
    <div class="step-counter">2</div>
    <div class="step-name"><?php echo _t('sdi','add_step2'); ?></div>
  </div>
  <div class="stepper-item">
    <div class="step-counter">3</div>
    <div class="step-name"><?php echo _t('sdi','add_step3'); ?></div>
  </div>
  <div class="stepper-item">
    <div class="step-counter">4</div>
    <div class="step-name"><?php echo _t('sdi','add_step4'); ?></div>
  </div>
</div>
<br class="mtm" />

<h2><?php echo mb_ucfirst(_t('sdi','add_title2')); ?></h2>

<form id="addsdi2" action="<?php echo $_SERVER['SCRIPT_NAME'].$http_params; ?>" method="post">
<p>
	<label for="e_scale_compare"><?php echo mb_ucfirst(_t('sdi','e_scale_compare')) ?> :</label>
	<?php echo selectBox($assessment_inputs, 'e_scale_compare', $form_e_scale_compare, null, array()); ?>
</p>
<p>
	<label for="e_fiability"><?php echo mb_ucfirst(_t('sdi','e_fiability')) ?> :</label>
	<?php echo selectBox($assessment_inputs, 'e_fiability', $form_e_fiability, null, array()); ?>
</p>
<p>
	<label for="e_accessibility"><?php echo mb_ucfirst(_t('sdi','e_accessibility')) ?> :</label>
	<?php echo selectBox($assessment_inputs, 'e_accessibility', $form_e_accessibility, null, array()); ?>
</p>
<p>
	<label for="e_lisibility"><?php echo mb_ucfirst(_t('sdi','e_lisibility')) ?> :</label>
	<?php echo selectBox($assessment_inputs, 'e_lisibility', $form_e_lisibility, null, array()); ?>
</p>
<p>
	<label for="e_relevance"><?php echo mb_ucfirst(_t('sdi','e_relevance')) ?> :</label>
	<?php echo selectBox($assessment_inputs, 'e_relevance', $form_e_relevance, null, array()); ?>
</p>
<p>
	<label for="e_global_performance"><?php echo mb_ucfirst(_t('sdi','e_global_performance')) ?> : </label>
	<?php echo selectBox($assessment_inputs, 'e_global_performance', $form_e_global_performance, null, array()); ?>
</p>

<div>
  <input name="table" type="hidden" value="<?php echo $table; ?>" id="table" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php if(empty($http_params)) echo cancel_button($rub_link."&amp;todo=list"); else echo cancel_button_close_parent(); ?>
  <input name="valider2" type="submit" value="<?php echo _t('sdi','btn_step2') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
} else {
    if (!isset($integrity3) || is_string($integrity3)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if (isset($integrity3) && is_string($integrity3)) display_errors($integrity3);
?>
<div class="stepper-wrapper">
  <div class="stepper-item completed">
    <div class="step-counter">1</div>
    <div class="step-name"><?php echo _t('sdi','add_step1'); ?></div>
  </div>
  <div class="stepper-item completed">
    <div class="step-counter">2</div>
    <div class="step-name"><?php echo _t('sdi','add_step2'); ?></div>
  </div>
  <div class="stepper-item active">
    <div class="step-counter">3</div>
    <div class="step-name"><?php echo _t('sdi','add_step3'); ?></div>
  </div>
  <div class="stepper-item">
    <div class="step-counter">4</div>
    <div class="step-name"><?php echo _t('sdi','add_step4'); ?></div>
  </div>
</div>
<br class="mtm" />

<h2><?php echo mb_ucfirst(_t('sdi','add_title3')); ?></h2>

<form id="addsdi3" action="<?php echo $_SERVER['SCRIPT_NAME'].$http_params; ?>" method="post">
<p>
	<label for="p_name"><?php echo mb_ucfirst(_t('sdi','p_name')) ?> :</label>
	<input name="p_name" type="text" class="textfield" id="p_name" maxlength="255" value="<?php echo $form_p_name; ?>" />
</p>
<p>
	<label for="p_service"><?php echo mb_ucfirst(_t('sdi','p_service')) ?> :</label>
	<input name="p_service" type="text" class="textfield" id="p_service" maxlength="255" value="<?php echo $form_p_service; ?>" />
</p>
<p>
	<label for="p_incharge"><?php echo mb_ucfirst(_t('sdi','p_incharge')) ?> :</label>
	<input name="p_incharge" type="text" class="textfield" id="p_incharge" maxlength="150" value="<?php echo $form_p_incharge; ?>" />
</p>
<p>
	<label for="p_address"><?php echo mb_ucfirst(_t('sdi','p_address')) ?> :</label>
	<textarea id="p_address" name="p_address" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_p_address; ?></textarea>
</p>
<p>
	<label for="p_phone"><?php echo mb_ucfirst(_t('sdi','p_phone')) ?> :</label>
	<input name="p_phone" type="text" class="textfield phone-format" id="p_phone" maxlength="14" value="<?php echo $form_p_phone; ?>" />
</p>
<p>
	<label for="p_fax"><?php echo mb_ucfirst(_t('sdi','p_fax')) ?> :</label>
	<input name="p_fax" type="text" class="textfield phone-format" id="p_fax" maxlength="14" value="<?php echo $form_p_fax; ?>" />
</p>
<p>
	<label for="p_email"><?php echo mb_ucfirst(_t('sdi','p_email')) ?> :</label>
	<input name="p_email" type="text" class="textfield" id="p_email" maxlength="200" value="<?php echo $form_p_email; ?>" />
</p>
<p>
	<label for="p_description"><?php echo mb_ucfirst(_t('sdi','p_description')) ?> :</label>
	<textarea id="p_description" name="p_description" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_p_description; ?></textarea>
</p>
<div>
	<input name="table" type="hidden" value="<?php echo $table; ?>" id="table" />
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <?php if(empty($http_params)) echo cancel_button($rub_link."&amp;todo=list"); else echo cancel_button_close_parent(); ?>
    <input name="valider3" type="submit" value="<?php echo _t('sdi','btn_step3') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
    } else {
      if (!isset($integrity4) || is_string($integrity4)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if (isset($integrity4) && is_string($integrity4)) display_errors($integrity4);
?>
<div class="stepper-wrapper">
  <div class="stepper-item completed">
    <div class="step-counter">1</div>
    <div class="step-name"><?php echo _t('sdi','add_step1'); ?></div>
  </div>
  <div class="stepper-item completed">
    <div class="step-counter">2</div>
    <div class="step-name"><?php echo _t('sdi','add_step2'); ?></div>
  </div>
  <div class="stepper-item completed">
    <div class="step-counter">3</div>
    <div class="step-name"><?php echo _t('sdi','add_step3'); ?></div>
  </div>
  <div class="stepper-item active">
    <div class="step-counter">4</div>
    <div class="step-name"><?php echo _t('sdi','add_step4'); ?></div>
  </div>
</div>
<br class="mtm" />

<h2><?php echo mb_ucfirst(_t('sdi','add_title4')); ?></h2>

<form id="addsdi4" action="<?php echo $_SERVER['SCRIPT_NAME'].$http_params; ?>" method="post">
<p>
	<label for="r_title"><?php echo mb_ucfirst(_t('sdi','r_title')) ?> : </label>
	<input name="r_title" type="text" class="textfield" id="r_title" maxlength="255" value="<?php echo $form_r_title; ?>" />
</p>
<p>
	<label for="r_body"><?php echo mb_ucfirst(_t('sdi','r_body')) ?> :</label>
	<textarea id="r_body" name="r_body" <?php echo AREA_SETTINGS; ?> class="largetextfield"><?php echo $form_r_body; ?></textarea>
</p>
<p>
	<label for="r_referer_uri"><?php echo mb_ucfirst(_t('sdi','r_referer_uri')) ?> :</label>
	<input name="r_referer_uri" type="text" class="textfield" id="r_referer_uri" maxlength="255" value="<?php echo $form_r_referer_uri; ?>" placeholder="http(s)://" />
</p>
<p>
	<label for="r_mask_uri"><?php echo mb_ucfirst(_t('sdi','r_mask_uri')) ?> :</label>
	<input name="r_mask_uri" type="text" class="textfield" id="r_mask_uri" maxlength="255" value="<?php echo $form_r_mask_uri; ?>" />
</p>

<div>
  <input name="table" type="hidden" value="<?php echo $table;  ?>" id="table" />
  <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
  <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
  <?php if(empty($http_params)) echo cancel_button($rub_link."&amp;todo=list"); else echo cancel_button_close_parent(); ?>
  <input name="valider4" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
} else {
        if (!isset($integrity5) || is_string($integrity5)) {


          $table=unserialize(urldecode($table));
          
          $display_sdi_name = formatText(empty_nc($table[0]), '2HTML');
          $display_sdi_description =formatText(empty_nc($table[1]), '2HTML');
          $display_sdi_comment =formatText(empty_nc($table[2]), '2HTML');
          //$display_sdi_range = empty_nc($table[4]);
          $display_sdi_goal = formatText(empty_nc($table[5]), '2HTML');
          $display_sdi_consulting = formatText(empty_nc($table[6]), '2HTML');
          $display_sdi_unit = formatText(empty_nc($table[7]), '2HTML');
          $display_sdi_max_value = empty_nc(fnumber_format($table[8], 'auto', false));
          $display_sdi_min_value = empty_nc(fnumber_format($table[9], 'auto', false));
          $display_sdi_threshold_value = empty_none(fnumber_format($table[10], 'auto', false));
          $display_sdi_frequency = empty_nc(fnumber_format($table[11], 'auto', false));
          $display_sdi_statut = empty_nc($table[12]);
          $display_e_scale_compare = zero_asNC($table[13]);
          $display_e_fiability = zero_asNC($table[14]);
          $display_e_accessibility = zero_asNC($table[15]);
          $display_e_lisibility = zero_asNC($table[16]);
          $display_e_relevance = zero_asNC($table[17]);
          $display_e_global_performance = zero_asNC($table[18]);
          $display_p_name = formatText(empty_nc($table[19]), '2HTML');
          $display_p_service = formatText(empty_nc($table[20]), '2HTML');
          $display_p_description =formatText(empty_nc($table[21]), '2HTML');
          $display_p_incharge = formatText(empty_nc($table[22]), '2HTML');
          $display_p_address =formatText(empty_nc($table[23]), '2HTML');
          $display_p_phone =empty_nc($table[24]);
          $display_p_fax = empty_nc($table[25]);
          $display_p_email = empty_nc($table[26]);
          $display_r_title =formatText(empty_nc($table[27]), '2HTML');
          $display_r_body = formatText(empty_nc($table[28]), '2HTML');
          $display_r_referer_uri = empty_nc($table[29]);
          $display_r_mask_uri = formatText(empty_nc($table[30]), '2HTML');

          if ($table[32]=='Y') $display_sdi_threshold_relative = _t('sdi','threshold_relative_Y');
          else $display_sdi_threshold_relative = _t('sdi','threshold_relative_N');

          if ($table[33]=='Y') $display_attached_to_dashboard = _t('divers','yes');
          else $display_attached_to_dashboard = _t('divers','no');
          
          if ($table['api-enabled']=='Y') $display_api_enabled = _t('divers','yes');
          else $display_api_enabled = _t('divers','no');
          if ($table['api-get-values']=='Y') $display_get_values = _t('divers','yes');
          else $display_get_values = _t('divers','no');
          if(trim($table['api-get-values-since']) != '') $display_get_values_since = $table['api-get-values-since'];
          else $display_get_values_since = empty_nc('');
          
          $display_api_url = formatText(empty_nc($table['api-url']), '2HTML');
          $display_api_decimal = ' (' . _t('sdi','api-decimal') . ' : ' . formatText($table['api-decimal'], '2HTML').')';
          if(Stringy\Stringy::create($display_api_url, CHARSET)->isUrl()) $display_api_url = sprintf('<a href="%s" target="_blank">%s</a>', $display_api_url, $display_api_url);
          $display_api_datefield = formatText(empty_nc($table['api-date-field']), '2HTML');
          $display_api_valuefield = formatText(empty_nc($table['api-value-field']), '2HTML');

          $display_sdi_nature = formatText($lang['sdi']['select_nature'][$table['nature']], '2HTML');
          $display_sdi_type = formatText($lang['sdi']['select_type'][$table[34]], '2HTML');
          $display_sdi_dashboard_viz = formatText($lang['sdi']['select_dashboard_viz'][$table[35]], '2HTML');
          $display_sdi_detail_viz = formatText($lang['sdi']['select_detail_viz'][$table[36]], '2HTML');
          $display_sdi_value_type = formatText($lang['sdi']['select_value_type'][$table[37]], '2HTML');
          $display_sdi_multiple_type = formatText($lang['sdi']['select_multiple_type'][$table['multiple_type']], '2HTML');

          $multipleclass = ($table[37] != 'multiple') ? 'invisible' : '';

          $record=$sql_object->DBSelect(SQL_getoneLevel($table[3]));
          isset($record[0]['level_name']) ? $display_sdi_level=formatText($record[0]['level_name'], '2HTML') : $display_sdi_level= _t('sdi', 'no_associated_level'). ' <span class="hint--top hint--large hint--rounded" aria-label="'. formatText(_t('sdi', 'no_associated_level_notice'), '2ATT') . '"><i class="fa fa-info-circle" aria-hidden="true"></i></span>'; // if no associated label

          $table = urlencode(serialize($table));
 ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));

?>
<div id="content">
<h2><?php echo mb_ucfirst(_t('recap','title')); ?></h2>
<h3 class="part"><?php echo mb_ucfirst(_t('sdi','add_step1')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','name2')); ?> :</dt>
	<dd><?php echo $display_sdi_name; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','type')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_type);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','nature')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_nature);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','dashboard_viz')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_dashboard_viz);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','detail_viz')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_detail_viz);?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','colors')) ?> : </dt>
	<dd><?php echo '<div class="mbs">' .get_html_colorbox($form_mcolor) . _t('dashboard','value') . '</div><div class="mbs">' . get_html_colorbox($form_tcolor). _t('dashboard','threshold_value').'</div>'; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','value_type')) ?> : </dt>
	<dd><?php echo mb_ucfirst($display_sdi_value_type);?></dd>
    <div class="<?php echo $multipleclass; ?>">
        <dt><?php echo mb_ucfirst(_t('sdi','multiple_type')) ?> : </dt>
        <dd><?php echo mb_ucfirst($display_sdi_multiple_type);?></dd>
    </div>
	<dt><?php echo mb_ucfirst(_t('divers','statut')); ?> :</dt>
	<dd><?php echo display_statut($display_sdi_statut); ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','level'));	?> :</dt>
	<dd><?php echo $display_sdi_level;	?></dd>
	<?php
	/** <dt><?php echo _t('sdi','range'); ?> :</dt>
	<dd><?php echo $display_sdi_range;?></dd> */
	?>
	<dt><?php echo mb_ucfirst(_t('sdi','description')); ?> :</dt>
	<dd><?php echo $display_sdi_description; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','goal'));	?> :</dt>
	<dd><?php echo $display_sdi_goal;	?>	</dd>
	<dt><?php echo mb_ucfirst(_t('sdi','consulting'));	?> :</dt>
	<dd><?php echo $display_sdi_consulting;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','attached_to_dashboard'));	?> :</dt>
	<dd><?php echo $display_attached_to_dashboard;	?></dd>
	<dt><?php echo mb_ucfirst(_t('tag','name')); ?> :</dt>
	<dd><?php echo empty_none(str_replace(',', ', ', $form_tags)); ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','comment')); ?> :</dt>
	<dd><?php echo $display_sdi_comment; ?></dd>
</dl>

<h3 class="part"><?php echo mb_ucfirst(_t('sdi','info_mesure')); ?></h3>
<dl>
	<dt><?php echo mb_ucfirst(_t('sdi','unit'));	?> :</dt>
	<dd><?php echo $display_sdi_unit;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','min_value'));	?> :</dt>
	<dd><?php echo $display_sdi_min_value;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','max_value'));	?> :</dt>
	<dd><?php echo $display_sdi_max_value;	?>	</dd>
	<dt><?php echo mb_ucfirst(_t('sdi','initial_threshold_value'));	?> :</dt>
	<dd><?php echo $display_sdi_threshold_value;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','threshold_relative'));	?> :</dt>
	<dd><?php echo $display_sdi_threshold_relative;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','frequency'));	?> :</dt>
	<dd><?php echo $display_sdi_frequency;	?></dd>
</dl>

<div class="<?php echo $apiclass; ?>">
<h3 class="part"><?php echo mb_ucfirst(_t('sdi','api')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','api-enabled')); ?> :</dt>
	<dd><?php echo $display_api_enabled; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-url')); ?> :</dt>
	<dd><?php echo $display_api_url;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-date-field')); ?> :</dt>
	<dd><?php echo $display_api_datefield; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-value-field'));	?> :</dt>
	<dd><?php echo $display_api_valuefield . $display_api_decimal; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','api-get-values'));	?> :</dt>
	<dd><?php echo $display_get_values;	?></dd>
	<?php if ($display_get_values == _t('divers','yes')) { ?>
	<dt><?php echo mb_ucfirst(_t('sdi','api-get-values-since')); ?> :</dt>
	<dd><?php echo $display_get_values_since;	?></dd>
	<?php } ?>
</dl>
 </div>

<h3 class="part"><?php echo mb_ucfirst(_t('sdi','add_step2')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','e_scale_compare'));	?> :</dt>
	<dd><?php echo $display_e_scale_compare; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','e_fiability'));	?> :</dt>
	<dd><?php echo $display_e_fiability; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','e_accessibility'));	?> :</dt>
	<dd><?php echo $display_e_accessibility; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','e_lisibility')); ?> :</dt>
	<dd><?php echo $display_e_lisibility; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','e_relevance'));	?> :</dt>
	<dd><?php echo $display_e_relevance; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','e_global_performance')); ?> :</dt>
	<dd><?php echo $display_e_global_performance; ?></dd>
</dl>

<h3 class="part"><?php echo mb_ucfirst(_t('sdi','add_step3')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','p_name'));	?> :</dt>
	<dd><?php echo $display_p_name;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_service'));	?> :</dt>
	<dd><?php echo $display_p_service;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_description'));	?> :</dt>
	<dd><?php echo $display_p_description;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_incharge'));	?> :</dt>
	<dd><?php echo $display_p_incharge;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_address')); ?> :</dt>
	<dd><?php echo $display_p_address; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_phone'));	?> :</dt>
	<dd class="phone-format"><?php echo $display_p_phone; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_fax')); ?> :</dt>
	<dd class="phone-format"><?php echo $display_p_fax;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','p_email'));	?> :</dt>
	<dd><?php echo $display_p_email; ?></dd>
</dl>

<h3 class="part"><?php echo mb_ucfirst(_t('sdi','add_step4')); ?></h3>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('sdi','r_title'));	?> :</dt>
	<dd><?php echo $display_r_title; ?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','r_body'));	?> :</dt>
	<dd><?php echo $display_r_body;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','r_referer_uri'));	?> :</dt>
	<dd><?php echo $display_r_referer_uri;	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','r_mask_uri'));	?> :</dt>
	<dd><?php echo $display_r_mask_uri;	?></dd>
</dl>

<form id="addsdi5" action="<?php echo $_SERVER['SCRIPT_NAME'].$http_params; ?>" method="post">
  <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <?php if(empty($http_params)) echo cancel_button($rub_link."&amp;todo=list"); else echo cancel_button_close_parent(); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
        }
      }
    }
  }
}

if(U_L == 'fr') {
	footerAddJS('../lib/js/jquery-mask-plugin/dist/jquery.mask.min.js');
	footerAddInlineJS("
 		$( '.phone-format').each(function( index ) {
	  if($(this).text() != '".empty_nc('')."') $(this).mask('00 00 00 00 00');
	});");
}
?>