<?php
/**
 * Search module
 * 
 * Display search list in back-office
 * 
 * @package linea21\core\search
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home');?></a>
	</li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','search');?></a></li>
	<li><span><?php echo formatNavTitle(_t('menu_alt',$rub)) ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH)); ?>
<div id="content">
<?php

if(defined('SEARCH_MODE') && stripos(SEARCH_MODE, 'boolean') === false) $disabled=' disabled';
else $disabled='';

if (!isset($_POST['valid'])) {
  echo '<h2>' . _t('menu','search') . '</h2>' . PHP_EOL;
?>
  <form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
    <div id="searchcontent">
    	<label for="search"><?php echo _t('search','keywords');?></label>
    	<input type="text" maxlength="150" class="textfield" name="search" id="search" style="margin-right: 30px" /> <br class="brendstep" />
    	<div style="margin: 3em 0 3em 150px">
        	<input type="radio" class="radio" name="searchtype" id="searchtype_1" value="one" checked="checked"<?php echo $disabled; ?> />
        	<label for="searchtype_1" class="autowidth"><?php echo _t('search','one_of_them');?></label>
        	<input type="radio" class="radio" name="searchtype" id="searchtype_2" value="all"<?php echo $disabled; ?> />
        	<label for="searchtype_2" class="autowidth"><?php echo _t('search','all_of_them');?></label>
        	<input type="radio" class="radio" name="searchtype" id="searchtype_3" value="exp"<?php echo $disabled; ?> />
        	<label for="searchtype_3" class="autowidth"><?php echo _t('search','expression');?></label>
       		<input type="radio" class="radio" name="searchtype" id="searchtype_4" value="expanded"<?php echo $disabled; ?> />
       		<label class="labelised autowidth" for="searchtype_4"><?php echo _t('search','expanded');?></label>
       		
    	</div>
    	<?php if(!empty($disabled)) { ?>
    		<div class="info"><?php echo _t('search', 'query_expansion_enabled'); ?></div>
    	<?php } ?>
    	<input type="hidden" name="rub" id="rubsearch" value="<?php echo $rub;?>" />
    	<br class="brendstep" />
    	<input type="submit" value="<?php echo _t('search','text_button');?>" name="valid" class="button" id="validsearch" />
    </div>
   </form>
<?php
} else {
  $type = 'ADMIN';
  include_once($dir . "/display.php");
  if (!isset($_REQUEST['search']) || strlen($_REQUEST['search']) <= 2)
  {
    echo '<div class="info">'.PHP_EOL;
    echo _t('search','min_length');
    echo  '</div>'.PHP_EOL;
  } else {
    if (isset($_REQUEST['searchincome'])) $str = trim($_REQUEST['searchincome']);
    else $str = $_REQUEST['search'];
    if (!isset($_REQUEST['searchtype'])) $searchtype = 'one';
    else $searchtype = $_REQUEST['searchtype'];
    if($searchtype=='one') $display_method=_t('search','one_of_them');
    if($searchtype=='all') $display_method=_t('search','all_of_them');
    if($searchtype=='exp') $display_method=_t('search','expression');
    if($searchtype=='expanded') $display_method=_t('search','expanded');
    echo '<h2>' . _t('search','result') . '</h2>' . PHP_EOL;

    echo '<div id="KeyWords">'.PHP_EOL;
    echo _t('search','keywords');
    echo formatText($str, '2HTML').'<br />'.PHP_EOL;
    echo _t('search','method');
    echo $display_method.'<br />'.PHP_EOL;
    echo '</div>'.PHP_EOL;
    echo '<div id="search-results">'.PHP_EOL;
    $start_time = getmicrotime();
    if ($rub == 'home') $rub = 'all';
    switch ($rub) {
    	case 'page':
    		$l21auth->isSuperAdmin() ? DisplaySearchPage($str, $type, $searchtype) : ReloadIndex('admin');
    		break;
      case 'project':
        $l21auth->isSuperAdmin() ? DisplaySearchProject($str, $type, $searchtype) : ReloadIndex('admin');
        if(defined('PROJECT_TASK') && PROJECT_TASK == 1) {
            $l21auth->isSuperAdmin() ? DisplaySearchProjectTasks($str, $type, $searchtype) : ReloadIndex('admin');
        }
        break;
      case 'news':
        $l21auth->hasRight('news') ? DisplaySearchNews($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'newsletter':
        $l21auth->isSuperAdmin() ? DisplaySearchNewsletter($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'publication':
        $l21auth->hasRight('publication') ? DisplaySearchPublication($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('publication') ? DisplaySearchPubliContents($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'workshop':
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshop($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRep($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRepContents($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopCalendar($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopCom($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'workshoprep':
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRep($str, $type, $searchtype) : ReloadIndex('admin');
        $l21auth->hasRight('workshop') ? DisplaySearchWorkshopRepContents($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'dashboard':
        $l21auth->hasRight('dashboard') ? DisplaySearchSdi($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'sdi':
        $l21auth->hasRight('dashboard') ? DisplaySearchSdi($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'comment':
        $l21auth->isSuperAdmin() ? DisplaySearchComment($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'yellowpages':
        $l21auth->isSuperAdmin() ? DisplaySearchYellowpages($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'user':
        $l21auth->isSuperAdmin() ? DisplaySearchUser($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'level':
        $l21auth->isSuperAdmin() ? DisplaySearchLevel($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'tag':
        $l21auth->isSuperAdmin() ? DisplaySearchTag($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'scale':
        $l21auth->isSuperAdmin() ? DisplaySearchScale($str, $type, $searchtype) : ReloadIndex('admin');
        break;
      case 'all':
      	if ($l21auth->isSuperAdmin()) DisplaySearchPage($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchProject($str, $type, $searchtype);
        if(defined('PROJECT_TASK') && PROJECT_TASK == 1) {
            $l21auth->isSuperAdmin() ? DisplaySearchProjectTasks($str, $type, $searchtype) : ReloadIndex('admin');
        }

        if ($l21auth->hasRight('news')) DisplaySearchNews($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchNewsletter($str, $type, $searchtype);

        if ($l21auth->hasRight('publication')) DisplaySearchPublication($str, $type, $searchtype);
        if ($l21auth->hasRight('publication')) DisplaySearchPubliContents($str, $type, $searchtype);

        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshop($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopRep($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopRepContents($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopCalendar($str, $type, $searchtype);
        if ($l21auth->hasRight('workshop')) DisplaySearchWorkshopCom($str, $type, $searchtype);

        if ($l21auth->hasRight('dashboard')) DisplaySearchSdi($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchComment($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchYellowpages($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchUser($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchLevel($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchTag($str, $type, $searchtype);

        if ($l21auth->isSuperAdmin()) DisplaySearchScale($str, $type, $searchtype);

        break;
      default:
    }
    echo '</div>'.PHP_EOL;
    $end_time = getmicrotime();
    DisplayQueryTime($start_time, $end_time);
    logfile(LOG_MAINFILE,array('[action] performing search', $str, $type, $searchtype, $rub, i2c_realip()));

    footerAddJS('../lib/js/jquery.easyMark.js');
    // we remove words < 3 chars
    $keywords = preg_replace(array('/\b\w{1,2}\b/','/\s+/'),array('',' '),$_REQUEST['search']);
    $js = "$('#search-results').easymark('highlight', '".formatText($keywords, '2ATT')."');";
    footerAddInlineJS($js);
  }
}
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->