<?php
/**
 * Workshop report module
 * 
 * Provide information regarding latest administration tasks
 * 
 * @package linea21\modules\workshoprep
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
////////////

$qbx_module=_t('menu','workshop');

if ($todo == 'add') {
  $result=$sql_object->DBSelect($req_quickbox_add);
  $qbx_liste='';
  $nb='';
  if($result==0) {
    $qbx_liste.="<li class=\"no-data\">"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_workrep_title=cutText($result[$i]['workrep_title'], 50);
      $qbx_workrep_title=formatText($qbx_workrep_title, '2HTML');
      $qbx_liste.="<li><a href=\"index.php?id=". $result[$i]['workrep_id'] ."&amp;rub=".$rub."&amp;todo=det\" title=\""._t('divers','date_crea').": ".$result[$i]['workrep_date_crea_display']." \">". $qbx_workrep_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb.''._t('workshoprep','qb_titleadd');
}

if ($todo == 'mod' || $todo == 'det') {
  $result=$sql_object->DBSelect($req_quickbox_mod);
  $qbx_liste='';
  $nb='';
  if($result==0) {
    $qbx_liste.="<li class=\"no-data\">"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_workrep_title=cutText($result[$i]['workrep_title'], 50);
      $qbx_workrep_title=formatText($qbx_workrep_title, '2HTML');
      $qbx_liste.="<li><a href=\"index.php?id=". $result[$i]['workrep_id'] ."&amp;rub=".$rub."&amp;todo=det\" title=\""._t('divers','last_modify')." ".$result[$i]['workrep_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['workrep_date_crea_display'].") \">". $qbx_workrep_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb.''._t('workshoprep','qb_titlemod');
}


if ($todo == 'sup') {
  $result=$sql_object->DBSelect($req_quickbox_sup);
  $qbx_liste='';
  $nb='';
  if($result==0) {

    $qbx_liste.="<li class=\"no-data\">"._t('divers','nodata')."</li>";
  } else {
    if(count($result)>=10) $nb=10; else $nb=count($result);
    for($i=0; $i<count($result); $i++) {
      $qbx_workrep_title=cutText($result[$i]['workrep_title'], 50);
      $qbx_workrep_title=formatText($qbx_workrep_title, '2HTML');
      $qbx_liste.="<li><a href=\"#\" title=\""._t('divers','date_sup')." ".$result[$i]['workrep_last_modify_display']." - ("._t('divers','date_crea').": ".$result[$i]['workrep_date_crea_display'].") \">". $qbx_workrep_title ."</a></li>\n";
    }
  }
  $qbx_h1=$nb.''._t('workshoprep','qb_titlesup');
}

echo QuickBoxNow($qbx_module, $qbx_h1, $qbx_liste);
?>