<?php
/**
 * Directory module
 * 
 * MySQL queries related to directory module
 * 
 * @package linea21\modules\yellowpages
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

$req_add = "SELECT scale_id, scale_denomination FROM " . T_SCALE . " WHERE scale_statut<>'E' AND scale_dependencies<".(MAX_SCALE_LEVEL-1)." ORDER BY scale_id;";

$req_quickbox_list = "SELECT yellowp_id, yellowp_name, DATE_FORMAT(yellowp_last_modify, '".toStringSqlDate('long')."') AS yellowp_last_modify, yellowp_last_modify AS yellowp_last_modify2, DATE_FORMAT(yellowp_date_crea, '".toStringSqlDate()."') AS yellowp_date_crea
FROM " . T_YELLOWPAGES . "
WHERE yellowp_statut <> 'E'
ORDER BY yellowp_last_modify2 DESC
LIMIT 0 , 10;";
$req_count_yp = "SELECT COUNT(yellowp_id) as num_rows FROM " . T_YELLOWPAGES . " WHERE yellowp_statut<>'E';";

$req_alphabetical="SELECT DISTINCT UPPER(LEFT(yellowp_name, 1)) AS first_letter FROM ". T_YELLOWPAGES." WHERE yellowp_statut <> 'E' ORDER BY first_letter ASC;";

function SQL_getCountypList($filter= -1, $search= -1) {
  switch ($filter) {
    case 'P':
      $mask=" WHERE yellowp_statut = 'P'";
      break;
    case 'D':
      $mask=" WHERE yellowp_statut = 'D'";
      break;
    case 'AA':
      $mask=" WHERE yellowp_statut = 'AA'";
      break;
    case 'ALPHA':
      $mask=" WHERE yellowp_statut <> 'E' AND lower(yellowp_name) LIKE '\\\\".strtolower($search)."%' ";
      break;
    default:
      $mask=" WHERE yellowp_statut <> 'E'";
      break;
  }
  if($filter== -1) $mask=" WHERE yellowp_statut <> 'E'";
  $requete= "SELECT COUNT(yellowp_id) AS num_rows FROM " . T_YELLOWPAGES . $mask.";";
  return $requete;
}

function SQL_getypList($debut, $limite = SELECT_LIMIT, $filter= -1, $search= -1) {
  switch ($filter) {
    case 'P':
      $mask=" WHERE yellowp_statut = 'P'";
      break;
    case 'D':
      $mask=" WHERE yellowp_statut = 'D'";
      break;
    case 'AA':
      $mask=" WHERE yellowp_statut = 'AA'";
      break;
    case 'ALPHA':
      $mask=" WHERE yellowp_statut <> 'E' AND lower(yellowp_name) LIKE '\\\\".strtolower($search)."%' ";
      break;
    default:
      $mask=" WHERE yellowp_statut <> 'E'";
      break;
  }
  if($filter== -1) $mask=" WHERE yellowp_statut <> 'E'";
  $requete=	"SELECT Y.yellowp_id, yellowp_name, Y.yellowp_statut, DATE_FORMAT(Y.yellowp_date_crea, '".toStringSqlDate('long')."') AS yellowp_date_crea_display FROM " . T_YELLOWPAGES." AS Y ".
  $mask." ORDER BY Y.yellowp_name LIMIT ".$debut." , ".$limite.";";
  return $requete;
}

function SQL_get_Display_CountypList($filter= -1, $search= -1) {
  switch ($filter) {
    case 'LEVEL':
      $mask=" WHERE yellowp_statut = 'P' AND ". sql_status_filter('yellowp_level', $search);
      break;

    case 'alpha':
      $mask=" WHERE yellowp_statut ='P' AND lower(yellowp_name) LIKE '\\\\".strtolower($search)."%' ";
      break;
    default:
      $mask=" WHERE yellowp_statut ='P'";
      break;
  }
  if($filter== -1) $mask=" WHERE yellowp_statut ='P'";
  $requete= "SELECT COUNT(yellowp_id) AS num_rows FROM " . T_YELLOWPAGES." AS Y ".
	 " LEFT OUTER JOIN ". T_LEVEL. " AS L on Y.yellowp_level=L.level_id"
	 . $mask.";";
	 return $requete;
}

    
function SQL_get_Display_ypList($debut, $limite = SELECT_LIMIT, $filter= -1, $search= -1) {
  switch ($filter) {
    case 'LEVEL':
      $mask=" WHERE yellowp_statut = 'P' AND ". sql_status_filter('yellowp_level', $search);
      break;

    case 'alpha':
      $mask=" WHERE yellowp_statut ='P' AND lower(yellowp_name) LIKE '\\\\".strtolower($search)."%' ";
      break;
    default:
      $mask=" WHERE yellowp_statut ='P'";
      break;
  }
  if($filter== -1) $mask=" WHERE yellowp_statut ='P'";
  $requete=	"SELECT Y.yellowp_id, LEFT(Y.yellowp_name, 60) AS yellowp_name, L.level_name, L.level_id, yellowp_activity, Y.yellowp_statut, DATE_FORMAT(Y.yellowp_date_crea, '".toStringSqlDate('long')."') AS yellowp_date_crea_display, yellowp_street, yellowp_postal_code, yellowp_city, yellowp_country, yellowp_phone, yellowp_fax, yellowp_email, yellowp_website  FROM " . T_YELLOWPAGES." AS Y ".
		 " LEFT OUTER JOIN ". T_LEVEL. " AS L on Y.yellowp_level=L.level_id".
  $mask." ORDER BY Y.yellowp_name LIMIT ".$debut." , ".$limite.";";
  return $requete;
}
function SQL_get_req_alphabetical(){
  $req_alphabetical="SELECT DISTINCT UCASE(LEFT(yellowp_name, 1)) AS first_letter FROM ". T_YELLOWPAGES." WHERE yellowp_statut = 'P' ORDER BY first_letter ASC;";
  return $req_alphabetical;
}

function SQL_getOneYpName($id) {
  $q =	"SELECT yellowp_name
      	FROM " . T_YELLOWPAGES . "
      	WHERE yellowp_id =". $id .";";
  return $q;
}

function SQL_getdetyp($yp_id, $force_status = false) {

	if($force_status) $force_status = " AND ". sql_status_filter('yellowp_statut', $force_status);
	else $force_status = "";

  $req_det= "
            SELECT yellowp_name, yellowp_activity, L.level_name, L.level_id, yellowp_level, yellowp_street, yellowp_postal_code, yellowp_city,  yellowp_country,  yellowp_phone,  yellowp_fax, yellowp_email, yellowp_website, yellowp_latitude, yellowp_longitude, DATE_FORMAT(yellowp_last_modify, '".toStringSqlDate('long')."') AS yellowp_last_modify, DATE_FORMAT(yellowp_date_crea, '".toStringSqlDate()."') AS yellowp_date_crea,   yellowp_statut
            FROM " . T_YELLOWPAGES . "
            LEFT  OUTER  JOIN " . T_LEVEL . " AS L ON yellowp_level = L.level_id
            WHERE yellowp_id ='". $yp_id ."'". $force_status.";";
  return $req_det;
}

function SQL_getlistyp($debut, $limite) {
  $mask="";
  if ($limite==true) {
    $mask= "LIMIT $debut , ". SELECT_LIMIT;
  }
  $req_listpre= "SELECT * FROM " . T_YELLOWPAGES . " WHERE yellowp_statut<>'E' ORDER BY yellowp_name $mask ;";
  return $req_listpre;
}

function SQL_getlistyppre($debut, $limite) {
  $mask="";
  if ($limite==true) {
    $mask= "LIMIT $debut , ". SELECT_LIMIT;
  }
  $req_list2= "SELECT * FROM " . T_YELLOWPAGES . " WHERE yellowp_statut='D' ORDER BY yellowp_name $mask ;";
  return $req_list2;
}


function SQL_getlistypstatut($statut, $debut, $limite) {
  $mask="";
  if ($limite==true) {
    $mask= "LIMIT $debut , ". SELECT_LIMIT;
  }
  $req_liststatut= "SELECT * FROM " . T_YELLOWPAGES . " WHERE yellowp_statut='$statut' ORDER BY yellowp_name $mask ;";
  return $req_liststatut;
}

?>