<?php
/**
 * Culture class
 * 
 * Handles user language for the whole app
 * 
 * @package linea21\core\culture
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Plugin Management
 */

class culture {

  private static $instance;

  private $params = array();

  private $separator = '_';

  public $cultures = array(); // collect data related to available languages


  private function __construct() {

    global $culture;

    $a = array('none');

    self::prepareCultures();

    $a=array_merge($a, array_keys($this->cultures));

    // checking if lang is forced or already set in session
    if(isset($_GET['flang']))
    {
      $_GET['flang'] = strip_tags($_GET['flang']);
      in_array($_GET['flang'], $a) ? $_SESSION['flang'] = $_GET['flang'] : die('no way!');
      $this->params['current'] = $_GET['flang'];
    }
    elseif(isset($_SESSION['flang']))
    {
      in_array($_SESSION['flang'], $a) ? 1 : die('no way!');
      $this->params['current'] =  $_SESSION['flang'];
    }
    else
    {
      $this->params['current'] =  LANGUAGE;
    }
    if($this->params['current']=='none') self::reset();

    // initializing parameters
    include('../languages/' .$this->params['current']. '/define.php');
    if(strpos($this->params['current'], $this->separator) != false)   {
      list($this->params['language_code'], $this->params['country_code']) = explode($this->separator, $this->params['current']);
    } else {
      $this->params['language_code'] = $this->params['current'];
    }
    $this->params['language'] = $culture[$this->params['current']]['Language'];
    if(isset($culture[$this->params['current']]['Country'])) $this->params['country'] = $culture[$this->params['current']]['Country'];

  }

  /**
   * prepareCultures()
   * Return available cultures
   * @return array
   **/
  private function prepareCultures() {

    $a = array();
    $b = array();

    if ($handle = opendir('../languages/')) {
      while (false !== ($file = readdir($handle))) {
        if ($file != "." && $file != ".." && $file != ".svn") {
          array_push($a, $file);
        }
      }
      closedir($handle);

      foreach($a as $el) {
        // $culture va is in  define.php file Sample : $culture = array( 'en' => array( 'Language' => 'English'));
        include('../languages/'.$el.'/define.php');
        $b = array_merge($b, $culture);
      }

    }

    $this->cultures = $b;
  }

  public static function getInstance()
  {
    if (!isset(self::$instance)) {
      $c = __CLASS__;
      self::$instance = new $c;
    }

    return self::$instance;
  }

  /**
   * getVar()
   * Only for current culture !!!
   * @param string $varname
   * @return string
   */
  public function getVar($varname) {

    return $this->params[$varname];

  }

  /**
   * getCultureInfo()
   * For any culture
   * @param string $culture
   * @param string $param
   * @return string or bool
   */
  public function getCultureInfo($culture, $param) {

    if(isset($this->cultures[$culture][$param])) {
      return $this->cultures[$culture][$param];
    } else
    return false;

  }

  public function renderSwitcher() {

    $switcher = '';
    if(isset($_SESSION['flang'])) {

      $array = self::availableCultures();
      $list = '';

      foreach($array as $culture => $value) {

        $a = array('flang' => $culture);
        if(CURRENT_APP =='admin') $url = get_permalink(array_merge($_GET, $a));
        if(CURRENT_APP =='public') $url = get_permalink($a);
        $str= ucfirst($value['Language']);
        if(isset($value['Country'])) $str.= ' ('.ucfirst($value['Country']).')';
        $list .= '<li><a href="'.$url.'" title="'.$str.'"><img src="'.THEME_ADMIN_PATH.'images/flags/'.$culture.'.png" alt="'.$str.'" /><span>' . $str . '</span></a></li>'.PHP_EOL;

      }

      $switcher .= '<div id="lang_switcher">';
      $switcher .= '<ul>';
      $switcher .= $list;
      $switcher .= '<li><a href="index.php?flang=none" title="default language">[X]</a></li>';
      $switcher .= '</ul>';
      $switcher .= '</div>';
    }

    echo $switcher;

  }

  public function reset() {

    if(isset($_SESSION['flang'])) unset($_SESSION['flang']);
    if(isset($_GET['flang'])) unset($_GET['flang']);
    $this->params['current'] =  LANGUAGE;

  }

  /**
   * availableCultures()
   * Return available cultures
   * @return array
   **/
  public function availableCultures() {

    return $this->cultures;
  }

}

?>