<?php
/**
 * Comment module
 * 
 * Display comments list in back-office
 * 
 * @package linea21\modules\comment
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
	include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once(override('../vote/display.php'));

if(isset($_GET['statut']) && $_GET['statut'] != -1) {
  $status=$_GET['statut'];
  $status_q=array($_GET['statut']);
} else {
  $status = -1;
  $status_q = array('P', 'D', 'E');
}

if(isset($_GET['module']) ) {
  $module=$_GET['module'];
} else {
  $module= 'all';
}

if(!isset($_GET['debut'])) $debut=0;
else $debut=$_GET['debut'];

$mask_statut_1='';
$mask_statut_2='';
$mask_statut_3='';
$mask_statut_4='';
$mask_statut_5='';
$mask_statut_6='';
$mask_statut_7='';

if($status=='public') $mask_statut_1='selected="selected"';
if($status=='draft') $mask_statut_2='selected="selected"';


// Nombre d'enregistrement total dans la bdd
$r = $sql_object->DBSelect(SQL_getTotalCountNumber());
$nb=$r[0]['nb'];
$nb_comments = sprintf(_t('comment','nb_total'), $nb);

$comm = new comment();

if($module=='all') {
  // tous les commentaires sont retournés !!!
  // et la pagination est effectuée ici via array_slice()
  // @todo Optimiser
  $data = $data_all = $comm->getAllByModule($status_q, $sql_object, false, 'date');
  !is_array($data) ?  $nb_q_comments = 0 : $nb_q_comments = count($data);
  $data = array_slice($data, $debut, SELECT_LIMIT);
  $html_comments = getMarkup($data, true);
} else {
  $data = $data_all = $comm->getByModule(array('module' => $module, 'status' => $status_q, 'limit' => false), $sql_object);
  !is_array($data) ?  $nb_q_comments = 0 : $nb_q_comments = count($data);
  if(is_array($data)) $data = array_slice($data, $debut, SELECT_LIMIT);
  $html_comments = getMarkup($data, true);
}


echo getAjaxFunction(); // for ajax call

if($module != 'all' || $status != -1) {
  $link_back="<div class=\"filter\"><a href=\"".$rub_link."&amp;todo=list\">"._t('comment','all')."</a></div>";
} else {
  $link_back='';
}



if($nb_q_comments<=1) $query_count = _t('divers','query_result')." : ".$nb_q_comments." "._t('divers','record');
else $query_count = _t('divers','query_result')." : ".$nb_q_comments." "._t('divers','records');


// handle comments exports
if(isset($data[0]['comment_id'])) {
	
	$content = '';
	
	// if vote is enabled on contribution and it is a contribution
	if(defined('MOD_VOTE') && MOD_VOTE == 1) {
	    $voteFlag = true;
	} else {
	    $voteFlag = false;
	}
	
	foreach ($data_all as $c) {
	    if($voteFlag) $likes_number = getNbVotes(array('module' => $c['comment_module'], 'module_id' => $c['comment_id']));
		$cdate       = $c['comment_date_crea_display'];
		$cdateshort  = substr($c['comment_date_crea_display'], 0, 10);
		$ctitle       = formatText($c['comment_title']);
		$cbody       = formatText($c['comment_body']);
		$cname= $c['user_login'];
		$item = itemMapping($c['comment_module']);
		
		// status
		if($c['comment_status']== 'E') {
			$cstatus = _t('comment', 'disapproved');
		}
		if($c['comment_status']== 'P') {
			$cstatus= _t('comment', 'approved');
		}
		if($c['comment_status']== 'D') {
			$cstatus= _t('comment', 'awaiting');
		}
		
		// get fullname
		if(!empty($c['profile_firstname']) || !empty($c['profile_lastname'])) {
			$cname .=  ' ('.$c['profile_firstname']. ' '.$c['profile_lastname'].')';
		} else {
			$cname .= $c['comment_name'];
		}
		
		if($c['comment_user_id']!=0) {
			$dataU = $GLOBALS['sql_object']->DBSelect(SQL_getUserInfo($c['comment_user_id']));
			$cemail = $dataU[0]['profile_email'];
			$cregistered = _t('divers', 'yes');
		} else {
			$cemail = $c['comment_email'];
			$cregistered = _t('divers', 'no');
		}
		
		$content .='<tr>';
		$content .= '<td>' . $item['name']. '</td>';
		$content .= '<td>' . $c['item_title'] . ' [id : ' . $c['comment_module_id'] . ']</td>';
		$content .= '<td>' . $cname. '</td>';
		$content .= '<td>' . $cregistered. '</td>';
		$content .= '<td>' . $cemail. '</td>';
		$content .= '<td>' . $ctitle. '</td>';
		$content .= '<td>' . $cbody. '</td>';
		if($voteFlag) $content .= '<td>' . $likes_number. '</td>';
		$content .= '<td>' . $cdate. '</td>';
		$content .= '<td>' . mb_ucfirst($cstatus). '</td>';
		$content .='</tr>';
		
	}
	
	
	$table_export  = '<table id="export-comments" class="visually-hidden">';
	$table_export .= '<thead>';
	$table_export .= '<tr>';
	$table_export .= '<td>'. mb_ucfirst(_t('comment', 'module')) . '</td>';
	$table_export .= '<td>'. mb_ucfirst(_t('comment', 'posted_in')) . '</td>';
	$table_export .= '<td>'. mb_ucfirst(_t('comment', 'name')) . '</td>';
	$table_export .= '<td>' . mb_ucfirst(_t('comment', 'registered_user')) .'</td>';
	$table_export .= '<td>'. mb_ucfirst(_t('contact', 'email')) . '</td>';
	$table_export .= '<td>'. mb_ucfirst(_t('comment', 'title')) . '</td>';
	$table_export .= '<td>'. mb_ucfirst(_t('comment', 'body')) . '</td>';
	if($voteFlag) $table_export .= '<td>'. mb_ucfirst(_t('like', 'like_plural')) . '</td>';
	$table_export .= '<td>'. mb_ucfirst(_t('divers', 'date')) . '</td>';
	$table_export .= '<td>'. mb_ucfirst(_t('divers', 'statut')) . '</td>';
	$table_export .= '</tr>';
	$table_export .= '</thead>';
	$table_export .= '<tbody>';
	$table_export .= $content;
	$table_export .= '</tbody>';
	$table_export .= '</table>';
	
	// Insert Javascript instructions to allow client Excel export
	footerAddJS('../lib/js/tableExport.jquery.plugin/tableExport.min.js');
	footerAddJS('../lib/js/tableExport.jquery.plugin/libs/html2canvas/html2canvas.min.js');
	
	
	$str = '$("#export-values li a").click(function() {
						var format = $(this).attr("data-format");
						var ignoreCol = []; // set columns to ignore
						$el = $("#export-comments");
			
  						$el.tableExport(
							{tableName:"'.mb_ucfirst(_t('comment', 'section') . ' : ' . $nb_comments. ' '. $query_count). '",type:format,escape:\'false\',ignoreColumn: ignoreCol,displayTableName:\'true\',htmlContent:\'false\',fileName:\'' . _t('comment', 'section') . '\'});
									
						return false;
						});';
	footerAddInlineJS($str);
}


$link_status=$rub_link."&amp;todo=list&amp;module=".$module."&amp;statut=";
$link_module=$rub_link."&amp;todo=list&amp;statut=".$status."&amp;module=";
$link_self=$rub_link."&amp;todo=list&amp;statut=".$status."&amp;module=".$module;

// Liste des modules disponibles
if($module=='news') $mask_statut_1 = 'selected="selected"';
if($module=='project') $mask_statut_2 = 'selected="selected"';
if($module=='publication') $mask_statut_3 = 'selected="selected"';
if($module=='report') $mask_statut_4 = 'selected="selected"';
if($module=='indicator') $mask_statut_5 = 'selected="selected"';
if($module=='files') $mask_statut_6 = 'selected="selected"';
if($module=='contribute') $mask_statut_7 = 'selected="selected"';
$select_module="<select name=\"statut_filter\" id=\"statut_filter\">\n";
$select_module.="<option value=\"-1\">"._t('comment','module_filter')."</option>\n";
$select_module.="<option value=\"".$link_module."news\"".$mask_statut_1."> -- ".ucfirst(_t('comment_map', 'news'))."</option>\n";
$select_module.="<option value=\"".$link_module."project\"".$mask_statut_2."> -- ".ucfirst(_t('comment_map', 'project'))."</option>\n";
$select_module.="<option value=\"".$link_module."publication\"".$mask_statut_3."> -- ".ucfirst(_t('comment_map', 'publication'))."</option>\n";
$select_module.="<option value=\"".$link_module."report\"".$mask_statut_4."> -- ".ucfirst(_t('comment_map', 'report'))."</option>\n";
$select_module.="<option value=\"".$link_module."indicator\"".$mask_statut_5."> -- ".ucfirst(_t('comment_map', 'indicator'))."</option>\n";
$select_module.="<option value=\"".$link_module."files\"".$mask_statut_6."> -- ".ucfirst(_t('comment_map', 'files'))."</option>\n";
$select_module.="<option value=\"".$link_module."contribute\"".$mask_statut_7."> -- ".ucfirst(_t('comment_map', 'contribute'))."</option>\n";
$select_module.="</select>\n";

$js = "$('#statut_filter').change(function() {
			  	if($(this).val() != -1) window.location = $(this).val();
			 });";

footerAddInlineJS($js);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"
		class="chemin_rub"><?php echo _t('menu','comment'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('comment','list')); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
  <div id="content">
  
  <div class="filter">
    	<a href="<?php echo $link_status; ?>D"><?php echo ucfirst(_t('comment', 'awaiting')); ?></a>
    	<a href="<?php echo $link_status; ?>P"><?php echo ucfirst(_t('comment', 'all_approved')); ?></a>
    	<a href="<?php echo $link_status; ?>E"><?php echo ucfirst(_t('comment', 'all_disapproved')); ?></a>
    	<a href="index.php?rub=comment&amp;todo=list"><?php echo _t('comment','all'); ?></a>
    </div>
  <div class="filterselect mbm"><?php echo $select_module; ?></div>
  <div class="clear ms">
    <?php
    echo $nb_comments. ' '. $query_count . "<br />\n";
    ?>
  </div>
  <?php if(isset($table_export)) { ?>
  <!-- dropdown container -->
<div class="dropdown export-button" id="export-values">
<!-- trigger button -->
<button><i class="fa fa-download" aria-hidden="true"></i></i> <?php echo _t('btn', 'export_values'); ?></button>
    <!-- dropdown menu -->
    <ul class="dropdown-menu">
        <li><a href="#export-values" data-format="excel"><i class="fa fa-file-excel-o" aria-hidden="true"></i> <?php echo _t('export', 'format', 'excel'); ?></a></li>
        <li><a href="#export-values" data-format="csv"><i class="fa fa-file-code-o" aria-hidden="true"></i> <?php echo _t('export', 'format', 'csv'); ?></a></li>
        <li><a href="#export-values" data-format="json"><i class="fa fa-file-code-o" aria-hidden="true"></i> <?php echo _t('export', 'format', 'json'); ?></a></li>
    </ul>
</div>
<?php } ?>
  <?php
  if(isset($table_export)) echo $table_export;
  echo '<br style="margin:2em;">';
  echo linkin_page($link_self, $nb_q_comments, $debut);
  echo '<div id="comments">';
  if(!empty($html_comments)) echo $html_comments;
  else echo "<div class=\"info\">"._t('comment','noresult')."</div>";
  echo '</div>';
  echo linkin_page($link_self, $nb_q_comments, $debut);
  ?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->