<?php
/**
 * Dashboard module
 * 
 * Indicator detail page. Display all values entered for a specific indicators
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if(!isset($_GET['id']) && !isset($_POST['id'])) {
	$id="1";
} else {
	if(isset($_POST['id']))	$id=$_POST['id'];
	if(isset($_GET['id']))	$id=$_GET['id'];
}
if(!isset($_GET['scale_id']) && !isset($_POST['scale_id'])) {
	$scale_id=1;
} else {
	if(isset($_POST['scale_id']))	$scale_id=$_POST['scale_id'];
	if(isset($_GET['scale_id']))	$scale_id=$_GET['scale_id'];
}

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('dashboard') && !$l21auth->hasRight('indicator', $id)) ReloadIndex('admin');
////////////

include_once("../dashboard/common.php");
include_once("../dashboard/display.php");
include_once(override("../dashboard/chart-prepare.php"));

footerAddJS('../lib/js/clipboard.js-2.0.10/dist/clipboard.min.js');

$str = "
        var clipboard = new ClipboardJS('.copy-chart-url');

    clipboard.on('success', function(e) {
        alertify.success(\"" . _t('copy', 'url_copy_succeed') . "\");
    });

    clipboard.on('error', function(e) {
        alertify.error(\"" . _t('copy', 'url_copy_failed') . "\");
    });";

footerAddInlineJS($str);
$str = "
        var clipboard2 = new ClipboardJS('.copy-chart-iframe');
    
    clipboard2.on('success', function(e) {
        alertify.success(\"" . _t('copy', 'embedcode_copy_succeed') . "\");
    });
            
    clipboard2.on('error', function(e) {
        alertify.error(\"" . _t('copy', 'embedcode_copy_failed') . "\");
    });";

footerAddInlineJS($str);

if(defined('CLIENT_CHARTS') && CLIENT_CHARTS == 1) {

	// footerAddJS('../lib/js/Highcharts-7.0.3/code/themes/grid-light.js');
	includeHighCharts(['exporting', 'offline-exporting']);
	footerAddJS('../lib/js/generate-chart.js');
	
	if(defined('EXPORT_CHART_SVG') && EXPORT_CHART_SVG == 1) {
	// code to generate SVG file to embed in PDF file
	$filename = $id . "_" . $scale_id;
	$js = 'function saveChart() {
                if($("#main-chart-container svg").length) {
    	           var svg = $("#main-chart-container svg")[0]
                    var svgStr = new XMLSerializer().serializeToString(svg);
                    var jqxhr = $.post( "../dashboard/_image_save.php", { svgcontent: svgStr, filename: "'. $filename .'" }, function() {
                    // console.log( "chart is saved on server" );
                    });
            }
    }';
	footerAddInlineJS($js, false);
	footerAddInlineJS('setTimeout(saveChart, 3000);');
	}	
}

// getting chart sizes from config file
list($cwidth, $cheight) = explode('x', CHART_DEFAULT_SIZE);


$sdi_object= new sdi;
//$result_sdii=$sdi_object->GetInfoSdi($id, $sql_object);
//$result_e=$sdi_object->GetEvaluation( $id, $sql_object, $ID=-1);
//$result_p=$sdi_object->GetProvider( $id, $sql_object, $ID=-1);
//$result_r=$sdi_object->GetRules( $id, $sql_object, $ID=-1);
$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);
$indicator_multiple_type =  formatText($result_sdii[0]['sdii_multiple_type'], '2HTML');

$level = formatText($result_sdii[0]['level_name'], '2HTML');
($result_sdii[0]['sdii_level'] != 0) ? $level=formatText($result_sdii[0]['level_name'], '2HTML') : $level= _t('sdi', 'no_associated_level'). ' <span class="hint--bottom hint--large hint--rounded" aria-label="'. formatText(_t('sdi', 'no_associated_level_notice'), '2ATT') . '"><i class="fa fa-info-circle" aria-hidden="true"></i></span>'; // if no associated label
$level_label_att = formatText($result_sdii[0]['level_label'] . ' : ' . $result_sdii[0]['level_name'], '2ATT');
$level_label = '<span class="level-label">' .formatText($result_sdii[0]['level_label'], '2HTML'). '</span> ';
if(defined('DISPLAY_LEVEL_LABEL') && DISPLAY_LEVEL_LABEL == 1) $disp_level_name = $level_label . $level; else $disp_level_name = $level;



// Do record exists?
if(!isset($result_sdii[0]['sdii_name'])) redirect_to('@module_default');

// setting $default_threshold value
// By default initial value
$default_threshold = $result_sdii[0]['sdii_threshold_value'];

$req_sdir=SQL_getRules( $id, $sql_object, $ID=-1);
$result_r = $sql_object -> DBSelect($req_sdir);

$req_sdie=SQL_getEvaluation( $id, $sql_object, $ID=-1);
$result_e = $sql_object -> DBSelect($req_sdie);

$req_sdip=SQL_getProvider( $id, $sql_object, $ID=-1);
$result_p = $sql_object -> DBSelect($req_sdip);

$req_sdiav=SQL_getAllValue("SCA", $scale_id, $id);
$result_value = $sql_object -> DBSelect($req_sdiav);
$result_value = add_cumulative_value($result_value, $result_sdii[0]); // we add 'sdiv_cumulative_value' attribute if needed



//$result_value=$sdi_object->GetAllValue("SCA", $scale_id, $id, $sql_object);
$req_scale=SQL_getonescale($scale_id);
$resultscale2 = $sql_object -> DBSelect($req_scale);

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_det_level="index.php?rub=level&amp;todo=det&amp;id=";
$link_det_indicator="index.php?rub=sdi&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;value_id=";
$link_mod=$rub_link."&amp;todo=mod&amp;value_id=";
$link_add=$rub_link."&amp;todo=add&amp;id=";
$navtitle=_t('dashboard','det')." : ".$result_sdii[0]['sdii_name'];


($result_sdii[0]['sdii_api_enabled'] == 'Y') ? $api = ' <span class="hint--top hint--rounded" aria-label="'._t('sdi', 'api-enabled').'"><i class="api-plugged active fa fa-code-fork" aria-hidden="true"></i></span>' : $api ='';
($result_sdii[0]['sdii_api_enabled'] == 'N' && !empty($result_sdii[0]['sdii_api_url'])) ? $api = ' <span class="hint--top hint--rounded" aria-label="'._t('sdi', 'api-disabled').'"><i class="api-plugged inactive fa fa-code-fork" aria-hidden="true"></i></span>' : $api = $api;


?>


<?php 
// Préparation de la génération des graphiques

// we create an array to populate and send to javascript
$obj = [];
$obj['site-language'] = U_L;
$obj['indicator-name'] = formatText($result_sdii[0]['sdii_name'], '2HTML');
$obj['indicator-type'] = $result_sdii[0]['sdii_value_type'];
$obj['indicator-force-min'] = cast_number($result_sdii[0]['sdii_force_chart_min']);
$obj['indicator-unique-mode'] = $result_sdii[0]['sdii_unique_mode'];
$obj['indicator-multiple-type'] = $result_sdii[0]['sdii_multiple_type'];
$obj['indicator-multiple-mode'] = $result_sdii[0]['sdii_multiple_mode'];
$obj['indicator-default-vis'] = $result_sdii[0]['sdii_detail_viz'];
$obj['indicator-wanted-vis'] =$result_sdii[0]['sdii_detail_viz'];
$obj['indicator-frequency'] = $result_sdii[0]['sdii_frequency'];
$obj['indicator-wanted-year'] = null;
$obj['indicator-serie-name']  = formatText(_t('dashboard', 'value'), '2HTML');
$obj['indicator-serie-color']  = $result_sdii[0]['sdii_mcolor'];
$obj['indicator-threshold-name']  = formatText(_t('dashboard', 'threshold_value'), '2HTML');
$obj['indicator-mean-name']  = formatText(_t('dashboard', 'multivalue_mean'), '2HTML');
$obj['indicator-threshold-color']  = $result_sdii[0]['sdii_tcolor'];
$obj['indicator-unit'] = $result_sdii[0]['sdii_unit'];
$obj['indicator-negative-notice'] = formatText(_t('dashboard', 'negative_values_notice'));
$obj['indicator-no-data-notice'] = formatText(_t('dashboard', 'no_data_notice'));
$obj['dates'] = array();
$obj['data'] = array();
$obj['data-mean'] = array();
$obj['thresholds'] = array();

if($obj['indicator-wanted-vis'] == 'donut') {
    $obj['indicator-wanted-vis'] = 'pie';
    $obj['vis-pie-size'] = '60%';
}
$cdata = prepare_chart_data($result_sdii, $obj, $result_value);
?>

<script>
	var input = <?php echo json_encode($cdata, JSON_NUMERIC_CHECK); ?>;
	// console.log(input);
</script>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','dashboard')?></a></li>
	<li><span><?php echo formatnavTitle($navtitle);	?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content" class="action-<?php echo $todo; ?>">
<h2><?php echo formatTitleh2($result_sdii[0]['sdii_name']) . $api; ?></h2>

<?php echo GetLastAnalysis($id, $scale_id); ?>
<!--  Unique value export -->
<form id="report" action="../export/report.php" method="post" class="visually-hidden">
<input type="hidden" name="what" value="dashboard">
<input type="hidden" name="quick_export" value="1">
<input type="hidden" name="scale" value="all">
<input type="hidden" name="sdi" value="det">
<input type="hidden" name="eachsdi[]" value="<?php echo $id; ?>">
<input type="hidden" name="graphic" value="1">
<input type="hidden" name="table_value" value="1">
<input type="hidden" name="notpublished" value="1">
<input type="hidden" name="provider" value="1">
<input type="hidden" name="reglementation" value="1">
<input type="hidden" name="evaluation" value="1">
<input type="hidden" name="format_report" value="word"><!-- pdf / word / html -->
<input type="hidden" name="sauver" value="1">
</form>
<!-- dropdown container -->
<div class="dropdown export-button" id="export-report">
<!-- trigger button -->
<button><i class="fa fa-download" aria-hidden="true"></i></i> <?php echo _t('export', 'action'); ?></button>
    <!-- dropdown menu -->
    <ul class="dropdown-menu">
        <li><a href="#report" data-format="pdf"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'pdf'); ?></a></li>
        <li><a href="#report" data-format="word"><i class="fa fa-file-word-o" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'word'); ?></a></li>
        <li><a href="#report" data-format="html"><i class="fa fa-html5" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'html'); ?></a></li>
    </ul>
</div>
<script>
$( "#export-report li a" ).click(function() {
	var format = $(this).attr('data-format');
	$( "#report input[name=format_report]").val(format);
  $( "#report" ).submit();
  return false;
});
</script>

<div class="iconetodo2">
<?php  if ($l21auth->isSuperAdmin() && defined('API_RETRIEVE') && API_RETRIEVE == 1) { ?>
    <a href="../dashboard/api-harvest.php?id=<?php echo $result_sdii[0]['sdii_id']; ?>&token=<?php echo SECRET_KEY; ?>" title="<?php echo _t('sdi','api-manual-import') . ' (' . _t('sdi', 'api-manual-import-hint').')'; ?>" class="ico_generic2" id="API-import-light"><i class="api-plugged fa fa-code-fork" aria-hidden="true"></i><span><?php echo _t('sdi','api-manual-import'); ?></span></a>
 <?php }  ?>
<?php echo "<a href=\"".$link_add.$id."&amp;scale_id=".$scale_id."\" title=\""._t('dashboard','add')."\" class=\"ico_add2\">";?><i class="fa fa-plus-circle" aria-hidden="true"></i><span><?php echo _t('dashboard','add'); ?></span></a>
<?php if ($l21auth->hasRight('sdi')) {
    echo "<a href=\"".$link_det_indicator.$id."\" title=\""._t('sdi','det')."\" class=\"ico_generic2 no-action\">";?>
    <i class="fa fa-eye" aria-hidden="true"></i><span><?php echo _t('sdi','det'); ?></span></a>
<?php } ?>
</div>

<?php 
// display flash message if indicator value is set from project page
display_flash_msg(false, '', 'added_value_from_project');
?>

<?php if ($result_value <> false) { ?> <br />
<?php if(defined('CHART_MIN_VALUES') && is_numeric(CHART_MIN_VALUES)) $minChartValues = CHART_MIN_VALUES; else $minChartValues = 2; ?>
<?php if (count($result_value) >= $minChartValues) {?>
	<?php 
	$slugname = Stringy\Stringy::create($result_sdii[0]['sdii_name'].'_'.$resultscale2[0]['scale_denomination'], CHARSET)->safeTruncate(50)->slugify(). '.png';
	$js_dlChart = "
 		$( 'div.chart-container')
			.on( 'mouseenter', function() {
				$('.download-chart').fadeIn(100);
			})
			.on( 'mouseleave', function() {
				$('.download-chart').fadeOut( 500 );
			});";
	footerAddInlineJS($js_dlChart);
	?>
	
	<?php if($result_sdii[0]['sdii_nature'] == 'quantitative') { ?>
	<?php if(!defined('CLIENT_CHARTS') || CLIENT_CHARTS != 1) { ?>
		<div class="chart-container">
		<img src="<?php echo override('../dashboard/graph.php')?>?id=<?php echo $id; ?>&amp;scale_id=<?php echo $scale_id; ?>&amp;display=true" id="imggraph" class="graph" alt="<?php echo _t('dashboard','all_value');?>" />
		<a class="download-chart ico_generic2" title="<?php echo mb_ucfirst(_t('dashboard', 'download_chart')); ?>" href="<?php echo override('../dashboard/graph.php')?>?id=<?php echo $id; ?>&amp;scale_id=<?php echo $scale_id; ?>&amp;display=true" download="<?php echo $slugname; ?>"><i class="fa fa-download" aria-hidden="true"></i><span> <?php echo mb_ucfirst(_t('dashboard', 'download_chart')); ?></span></a>
		</div>
	<?php } else { ?>
		<!--  for stacked chart only, we add a switcher from normal to percent representation --> 
		<?php if($result_sdii[0]['sdii_value_type'] == 'multiple' && $result_sdii[0]['sdii_multiple_type'] == 'sum') { ?>
        <div id="chart-percent-switch" class="flex-container">
        	<input type="checkbox" class="switch" name="d-percentage" id="d-percentage" value="1" />
        	<label for="d-percentage" class="percent-label autowidth"><?php echo mb_ucfirst(_t('unit', 'percent')); ?></label>
        </div>
        <script>
    	var chartType = 'normal';
    	var icolor = $('.percent-label').css('color');
        $('#d-percentage').change(function() {
        	 var index = $("#main-chart-container").data('highchartsChart');
        	 var chart = Highcharts.charts[index];
        	 
        	if ($(this).prop("checked")) {
            	chartType = 'percent';
            	unit = "<?php echo formatText($result_sdii[0]['sdii_unit'], '2HTML'); ?> (%)";
            	$('.percent-label').css('color', '#8ce196');
        	} else {
            	chartType = 'normal';
            	unit = "<?php echo formatText($result_sdii[0]['sdii_unit'], '2HTML'); ?>";
            	$('.percent-label').css('color', icolor);
          	}
        	
         	chart.update({
         		yAxis: {
     				title: {
     					text: unit
     				}
         	    },
         		plotOptions: {
         	      series: {
         	    	  stacking: chartType
         	      }         	     
         		}
         	});
        	
        });
        </script>
        <?php } ?>
		<div id="main-chart-container"></div>
	<?php }  ?>


    <div class="toggle_title">
        <a id="aff-copy-url" href="#" title="<?php echo _t('dashboard','embed_chart_title');?>"><?php echo _t('dashboard', 'embed_chart_title'); ?></a>
    </div>
	<div class="copy-url-block grid2-1 row pas flex-container mbl"  style="display: none;">
		<div class="w75 notice txtright">
			<?php echo _t('dashboard', 'embed_chart'); ?>
		</div>
		<div class="txtright item-fluid">
		  <!-- SITE_ROOT_URL. "dashboard/graph.php?id=12&scale_id=1&w=900&h=640&display=true" -->
		  <input class="visually-hidden" id="chart-url" value="<?php echo SITE_ROOT_URL. 'public/chart/id/'.$id.'/scale/1/w/'.$cwidth.'/h/'.$cheight.'/png'; ?>" /><button class="copy-chart-url button small" data-clipboard-action="copy" data-clipboard-target="#chart-url"><i class="fa fa-copy"></i> <?php echo _t('copy', 'url'); ?></button>
		  
		  <?php 
		  $embedcode = '<iframe src="'.SITE_ROOT_URL.'public/get-chart.php?id='.$id.'&width='.$cwidth.'&height='.$cheight.'" width="100%" height="'.($cheight+80).'" frameborder="0" style="border:0;width:100%;overflow:hidden;" allowfullscreen="" aria-hidden="false" tabindex="0" scrolling="no"></iframe>';
		  ?>
		  <input class="visually-hidden" id="chart-iframe" value="<?php echo htmlentities($embedcode); ?>" /><button class="copy-chart-iframe button small" data-clipboard-action="copy" data-clipboard-target="#chart-iframe"><i class="fa fa-file-code-o"></i> <?php echo _t('copy', 'embedcode'); ?></button>
		  
		</div>
	</div>
	<?php }  ?>
	<?php if($result_sdii[0]['sdii_nature'] == 'qualitative') echo getQualitativeViz($result_value, $result_sdii[0]); ?>
<?php } ?>
<h2 class="mtl"><?php echo formatTitleh2(_t('dashboard','all_value')." / ".$resultscale2[0]['scale_denomination']); ?></h2>
<?php
// check if we use multi-values or not
($result_sdii[0]['sdii_value_type'] == 'multiple') ? $tclass = ' multi-values' : $tclass = '';
?>
<table class="multisort<?php echo $tclass; ?>" id="indicator-values">
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('dashboard','date'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('divers','by'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','multivalue_value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		if($result_sdii[0]['sdii_value_type'] == 'multiple') echo "<td style=\"display:none\"  data-tableexport-display=\"always\">".mb_ucfirst(_t('dashboard','multivalue_distribution'))."</td>\n";
        if($result_sdii[0]['sdii_value_type'] == 'unique' && $result_sdii[0]['sdii_unique_mode'] == 'cumulative') echo "<td>".mb_ucfirst(_t('dashboard','cumulative_value'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','threshold_value'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','rate'))."</td>\n";
		echo "<td>".mb_ucfirst(_t('dashboard','comment'))."</td>\n";
		echo "<td class=\"sorter-false\"  data-tableexport-display=\"none\">&nbsp;</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php
	for ($i=0;$i<count($result_value);$i++){
	  $comment = '';
	  $current_val = '';
	  
	  $raw_multivalue = ''; // used to generate additional raw in excel export
	  
	  // seting default values
	  $display_min = empty_nc(fnumber_format($result_sdii[0]['sdii_min_value'], 'auto', false));
	  $display_max = empty_nc(fnumber_format($result_sdii[0]['sdii_max_value'], 'auto', false));
	  $display_threshold = empty_none(fnumber_format($result_sdii[0]['sdii_threshold_value'], 'auto', false));

	  // indicator is multivalues
	  if($result_sdii[0]['sdii_value_type'] == 'multiple') {

          if(!empty($result_value[$i]['sdiv_multivalue']) && !is_null($result_value[$i]['sdiv_multivalue'])) {
              $data = unserialize($result_value[$i]['sdiv_multivalue']);

              foreach ($data as &$val) {
                  $current_val .= '<p class="indicator-multivalue">';
                  if (!empty($val['label'])) $current_val .= '<span class="value-label" data-label="' . formatText($val['label'], '2HTML') . '">' . formatText($val['label'], '2HTML') . '</span> : ';

                  if(!is_null($val['value'])) {
                      $current_val .= '<span class="value-value" data-value="' . $val['value'] . '">' . fnumber_format($val['value'], 'auto', false) . '</span>';
                      if ($indicator_multiple_type == 'sum') $current_val .= '<span class="value-percent"> (' . fnumber_format($val['_percentage'], 2, false) . ' %)</span>';
                  } else {
                      $current_val .= '<span class="value-value" data-value="' . $val['value'] . '">' . _t('dashboard', 'no_data') . '</span>';
                  }
                  $current_val .= '</p>';

                  $raw_multivalue .= formatText($val['label'], '2HTML') . ' : ' . $val['value'] . '<br />';
              }
          } else {
              $current_val = _t('dashboard','no_data');
              $raw_multivalue = _t('dashboard','no_data');
          }
	  	// we display the total
	  	if(!defined('CLIENT_CHARTS') || CLIENT_CHARTS != 1) {
	  	    $chartlink = override('../dashboard/pie.php').'?id='.$id.'&amp;value='.$result_value[$i]['sdiv_id'].'&amp;display=true';
	  	} else {
	  	    $chartlink = SITE_ROOT_URL .'public/get-chart.php?id='.$id.'&amp;type=donut&amp;year='.substr(formatDate($result_value[$i]['date_p'], true), 0, 4).'&alternatives=all&share=1';
	  	}
        // we display the total if $indicator_multiple_type == 'sum'
        if($indicator_multiple_type == 'sum') {

            $current_val .= '<p class="value-total indicator-multivalue">';
            if(!is_null($data[0]['_total'])) {
                $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : <span class="total-numeric" data-total="' . $data[0]['_total'] . '">' . fnumber_format($data[0]['_total'], 'auto', false) . '</span>';
                $current_val .= ' <span><a class="see-detail-chart" href="' . $chartlink . '"><i class="fa fa-pie-chart" aria-hidden="true"></i> ' . _t('dashboard', 'to_detail_chart') . '</a></span>';
            } else {
                $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' . _t('dashboard', 'no_data') . '</span>';
            }
            $current_val .= '</p>';
            $current_val_raw = $data[0]['_total'];
        }
          // we display the total if $indicator_multiple_type == 'mean'
          if($indicator_multiple_type == 'mean') {
              $current_val .= '<p class="value-mean indicator-multivalue">';
              if(!is_null($data[0]['_mean'])) {
                  $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_mean')) . ' : <span class="total-numeric" data-mean="' . $data[0]['_mean'] . '">' . fnumber_format($data[0]['_mean'], 2, false) . '</span>';
              } else {
                  $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_mean')) . ' : ' . _t('dashboard', 'no_data') . '</span>';
              }
                  $current_val .= '</p>';
                  $current_val_raw = $data[0]['_mean'];
          }
          // we display the total if $indicator_multiple_type == 'none'
          if($indicator_multiple_type == 'none') {
              $current_val .= '';
              $current_val_raw = _t('sdi', 'multiple_type_none');
          }


        if($indicator_multiple_type != 'none') {
            if ($i == 0) {
                $lastValue = $current_val_raw; // we store data to compute TCAM and global rate
                $year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
            }
            if ($i == count($result_value) - 1) {
                $firstValue = $current_val_raw; // we store data to compute TCAM and global rate
                $year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
            }
        }
	  	
	  	// we compute rate
        if($indicator_multiple_type == 'mean') $rate_field = '_mean'; else $rate_field = '_total';
	  	if(isset($result_value[$i+1]['sdiv_multivalue']) && $indicator_multiple_type != 'none') {
	  		$dataPlusOne = unserialize($result_value[$i+1]['sdiv_multivalue']);
	  		if($dataPlusOne[0][$rate_field] != 0) {
				$evol = ($data[0][$rate_field] - $dataPlusOne[0][$rate_field]) / $dataPlusOne[0][$rate_field] * 100;
				// _debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$data[0][$rate_field]. ' - ' . $dataPlusOne[0][$rate_field]. ') / '. $dataPlusOne[0][$rate_field]);
				$evol = fnumber_format($evol, 2). ' %';
			} else {
				$evol = empty_nc('');
			}
	  	} else {
	  		$evol = empty_nc('');
	  	}

	  	// indicator is NOT multivalues
	  } else {
	  	

	  	
	  	// If indicator is boolean or qualitative
	  	if($result_sdii[0]['sdii_nature'] == 'boolean' || $result_sdii[0]['sdii_nature'] == 'qualitative') {
	  		$a = getBooleanValues($result_sdii[0]);

	  		if($a) {
	  			$index = array();
	  			foreach ($a as $key => $value) {
	  				array_push($index, $key);
	  			}
                if(is_null($result_value[$i]['sdiv_value'])) {
                    $current_val .=  _t('dashboard', 'no_data');
                    $current_val_raw = $result_value[$i]['sdiv_value'];
                } else {
                    $current_val .= $a[$result_value[$i]['sdiv_value']];
                    $current_val_raw = $result_value[$i]['sdiv_value'];
                }

	  			$maskminvalue = $a[min($index)];
	  			$maskmaxvalue = $a[max($index)];
	  			if(is_null($result_value[$i]['sdiv_threshold'])) $threshold = empty_none('');
	  			else $threshold = $a[$result_value[$i]['sdiv_threshold']];
	  			
	  			
	  		} else {
                  if(is_null($result_value[$i]['sdiv_value'])) {
                      $current_val .= mb_ucfirst(_t('dashboard', 'no_data'));
                      $current_val_raw = $result_value[$i]['sdiv_value'];
                  } else {
                      $current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
                      $current_val_raw = $result_value[$i]['sdiv_value'];
                  }
	  		}
	  		
	  	} else {
            if(is_null($result_value[$i]['sdiv_value'])) {
                $current_val .= mb_ucfirst(_t('dashboard', 'no_data'));
                $current_val_raw = $result_value[$i]['sdiv_value'];
            } else {
                $current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
                $current_val_raw = $result_value[$i]['sdiv_value'];
            }

	  		if($i == 0) {
	  			$lastValue = $current_val_raw; // we store data to compute TCAM and global rate
	  			$year_end = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
	  		}
	  		if($i == count($result_value)-1) {
	  			$firstValue = $current_val_raw; // we store data to compute TCAM and global rate
	  			$year_start = substr(formatDate($result_value[$i]['date_p'], true), 0, 4);
	  		}
	  	}

	  	$evol = empty_nc('');
	  	// we compute rate - 
	  	if($result_sdii[0]['sdii_nature'] == 'quantitative') {
	  	    if(isset($result_value[$i+1]['sdiv_value']) && is_numeric($result_value[$i+1]['sdiv_value']) && $result_value[$i+1]['sdiv_value'] != 0) {
		  	    if(!is_null($result_value[$i+1]['sdiv_value']) && !is_null($result_value[$i]['sdiv_value']) ) {
                    $evol = ($result_value[$i]['sdiv_value'] - $result_value[$i + 1]['sdiv_value']) / $result_value[$i + 1]['sdiv_value'] * 100;
                    // _debug('rate : '. fnumber_format($evol, 2). ' %  - details : ('.$result_value[$i]['sdiv_value']. ' - ' . $result_value[$i+1]['sdiv_value']. ') / '. $result_value[$i+1]['sdiv_value']);
                    $evol = fnumber_format($evol, 2) . ' %';
                } else $evol = empty_nc('');
	  	    }  else {
	  	        $evol = empty_nc('');
	  	    }
	  	}
	  }
	  
	  $threshold_raw = $default_threshold;

	  // default threshold values
	  if($result_sdii[0]['sdii_nature'] == 'quantitative') {
	  	$threshold = empty_none(fnumber_format($default_threshold, 'auto', false));	  	
	  } else {
	  	if(is_null($default_threshold)) {
	  		$threshold = empty_none('');
	  	} else {
	  		$threshold = $a[$default_threshold];
	  	}
	  }
	  
	  // if set, we get it from the table
	  if(!is_null($result_value[$i]['sdiv_threshold'])) {
	  	if($result_sdii[0]['sdii_nature'] == 'boolean' || $result_sdii[0]['sdii_nature'] == 'qualitative') {
	  		$threshold = $a[$result_value[$i]['sdiv_threshold']];
		  	$threshold_raw = $result_value[$i]['sdiv_threshold'];
	  	} else {
	  		$threshold = fnumber_format($result_value[$i]['sdiv_threshold'], 'auto', false);
	  		$threshold_raw = $result_value[$i]['sdiv_threshold'];
	  	}
	  } else {
	      $threshold = empty_none('');
	      $threshold_raw = '';
	  }


	  ($result_value[$i]['sdiv_comment_display'] == 'Y') ? $comment_status = _t('dashboard', 'public') : $comment_status = _t('dashboard', 'private');
      $history = getIndicatorValueContributors($result_value[$i], $sql_object);
      if(!empty($history)) $history = sprintf('<div class="modification-history no-export"><span class="hint--top hint--large hint--rounded" aria-label="%s : %s"><i class="fa fa-history" aria-hidden="true"></i></span></div>', _t('dashboard', 'history_edition'), $history);

	  if(!empty($result_value[$i]['sdiv_comment'])) {
	    $comment  = '<div class="valuecomment">';
	    $comment .= '<i class="fa fa-comment-o" aria-hidden="true"></i>';
	    $comment .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'comment')).' ('.$comment_status.') :</strong> '.$result_value[$i]['sdiv_comment'].'</div>';
	    $comment .= '</div>';
	  }
	  echo "<tr>\n";
	  echo "<td class=\"date\" data-date=\"". formatText($result_value[$i]['date_p'], '2HTML')."\">". formatText($result_value[$i]['date_p'], '2HTML'). $history."</td>\n";
	  echo "<td>". $result_value[$i]['user_login']  ."</td>\n";
	  echo "<td class=\"value\" data-value=\"". $current_val_raw."\">". formatText($current_val, '2HTML');
      if($result_sdii[0]['sdii_value_type'] == 'unique' && $result_sdii[0]['sdii_unique_mode'] == 'cumulative') echo "<td class=\"cumulative-value\" data-value=\"". $result_value[$i]['sdiv_cumulative_value']."\">". formatText(fnumber_format($result_value[$i]['sdiv_cumulative_value'], 'auto', false), '2HTML');
      if(!empty($result_value[$i]['sdiv_analysis'])) {
        $analysis  = '<div class="valuecomment analysis no-export">';
        $analysis .= '<i class="fa fa-line-chart" aria-hidden="true"></i>';
        $analysis .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'last_analysis')).' :</strong> '.$result_value[$i]['sdiv_analysis'].'</div>';
        $analysis .= '</div>';
        echo $analysis;
      }
	  if($result_sdii[0]['sdii_value_type'] == 'multiple') echo "<td style=\"display:none\"  data-tableexport-display=\"always\">".$raw_multivalue."</td>\n";
	   
	  if ($result_value[$i]['sdiv_statut']=='D') {
	    echo "<span class=\"state\">".mb_ucfirst(_t('statut','draft'))."</span>";
	  }
	  echo "</td>\n";
	  echo "<td class=\"threshold\" data-threshold=\"". $threshold_raw ."\">". $threshold."</td>\n";
	  echo "<td class=\"rate\">". $evol."</td>\n";
	  echo "<td>". $comment."</td>\n";
	  echo "<td data-tableexport-display=\"none\"><div class=\"iconetab\"><a href=\"".$link_sup.$result_value[$i]['sdiv_id']."&amp;id=".$id."&amp;scale_id=".$scale_id."\" title=\""._t('dashboard','sup')."\" class=\"ico_sup\"><i class=\"fa fa-trash\"></i><span>" . _t('dashboard','sup') . "</span></a>";
	  echo "<a href=\"".$link_mod.$result_value[$i]['sdiv_id']."&amp;id=".$id."&amp;scale_id=".$scale_id."\" title=\""._t('dashboard','mod')."\" class=\"ico_mod\"><i class=\"fa fa-pencil-square-o\"></i><span>" . _t('dashboard','mod') . "</span></a></div></td>\n";
	  echo "</tr>\n";

	}

	// Ability to sort table
	addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
	footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
	$str = '$("table.multisort").tablesorter({	});';
	footerAddInlineJS($str);
	?>
	</tbody>
</table>
<?php 
if($result_sdii[0]['sdii_nature'] == 'quantitative' && $result_sdii[0]['sdii_multiple_type'] != 'none') echo getRates($firstValue, $lastValue, $year_start, $year_end);
?>

<!-- dropdown container -->
<div class="dropdown export-button" id="export-values">
<!-- trigger button -->
<button><i class="fa fa-download" aria-hidden="true"></i></i> <?php echo _t('btn', 'export_values'); ?></button>
    <!-- dropdown menu -->
    <ul class="dropdown-menu">
        <li><a href="#export-values" data-format="excel"><i class="fa fa-file-excel-o" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'excel'); ?></a></li>
        <li><a href="#export-values" data-format="csv"><i class="fa fa-file-code-o" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'csv'); ?></a></li>
        <li><a href="#export-values" data-format="json"><i class="fa fa-file-code-o" aria-hidden="true"></i></i> <?php echo _t('export', 'format', 'json'); ?></a></li>
        <li><a href="#export-values" data-format="png"><i class="fa fa-file-image-o" aria-hidden="true"></i> <?php echo _t('export', 'format', 'png'); ?></a></li> 
    </ul>
    
</div>

<?php 
// Insert Javascript instructions to allow client Excel export
footerAddJS('../lib/js/tableExport.jquery.plugin/tableExport.min.js');
footerAddJS('../lib/js/tableExport.jquery.plugin/libs/html2canvas/html2canvas.min.js');

$slug_name = Stringy\Stringy::create($result_sdii[0]['sdii_name'], CHARSET)->safeTruncate(50)->slugify();


$str = '$("#export-values li a").click(function() {
						
						var format = $(this).attr("data-format");
						var ignoreCol = []; // set columns to ignore
						
						// we clone element and we ignore unwanted column
						$el = $("#indicator-values").clone().attr("id", "indicator-values-clone"); // we create a clone
						$el.find( ".no-export" ).remove(); // we remove unwanted elements inside $el
						ignoreCol.push(7);
						$el.insertAfter("#export-values"); // if not displayed, the export does not work

		
						// if is multi-values table we dynamically change the content
						if( $("#indicator-values").hasClass("multi-values") && format != "png") {
							
							$el.find( "td.value" ).each(function( index ) {
								// we replace all values by "data-value" attribute content
								$( this ).text( $(this).attr("data-value") );
							});

							$el.insertAfter("#export-values"); // if not displayed, the export does not work
						}
					if(format == "png") $("html, body").scrollTop(0);
  					$el.tableExport(
							{tableName:"'.mb_ucfirst($result_sdii[0]['sdii_name'] . ' - ' .$result_sdii[0]['sdii_unit'] . ' / '. $resultscale2[0]['scale_denomination']). '",type:format,escape:\'false\',ignoreColumn: ignoreCol,displayTableName:\'true\',htmlContent:\'false\',fileName:\'' . $slug_name . '\'});
						
						return false;
						});';
footerAddInlineJS($str);
?>


	<?php }
	else echo "<div class=\"info\">"._t('dashboard','novalue').": ".formatText($resultscale2[0]['scale_denomination'], '2HTML')."</div>";
	?>

<dl class="dl2">
	<dt class="i-level"><?php echo mb_ucfirst(_t('sdi','level')) ?> :</dt>
	<dd><?php
	if ($l21auth->isSuperAdmin() && $result_sdii[0]['sdii_level'] != 0)
	    echo "<a href=\"".$link_det_level.$result_sdii[0]['sdii_level']."\" title=\"".$level_label_att."\">".$disp_level_name."</a>";
	else echo $disp_level_name;
	?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','description')) ?> :</dt>
	<dd><?php echo formatText($result_sdii[0]['sdii_description'], '2HTML');?></dd>
	<dt><?php echo mb_ucfirst(_t('sdi','threshold_relative')) ?> :</dt>
	<dd><?php
	if ($result_sdii[0]['sdii_threshold_relative']=='Y') echo mb_ucfirst(_t('sdi','threshold_relative_Y'));
	else echo mb_ucfirst(_t('sdi','threshold_relative_N'));
	?></dd>
	<dt><?php echo mb_ucfirst(_t('dashboard','associated_projects')) ?> :</dt>
	<dd><?php echo get_associated_projects($id); ?></dd>
</dl>


<h2><?php echo _t('sdi','info_mesure'); ?></h2>

<table>
	<thead>
		<tr>
		<?php
		echo "<td>".mb_ucfirst(_t('sdi','min_value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','max_value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','initial_threshold_value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
		echo "<td>".mb_ucfirst(_t('sdi','frequency'))."</td>\n";
		?>
		</tr>
	</thead>
	<tbody>
	<?php
	
	isset($maskminvalue) ? $display_min = $maskminvalue : $display_min = empty_nc(fnumber_format($result_sdii[0]['sdii_min_value'], 'auto', false));
	isset($maskmaxvalue) ? $display_max = $maskmaxvalue : $display_max = empty_nc(fnumber_format($result_sdii[0]['sdii_max_value'], 'auto', false));
	isset($maskthreshold) ? $display_threshold = $maskthreshold : $display_threshold = empty_nc(fnumber_format($result_sdii[0]['sdii_threshold_value'], 'auto', false));
	
	echo "<tr>\n";
	echo "<td>". $display_min."</td>\n";
	echo "<td>". $display_max."</td>\n";
	echo "<td>". $display_threshold ."</td>\n";
	echo "<td>". formatText(fnumber_format($result_sdii[0]['sdii_frequency'], 'auto', false), '2HTML')."</td>\n";
	echo "</tr>\n";
	?>
	</tbody>
</table>


<?php 
if ($result_sdii[0]['sdii_api_enabled']=='Y') $display_api_enabled = _t('divers','yes');
else $display_api_enabled = _t('divers','no');
if ($result_sdii[0]['sdii_api_getvalues']=='Y') $display_api_getvalues = _t('divers','yes');
else $display_api_getvalues = _t('divers','no');
if ($result_sdii[0]['sdii_api_overwritevalues']=='Y') $display_api_overwritevalues = _t('divers','yes');
else $display_api_overwritevalues = _t('divers','no');
$display_api_url = formatText(empty_nc($result_sdii[0]['sdii_api_url']), '2HTML');
$display_api_decimal = ' (' . _t('sdi','api-decimal') . ' : ' . formatText($result_sdii[0]['sdii_api_decimal'], '2HTML').')';
if(Stringy\Stringy::create($display_api_url, CHARSET)->isUrl()) $display_api_url = sprintf('<a href="%s" target="_blank">%s</a>', $display_api_url, $display_api_url);

$display_api_datefield = formatText(empty_nc($result_sdii[0]['sdii_api_datefield']), '2HTML');
$display_api_valuefield = formatText(empty_nc($result_sdii[0]['sdii_api_valuefield']), '2HTML');

if($result_sdii[0]['sdii_value_type'] == 'multiple') {
    $form_api_multimapping = unserialize($result_sdii[0]['sdii_api_multimapping']);
    $form_api_multimapping_field = '';

    if(is_array($form_api_multimapping)) {
        foreach ($form_api_multimapping as $k => $v) {
            $form_api_multimapping_field .= '<div class="mapping-fields">';
            $form_api_multimapping_field .= '<span>'.mb_ucfirst($k). ' ⬌ '. $v. '</span>';
            $form_api_multimapping_field .= '</div>';
        }
    }
    $display_api_valuefield = $form_api_multimapping_field;
}

?>

<?php if ($result_sdii[0]['sdii_api_enabled']=='Y') { ?>
<div class="i-api-info">
    <div class="toggle_title">
        <a id="affapi" href="#" title="<?php echo _t('sdi','api');?>"><?php echo _t('sdi','api');?></a>
    </div>
    <div id="api-infos" style="display: none;" class="mtm">
        <?php
        if(!defined('API_RETRIEVE') || API_RETRIEVE == 0) echo '<p class="error">'._t('sdi', 'api-globally-disabled').'</p>';
        ?>
    <dl>
        <dt><?php echo mb_ucfirst(_t('sdi','api-enabled')) ?> :</dt>
        <dd><?php echo $display_api_enabled;?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','api-url')) ?> :</dt>
        <dd><?php echo $display_api_url;?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','api-date-field')) ?> :</dt>
        <dd><?php echo $display_api_datefield;?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','api-value-field')) ?> :</dt>
        <dd><?php echo $display_api_valuefield . $display_api_decimal; ?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','api-get-values')) ?> :</dt>
        <dd><?php echo $display_api_getvalues; ?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','api-get-values-since')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_api_getvalues_since'], 'HTML')); ?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','api-overwrite-values')) ?> :</dt>
        <dd><?php echo $display_api_overwritevalues; ?></dd>
    </dl>
        <?php if(defined('API_RETRIEVE') && API_RETRIEVE == 1) { ?>
    <div class="mod_link"><span style="display:block" class="w100 hint--top hint--rounded hint--large" aria-label="<?php echo _t('sdi', 'api-manual-import-hint'); ?>"><a href="../dashboard/api-harvest.php?id=<?php echo $result_sdii[0]['sdii_id']; ?>&token=<?php echo SECRET_KEY; ?>" class="big-button" id="API-import"><i class="api-plugged fa fa-code-fork" aria-hidden="true"></i> <?php echo _t('sdi','api-manual-import'); ?></a></span></div>

        <?php } ?>
    <?php
    // ajax code
    $js = '$("#API-import,#API-import-light").click(function() {
         
                var el = this;
                var url = $(el).attr("href") + "&mode=ajax";
         
                $.ajax({
                    type: "GET",
                    url: url,
                    dataType: "json",
                    success: function(data) {
                        if(data.status==1) {
                            alertify.success(data.msg);
                            setTimeout(function(){
                              window.location = "../admin/index.php?rub=dashboard&todo=det&id='.$result_sdii[0]['sdii_id'].'";
                            }, 4500);
                        } else {
                            alertify.error(data.msg);
                        }
                    }
                });
                return false;
            });';

    footerAddInlineJS($js);
    ?>
    </div>
</div>
<?php } ?>
<div class="i-info">
    <div class="toggle_title">
        <a href="" id="affinfoge"><?php echo mb_ucfirst(_t('dashboard','det_sdi'));?></a>
    </div>
    <div id="general" style="display: none;" class="mtm">
    <dl class="dl2">

    <?php /*<dt><?php echo mb_ucfirst(_t('sdi','range')) ?> : </dt>
    <dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_range']), '2HTML');?></dd> */ ?>
        <dt><?php echo mb_ucfirst(_t('sdi','comment')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_comment']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','goal')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_goal']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','consulting')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_sdii[0]['sdii_consulting']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('divers','statut')) ?> :</dt>
        <dd><?php echo display_statut($result_sdii[0]['sdii_statut']);?></dd>
    </dl>
    </div>
</div>

<div class="i-provider">
    <div class="toggle_title">
        <a href="#" id="affprovider"><?php echo _t('sdi','aff_sdi_p');?></a>
    </div>
    <div id="provider" style="display: none;" class="mtm">
    <?php if ($result_p[0]['sdip_name']=="") {
      echo "<h2 class=\"info\">"._t('divers','nodata')."</h2>";
    } else {
    if(empty($result_p[0]['sdip_email'])) {
      $mailto_provider = empty_nc($result_p[0]['sdip_email']);
    } else {
      $mailto_provider =  "<a href=\"mailto:".formatText(empty_nc($result_p[0]['sdip_email']), '2HTML')."\" title=\"".formatText(empty_nc($result_p[0]['sdip_email']), '2HTML')."\">".formatText(empty_nc($result_p[0]['sdip_email']), '2HTML')."</a>";
    }
    ?>
    <h2><?php echo formatText(empty_nc($result_p[0]['sdip_name']), '2HTML');?></h2>
    <dl class="dl2">
        <dt><?php echo mb_ucfirst(_t('sdi','p_service')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_p[0]['sdip_service']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','p_incharge')) ?>	:</dt>
        <dd><?php echo formatText(empty_nc($result_p[0]['sdip_incharge']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','p_address')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_p[0]['sdip_address']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','p_phone')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_p[0]['sdip_phone']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','p_fax')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_p[0]['sdip_fax']), '2HTML');?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','p_email')) ?> :</dt>
        <dd><?php echo $mailto_provider; ?></dd>
        <dt><?php echo mb_ucfirst(_t('sdi','p_description')) ?> :</dt>
        <dd><?php echo formatText(empty_nc($result_p[0]['sdip_description']), '2HTML');?></dd>
    </dl>
    <?php } ?>
    </div>
</div>

<div class="i-assessment">
    <div class="toggle_title">
        <a href="#" id="affeval"><?php echo _t('sdi','aff_sdi_e');?></a>
    </div>
    <div id="evaluation" style="display: none;" class="mtm">
    <table>
        <thead>
            <tr>
            <?php
            echo "<td>".mb_ucfirst(_t('sdi','e_scale_compare'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','e_fiability'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','e_accessibility'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','e_lisibility'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','e_relevance'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','e_global_performance'))."</td>\n";
            ?>
            </tr>
        </thead>
        <tbody>
        <?php echo "<tr>\n";
        echo "<td>". empty_nc($result_e[0]['sdie_scale_compare'])."</td>\n";
        echo "<td>". empty_nc($result_e[0]['sdie_fiability'])."</td>\n";
        echo "<td>". empty_nc($result_e[0]['sdie_accessibility'])."</td>\n";
        echo "<td>". empty_nc($result_e[0]['sdie_lisibility'])."</td>\n";
        echo "<td>". empty_nc($result_e[0]['sdie_relevance'])."</td>\n";
        echo "<td>". empty_nc($result_e[0]['sdie_global_performance'])."</td>\n";
        echo "</tr>\n";
        ?>
        </tbody>
    </table>
    </div>
</div>

<div class="i-regulation">
    <div class="toggle_title">
        <a href="#" id="affreg"><?php echo _t('sdi','aff_sdi_r');?></a>
    </div>
    <div id="reglementation" style="display: none;"  class="mtm"><?php if ($result_r[0]['sdir_title']=="") {
      echo "<h2 class=\"info\">"._t('divers','nodata')."</h2>";
    }else {?> <?php
    if(empty($result_r[0]['sdir_referer_uri'])) {
      $rules_link = empty_nc($result_r[0]['sdir_referer_uri']);
    } else {
      $rules_link = "<a href=\"".formatText(empty_nc($result_r[0]['sdir_referer_uri']), '2HTML')."\" title=\"".formatText(empty_nc($result_r[0]['sdir_mask_uri']), '2HTML')."\" class=\"out\">".formatText(empty_nc($result_r[0]['sdir_mask_uri']), '2HTML')."</a>";
    }
    ?>
    <h2><?php echo formatText(empty_nc($result_r[0]['sdir_title']), '2HTML');?></h2>

    <dl class="dl2">
        <dt><?php echo mb_ucfirst(_t('sdi','r_referer_uri')) ?> :</dt>
        <dd><?php echo $rules_link; "</dd>"; ?>
    </dl>

    <div>
      <?php echo formatText(empty_nc($result_r[0]['sdir_body']), '2HTML'); ?>
    </div>
    <?php } ?>
    </div>
</div>

</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->

<script>
$(document).ready(function() {
	var cboxOptions = { iframe:true, innerWidth: '80%', innerHeight: '85%', maxWidth: '1080px', maxHeight: '960px' }
	$('.see-detail-chart').colorbox(cboxOptions);
	$(window).resize(function(){ $.colorbox.resize({ width: window.innerWidth > parseInt(cboxOptions.maxWidth) ? cboxOptions.maxWidth : cboxOptions.width, height: window.innerHeight > parseInt(cboxOptions.maxHeight) ? cboxOptions.maxHeight : cboxOptions.height }); });

	$(".valuecomment").hover(
		function() {
			$('.cont', this).fadeIn();
		},
		function() {
			$('.cont', this).hide();
		});
});
</script>
