<?php
/**
 * Export module
 * 
 * Main report generation page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */


set_time_limit(0);
include_once('../config/define.php');
ob_start();

// prevent XSS
$_POST  = filter_input_array(INPUT_POST, FILTER_SANITIZE_FULL_SPECIAL_CHARS);
// print_r($_POST);

IncludeReportLang();

// we get the indicator id if sent to check if user is allowed to generate export  
$indic = isset($_POST['eachsdi']) && is_int((int) $_POST['eachsdi'][0])  ? (int) $_POST['eachsdi'][0] : 0;

if($_POST['what'] === 'dashboard') {
	//////////// Check Droits utilisateur ////////////
    if (!$l21auth->hasRight('dashboard') && !$l21auth->hasRight('indicator', $indic)) ReloadIndex('admin');
	////////////
	include_once(override('phpsql.process.dashboard.php', THEME_PUBLIC_PATH));
	include_once(override('../dashboard/common.php', THEME_PUBLIC_PATH));
} else {
	//////////// Check Droits utilisateur ////////////
    if (!$l21auth->hasRight('project')) ReloadIndex('admin');
	////////////
	include_once(override('phpsql.process.project.php', THEME_PUBLIC_PATH));
}
include_once(override('../level/display.php'));

isset($_POST['quick_export']) ? $report_settings['quick_export'] = true : false ;
isset($_POST['format_report']) ? $report_settings['export_format'] = $_POST['format_report'] : $report_settings['export_format'] = 'pdf';

// DO NOT REMOVE - usefull for debug !
error_reporting(E_ALL);
ini_set('display_errors', '1');

if(defined('EXPORT_LOG') && EXPORT_LOG == 1) {
    SureRemoveDir('../tmp/export-logs', 1);
    mkdir('../tmp/export-logs', 0755, true); 
}

// we remove all old images files in case there are still there
if(!$report_settings['quick_export']) SureRemoveDir('../tmp/report', 1);

if($report_settings['export_format'] == 'pdf') {
	$bookmark_level = 0;
	if($report_settings['levels'] == false) $bookmark_level = -1; // necessary for generating right TOC
	require_once(override('../export/pdf/main.php', THEME_PUBLIC_PATH));
	
} elseif($report_settings['export_format'] == 'excel') {
    $bookmark_level = 1;
    require_once(override('../export/excel/main.php', THEME_PUBLIC_PATH));
	
}
else {
    $bookmark_level = 1;
    require_once(override('../export/word/main.php', THEME_PUBLIC_PATH));
    
}

SureRemoveDir('../tmp/report', 1);
?>
