<?php
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 1.6
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
if(file_exists('../config/define_release.ini')) {
	
	if(!is_writable ('../config/')) die("'config/' folder is not writable. Please change permissions and refresh the page.");
	
	// config.ini file does not exists, we take values from config.ini.default - $installation_process set to true
	
	// update main ini file
    $ini_r = array();
	
	// we parse the old DB ini file
	$ini_db = parse_ini_file("../config/define_db.ini");
	
	// we set database values into the new config.ini file
	$ini_r['DB_HOST'] = $ini_db['DB_HOST'];
	$ini_r['DB_USER'] = $ini_db['DB_USER'];
	$ini_r['DB_PASS'] = $ini_db['DB_PASS'];
	$ini_r['DB_NAME'] = $ini_db['DB_NAME'];
	$ini_r['DB_ADMINMAIL'] = $ini_db['DB_ADMINMAIL'];
	
    
	// we parse the old ini file
	$ini_release = parse_ini_file("../config/define_release.ini");
	
	// we parse the new ini file to check if keys exists
	$ini_config = parse_ini_file("../config/config.ini.default");

	foreach ($ini_release as $key => $value) {
		// if the key exists in the default ini file, we overwrite the default value by the previous
		if(isset($ini_config[$key])) $ini_r[$key] = $value;
	}
	
	$l21config->setParams($ini_r);

	// we write the new file
    if($l21config->writeReleaseParams()) {
		echo "Writing new configuration file : /config/config.ini</br>";
	} else {
		echo "Problem writing new configuration file : /config/config.ini</br>";
	}

	// we backup old config files before removing them
	$dest = '../tmp/backup/config/';
	
	if(!file_exists($dest)) mkdir($dest, 0755, true);

	if (!copy("../config/define_release.ini", $dest . "define_release.ini")) {
		echo "Failed to backup define_release.ini file.</br>";
	} else {
		echo "Backup define_release.ini file : ok.</br>";
		
		if(unlink("../config/define_release.ini")) {
			echo "Removing define_release.ini file form /config/ folder.</br>";
		}
	}
    
    	if (!copy("../config/define_db.ini", $dest . "define_db.ini")) {
		echo "Failed to backup define_db.ini file.</br>";
	} else {
		echo "Backup define_db.ini file : ok.</br>";
		
		if(unlink("../config/define_db.ini")) {
			echo "Removing define_db.ini file form /config/ folder.</br>";
		}
	}
	
	@unlink('../newsletter/x7iYhD98w_sendmail.php');

}
?>