/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Highcharts cylinder module
 *
 * (c) 2010-2021 Kacper Madej
 *
 * License: www.highcharts.com/license
 */!function(e){"object"==typeof module&&module.exports?(e.default=e,module.exports=e):"function"==typeof define&&define.amd?define("highcharts/modules/cylinder",["highcharts","highcharts/highcharts-3d"],function(t){return e(t),e.Highcharts=t,e}):e("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(e){"use strict";var t=e?e._modules:{};function s(e,t,s,r){e.hasOwnProperty(t)||(e[t]=r.apply(null,s),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:t,module:e[t]}})))}s(t,"Series/Cylinder/SVGElement3DCylinder.js",[t["Core/Color/Color.js"],t["Core/Renderer/RendererRegistry.js"]],function(e,t){let{parse:s}=e,{Element3D:r}=t.getRendererType().prototype;return class extends r{constructor(){super(...arguments),this.parts=["top","bottom","front","back"],this.pathType="cylinder"}fillSetter(e){return this.singleSetterForParts("fill",null,{front:e,back:e,top:s(e).brighten(.1).get(),bottom:s(e).brighten(-.1).get()}),this.color=this.fill=e,this}}}),s(t,"Series/Cylinder/CylinderComposition.js",[t["Core/Globals.js"],t["Core/Math3D.js"],t["Series/Cylinder/SVGElement3DCylinder.js"],t["Core/Utilities.js"]],function(e,t,s,r){let{charts:i,deg2rad:n}=e,{perspective:o}=t,{extend:l,pick:d,pushUnique:u}=r,h=[];function y(e){return!e.some(e=>"C"===e[0])}function p(e){return this.element3d("cylinder",e)}function c(e){let t=i[this.chartIndex],s=this.cuboidPath(e),r=!s.isTop,n=!s.isFront,o=this.getCylinderEnd(t,e),l=this.getCylinderEnd(t,e,!0);return{front:this.getCylinderFront(o,l),back:this.getCylinderBack(o,l),top:o,bottom:l,zIndexes:{top:r?3:0,bottom:r?0:3,front:n?2:1,back:n?1:2,group:s.zIndexes.group}}}function C(e){let t=[["M",e[0].x,e[0].y]],s=e.length-2;for(let r=1;r<s;r+=3)t.push(["C",e[r].x,e[r].y,e[r+1].x,e[r+1].y,e[r+2].x,e[r+2].y]);return t}function a(e,t){let s=[];if(y(e)){let t=e[0],r=e[2];"M"===t[0]&&"L"===r[0]&&(s.push(["M",r[1],r[2]]),s.push(e[3]),s.push(["L",t[1],t[2]]))}else"C"===e[2][0]&&s.push(["M",e[2][5],e[2][6]]),s.push(e[3],e[4]);if(y(t)){let e=t[0];"M"===e[0]&&(s.push(["L",e[1],e[2]]),s.push(t[3]),s.push(t[2]))}else{let e=t[2],r=t[3],i=t[4];"C"===e[0]&&"C"===r[0]&&"C"===i[0]&&(s.push(["L",i[5],i[6]]),s.push(["C",i[3],i[4],i[1],i[2],r[5],r[6]]),s.push(["C",r[3],r[4],r[1],r[2],e[5],e[6]]))}return s.push(["Z"]),s}function f(e,t,s){let r,i;let{width:l=0,height:u=0,alphaCorrection:h=0}=t,y=d(t.depth,l,0),p=Math.min(l,y)/2,c=n*(e.options.chart.options3d.beta-90+h),C=(t.y||0)+(s?u:0),a=.5519*p,f=l/2+(t.x||0),g=y/2+(t.z||0),m=[{x:0,y:C,z:p},{x:a,y:C,z:p},{x:p,y:C,z:a},{x:p,y:C,z:0},{x:p,y:C,z:-a},{x:a,y:C,z:-p},{x:0,y:C,z:-p},{x:-a,y:C,z:-p},{x:-p,y:C,z:-a},{x:-p,y:C,z:0},{x:-p,y:C,z:a},{x:-a,y:C,z:p},{x:0,y:C,z:p}],x=Math.cos(c),S=Math.sin(c);for(let e of m)r=e.x,i=e.z,e.x=r*x-i*S+f,e.z=i*x+r*S+g;let j=o(m,e,!0);return 2.5>Math.abs(j[3].y-j[9].y)&&2.5>Math.abs(j[0].y-j[6].y)?this.toLinePath([j[0],j[3],j[6],j[9]],!0):this.getCurvedPath(j)}function g(e,t){let s=e.slice(0,3);if(y(t)){let e=t[0];"M"===e[0]&&(s.push(t[2]),s.push(t[1]),s.push(["L",e[1],e[2]]))}else{let e=t[0],r=t[1],i=t[2];"M"===e[0]&&"C"===r[0]&&"C"===i[0]&&(s.push(["L",i[5],i[6]]),s.push(["C",i[3],i[4],i[1],i[2],r[5],r[6]]),s.push(["C",r[3],r[4],r[1],r[2],e[1],e[2]]))}return s.push(["Z"]),s}return{compose:function(e){if(u(h,e)){let t=e.prototype;t.Element3D.types.cylinder=s,l(t,{cylinder:p,cylinderPath:c,getCurvedPath:C,getCylinderBack:a,getCylinderEnd:f,getCylinderFront:g})}}}}),s(t,"Series/Cylinder/CylinderPoint.js",[t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t){let{column:{prototype:{pointClass:s}}}=e.seriesTypes,{extend:r}=t;class i extends s{constructor(){super(...arguments),this.options=void 0,this.series=void 0}}return r(i.prototype,{shapeType:"cylinder"}),i}),s(t,"Series/Cylinder/CylinderSeriesDefaults.js",[],function(){return{}}),s(t,"Series/Cylinder/CylinderSeries.js",[t["Series/Cylinder/CylinderComposition.js"],t["Series/Cylinder/CylinderPoint.js"],t["Series/Cylinder/CylinderSeriesDefaults.js"],t["Core/Series/SeriesRegistry.js"],t["Core/Utilities.js"]],function(e,t,s,r,i){let{column:n}=r.seriesTypes,{extend:o,merge:l}=i;class d extends n{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0}}return d.compose=e.compose,d.defaultOptions=l(n.defaultOptions,s),o(d.prototype,{pointClass:t}),r.registerSeriesType("cylinder",d),d}),s(t,"masters/modules/cylinder.src.js",[t["Series/Cylinder/CylinderSeries.js"],t["Core/Renderer/RendererRegistry.js"]],function(e,t){e.compose(t.getRendererType())})});//# sourceMappingURL=cylinder.js.map