/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * (c) 2009-2022
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/flowmap",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function o(t,i,o,e){t.hasOwnProperty(i)||(t[i]=e.apply(null,o),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}o(i,"Series/FlowMap/FlowMapPoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){let{seriesTypes:{mapline:{prototype:{pointClass:o}}}}=t,{pick:e,isString:s,isNumber:r}=i;return class extends o{constructor(){super(...arguments),this.options=void 0,this.series=void 0}isValid(){let t=!!(this.options.to&&this.options.from);return[this.options.to,this.options.from].forEach(function(i){t=!!(t&&i&&(s(i)||r(e(i[0],i.lat))&&r(e(i[1],i.lon))))}),t}}}),o(i,"Series/FlowMap/FlowMapSeries.js",[i["Series/FlowMap/FlowMapPoint.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,o){let{series:{prototype:{pointClass:e}},seriesTypes:{column:s,map:r,mapline:n}}=i,{addEvent:a,arrayMax:h,arrayMin:l,defined:p,extend:d,isArray:f,merge:c,pick:u,relativeLength:m}=o;class g extends n{constructor(){super(...arguments),this.data=void 0,this.options=void 0,this.points=void 0,this.smallestWeight=void 0,this.greatestWeight=void 0,this.centerOfPoints=void 0}static getLength(t,i){return Math.sqrt(t*t+i*i)}static normalize(t,i){let o=this.getLength(t,i);return[t/o,i/o]}static markerEndPath(t,i,o,e){let s=m(e.width||0,this.getLength(i[0]-t[0],i[1]-t[1])),r=e.markerType||"arrow",[n,a]=this.normalize(i[0]-t[0],i[1]-t[1]),h=[];if("arrow"===r){let[e,r]=t;e-=n*s,r-=a*s,h.push(["L",e,r]),h.push(["L",o[0],o[1]]),[e,r]=i,e+=n*s,r+=a*s,h.push(["L",e,r])}if("mushroom"===r){let[e,r]=t,[l,p]=i,[d,f]=o,c=(l-e)/2+e,u=(p-r)/2+r;e-=n*s,r-=a*s,h.push(["L",e,r]),l+=n*s,p+=a*s,h.push(["Q",(d-c)*2+c,(f-u)*2+u,l,p])}return h}animate(t){let i=this.points;t||i.forEach(t=>{if(t.shapeArgs&&f(t.shapeArgs.d)&&t.shapeArgs.d.length){let i=t.shapeArgs.d,o=i[0][1],e=i[0][2];if(o&&e){let s=[];for(let t=0;t<i.length;t++){s.push([...i[t]]);for(let r=1;r<i[t].length;r++)s[t][r]=r%2?o:e}t.graphic&&(t.graphic.attr({d:s}),t.graphic.animate({d:i}))}}})}getLinkWidth(t){let i=this.options.width,o=t.options.weight||this.options.weight;if(t.options.weight=o,i&&!o)return i;let e=this.smallestWeight,s=this.greatestWeight;if(!p(o)||!e||!s)return 0;let r=this.options.minWidth,n=this.options.maxWidth;return(o-e)*(n-r)/(s-e||1)+r}autoCurve(t,i,o,e,s,r){let n={x:o-t,y:e-i},a={x:(o-t)/2+t,y:(e-i)/2+i},h={x:a.x-s,y:a.y-r},l=n.x*h.x+n.y*h.y,p=n.x*h.y-n.y*h.x,d=Math.atan2(p,l),f=180*d/Math.PI;return f<0&&(f=360+f),-(.7*Math.sin(d=f*Math.PI/180))}pointAttribs(t,i){let o=r.prototype.pointAttribs.call(this,t,i);return o.fill=u(t.options.fillColor,t.options.color,"none"===this.options.fillColor?null:this.options.fillColor,this.color),o["fill-opacity"]=u(t.options.fillOpacity,this.options.fillOpacity),o["stroke-width"]=u(t.options.lineWidth,this.options.lineWidth,1),t.options.opacity&&(o.opacity=t.options.opacity),o}translate(){this.chart.hasRendered&&(this.isDirtyData||!this.hasRendered)&&(this.processData(),this.generatePoints());let t=[],i=0,o=0;this.points.forEach(s=>{let r,n;let h=this.chart,l=h.mapView,p=s.options,d=()=>{s.series.isDirty=!0},c=t=>{let i=h.get(t);if(i instanceof e&&i.plotX&&i.plotY)return a(i,"update",d),{x:i.plotX,y:i.plotY}},m=t=>f(t)?{lon:t[0],lat:t[1]}:t;"string"==typeof p.from?r=c(p.from):"object"==typeof p.from&&l&&(r=l.lonLatToPixels(m(p.from))),"string"==typeof p.to?n=c(p.to):"object"==typeof p.to&&l&&(n=l.lonLatToPixels(m(p.to))),s.fromPos=r,s.toPos=n,r&&n&&(i+=(r.x+n.x)/2,o+=(r.y+n.y)/2),u(s.options.weight,this.options.weight)&&t.push(u(s.options.weight,this.options.weight))}),this.smallestWeight=l(t),this.greatestWeight=h(t),this.centerOfPoints={x:i/this.points.length,y:o/this.points.length},this.points.forEach(t=>{if(!this.getLinkWidth(t)){t.shapeArgs={d:[]};return}t.fromPos&&(t.plotX=t.fromPos.x,t.plotY=t.fromPos.y),t.shapeType="path",t.shapeArgs=this.getPointShapeArgs(t),t.color=u(t.options.color,t.series.color)})}getPointShapeArgs(t){let{fromPos:i,toPos:o}=t;if(!i||!o)return{};let e=this.getLinkWidth(t)/2,s=t.options,r=c(this.options.markerEnd,s.markerEnd),n=u(s.growTowards,this.options.growTowards),a=i.x||0,h=i.y||0,l=o.x||0,d=o.y||0,f=u(s.curveFactor,this.options.curveFactor),y=r&&r.enabled&&r.height||0;if(p(f)||(f=this.autoCurve(a,h,l,d,this.centerOfPoints.x,this.centerOfPoints.y)),y){y=m(y,4*e);let t=l-a,i=d-h;t*=.5,i*=.5;let o=a+t,s=h+i,r=t;t=i,i=-r;let n=o+t*f,p=s+i*f,[c,u]=g.normalize(n-l,p-d);c*=y,u*=y,l+=c,d+=u}let w=l-a,x=d-h;w*=.5,x*=.5;let P=a+w,v=h+x,M=w;w=x,x=-M;let[W,L]=g.normalize(w,x),C=1+.25*Math.sqrt(f*f);W*=e*C,L*=e*C;let b=P+w*f,E=v+x*f,[j,k]=g.normalize(b-a,E-h);M=j,j=k,k=-M,j*=e,k*=e;let[A,S]=g.normalize(b-l,E-d);M=A,A=-S,S=M,A*=e,S*=e,n&&(j/=e,k/=e,W/=4,L/=4);let F={d:[["M",a-j,h-k],["Q",b-W,E-L,l-A,d-S],["L",l+A,d+S],["Q",b+W,E+L,a+j,h+k],["Z"]]};if(r&&r.enabled&&F.d){let t=g.markerEndPath([l-A,d-S],[l+A,d+S],[o.x,o.y],r);F.d.splice(2,0,...t)}let O=t.options.from,T=t.options.to,z=O.lat,D=O.lon,H=T.lat,R=T.lon;return z&&D&&(t.options.from=`${+z}, ${+D}`),H&&R&&(t.options.to=`${+H}, ${+R}`),F}}return g.defaultOptions=c(n.defaultOptions,{animation:!0,dataLabels:{enabled:!1},fillOpacity:.5,markerEnd:{enabled:!0,height:"40%",width:"40%",markerType:"arrow"},width:1,maxWidth:25,minWidth:5,lineWidth:void 0,tooltip:{headerFormat:'<span style="font-size: 0.8em">{series.name}</span><br/>',pointFormat:"{point.options.from} → {point.options.to}: <b>{point.options.weight}</b>"}}),d(g.prototype,{pointClass:t,pointArrayMap:["from","to","weight"],drawPoints:s.prototype.drawPoints,useMapGeometry:!0}),i.registerSeriesType("flowmap",g),g}),o(i,"masters/modules/flowmap.src.js",[],function(){})});//# sourceMappingURL=flowmap.js.map