<?php
/**
 * Scale module
 * 
 * Add scale page
 * 
 * @package linea21\core\scale
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','scale'); ?></a></li>
	<li><span><?php echo formatnavTitle(_t('scale','add')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
if(isset($_POST['enregistrer'])) {
  $data_table=unserialize(urldecode($_POST['data_table']));
  $scale_object= new scale;
  $result=$scale_object->AddScale($data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

$form_denomination='';
$form_comment='';
$form_surface='';
$form_population='';
$form_cin='';
$form_root_scale=-1;
if(isset($_POST['valider'])) {
    
  $table = array();
  $table[0]=$_POST['denomination'];
  $table[1]=$_POST['surface'];
  $table[2]=$_POST['population'];
  $table[3]=$_POST['root_scale'];
  $table[4]=$_POST['com_scale'];
  $table[5]='P'; // statut
  $table['cin']=$_POST['cin'];
  $table['extradata']='';
  $scale_object= new scale;
  $integrity=$scale_object->CheckDataIntegrity($table);
  if(is_string($integrity)) $format_text='2FIELD';
  else $format_text='2HTML';
  $form_denomination=formatText($_POST['denomination'], $format_text);
  $form_surface=$_POST['surface'];
  $form_population=$_POST['population'];
  $form_cin=$_POST['cin'];
  $form_comment=formatText($_POST['com_scale'], $format_text);
  $form_root_scale=$_POST['root_scale'];
  $table=urlencode(serialize($table));
}

include_once("../lib/input_helpers.php");
// select-box des échelles
$data=$sql_object->DBSelect($req_add);
$select_root=ScaleSelectBox($data, "root_scale", $form_root_scale);
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);
?>
<h2><?php echo formatTitleh2(_t('scale','add_title')); ?></h2>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<p>
		<label for="denomination"><?php echo mb_ucfirst(_t('scale','denomination')); ?>&nbsp;:&nbsp;*</label>
		<input name="denomination" type="text" id="denomination" maxlength="200" value="<?php echo $form_denomination; ?>" class="textfield" required />
	</p>
	<p>
		<label for="root_scale"><?php echo mb_ucfirst(_t('scale','root')); ?> : </label>
		<?php echo $select_root; ?>
	</p>
	<p>
		<label for="surface"><?php echo mb_ucfirst(_t('scale','surface')); ?> (<?php echo SURFACE_UNIT; ?>) :</label>
		<input name="surface" type="text" id="surface" maxlength="8" value="<?php echo $form_surface; ?>" class="textfield" />
	</p>
	<p>
		<label for="population"><?php echo mb_ucfirst(_t('scale','population')); ?> :</label>
		<input name="population" type="text" id="population" maxlength="8" value="<?php echo $form_population; ?>" class="textfield" />
	</p>
	<p>
		<label for="cin"><?php echo mb_ucfirst(_t('scale','cin')); ?> :</label>
		<input name="cin" type="text" id="cin" maxlength="20" value="<?php echo $form_cin; ?>" class="textfield" />
	</p>
	<p>
		<label for="com_scale"><?php echo mb_ucfirst(_t('scale','comment')); ?> : </label>
		<textarea id="com_scale" name="com_scale" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_comment; ?></textarea>
		<br />
	</p>
	<div>
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button('javascript:history.go(-1);'); ?>
		<input name="valider" type="submit" 	value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{
  $display_form_comment=empty_none($form_comment);
  $display_form_surface=empty_nc($form_surface);
  $display_form_population=empty_nc($form_population);
  $display_form_cin=empty_nc($form_cin);

  $requete=SQL_getonescale($_POST['root_scale']);
  $data=$sql_object->DBSelect($requete);
  $display_root_scale=empty_none(formatText($data[0]['scale_denomination'], '2HTML'));

  ?>
<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
<dl class="summary">
	<dt><?php echo mb_ucfirst(_t('scale','denomination')); ?> :</dt>
	<dd><?php echo $form_denomination; ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','root')); ?> :</dt>
	<dd><?php echo $display_root_scale; ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','surface')); ?> (<?php echo SURFACE_UNIT; ?>) :</dt>
	<dd><?php echo fnumber_format($display_form_surface, 'auto', false); ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','population')); ?> :</dt>
	<dd><?php echo fnumber_format($display_form_population, 0, false); ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','cin')); ?> :</dt>
	<dd><?php echo $display_form_cin; ?></dd>
	<dt><?php echo mb_ucfirst(_t('scale','comment')); ?> :</dt>
	<dd><?php echo $display_form_comment; ?><br />
	</dd>
</dl>
<form id="addscale" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
<div>
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
	<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
	<?php echo cancel_button('?rub='.$rub.'&amp;todo=list'); ?>
	<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
	<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>