<?php
/**
 * System module
 * 
 * Modify settings from back-office
 * 
 * @package linea21\core\system
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once ("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once('../lib/input_helpers.php');

$hidden=false; //variable pour cacher ou non les champs de formulaire
$link_mod=$rub_link."&amp;todo=mod&amp;type=";
$updatable=true; //le formulaire est en modification ou en visualisation
$suffix='-edit';

if (isset($_REQUEST['type'])) $type=$_REQUEST['type'];

if(isset($_POST['valider'])) {
  $updatable=false;
  $suffix='-readonly';
  $hidden=true;
  $l21config->setParams($_POST);
  $data_array = urlencode(serialize($_POST));
}
if(isset($_POST['enregistrer'])) {

	// we prepare values with new inputs
  $l21config->setParams(unserialize(urldecode($_POST['data'])));

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;

  //ok on écrit les paramètres en fichiers
  if($l21config->writeReleaseParams()) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else system_error();
}

$js= "clone_validation_buttons('form#config-readonly', '#content > h2', 'after');";
footerAddInlineJS($js);

?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','system')?></a></li>
	<li><span><?php echo _t('system','mod') ?></span></li>
</ul>
</div>

<!--end barre haute -->
<div class="contentcontainer">
  <?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
  <div id="content">
    <h2><?php echo _t('system','mod'); ?></h2>
    <form id="<?php echo $type.$suffix; ?>" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
      <?php
        switch ($type)
        {
          case 'config':
            echo $l21config->getReleaseParams($updatable,$hidden);
            break;
          case 'database':
            echo $l21config->getDatabaseParams($updatable,$hidden);
            break;
          case 'theme':
            echo $l21config->getThemeParams($updatable,$hidden);
            break;
          default:
            exit('no way');
        }
      ?>
      <div>
        <input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
        <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
        <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
        <?php if(isset($data_array)) { ?>
          <input name="data" type="hidden" value="<?php echo $data_array; ?>" />
        <?php } ?>
        <?php
        if(!isset($_POST['valider']) && !isset($_POST['enregistrer'])){
          echo cancel_button('javascript:history.go(-1);');
        ?>
        <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
        <?php }
        else if(isset($_POST['valider'])){
        ?>
        <?php echo cancel_button('?rub=system&amp;todo=list'); ?>
      	<input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
      	<input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="enregistrer" />
        <?php } ?>
       </div>
    </form>
  </div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->


<?php 

$js = "
    $('input:disabled').addClass('dynamic');
    var flag = 'disabled';
    $('a.activate').click(function() {
        if(flag == 'disabled') {
            $('input.dynamic').prop('disabled', false);
            flag = 'enabled';
        } else {
            $('input.dynamic').prop('disabled', true);
            flag = 'disabled';
        }
    return false;
});";

footerAddInlineJS($js);
?>
