<?php
/**
 * User module
 * 
 * Add user page
 * 
 * @package linea21\core\user
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isSuperAdmin()) ReloadIndex('admin');
////////////

include_once("../lib/input_helpers.php");
include_once(override('../level/mysql.inc.php', THEME_ADMIN_PATH));
// Multiple select CSS/JS inclusion
addDynamicCSS('../lib/js/multipleSelect/dist/multiple-select.css');
footerAddJS('../lib/js/multipleSelect/dist/multiple-select.js');

?>

<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','user'); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('user','add')); ?></span></li>
</ul>
</div>
<!--end barre haute -->
<?php
$form_pseudo='';
$form_email='';
$form_password='';
$form_first_name='';
$form_last_name='';
$form_profile_leisures = '';
$form_profile_job = '';
$layer_rights= "style=\"display:none;\"";
$mask_type_S='';
$mask_type_P='';
$mask_type_A='';

$mask_sdi_1="checked=\"checked\"";
$mask_sdi_2='';
$mask_dashboard_1="checked=\"checked\"";
$mask_dashboard_2='';
$mask_project_1="checked=\"checked\"";
$mask_project_2='';
$mask_publication_1="checked=\"checked\"";
$mask_publication_2='';
$mask_news_1="checked=\"checked\"";
$mask_news_2='';
$mask_workshop_1="checked=\"checked\"";
$mask_workshop_2='';
$mask_notify=' checked';

$q=SQL_getWorkgroupsList(array('P', 'D', 'PA', 'AA'));
$workgroups=$sql_object->DBSelect($q);
$default_wg = array();

$form_projects = array();

$user_object= new user;

$pwdsec = [];
if (defined('PASSWD_STRENGTH')) {
    if (strpos(PASSWD_STRENGTH, 'a') !== false) array_push($pwdsec, _t('user', 'lowercase_char') );
    if (strpos(PASSWD_STRENGTH, 'A') !== false) array_push($pwdsec, _t('user', 'uppercase_char') ) . '<br>';
    if (strpos(PASSWD_STRENGTH, '0') !== false) array_push($pwdsec, _t('user', 'digit_char') ) . '<br>';
    if (strpos(PASSWD_STRENGTH, '/') !== false) array_push($pwdsec, sprintf(_t('user', 'symbol_char'), $user_object->SYMBOL_LIST) ) . '<br>';

    $security_msg = '<p class="soft-emphase"><strong>' . _t('user', 'security_policy') . '</strong>'. sprintf(_t('user', 'security_policy_msg'), join(', ', $pwdsec)) .'<p>';
}





if(isset($_POST['enregistrer'])) {
	
	/** include envoi de mail */
	include_once(override('../mail/mail_actions.php'));
	include_once(override('../mail/send.php'));
	$a = array();
	
  $data_table_user=unserialize(urldecode($_POST['data_table_user']));
  $data_table_right=unserialize(urldecode($_POST['data_table_right']));
  $data_table_workgroups=unserialize(urldecode($_POST['data_table_workgroups']));
  $data_table_projects=unserialize(urldecode($_POST['data_table_projects']));
  
  if(empty($data_table_user[5])) $data_table_user[5] = $user_object -> GetNewPassword();

  $a['login'] = $data_table_user[0];
  $a['password'] = $data_table_user[5];
  $a['action'] ='add_user';
  $a['recipient'] = $data_table_user[1];
  
  // we notify user only if asked
  if($data_table_user['notify'] === true) {
	  $emailContainer = prepare_email($a);
	  $r = send_email($emailContainer);
  }
  /** end mail */

  $result=$user_object->AddUser($data_table_user, $data_table_right, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
  if(is_numeric($result)) {
    $r = $user_object -> AddWorkshops($result, $data_table_workgroups, 'U' , $sql_object);
    $r = $user_object -> AddProjects($result, $data_table_projects, $sql_object);
    header("Location: ".safe_redirect($link_confirm));
    exit;
  }
  else  system_error();
}


if(isset($_POST['valider'])) {
    
  $table_user = array();
  $table_right = array();
  
  $table_user[0] = $_POST['pseudo'];
  $table_user[1] = $_POST['email'];
  $table_user[2] = 'N';
  $table_user[3] = $_POST['first_name'];
  $table_user[4] = $_POST['last_name'];
  $table_user[5] = $_POST['password'];
  $table_user["leisures"] = $_POST['leisures'];
  $table_user["job"] = $_POST['job'];
  
  isset($_POST['notify-user']) ? $table_user['notify'] = true : $table_user['notify'] = false;
 
  $user_object= new user;
  
  if(!empty($table_user[5])) $integrity = $user_object->checkPasswordValidity($table_user[5]);
  else $integrity = true;
  
  if($integrity ===  true ) $integrity = $user_object->CheckDataIntegrity($table_user, $sql_object);

  if($_POST['user_type']=='simple_user') {
    $table_right=$user_object->InitUserRight('SIMPLE_USER');
    $mask_type_S="checked=\"checked\"";
  }
  if($_POST['user_type']=='admin_user') {
    $table_right=$user_object->InitUserRight('ADMIN_USER');
    $mask_type_A="checked=\"checked\"";
  }
  if($_POST['user_type']=='privilege_user') {
    $table_right['sdi']=$_POST['sdi'];
    $table_right['dashboard']=$_POST['dashboard'];
    $table_right['project']=$_POST['project'];
    $table_right['workshop']=$_POST['workshop'];
    $table_right['publication']=$_POST['publication'];
    $table_right['news']=$_POST['news'];
    $table_right['yellowpages']='U';
    $table_right['level']='U';
    $table_right['scale']='U';
    $table_right['category_user']='U';
    $layer_rights= "style=\"display:block;\"";
    $mask_type_P="checked=\"checked\"";
  }

  if(isset($_POST['workgroups'])) {
    $table_workgroups=$_POST['workgroups'];
    $default_wg=$table_workgroups;
  }
  else $table_workgroups=array();
  
  if(isset($_POST['projects'])) {
      $table_projects=$_POST['projects'];
  }
  else $table_projects=array();
  if($table_right['project'] == 'U') $table_projects = array(); // to be sure no projects is associated to user with no given rights on projects

  if(is_string($integrity)) $format_text='2FIELD'; else $format_text='2HTML';
  
  $form_pseudo=$_POST['pseudo'];
  $form_email=$_POST['email'];
  $form_first_name=$_POST['first_name'];
  $form_last_name=$_POST['last_name'];
  $form_profile_leisures = formatText($_POST['leisures'], $format_text);
  $form_profile_job = formatText($_POST['job'], $format_text);
  
  if(!isset($_POST['notify-user'])) $mask_notify = '';
  
  if(isset($_POST['projects']) && $table_right['project'] != 'U') $form_projects = $_POST['projects'];
  
  $table_user=urlencode(serialize($table_user));
  $table_right=urlencode(serialize($table_right));
  $table_workgroups=urlencode(serialize($table_workgroups));
  $table_projects=urlencode(serialize($table_projects));

  if($_POST['sdi']=='O') {
      $mask_sdi_1='';
      $mask_sdi_2="checked=\"checked\"";
  }
  if($_POST['dashboard']=='O') {
    $mask_dashboard_1='';
    $mask_dashboard_2="checked=\"checked\"";
  }
  if($_POST['project']=='O') {
  	$mask_project_1='';
  	$mask_project_2="checked=\"checked\"";
  }
  if($_POST['publication']=='O') {
    $mask_publication_1='';
    $mask_publication_2="checked=\"checked\"";
  }
  if($_POST['news']=='O') {
    $mask_news_1='';
    $mask_news_2="checked=\"checked\"";
  }
  if($_POST['workshop']=='O') {
    $mask_workshop_1='';
    $mask_workshop_2="checked=\"checked\"";
  }
}

// preparation affichage detaillé
$rights_display='<div class="flex-container perms-container">';
$rights_display.='<div class="w66">';
if(defined('MOD_SDI')) {
  $rights_display.= "<div class=\"perms-item\" data-notice=\"perms-sdi\"><div class=\"rights\">⇨ "._t('menu','sdi')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"sdi_1\" class=\"radio\" name=\"sdi\" value=\"U\" ".$mask_sdi_1." required /><label for=\"sdi_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"sdi_2\" class=\"radio\" name=\"sdi\" value=\"O\" ".$mask_sdi_2." required /><label for=\"sdi_2\">". _t('user','managerrights')."</label>\n";
  $rights_display.= "</div></div>\n";
  $rights_display.= "<div class=\"perms-item\"data-notice=\"perms-dashboard\"><div class=\"rights\">⇨ "._t('menu','dashboard')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"dashboard_1\" class=\"radio\" name=\"dashboard\" value=\"U\" ".$mask_dashboard_1." required /><label for=\"dashboard_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"dashboard_2\" class=\"radio\" name=\"dashboard\" value=\"O\" ".$mask_dashboard_2." required /><label for=\"dashboard_2\">". _t('user','managerrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else {
    $rights_display.="<input type=\"hidden\" id=\"sdi\" name=\"sdi\" value=\"U\" />\n";
    $rights_display.="<input type=\"hidden\" id=\"dashboard\" name=\"dashboard\" value=\"U\" />\n";
}
if(defined('MOD_PROJECT')) {
    $rights_display.= "<div class=\"perms-item\" data-notice=\"perms-project\"><div class=\"rights\">⇨ "._t('menu','project')." : </div>\n";
	$rights_display.= "<div class=\"rightpanel\">\n";
	$rights_display.= "<input type=\"radio\" id=\"project_1\" class=\"radio\" name=\"project\" value=\"U\" ".$mask_project_1." required /><label for=\"project_1\">". _t('user','norights')."</label>\n";
	$rights_display.= "<input type=\"radio\" id=\"project_2\" class=\"radio\" name=\"project\" value=\"O\" ".$mask_project_2." required /><label for=\"project_2\">". _t('user','managerrights')."</label>\n";
	$rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"project\" name=\"project\" value=\"U\" />\n";
if(defined('MOD_PUBLICATION')) {
  $rights_display.= "<div class=\"perms-item\" data-notice=\"perms-publication\"><div class=\"rights\">⇨ "._t('menu','publication')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"publication_1\" class=\"radio\" name=\"publication\" value=\"U\" ".$mask_publication_1." required /><label for=\"publication_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"publication_2\" class=\"radio\" name=\"publication\" value=\"O\" ".$mask_publication_2." required /><label for=\"publication_2\">". _t('user','redactorrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"publication\" name=\"publication\" value=\"U\" />\n";
if(defined('MOD_NEWS')) {
  $rights_display.= "<div class=\"perms-item\" data-notice=\"perms-news\"><div class=\"rights\">⇨ "._t('menu','news')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"news_1\" class=\"radio\" name=\"news\" value=\"U\" ".$mask_news_1." required /><label for=\"news_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"news_2\" class=\"radio\" name=\"news\" value=\"O\" ".$mask_news_2." required /><label for=\"news_2\">". _t('user','redactorrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"news\" name=\"news\" value=\"U\" />\n";
if(defined('MOD_WORKSHOP')) {
  $rights_display.= "<div class=\"perms-item\" data-notice=\"perms-workgroup\"><div class=\"rights\">⇨ "._t('menu','workshop')." : </div>\n";
  $rights_display.= "<div class=\"rightpanel\">\n";
  $rights_display.= "<input type=\"radio\" id=\"workshop_1\" class=\"radio\" name=\"workshop\" value=\"U\" ".$mask_workshop_1." required /><label for=\"workshop_1\">". _t('user','norights')."</label>\n";
  $rights_display.= "<input type=\"radio\" id=\"workshop_2\" class=\"radio\" name=\"workshop\" value=\"O\" ".$mask_workshop_2." required /><label for=\"workshop_2\">". _t('user','animatorrights')."</label>\n";
  $rights_display.= "</div></div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"wokshop\" name=\"workshop\" value=\"U\" />\n";

$rights_display.='</div>';
$rights_display.='<div class="item-fluid">';
$rights_display.= "<div class=\"permission-notice\" id=\"perms-sdi\">"._t('user', 'notice-perms-sdi')."</div>\n";
$rights_display.= "<div class=\"permission-notice\" id=\"perms-dashboard\">"._t('user', 'notice-perms-dashboard')."</div>\n";
$rights_display.= "<div class=\"permission-notice\" id=\"perms-project\">"._t('user', 'notice-perms-project')."</div>\n";
$rights_display.= "<div class=\"permission-notice\" id=\"perms-publication\">"._t('user', 'notice-perms-publication')."</div>\n";
$rights_display.= "<div class=\"permission-notice\" id=\"perms-news\">"._t('user', 'notice-perms-news')."</div>\n";
$rights_display.= "<div class=\"permission-notice\" id=\"perms-workgroup\">"._t('user', 'notice-perms-workgroup')."</div>\n";
$rights_display.='</div>'; // close item-fluid
$rights_display.='</div>';


$js = "$('.perms-item').hover(
      function() {
        var notice = $( this ).attr('data-notice');
        $( '#' + notice ).fadeIn();
      }, function() {
        var notice = $( this ).attr('data-notice');
        $( '#' + notice ).hide();
      }
    );";

footerAddInlineJS($js);

if(!isset($_POST['valider'])) $mask_type_S='checked="checked"';

// select-box multiple des projets avec hiérarchie par niveau
$levels = $GLOBALS['sql_object']->DBSelect(SQL_getLevelsList());
$levels = getLevelChildren($levels, 0); // 0 is parentid
$select_projects=ProjectSelectBoxByLevels($levels, "projects", $form_projects, [], true);

?>

<?php
if(!isset($integrity) || is_string($integrity)) {
  ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php
if(isset($integrity) && is_string($integrity)) display_errors($integrity);

$js = "$('input:radio[name=user_type]').click(function() {
					var value = $(this).val();
					if(value == 'privilege_user') {
						$('div#rights').slideDown();
					} else {
						if($('div#rights').is(':visible')) $('div#rights').slideUp();
					}
				});";
footerAddInlineJS($js);

$js = "$('input[type=radio][name=sdi]').change(function() {
        if($('#sdi_2').is(':checked')) { 
            $('#dashboard_1').prop('checked', false);
            $('#dashboard_2').prop('checked', true);
            // read-only does not work on radio, we disable only unchecked value so field is always posted
            $('input[type=radio][name=dashboard]:not(:checked)').prop('disabled', true); 
        } else {
            $('input[type=radio][name=dashboard]').prop('disabled', false);
        }
    });";

footerAddInlineJS($js);

?>
<script>
$(document).ready( function() {

	  var $select = $('#projects');
	  $select.multipleSelect({
    	placeholder:'<?php echo  mb_ucfirst(_t('divers','select_choice')); ?>',
    	formatSelectAll () {
    		return '<?php echo mb_ucfirst(_t('divers','select_all')); ?>'
    	},
    	formatAllSelected () {
    		return '<?php echo mb_ucfirst(_t('divers','all_selected')); ?>'
    	},
    	formatNoMatchesFound () {
    		return '<?php echo mb_ucfirst(_t('divers','no_matches')); ?>'
    	},
    	formatCountSelected (count, total) {
    		return '<?php echo mb_ucfirst(_t('divers','n_selected')); ?>'.replace("#", count).replace("%", total);
    	},
        filter: true,
        multiple: false,
        minimumCountSelected: 2
    });
    // by default this is disabled because it is simple user
    $select.multipleSelect("disable");
    $('input:radio[name=user_type]').click(function() {
    	$select.multipleSelect("disable");
    	if($(this).val() == 'admin_user') $select.multipleSelect("enable");
    	if($(this).val() == 'privilege_user' && $("input:radio[name=project]:checked").val() == 'O') $select.multipleSelect("enable");
    	if($(this).val() == 'simple_user' || $("input:radio[name=project]:checked").val() == 'U') $select.multipleSelect("uncheckAll");
    });
    $('input:radio[name=project]').click(function() {
    	if($(this).val() == 'O') $select.multipleSelect("enable");
    	else {
        	$select.multipleSelect("disable");
        	$select.multipleSelect("uncheckAll");
    	}
    });
});
</script>
<h2><?php echo formatTitleh2(_t('user','add_title')); ?></h2>

<form id="adduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<div class="label"><?php echo ucfirst(_t('user','type')); ?>&nbsp;:&nbsp;*</div>
	<div class="rightpanel">
    	<input name="user_type" type="radio" class="radio" id="simple_user" maxlength="150" value="simple_user" <?php echo $mask_type_S; ?> />
    	<label for="simple_user"><?php echo mb_ucfirst(_t('user','type_simple')); ?></label>
    	<input name="user_type" type="radio" class="radio" id="privilege_user" maxlength="150" value="privilege_user" <?php echo $mask_type_P;  ?> />
    	<label for="privilege_user"><?php echo mb_ucfirst(_t('user','type_privilege')); ?></label>
    	<input name="user_type" type="radio" class="radio" id="admin_user" maxlength="150" value="admin_user" <?php echo $mask_type_A;  ?> />
    	<label for="admin_user"><?php echo mb_ucfirst(_t('user','type_admin')); ?></label>
	</div>

<div id="rights" <?php echo $layer_rights; ?>>

<h3 class="part"><?php echo mb_ucfirst(_t('user','set_rights')); ?></h3>
<?php echo $rights_display; ?></div>

<h3 class="part"><?php echo mb_ucfirst(_t('user','profile')); ?></h3>
<p>
	<label for="pseudo"><?php echo mb_ucfirst(_t('user','login')); ?>&nbsp;:&nbsp;*</label>
	<input name="pseudo" type="text" class="textfield" id="pseudo" maxlength="150" value="<?php echo $form_pseudo; ?>" required />
</p>
<p>
<label for="email"><?php echo mb_ucfirst(_t('user','email')); ?>&nbsp;:&nbsp;*</label>
<input name="email" type="text" class="textfield" id="email" maxlength="200" value="<?php echo $form_email; ?>" required />
</p>
<p>
	<label for="password"><?php echo mb_ucfirst(_t('user','password')); ?> : </label>
	<input name="password" type="password" class="textfield" id="password" maxlength="100" value="<?php echo $form_password; ?>" placeholder="<?php echo _t('user','password_placeholder'); ?>" />
	<?php if(isset($security_msg))echo '<div class="input-notice">'.$security_msg. '</div>'; ?>
</p>
<p>
	<label for="first_name"><?php echo mb_ucfirst(_t('user','first_name')); ?> : </label>
	<input name="first_name" type="text" class="textfield" id="first_name" maxlength="200" value="<?php echo $form_first_name; ?>" />
</p>
<p>
	<label for="last_name"><?php echo mb_ucfirst(_t('user','last_name')); ?> : </label>
	<input name="last_name" type="text" class="textfield" id="last_name" maxlength="200" value="<?php echo $form_last_name; ?>" />
</p>
<p>
<label for="leisures"><?php echo mb_ucfirst(_t('user','leisures')); ?> :</label>
<input name="leisures" type="text" class="textfield" id="leisures" maxlength="150" value="<?php echo $form_profile_leisures; ?>" />
</p>
<p>
<label for="job"><?php echo mb_ucfirst(_t('user','job')); ?> :</label>
<input name="job" type="text" class="textfield" id="job" maxlength="150" value="<?php echo $form_profile_job; ?>" />
</p>
<p class="mts">
	<label for="notify-user"><?php echo mb_ucfirst(_t('user','notify')); ?> :</label>
	<input type="checkbox" class="switch" name="notify-user" id="notify-user" value="1"<?php echo $mask_notify; ?> />
</p>
<div>
	<div class="label"><?php echo ucfirst(_t('user','workgroups')); ?> :</div>
	<div class="rightpanel"><?php echo workgroupsCheckbox($workgroups, 'workgroups[]', $default_wg); ?></div>
</div>
<div>
	<div class="label"><span class="hint--top hint--large hint--rounded" aria-label="<?php echo formatText(_t('user', 'projects-notice'), '2ATT'); ?>"><i class="fa fa-info-circle" aria-hidden="true"></i></span> <?php echo ucfirst(_t('user','projects')); ?> :</div>
	<div class="rightpanel"><?php echo $select_projects; ?></div>
</div>
<div>
	<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
	<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
</div>
<?php
if(isset($table_user) && isset($table_right) && isset($table_workgroups)) {
  echo "<input name=\"data_table_user\" type=\"hidden\" value=\"".$table_user."\" id=\"data_table_user\" />\n";
  echo "<input name=\"data_table_right\" type=\"hidden\" value=\"".$table_right."\" id=\"data_table_right\" />\n";
  echo "<input name=\"data_table_workgroups\" type=\"hidden\" value=\"".$table_workgroups."\" id=\"data_table_workgroups\" />\n";
  echo "<input name=\"data_table_projects\" type=\"hidden\" value=\"".$table_projects."\" id=\"data_table_projects\" />\n";
}
?>
<br />
<?php echo cancel_button('javascript:history.go(-1);'); ?>
<input name="valider" type="submit" value="<?php echo _t('btn','valid'); ?>" class="button" id="valider" />
</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
// Récapitulatif
} else	{

  $wg_display = '';
  if(isset($_POST['workgroups'])) {
    $q=SQL_Get_WorkshopsDenomination($_POST['workgroups']);
    $workgroups=$sql_object->DBSelect($q);
    foreach($workgroups as $wg) {
      $wg_display .= '- '.$wg['workshop_denomination'].'<br />'.PHP_EOL;
    }
  } else $wg_display .= _t('divers', 'none');


  $mask_notify=='' ? $display_notification = _t('divers', 'no') : $display_notification = _t('divers', 'yes');
  
  $reca_droits ='';
  if($_POST['user_type']=='simple_user') {
    $display_type=_t('user','type_simple');
  }
  if($_POST['user_type']=='admin_user') {
    $display_type=_t('user','type_admin');
  }
  if($_POST['user_type']=='privilege_user')  {
    $display_type=_t('user','type_privilege');

    $reca_droits.='<h3 class="part">'. _t('user','set_rights').'</h3>'.PHP_EOL;
    $reca_droits.='<dl class="summary">'.PHP_EOL;

    if(defined('MOD_SDI'))  {
      $reca_droits.="<dt> . "._t('menu','sdi')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['sdi'], 'sdi')."</dd>";
      $reca_droits.="<dt> . "._t('menu','dashboard')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['dashboard'], 'dashboard')."</dd>";
    }
    if(defined('MOD_PROJECT'))  {
    	$reca_droits.="<dt> . "._t('menu','project')."</dt>\n";
    	$reca_droits.="<dd>".GetDisplayUserRight($_POST['project'], 'project')."<br /></dd>\n";
    }
    if(defined('MOD_PUBLICATION'))  {
      $reca_droits.="<dt>  . "._t('menu','publication')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['publication'])."</dd>";
    }
    if(defined('MOD_WORKSHOP'))  {
      $reca_droits.="<dt>  . "._t('menu','workshop')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['workshop'], 'workshop')."</dd>";
    }
    if(defined('MOD_NEWS'))  {
      $reca_droits.="<dt>  . "._t('menu','news')." : </dt>";
      $reca_droits.="<dd>".GetDisplayUserRight($_POST['news'])."</dd>";
    }
    $reca_droits.='</dl>'.PHP_EOL;
    
    
  }
  
  // project user is being involved in as project manager in following projects
  if(count($form_projects) == 0) $userProjects = empty_none('');
  else {
      $userProjects = '';
      $r = $sql_object -> DBSelect(SQL_get_projects_by_ids($form_projects));

      if(is_array($r)) {
          for ($i = 0;$i < count($r);$i++) {
              $userProjects .= '<li>' .  formatText($r[$i]['project_name'])  . '</li>'.PHP_EOL;
          }
      }
      $userProjects = '<ul>'.$userProjects.'</ul>'.PHP_EOL;
  }
  

  ?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
  <h2><?php echo formatTitleh2(_t('recap','title')); ?></h2>
  <dl class="summary">
  	<dt><?php echo mb_ucfirst(_t('user','type')); ?> :</dt>
  	<dd><?php echo $display_type; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','login')); ?> :</dt>
  	<dd><?php echo $form_pseudo; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','email')); ?> :</dt>
  	<dd><?php echo $form_email; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','password')); ?> :</dt>
  	<dd>•••••••••</dd>
  	<dt><?php echo mb_ucfirst(_t('user','first_name')); ?> :</dt>
  	<dd><?php echo $form_first_name; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','last_name')); ?> :</dt>
  	<dd><?php echo $form_last_name; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','leisures')); ?> :</dt>
  	<dd><?php echo $form_profile_leisures; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','job')); ?> :</dt>
  	<dd><?php echo $form_profile_job; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','notify')); ?> :</dt>
  	<dd><?php echo $display_notification; ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','workgroups')); ?> :</dt>
  	<dd><?php echo stripslashes($wg_display); ?></dd>
  	<dt><?php echo mb_ucfirst(_t('user','projects')); ?> :</dt>
  	<dd><?php echo stripslashes($userProjects); ?></dd>
  </dl>
  <?php echo $reca_droits; ?>
  <form id="adduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
    <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="data_table_user" type="hidden" value="<?php echo $table_user; ?>" id="data_table_user" />
    <input name="data_table_right" type="hidden" value="<?php echo $table_right; ?>" id="data_table_right" />
    <input name="data_table_workgroups" type="hidden" value="<?php echo $table_workgroups; ?>" id="data_table_workgroups" />
    <input name="data_table_projects" type="hidden" value="<?php echo $table_projects; ?>" id="data_table_projects" />
    <?php echo cancel_button('?rub=user&amp;todo=list'); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="valider" />
    </div>
  </form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php } ?>