<?php
/**
 * Vote module
 *
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 *
 * @package linea21\modules\vote
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../vote/'.SQL.'.inc.php'));
include_once('../class/class.vote.php');


if(!function_exists('getNbVotes')) {
    
    function getNbVotes($a) {
        $data = $GLOBALS['sql_object']->DBSelect(SQL_getVotesNumber($a));
        return $data[0]['nb'];
    }
    
}



if(!function_exists('getAjaxVotesFunction')) {
    function getAjaxVotesFunction($data = array()) {
        $str = '<script>
                  $(function() {

                  	$(".i-like-it a").click(function() {
                        
                  		var url = $(this).attr("href");
                        var elid = $(this).attr("data-id");
                        $("a.cancel-vote").unbind( "click" );  

                        $.post( url, { module: "'.$data['module'].'", module_id: elid, call:"ajax" }, function( data ) {
                            $("#vote-msg-"+ elid).empty();
                            if(data.status == "error") {
                                $("#vote-msg-"+ elid).removeClass("info-light").addClass("error-light");
                                $("#vote-msg-"+ elid).html(data.msg).hide().fadeIn("slow");
                            }
                            // success
                            if(data.status == "success") {
                              $("#vote-msg-"+ elid).removeClass("error-light").addClass("info-light");
                              $("#cnt-votes-"+ elid).html(data.counter).hide().fadeIn("slow");
                              var extra = "'.addslashes(sprintf(_t('like', 'cancel'), 30)) .'";
                              $("#vote-msg-"+ elid).html(data.msg + extra).hide().fadeIn("slow");
                              $("#vote-msg-"+ elid + " a.cancel-vote").attr("href", "'.SITE_ROOT_URL.'vote/_vote.php?vote-id="+ data.vote_id);
                                // we bind click event   
                                $(document).on("click", "a.cancel-vote", function() {
                                    var url = $(this).attr("href");
                                     
                                    $.post( url, function( data ) {
                                        console.log(data);
                                        if(data.status == "success") {
                                            $("#vote-msg-"+ elid).removeClass("error-light").addClass("info-light");
                                            $("#vote-msg-"+ elid).html(data.msg).hide().fadeIn("slow");
                                            $("#cnt-votes-"+ elid).html(parseInt($("#cnt-votes-"+ elid).text()-1)).hide().fadeIn("slow");
                                        } else {
                                            $("#vote-msg-"+ elid).removeClass("info-light").addClass("error-light");
                                            $("#vote-msg-"+ elid).html(data.msg).hide().fadeIn("slow");
                                        }
                                    }, "json");
                                    $(document).off("click"); // important to prevent multiples click triggering !!!
                                    return false;
                                });
                            }
                            // console.log(data);
                        }, "json");

						return false;
					});
            
                  });
          </script>';
        
        return $str;
    }
}



?>