<?php
/**
 * Workshop module - Delete workgroup user page
 * 
 * Delete workgroup user page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];
if(isset($_POST['u_id']))	$u_id=$_POST['u_id'];
if(isset($_GET['u_id']))	$u_id=$_GET['u_id'];

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) && !$l21auth->isSuperAdmin())
ReloadIndex('admin');
////////////

$link_det=$rub_link."&amp;todo=det&amp;id=".$id;
$link_cancel=$rub_link."&amp;todo=det&amp;id=".$id;

if(isset($_POST['valider'])) {
  $workshop_object = new workshop;
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id;
  $result=$workshop_object->DeleteUserWorkshop($u_id, $id, $sql_object);
  if($result) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

$req_det= SQL_getoneCompleteWorkshop($id);
$result=$sql_object->DBSelect($req_det);
$req_det_u=SQL_getoneUser($u_id);
$result_user=$sql_object->DBSelect($req_det_u);

// Do record exists?
if(!isset($result[0]['workshop_denomination'])) redirect_to('@module_default');

// Do record exists?
if(!isset($result_user[0]['user_login'])) redirect_to('@module_default');

$workshop_denomination=FormatText($result[0]['workshop_denomination']);
$user_login=FormatText($result_user[0]['user_login']);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop')?></a></li>
	<li><span><?php echo _t('workshop','del_user')." : ". $user_login; ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php afflinkbar($todo,$id, $lang); ?> <?php echo "<h2>".$user_login." ("._t('workshop','name')." : ".$workshop_denomination.") </h2>"; ?>
<form id="supworkshop" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
	<div class="info">
	<i class="fa fa-trash"></i>
	<?php echo _t('workshop','del_user_warning'); ?>
	</div>
	<div>
		<input name="id" type="hidden" value="<?php echo $id; ?>" />
		<input name="u_id" type="hidden" value="<?php echo $u_id; ?>" />
		<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
		<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
		<?php echo cancel_button($link_cancel); ?>
		<input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
	</div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->