<?php
/**
 * Workshop report module
 * 
 * MySQL queries related to workshop report module
 * 
 * @package linea21\modules\workshoprep
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Workshoprep' (as Workshop Report) module is used by 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

$req_quickbox_add = "SELECT workrep_id, LEFT(workrep_title, 50) as workrep_title, workrep_date_crea, DATE_FORMAT(workrep_date_crea, '".toStringSqlDate('long')."') AS workrep_date_crea_display FROM " . T_WORK_REP . " WHERE workrep_statut  = 'P' OR workrep_statut = 'D'  ORDER BY workrep_date_crea DESC LIMIT 0 , 10;";
$req_quickbox_sup = "SELECT workrep_id,  LEFT(workrep_title, 50) as workrep_title, workrep_last_modify, DATE_FORMAT(workrep_last_modify, '".toStringSqlDate('long')."') AS workrep_last_modify_display, DATE_FORMAT(workrep_date_crea, '".toStringSqlDate()."') AS workrep_date_crea_display FROM " . T_WORK_REP . " WHERE workrep_statut = 'E' ORDER BY workrep_last_modify DESC LIMIT 0 , 10;";
$req_quickbox_mod = "SELECT workrep_id, LEFT(workrep_title, 50) as workrep_title, workrep_last_modify, DATE_FORMAT(workrep_last_modify, '".toStringSqlDate('long')."') AS workrep_last_modify_display, DATE_FORMAT(workrep_date_crea, '".toStringSqlDate()."') AS workrep_date_crea_display FROM " . T_WORK_REP . " WHERE workrep_statut  <> 'E' ORDER BY workrep_last_modify DESC LIMIT 0 , 10;";


function SQL_getoneCompleteWorkshopRep($work_id, $force_status = false) {

	if($force_status) $force_status = " AND ". sql_status_filter('workrep_statut', $force_status);
	else $force_status = "";

  $requete =	"SELECT WR.workrep_title , WR. workrep_resume, WR.workrep_comment, WR.workrep_visible, WR.workrep_statut, ".
				"W.workshop_denomination, WR.workrep_workshop_id, ".
				"DATE_FORMAT(WR.workrep_date_crea, '".toStringSqlDate()."') AS workrep_date_crea_display, ".
				"DATE_FORMAT(WR.workrep_last_modify, '".toStringSqlDate('long')."') AS workrep_last_modify_display, ".
				"DATE_FORMAT(WR.workrep_published_date, '".toStringSqlDate()."') AS workrep_published_date_display, ".
				"DATE_FORMAT(WR.workrep_published_date, '".toStringSqlDate('long')."') AS workrep_published_date_display_long ".
				"FROM " . T_WORK_REP . " AS  WR ".
				"LEFT OUTER JOIN ".T_WORK." AS W on W.workshop_id=WR.workrep_workshop_id ".
				"WHERE workrep_id='".$work_id."'". $force_status." LIMIT 1;";
  #echo $requete;
  return $requete;
}

if(!function_exists('SQL_getWorkshopParts')) {
  function SQL_getWorkshopParts($work_id) {
    $requete =	"SELECT WC.workrepcon_id, WC.workrepcon_title, WC.workrepcon_range, WC.workrepcon_date_crea FROM " . J_PARTS ." AS JW ".
				"LEFT OUTER JOIN ".T_WORK_REP_CONT." AS WC ON JW.j_parts_id=WC.workrepcon_id ".
				"WHERE  JW.j_root_id='".$work_id."' AND j_type='W' AND workrepcon_validity='Y' ORDER BY WC.workrepcon_range ASC, WC.workrepcon_date_crea ASC;";
    #echo $requete;
    return $requete;
  }
}

function SQL_getWorkshopDenomination($work_id) {
  $requete =	"SELECT workshop_denomination FROM " . T_WORK . " WHERE workshop_id='".$work_id."';";
  return $requete;
}

function SQL_getWorkshopRepTitle($workrep_id) {
  $requete =	"SELECT workrep_title FROM " . T_WORK_REP . " WHERE workrep_id='".$workrep_id."';";
  return $requete;
}


// Copie conforme de celle qui se trouve dans publication
function SQL_GetResources($ID, $type, $ressource, $sql_object)
{
  switch ($ressource) {
    case 'BIBLIO':
      $TDB_LIAISON = J_BIBLIO;
      $ACTIVE_TABLE = T_BIBLIO_RES;
      $join_active="bibliores";
      $champ2="j_biblio_id";
      break;
    case 'LINK':
      $TDB_LIAISON = J_LINK;
      $ACTIVE_TABLE = T_LINK_RES;
      $join_active="linkres";
      $champ2="j_link_id";
      break;
    case 'MULTI':
      $TDB_LIAISON = J_MULTI;
      $ACTIVE_TABLE = T_MULTI_RES;
      $join_active="multires";
      $champ2="j_multi_id";
      break;
    default:
      return false;
  }

  $requete = "SELECT * FROM " . $ACTIVE_TABLE . " LEFT OUTER JOIN ".$TDB_LIAISON." ON ".$champ2."=".$join_active."_id WHERE j_root_id='".$ID."' AND j_type='".substr($type, 0, 1)."' AND ".$join_active."_validity='Y' ORDER BY ".$join_active."_range ASC, ".$join_active."_date_crea ASC;";
  #echo $requete;
  $result = $sql_object -> DBSelect ($requete);

  return $result;
}

?>
