<?php
/**
 * Ajax sort table
 * 
 * Dynamically save new sort tables passed in parameters
 *  
 * @package linea21\core\admin
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$noplugin = true; // flag for ../config/define.php file
include_once('../config/define.php');

securityCheck();
if(isset($_REQUEST['sort-table'])) $_REQUEST['sort-table']= $_REQUEST['sort-table'];
if(isset($_REQUEST['rangeIndex'])) $_REQUEST['rangeIndex']= strip_tags($_REQUEST['rangeIndex']);

if(!isset($_REQUEST['rub'])) die();

if($_REQUEST['rub'] == 'sdi') $module = 'dashboard';
else $module = $_REQUEST['rub'];

if(isset($_REQUEST['rangeIndex'])) $rangeIndex = $_REQUEST['rangeIndex'];
else $rangeIndex = 0;

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight($module)) ReloadIndex('admin');
////////////

include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');

// we need to set module manually to order indicators project here
if($module == 'project' && isset($_REQUEST['order']) && $_REQUEST['order'] == 'indic') $module = 'indicators-project';

switch ($module) {
  case "project":
  	// used for flat list in unique html table
  	if(isset($_REQUEST['sort-table'])) {
	    $items = $_REQUEST['sort-table'];
	    include_once('../class/class.project.php');
	    $o = new project;
  	} else {
  		$items = array_intersect_key($_REQUEST, array_flip(preg_grep('/^sort-table-level-/', array_keys($_REQUEST)))); // return an array containing sort-table-level-[id]
  		$keyname =  key($items); // sort-table-level-4
  		$items = $items[$keyname]; // return formatted array
  		include_once('../class/class.project.php');
  		$o = new project;
  	}
    break;
  case "indicators-project":
      $items = $_REQUEST['sort-table'];
      $id = (int) $_REQUEST['id'];
      include_once('../class/class.project.php');
      $o = new project;
      break;
  case "dashboard":
      $data = $_REQUEST['sort-table'];
      include_once('../class/class.sdi.php');
      $o = new sdi;
      break;
  case "scale":
      $data = $_REQUEST['sort-table'];
      include_once('../class/class.scale.php');
      $o = new scale;
      break;
  case "task":
      $data = $_REQUEST['sort-table'];
      include_once('../class/class.project_task.php');
      $o = new projectTask();
      break;
  case "level":
    $data = $_REQUEST['sort-table'];
    include_once('../class/class.level.php');
    $o = new level;
    break;
  case "news":
    $items = $_REQUEST['sort-table'];
    include_once('../class/class.news.php');
    include_once('../news/mysql.inc.php');
    $o = new news;
    break;
  case "publication":
    if(isset($_REQUEST['sort-table'])) {
      $items = $_REQUEST['sort-table'];
      include_once('../class/class.publication.php');
      $o = new publication;
    }
    if(isset($_REQUEST['sort-part'])) {
      $items = $_REQUEST['sort-part'];
      $extra = 'publication';
      include_once('../class/class.contents.php');
      $o = new contents;
    }
    if(isset($_REQUEST['sort-link'])) {
      $items = $_REQUEST['sort-link'];
      $extra = 'link';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-biblio'])) {
      $items = $_REQUEST['sort-biblio'];
      $extra = 'biblio';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-multi'])) {
      $items = $_REQUEST['sort-multi'];
      $extra = 'multi';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    break;
  case "workshop":
    $items = $_REQUEST['sort-table'];
    include_once('../class/class.workshop.php');
    $o = new workshop;
    break;
  case "workshoprep":
    if(isset($_REQUEST['sort-part'])) {
      $items = $_REQUEST['sort-part'];
      $extra = 'workshop';
      include_once('../class/class.contents.php');
      $o = new contents;
    }
    if(isset($_REQUEST['sort-link'])) {
      $items = $_REQUEST['sort-link'];
      $extra = 'link';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-biblio'])) {
      $items = $_REQUEST['sort-biblio'];
      $extra = 'biblio';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    if(isset($_REQUEST['sort-multi'])) {
      $items = $_REQUEST['sort-multi'];
      $extra = 'multi';
      include_once('../class/class.resources.php');
      $o = new resources;
    }
    break;
  default:
    $class= 'error';
  $msg = 'incorrect $_REQUEST["rub"] parameter';
  break;

}



// we sort items except if $module is contained in exclusion list 
if(!in_array($module, array('level', 'scale', 'dashboard', 'task'))) $data = sortItems($module, $items);


// rangeIndex is used to handle pagination - now for 'news' module
// see https://dev.linea21.com/issues/1347
if($rangeIndex != 0) {
    foreach ($data as $k => $v) {
        $data[$k] = $v + $rangeIndex;
    }
}

if(isset($extra)) {

  $res = $o->changeRanges($data, $GLOBALS['sql_object'], $extra);
} else {
    if($module == 'indicators-project') $res = $o->changeIndicatorsRanges($id, $data, $GLOBALS['sql_object']);
    else {
        $res = $o->changeRanges($data, $GLOBALS['sql_object']);
    }
}


if($res == 1) {
  $class = "succeed";
  $msg = _t('msg', 'update_successful');
} else {
  $class = "failed";
  $msg = _t('msg', 'update_failed');
}

$a = array("class"=>$class,"msg"=>$msg);

echo json_encode($a);
?>
