<?php
/**
 * Calendar class
 * 
 * Povides methods to handle events for worgroups module
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Workgroup Calendar Management
 */

class calendar {
	/* @param
	 * */

	var $TDB_CALENDAR = T_WORK_CAL; // nom de la table.
	var $ID;
	var $TASK_DATE;
	var $TASK;
	var $TASK_DETAILS;
	var $WORKSHOP_ID;
	var $POSTED_BY;
	var $DATE_CREA;
	var $LAST_MODIFY;
	var $VALIDITY;
	protected $dispatcher = null;

	public function __construct()
	{
		$this->dispatcher = $GLOBALS['dispatcher'];
	}

	public function __call($method, $arguments)
	{
		$event = $this->dispatcher->notifyUntil(new sfEvent($this, 'calendar.extensible_function', array(
				'method'    => $method,
				'arguments' => $arguments
		)));
		if (!$event->isProcessed())
		{
			throw new Exception(sprintf('Call to undefined method %s::%s.', get_class($this), $method));
		}

		return $event->getReturnValue();
	}

	/**
	 * calendar::CheckDataIntegrity()
	 * Vérification intégrité des données
	 *
	 * @access public
	 * @param array $table contient les composants d'une tache
	 * @return boolean true
	 * si verifié, sinon string 'message d'erreur'
	 */
	function CheckDataIntegrity($table, $sql_object)
	{
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'calendar.before_datacheck', array('data' => $table)), $table);
		$table = $r->getReturnValue();

		if (strlen($table[1]) < 3) return _t('workshop','no_task');
		if (strlen($table[2]) < 3) return _t('workshop','no_task_details');

		if(is_string(checkdate_validity($table[0]))) {
			return checkdate_validity($table[0]);
		}

		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'calendar.after_datacheck', array('data' => $table)));

		return $r;
	}

	/**
	 * calendar::AddTask()
	 * Ajout d'une nouvelle tache dans le calendrier
	 *
	 * @access public
	 * @param array $table_task contient les composants d'une tache
	 * @param object $sql_object
	 * @return integer $last_id
	 */
	function AddTask($table_task, $sql_object)
	{
		global $l21auth;
		
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'calendar.before_add', array('data' => $table_task)), $table_task);
		$table_task = $r->getReturnValue();
		
		// image 64 encoded conversion if enabled before escaping content
		$table_task[2] = convertBase64Images($table_task[2], 'wg-');

		$table_task=$sql_object->DBescape($table_task);
		if ($table_task[0] != '') {
			$this->TASK_DATE = formatDate($table_task[0], true);
		}
		if ($table_task[1] != '') {
			$this->TASK = strip_input(trim($table_task[1]));
		}
		if ($table_task[2] != '') {
			$this->TASK_DETAILS = strip_input(trim($table_task[2]), true);
		}
		if (is_numeric($table_task[3])) {
			$this->WORKSHOP_ID = $table_task[3];
		}
		if (is_numeric($table_task[4])) {
			$this->POSTED_BY = $table_task[4];
		}
		if($table_task[5] == 1) {
			$this->WORKSHOP_ID = 999999999;
		}

		$this->VALIDITY = "Y";

		$q = "INSERT INTO " . $this->TDB_CALENDAR . " (workcal_task_date, workcal_task, workcal_task_details, workcal_workshop_id, workcal_posted_by, workcal_validity, workcal_date_crea) " . "VALUES('" . $this->TASK_DATE . "', '" . $this->TASK . "', '" . $this->TASK_DETAILS . "', " . $this->WORKSHOP_ID . ", '" . $this->POSTED_BY . "', '" . $this->VALIDITY . "', NOW());";

		$last_id = $sql_object->DBInsert ($q, 1);
		
		// we log add action
		if(is_numeric($last_id))	logfile(LOG_MAINFILE, array('[action] add workgroup task', 'ID='.$last_id, 'by_id='.$l21auth->GetSessionElement('id'), 'by_login='.$l21auth->GetSessionElement('login')));
		
		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'calendar.after_add', array('data' => $table_task, 'id' => $last_id)));

		return $last_id;
	}

	/**
	 * calendar::DeleteTask()
	 * suppression d'une tache
	 *
	 * @access public
	 * @param int $id identifiant de la tache
	 * @param object $sql_object
	 * @return bool $result
	 */
	function DeleteTask($ID, $sql_object)
	{
		global $l21auth;
		
		// Notify the beginning of the current method
		$this->dispatcher->notify(new sfEvent($this, 'calendar.delete', array('id' => $ID)));

		if (is_numeric($ID)) {
			$this->ID = $ID;
		} else return false;
		$q = "UPDATE " . $this->TDB_CALENDAR . " SET workcal_validity='N' WHERE workcal_id=" . $this->ID . ";";
		$result = $sql_object->DBQuery ($q);
		
		// we log delete action
		if($result)	logfile(LOG_MAINFILE, array('[action] delete workgroup task', 'ID='.$ID, 'by_id='.$l21auth->GetSessionElement('id'), 'by_login='.$l21auth->GetSessionElement('login')));
		 
		return $result;
	}

	/**
	 * calendar::ModifyTask()
	 * modification d'une tache
	 *
	 * @access public
	 * @param int $ID identifiant de la tache
	 * @param object $sql_object
	 * @param array $table_task contient les composants d'une tache
	 * @return bool $result
	 */
	function ModifyTask($ID, $table_task, $sql_object)
	{
		// Filter data event + return value
		$r = $this->dispatcher->filter(new sfEvent($this, 'calendar.before_modify', array('data' => $table_task, 'id' => $ID)), $table_task);
		$table_task = $r->getReturnValue();

		$table_task=$sql_object->DBescape($table_task);
		if ($table_task[0] != '') {
			$this->TASK_DATE = formatDate($table_task[0], true);
		}
		if ($table_task[1] != '') {
			$this->TASK = strip_input(trim($table_task[1]));
		}
		if ($table_task[2] != '') {
			$this->TASK_DETAILS = strip_input(trim($table_task[2]), true);
		}

		$q = "UPDATE  " . $this->TDB_CALENDAR . " SET workcal_task_date='" . $this->TASK_DATE . "', workcal_task='" . $this->TASK . "' , workcal_task_details='" . $this->TASK_DETAILS . "', workcal_last_modify=NOW() WHERE workcal_id=" . $ID . ";";
		$result = $sql_object->DBQuery($q);

		// Notify the end of the current method
		$this->dispatcher->notify(new sfEvent($this, 'calendar.after_modify', array('data' => $table_task, 'id' => $this->ID)));

		return $result;
	}
}

?>