<?php
/**
 * Handle content for publication and workgroup report modules
 * 
 * Delete a specific content in back-office
 * 
 * @package linea21\modules\content
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

$complete_type=strtoupper($mod_inc);

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

if(isset($_POST['valider'])) {
  $contents_object = new contents;
  $result=$contents_object->DeleteContents($id, $complete_type,$sql_object);

  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&type=".$type."&id=".$parent;
  if($result) {
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}

if($type=='P') {
  $requete= SQL_getPublicationTitle($parent);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['publi_title'])) redirect_to('publication');
  
  $current_title=FormatText($result[0]['publi_title']);
  $current_owner=$result[0]['publi_posted_by'];

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('publication')) ReloadIndex('admin');
  if ($l21auth->GetSessionElement('id')!=$current_owner && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
  ///////////

  $requete= SQL_getOnePublicationParts($id);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['publicon_title'])) redirect_to('publication');
  
  $current_part=FormatText($result[0]['publicon_title'], '2HTML');
}
if($type=='W') {
  $requete= SQL_getWorkshopRepTitleAndGroup($parent);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['workrep_title'])) redirect_to('workshop');
  
  $current_title=FormatText($result[0]['workrep_title']).' ('.FormatText($result[0]['workshop_denomination']).')';
  $current_workshop_id=$result[0]['workrep_workshop_id'];

  //////////// Check Droits utilisateur ////////////
  if (!$l21auth->hasRight('workshop')) ReloadIndex('admin');
  if (!$l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $current_workshop_id) && !$l21auth->isSuperAdmin()) ReloadIndex('admin');
  ///////////

  $requete= SQL_getOneWorkshopParts($id);
  $result=$sql_object->DBSelect($requete);
  
  // Do record exists?
  if(!isset($result[0]['workrepcon_title'])) redirect_to('workshop');
  
  $current_part=FormatText($result[0]['workrepcon_title'], '2HTML');
}
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu',$mod_inc); ?></a></li>
	<li><span><?php echo formatNavTitle(_t('contents',$mod_inc.'_type')." : ". $current_title); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content">
<?php echo "<h2>". formatTitleh2($current_title)."</h2>"; ?>
<form id="supcontents" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">
  <p class="info">
  <i class="fa fa-trash"></i> <?php echo _t('contents','supp_info')."'".$current_part."'\n"; ?>
  </p>
  <p>
    <?php echo _t('divers','sup_confirm'); ?>
  </p>
  <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
    <input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
    <?php echo cancel_button($cancel_link); ?>
    <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->