<?php
/**
 * Dashboard module
 * 
 * Add indicator's value page
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

if(!isset($_GET['id']) && !isset($_POST['id'])) {
	$id=1;
} else {
	if(isset($_POST['id']))	$id=$_POST['id'];
	if(isset($_GET['id']))	$id=$_GET['id'];
}
if(!isset($_GET['scale_id']) && !isset($_POST['scale_id'])) {
	$scale_id=1;
} else {
	if(isset($_POST['scale_id']))	$scale_id=$_POST['scale_id'];
	if(isset($_GET['scale_id']))	$scale_id=$_GET['scale_id'];
}

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('dashboard') && !$l21auth->hasRight('indicator', $id)) ReloadIndex('admin');
////////////

include_once("../lib/input_helpers.php");
include_once("../dashboard/common.php");


$link_mod_sdi="index.php?&amp;rub=sdi&amp;todo=det&amp;id=";
$link_cancel=$rub_link."&amp;todo=det&amp;id=".$id."&amp;scale_id=".$scale_id;

if (isset($_POST['enregistrer'])) {
  $data_table = unserialize(urldecode($_POST['data_table']));
  $data_table['user_id'] = $l21auth->GetSessionElement('id');
  
  $sdi_object= new sdi;
  $result=$sdi_object->AddValue($data_table, $sql_object);
  $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id."&scale_id=".$scale_id;
  if(is_numeric($result)) {
      // we init flash message if needed
      if($data_table['project_referer'] != -1) {
          $msg = '<p class="txtcenter ptm filter clear"><a href="index.php?rub=project&amp;todo=det&amp;id='.$data_table['project_referer'].'" style="float:none"><i class="fa fa-level-up" aria-hidden="true"></i> <i class="fa fa-briefcase fa-fw" aria-hidden="true"></i> '._t('dashboard', 'go_back_to_project').'</a></p>';
          set_flash_msg($msg, 'added_value_from_project');
      }
      
      header("Location: ".safe_redirect($link_confirm));
      exit;
  }
  else  system_error();
}
$form_value ="";
$form_sdi_id ="";
$form_scale_id = $scale_id;
if(U_L == 'fr') $form_date = date("d-m-Y");
else $form_date = date("Y-m-d");
$form_threshold ="";
$mask_nodata = '';
$form_statut = "";
$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';
$form_comment = "";
$form_analysis = "";
$mask_statutc_public="checked=\"checked\"";
$mask_statutc_private='';

$resultscale = $sql_object -> DBSelect($req_list_scale);
$listing=ScaleSelectBox($resultscale, "scale" ,$form_scale_id) ;

// we handle project referer to display link to source project if needed
if(isset($_GET['project-referer']) && is_numeric($_GET['project-referer'])) $project_referer = $_GET['project-referer'];
else $project_referer = -1;

$sdi_object= new sdi;
$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);
$indicator_name =  formatText($result_sdii[0]['sdii_name'], '2HTML');
$indicator_instructions =  formatText($result_sdii[0]['sdii_input_instructions'], '2HTML');
$indicator_multiple_type =  formatText($result_sdii[0]['sdii_multiple_type'], '2HTML');
$indicator_type = $result_sdii[0]['sdii_value_type'];

$req_sdiav=SQL_getAllValue("SCA", $scale_id, $id);
$result_value = $sql_object -> DBSelect($req_sdiav);

$navtitle=_t('dashboard','add')." : ". $indicator_name;

if($result_sdii[0]['sdii_nature'] == 'boolean' || $result_sdii[0]['sdii_nature'] == 'qualitative') {
	$a = getBooleanValues($result_sdii[0]);
	
	if($a) {
		$index = array();
		foreach ($a as $key => $value) {
			array_push($index, $key);
		}

		$maskminvalue = $a[min($index)];
		$maskmaxvalue = $a[max($index)];
		if(isset($result_sdii[0]['sdii_threshold_value'])) $maskthreshold = $a[$result_sdii[0]['sdii_threshold_value']];
		
	}
}

// setting $form_threshold value
// By default initial value
$default_threshold = $result_sdii[0]['sdii_threshold_value'];
// if set, we get the latest for the given scale
$r = $sql_object -> DBSelect(SQL_getlastInsertByPublicationDate($id, $scale_id));


// Multiple entries for 'unique' value indicator only

if ($result_sdii[0]['sdii_value_type'] == 'unique') {

$modal  = '<div id="multiple-entry-container">'. PHP_EOL;
$modal .= '<div class="selected-scale-cont txtright">'.mb_ucfirst(_t('dashboard','scale')). ' : <span id="selected-scale">x</span></div>'. PHP_EOL;
$modal  .= '<form id="add-values" action="'. $_SERVER['SCRIPT_NAME'] . '"	method="post" class="secondary-form">'.  PHP_EOL;
$modal  .= '<table>'. PHP_EOL;
$modal  .= '<thead><tr>'. PHP_EOL;
$modal  .= '<td class="t-id">&nbsp;</td>'. PHP_EOL;
$modal  .= '<td class="t-value">'. mb_ucfirst(_t('dashboard','value')) .' *</td>'. PHP_EOL;
$modal  .= '<td class="t-nodata">'. mb_ucfirst(_t('dashboard','no_data')) .'</td>'. PHP_EOL;
$modal  .= '<td class="t-threshold">'.mb_ucfirst(_t('dashboard','threshold_value')).'</td>'. PHP_EOL;
$modal  .= '<td class="t-date">'.mb_ucfirst(_t('dashboard','date')).' *</td>'. PHP_EOL;
$modal  .= '<td class="t-comment">'.mb_ucfirst(_t('dashboard','comment')).'</td>'. PHP_EOL;
$modal  .= '</tr></thead>'. PHP_EOL;

$modal  .= '<tbody class="multiple-values">'. PHP_EOL;

for($i=0; $i < 10; $i++) {
    $modal  .= '<tr>'. PHP_EOL;
    $modal  .= '<td class="t-id">'.($i+1).'</td>'. PHP_EOL;
    $modal  .= '<td class="t-value"><input id="value-'.$i.'" name="value-'.$i.'" class="w90" value="" type="text" /></td>'. PHP_EOL;
    $modal  .= '<td class="t-nodata"><input class="switch" name="nodata-'.$i.'" type="checkbox" id="nodata-'.$i.'" value="1" /></td>';
    $modal  .= '<td class="t-threshold"><input id="threshold-'.$i.'" name="threshold-'.$i.'" class="w90" value="'.$form_threshold.'" type="text" /></td>'. PHP_EOL;
    $modal  .= '<td class="t-date"><input id="date-'.$i.'" name="date-'.$i.'" class="date-pick w90" value="" type="text" maxlength="10" /></td>'. PHP_EOL;
    $modal  .= '<td class="t-comment"><input id="comment-'.$i.'" name="comment-'.$i.'" class="w90" value="" type="text" maxlength="1000" /></td>'. PHP_EOL;
    $modal  .= '</tr>'. PHP_EOL;
}
$modal .= '</tbody>'. PHP_EOL;
$modal .= '</table>'. PHP_EOL;
$modal .= '<div class="txtright">'. PHP_EOL;
$modal .= '<input name="id" type="hidden" value="'.$id.'" id="m-id" />'. PHP_EOL;
$modal .= '<input name="project_referer" type="hidden" value="'.$project_referer.'" id="m-project_referer" />'. PHP_EOL;
$modal .= '<input name="scale_id" type="hidden" value="'.$scale_id.'" id="m-scale_id" />'. PHP_EOL;
$modal .= '<input name="rub" type="hidden" value="'. $rub.'" />'. PHP_EOL;
$modal .= '<input name="todo" type="hidden" value="'.$todo.'" />'. PHP_EOL;
$modal .= '<input name="validerMultiple" type="hidden" value="1" class="button" id="validerMultiple" />'. PHP_EOL;
$modal .= '<a href="#" id="verify" class="button">'. mb_ucfirst(_t('dashboard','check_and_submit')) .'</a>'. PHP_EOL;
$modal .= '</div>'. PHP_EOL;
$modal .= '</form>'. PHP_EOL;
$modal .= '</div>'. PHP_EOL;
?>
<script>
    $( document ).ready(function() {

        // multiple entry
        $("td.t-nodata input.switch").change(function () {
            // console.log($(this));
            var target = $(this).prop('id').replace('nodata', 'value');
            if($(this).is(":checked")) {
                $('#'+ target).css("opacity", 0.5);
                $('#'+ target).val('').prop('readonly', true);
            } else {
                $('#'+ target).css("opacity", 1);
                $('#'+ target).prop('readonly', false);
            }
        });

        $( "#nodata" ).trigger( "change" ); // we trigger it when loading page

        var cboxOptions = { inline:true, innerWidth: "80%", innerHeight: "90%", maxWidth: "80%", maxHeight: "90%" }
        $("#multiple-entry").colorbox(cboxOptions);
        $(window).resize(function(){ $.colorbox.resize({ width: window.innerWidth > parseInt(cboxOptions.maxWidth) ? cboxOptions.maxWidth : cboxOptions.width, height: window.innerHeight > parseInt(cboxOptions.maxHeight) ? cboxOptions.maxHeight : cboxOptions.height }); });
        $("#multiple-entry-container").wrap('<div style="display:none"></div>');

        $("#verify").click(function () {
            let flag = 1;

            $("tbody.multiple-values tr").each(function (index) {

                if( $(this).find("td.t-nodata input").is(":checked")) var nodata = 1;
                else var nodata = 0;
                let value = $(this).find("td.t-value input").val().trim();
                let threshold = $(this).find("td.t-threshold input").val().trim();
                let date = $(this).find("td.t-date input").val().trim();
                let comment = $(this).find("td.t-comment input").val().trim();

                let concatTest = value + threshold + date + comment;
                // no information on full line, we do not consider it
                if(concatTest !== "") {
                    // we test the validity of 'value' field
                    if(nodata == 0 && (value.length == 0 || !isNumeric(value.replace(",", ".")))) {
                        flag = 0;
                        $(this).find("td.t-value input").addClass("f-error");
                    } else {
                        $(this).find("td.t-value input").removeClass("f-error");
                    }
                    if(threshold !== "" && !isNumeric(threshold.replace(",", "."))) {
                        flag = 0;
                        $(this).find("td.t-threshold input").addClass("f-error");
                    } else {
                        $(this).find("td.t-threshold input").removeClass("f-error");
                    }
                    // we format date field to '2024-02-27'
                    if(lang == "fr")  {
                        datetmp = date.split("-");
                        date = datetmp[2] + "-" + datetmp[1] + "-" + datetmp[0];
                    }
                    // we test the validity of 'date' field by creating a date object
                    // https://bobbyhadz.com/blog/javascript-check-if-date-is-valid
                    if(date.length == 0 || !dateIsValid(new Date(date))) {
                        flag = 0;
                        $(this).find("td.t-date input").addClass("f-error");
                    } else {
                        $(this).find("td.t-date input").removeClass("f-error");
                    }
                } // closing each instruction
                // console.log(concatTest);
                // console.log(" Final flag : " + flag);
            });
            if(flag == 0) {
                alertify.error("<?php echo mb_ucfirst(_t('dashboard','errors_found')); ?>");
            }
            if(flag == 1) {
                alertify.success("<?php echo mb_ucfirst(_t('dashboard','check_passed')); ?>");
                setTimeout(function() {
                    $('#add-values').trigger('submit');
                },2500);
            }

            return false;
        });
        // we do change dynamically fields values on scale for multiple entries
        $('#scale').on('change', function() {
            $("input#m-scale_id").val(this.value); // we update hidden input field ID
            $("#selected-scale").text($("#scale :selected").text()); // we update text information
        });

        $( "#scale" ).trigger( "change" ); // we trigger it when loading page

    });
</script>

<?php } // closing  'unique' test indicator ?>
<?php
// we do add latest threshold if set
$form_threshold = ''; // by default $form_threshold is empty string
if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
    $form_threshold = fnumber_format($r[0]['sdiv_threshold'], 'auto', false);
} else {
    // $form_threshold = fnumber_format($default_threshold, 'auto', false);
    // if no values, we put default threshold if not empty
    if(!isset($r[0]['sdiv_value']) && $default_threshold != '') $form_threshold = fnumber_format($default_threshold, 'auto', false);
	if($result_sdii[0]['sdii_nature'] != 'quantitative' && $default_threshold == '') $form_threshold = -1;
}

// we init the value form with one row
// only for multivalues
if($result_sdii[0]['sdii_value_type'] == 'multiple') {
    
    // By default, we create an empty array with on entry value / label
    $form_values = array(array('value' => '', 'label'=> ''));
    
    // get content with the following pattern
    // For example {val 1;val 2}
    $pattern = '/{(.*?)}/';
    
    // we check if values are pre-defined in comment field to fill-up form. If $r = 0 no pattern is found, if $r == 1 is found !
    $pr =preg_match($pattern, $result_sdii[0]['sdii_comment'], $matches);
    
    // Step 1, we check if we have pre-defined value 
    if($pr == 1) {
        $str = rtrim($matches[1], ";"); // we delete last ; if needed
        $a = explode(";", $str); // we explode array on ';', we then create the array with given labels
        $form_values = []; // we reset values in array and populate it again
        foreach($a as $el)
        {
            array_push($form_values, array('value' => '', 'label' => formatText($el, '2HTML')));
        }
    }
    
	// Step 2, we get the latest values to pre-fill the form
	if(!empty($r[0]['sdiv_multivalue'])) {
		$form_values = unserialize($r[0]['sdiv_multivalue']);
		
		foreach($form_values as $key => &$value)
		{
			// we init the latest values
			$value['value'] = '';
		}
	}
}

if (isset($_POST['validerMultiple'])) {

    $a = [];
    for($i=0; $i < 10; $i++) {
        $nodata = isset($_POST["nodata-{$i}"]) ? 1 :  0;

        // we prepare entries only if a value is set or if nodata is explicit
        if((!empty($_POST["value-{$i}"]) && !empty($_POST["date-{$i}"])) || ($nodata == 1 && !empty($_POST["date-{$i}"])) ) {
            $entry = [];
            $entry[0] = sys_number_format($_POST["value-{$i}"]); // current value
            $entry[1] = $_POST["id"]; // current indicator  ID
            $entry[2] = $_POST["threshold-{$i}"]; // current threshold
            $entry[3] = $_POST["scale_id"];// current scale ID
            $entry[4] = $_POST["date-{$i}"];
            $entry[5] = 'P'; // current status
            $entry[6] = $_POST["comment-{$i}"]; // current status
            $entry[7] = 'Y'; // current comment status
            $entry['analysis'] = ''; // current analysis
            $entry['user_id'] = $l21auth->GetSessionElement('id');
            $entry['nodata'] = $nodata;
            $entry['indicator_type'] = $indicator_type;// indicator's type
            array_push($a, $entry);
        }
    }

    $r = $sdi_object->AddMultipleValues($a, $sql_object);

    $link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&id=".$id."&scale_id=".$scale_id;
    if(is_numeric($r)) {
        // we init flash message if needed
        if ($_POST['project_referer'] != -1) {
            $msg = '<p class="txtcenter ptm filter clear"><a href="index.php?rub=project&amp;todo=det&amp;id=' . $data_table['project_referer'] . '" style="float:none"><i class="fa fa-level-up" aria-hidden="true"></i> <i class="fa fa-briefcase fa-fw" aria-hidden="true"></i> ' . _t('dashboard', 'go_back_to_project') . '</a></p>';
            set_flash_msg($msg, 'added_value_from_project');
        }

        header("Location: " . safe_redirect($link_confirm));
        exit;
    }
}

if (isset($_POST['valider'])) {

	// we populate the form and the array
	if($result_sdii[0]['sdii_value_type'] == 'unique') {
	    
	    $table = array();
		$form_value = $_POST['value'];
		$table[0] = sys_number_format($_POST['value']);

		// if indicator has several values
	} else {

		$a = array();
		$form_values = array();
		
		$i = 0;
		foreach($_POST['values']  as &$value) {
			$form_values[$i]['value'] = $value;
			$i++;
		}
		$i = 0;
		foreach($_POST['labels']  as &$label) {
			$form_values[$i]['label'] = $label;
			$i++;
		}

		$table[0] = $form_values;
	}

  $table[1] = $_POST['id'];
  // for boolean / qualitative values
  if($_POST['threshold'] == -1) $table[2] = '';
  else $table[2] = $_POST['threshold'];  
  $table[3] = $_POST['scale'];
  $table[4] = $_POST['date'];
  $table[5] = $_POST['statut'];
  $table[6] = $_POST['comment'];
  $table['analysis'] = $_POST['analysis'];
  $table[7] = $_POST['statutc'];
  $table['indicator_type'] = $indicator_type;

    if(isset($_POST['nodata'])) {
        $mask_nodata = 'checked="checked"';
        $table['nodata'] = 1;
    } else {
        $mask_nodata = '';
        $table['nodata'] = 0;
    }
  
  $table['project_referer'] = $_POST['project_referer'];

  $sdi_object = new sdi;
  $integrity = $sdi_object -> CheckDataIntegrity_value($table, $sql_object);

  $form_sdi_id =$_POST['id'];
  $form_threshold = $_POST['threshold'];
  $form_scale_id =$_POST['scale'];
  $form_date =$_POST['date'];
  $form_statut = $_POST['statut'];
  $form_comment = $_POST['comment'];
  $form_analysis = $_POST['analysis'];
  $form_statutc = $_POST['statutc'];
  if($form_statut=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
  if($form_statut=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
  if($form_statutc=='Y') $mask_statutc_public="checked=\"checked\""; else $mask_statutc_public='';
  if($form_statutc=='N') $mask_statutc_private="checked=\"checked\""; else $mask_statutc_private='';
  $table = urlencode(serialize($table));
}

	// foundation Datepicker include
	addDynamicCSS('../lib/js/foundation-datepicker/stylesheets/foundation-datepicker.css');
	footerAddJS('../lib/js/foundation-datepicker/js/foundation-datepicker.js');
?>
<div id="chemin">
  <ul>
  	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
  	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>"	class="chemin_rub"><?php echo _t('menu','dashboard');?></a></li>
  	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
  </ul>
</div>
<!--end barre haute -->

<script>
	$(function()
	{
        // normal mode
        $("#nodata").change(function () {

            if($(this).is(":checked")) {
                $("p.i-value").css("opacity", 0.5);
                $("div#indicator-values").css("opacity", 0.5);
                $("#value[type=text]").val('').prop('readonly', true);
                $("#indicator-values input").prop('readonly', true);
                // $("#indicator-values input[name^='values']").val(''); // ou supprimer à l'enregistrement seulement
            } else {
                $("p.i-value").css("opacity", 1);
                $("div#indicator-values").css("opacity", 1);
                $("#value").prop('readonly', false);
                $("#indicator-values input").prop('readonly', false);
            }
        });

		var rowNum = <?php echo isset($form_values) ? (count($form_values) - 1) : 0; ?>;
		$('#addValueButton').click(function(e) {
			e.preventDefault();
			rowNum++;
			var row = '<p id="rowNum'+rowNum+'">' +
								'<label for="indic_label_'+rowNum+'" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_label')) ?> : <\/label> <input type="text" name="labels[]" maxlength="255" id="indic_label_'+rowNum+'" value="" class="tinytextfield" required \/> ' +
								'<label for="indic_value_'+rowNum+'" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_value')) ?> : <\/label> <input type="text" name="values[]" maxlength="255" id="indic_value_'+rowNum+'" value="" class="tinytextfield" required \/> ' +
								'<a class="rmValue" href="#" title="<?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?>"><i class="fa fa-minus-circle" aria-hidden="true"><\/i><span><?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?><\/span><\/a><\/p>';

			$('#indicator-values').append(row);

			// for dynamic fields
			$('a.rmValue').click(function(e) {
				e.preventDefault();
				$(this).parent().remove();
			});

		});

		// for initial fields
		$('a.rmValue').click(function(e) {
			e.preventDefault();
			$(this).parent().remove();
		});

		/** datePicker integration
		---------------------------------------------------*/
		$('.date-pick').fdatepicker({ 
			language: '<?php echo U_L; ?>',
			format: '<?php echo DATE_FORMAT; ?>'
		});

		var thresholds = <?php echo json_encode($sdi_object->getScalesThresholds($id, $default_threshold, $sql_object)); ?>;

		// update threshold value when changing scale
		$('#scale').change(function() {
			  var key = $("#scale").val();
			  $("#threshold").val(thresholds[key]);
			});

    });
</script>

<?php
if (!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content" class="action-<?php echo $todo; ?>">
<?php
if (isset($integrity) && is_string($integrity)) display_errors($integrity);

if ($l21auth->hasRight('sdi')) {?>
<div class="mod_link">
    <a href="<?php echo $link_mod_sdi.$id ;?>"><?php echo mb_ucfirst(_t('dashboard','det_sdi'));?></a>
</div>
<?php } ?>
<?php
if($result_sdii[0]['sdii_value_type'] == 'unique' && $result_sdii[0]['sdii_nature'] == 'quantitative') {
        echo '<div class="txtright filter"><a href="#multiple-entry-container" id="multiple-entry" class="cboxElement">'. mb_ucfirst(_t('dashboard','multiple_entry')).'</a></div>';
        echo $modal;
}
?>
<br class="brendstep" />

<h2><?php echo mb_ucfirst(_t('dashboard','add_title1')); ?></h2>
<div id="dashboard-subtitle" class="subtitle"><i class="fa fa-bar-chart" aria-hidden="true"></i><?php echo $indicator_name; ?></div>

<?php if(!empty($indicator_instructions)) echo '<div class="indic-input-instruction">' . $indicator_instructions . '</div>'; ?>
<form id="addvalue" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>"	method="post">

<?php if($result_sdii[0]['sdii_value_type'] == 'unique') { ?>
<?php 
if(is_array($result_value) && !is_null($result_value[0]['sdiv_value'])) $placeholder = sprintf(_t('dashboard', 'previous_value'), fnumber_format($result_value[0]['sdiv_value'], 'auto', false)); else $placeholder = '';
?>
<p class="i-value">
	<label for="value"><?php echo mb_ucfirst(_t('dashboard','value')) ?> (<?php echo $result_sdii[0]['sdii_unit']; ?>): *</label>
	<?php if($result_sdii[0]['sdii_nature'] == 'quantitative') { ?>
	<input name="value" type="text" id="value" maxlength="255" value="<?php echo $form_value; ?>" class="textfield" placeholder="<?php echo $placeholder; ?>" required />
	<?php } else {
		echo selectBox(getBooleanValues($result_sdii[0]), 'value', $form_value, '');
	}
	if(isset($bool_msg)) echo '<span class="soft-emphase input-notice">'.$bool_msg.'</span>';
	?>
</p>
<?php } else { ?>
<div id="indicator-values" class="radioinline">

	<?php
	$cnt = 0;
	foreach($form_values as $val) {
	?>
		<p>
		<label for="indic_label_<?php echo $cnt; ?>" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_label')) ?> : </label>
		<input name="labels[]" type="text" id="indic_label_<?php echo $cnt; ?>" maxlength="255" value="<?php echo formatText($val['label'], 'HTML'); ?>" class="tinytextfield" required />
		<label for="indic_value_<?php echo $cnt; ?>" class="autowidth"><?php echo mb_ucfirst(_t('dashboard','multivalue_value')) ?> : </label>
		<input name="values[]" type="text" id="indic_value_<?php echo $cnt; ?>" maxlength="255" value="<?php echo $val['value']; ?>" class="tinytextfield" required />
		<?php if($cnt == 0) { ?>
			<a href="#" id="addValueButton" title="<?php echo mb_ucfirst(_t('dashboard','add')); ?>"><i class="fa fa-plus-circle" aria-hidden="true"></i><span><?php echo mb_ucfirst(_t('dashboard','add')); ?></span></a>
		<?php } else { ?>
			<a class="rmValue" href="#" title="<?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?>"><i class="fa fa-minus-circle" aria-hidden="true"></i><span><?php echo addslashes(mb_ucfirst(_t('dashboard','sup'))); ?></span></a>
		<?php } ?>
		<?php $cnt++; ?>
		</p>
		<?php } ?>

</div>
<hr />
<?php } ?>
<p class="i-nodata">
    <label for="nodata"><?php echo mb_ucfirst(_t('dashboard','no_data')); ?> :</label>
    <input class="switch" name="nodata" type="checkbox" id="nodata" value="1" <?php echo $mask_nodata; ?> />
</p>
<p class="i-scale">
	<label for="scale"><?php echo mb_ucfirst(_t('dashboard','scale')) ?>&nbsp;:&nbsp;*</label>
	<?php echo $listing; ?>
</p>
<p class="i-threshold">
	<label for="threshold"><?php echo mb_ucfirst(_t('sdi','threshold_value')) ?> :</label>
	<?php if($result_sdii[0]['sdii_nature'] == 'quantitative') { ?>
	<input name="threshold" type="text" id="threshold" maxlength="100" value="<?php echo $form_threshold; ?>" class="textfield" />
	<?php } else {
		echo selectBox(array(-1 => empty_none('')) + getBooleanValues($result_sdii[0]), 'threshold', $form_threshold, -1);
	}
	?>
</p>
<div class="i-status">
    <div class="label"><?php echo mb_ucfirst(_t('divers','statut')); ?> : </div>
    <div class="rightpanel">
        <input name="statut" type="radio" class="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> />
        <label for="statut_P"><?php echo mb_ucfirst(_t('statut','public')); ?></label>
        <input name="statut" type="radio" class="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> />
        <label for="statut_D"><?php echo mb_ucfirst(_t('statut','draft')); ?></label>
    </div>
</div>
<p class="i-date">
	<label for="date"><?php echo mb_ucfirst(_t('dashboard','date')); ?>&nbsp;:&nbsp;*</label>
	<input name="date" type="text" maxlength="10" id="date"	class="date-pick shorttextfield" value="<?php echo $form_date; ?>" required />
</p>
<p class="i-analysis">
     <label for="analysis"><span class="hint--top hint--large hint--rounded" aria-label="<?php echo mb_ucfirst(_t('dashboard','last_analysis_notice')); ?>"><i class="fa fa-info-circle" aria-hidden="true"></i></span> <?php echo mb_ucfirst(_t('dashboard','last_analysis')) ?> : </label>
     <textarea id="analysis" name="analysis" <?php echo AREA_SETTINGS; ?>	class="largetextfield"><?php echo $form_analysis; ?></textarea>
</p>
<p class="i-comment">
	<label for="comment"><?php echo mb_ucfirst(_t('dashboard','comment')) ?> : </label>
	<textarea id="comment" name="comment" <?php echo AREA_SETTINGS; ?>	class="largetextfield"><?php echo $form_comment; ?></textarea>
</p>
<div class="i-comment-status">
    <div class="label"><?php echo mb_ucfirst(_t('dashboard','comment_status')); ?> : </div>
    <div class="rightpanel">
        <input name="statutc" type="radio" class="radio" id="statutc_P" value="Y" <?php echo $mask_statutc_public; ?> required />
        <label for="statutc_P"><?php echo mb_ucfirst(_t('dashboard','public')); ?></label>
        <input name="statutc" type="radio" class="radio" id="statutc_D" value="N" <?php echo $mask_statutc_private; ?> />
        <label for="statutc_D"><?php echo mb_ucfirst(_t('dashboard','private')); ?></label>
    </div>
</div>

<div class="i-units">
    <div class="toggle_title">
        <a href="#" id="affeval"><?php echo _t('sdi','info_mesure');?></a>
    </div>
    <div id="evaluation" style="display: none;" class="mtm"><br class="brendstep" />
    <table>
        <thead>
            <tr>
            <?php
            echo "<td>".mb_ucfirst(_t('sdi','unit'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','min_value'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','max_value'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('sdi','initial_threshold_value'))."</td>\n";
            ?>
            </tr>
        </thead>
        <tbody>
        <?php

        isset($maskminvalue) ? $display_min = $maskminvalue : $display_min = empty_nc(fnumber_format($result_sdii[0]['sdii_min_value'], 'auto', false));
        isset($maskmaxvalue) ? $display_max = $maskmaxvalue : $display_max = empty_nc(fnumber_format($result_sdii[0]['sdii_max_value'], 'auto', false));
        isset($maskthreshold) ? $display_threshold = $maskthreshold : $display_threshold = empty_nc(fnumber_format($result_sdii[0]['sdii_threshold_value'], 'auto', false));

        echo "<tr>\n";
        echo "<td>". $result_sdii[0]['sdii_unit']."</td>\n";
        echo "<td>". $display_min ."</td>\n";
        echo "<td>". $display_max."</td>\n";
        echo "<td>". $display_threshold ."</td>\n";
        echo "</tr>\n";
        ?>
        </tbody>
    </table>
    </div>
</div>
<div class="i-past-values">
    <?php if (is_array($result_value)) {?>
    <div class="toggle_title">
        <a href="#" id="affval"><?php echo _t('dashboard','all_value');?></a>
    </div>
    <div id="valeur" style="display: none;" class="mtm"><br class="brendstep" />
    <table>
        <thead>
            <tr>
            <?php
            echo "<td>".mb_ucfirst(_t('dashboard','date'))."</td>\n";
            echo "<td>".mb_ucfirst(_t('dashboard','value'))." (".formatText($result_sdii[0]['sdii_unit'], '2HTML').")"."</td>\n";
            echo "<td>".mb_ucfirst(_t('dashboard','comment'))."</td>\n";
            ?>
            </tr>
        </thead>
        <tbody>
        <?php

        for ($i=0;$i<count($result_value);$i++){

          $comment = '';
          $current_val = '';

          // indicator is multivalues
          if(!empty($result_value[$i]['sdiv_multivalue'])) {

            $data = unserialize($result_value[$i]['sdiv_multivalue']);

            foreach($data as &$val) {
                $current_val .= '<p>';
                if(!empty($val['label'])) $current_val .= formatText($val['label'], 'HTML'). ' : ';
                $current_val .= fnumber_format($val['value'], 'auto', false);
                if(!is_null($val['value'])) {
                    $current_val .= '<span class="value-value" data-value="' . $val['value'] . '">' . fnumber_format($val['value'], 'auto', false) . '</span>';
                    if ($indicator_multiple_type == 'sum') $current_val .= '<span class="value-percent"> (' . fnumber_format($val['_percentage'], 2, false) . ' %)</span>';
                } else {
                    $current_val .= '<span class="value-value" data-value="' . $val['value'] . '">' . _t('dashboard', 'no_data') . '</span>';
                }
                $current_val .= '</p>';
            }
            // we display the validerMul if $indicator_multiple_type == 'sum'
              if($indicator_multiple_type == 'sum') {
                  $current_val .= '<p class="value-total">';
                  if(!is_null($data[0]['_total'])) {
                      $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' . fnumber_format($data[0]['_total'], 'auto', false);
                  } else {
                      $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' .mb_ucfirst(_t('dashboard', 'no_data'));
                  }
                  $current_val .= '</p>';
              }
              // we display the total if $indicator_multiple_type == 'mean'
              if($indicator_multiple_type == 'mean') {
                  $current_val .= '<p class="value-mean">';
                  if(!is_null($data[0]['_mean'])) {
                      $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_mean')) . ' : ' . fnumber_format($data[0]['_mean'], 2, false);
                  } else {
                      $current_val .= mb_ucfirst(_t('dashboard', 'multivalue_mean')) . ' : ' .mb_ucfirst(_t('dashboard', 'no_data'));
                  }
                  $current_val .= '</p>';
              }
              
            // indicator is NOT multivalues
          } else {

              // If indicator is boolean or qualitative
              if($result_sdii[0]['sdii_nature'] == 'boolean' || $result_sdii[0]['sdii_nature'] == 'qualitative') {
                  $a = getBooleanValues($result_sdii[0]);

                  if($a) {
                      $index = array();
                      foreach ($a as $key => $value) {
                          array_push($index, $key);
                      }
                      if(is_null($result_value[$i]['sdiv_value'])) {
                          $current_val .=  _t('dashboard', 'no_data');
                          $current_val_raw = $result_value[$i]['sdiv_value'];
                      } else {
                          $current_val .= $a[$result_value[$i]['sdiv_value']];
                          $current_val_raw = $result_value[$i]['sdiv_value'];
                      }

                  } else {
                      if(is_null($result_value[$i]['sdiv_value'])) {
                          $current_val .= mb_ucfirst(_t('dashboard', 'no_data'));
                      } else {
                          $current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
                      }
                  }

              } else {
                  if(is_null($result_value[$i]['sdiv_value'])) {
                      $current_val .= mb_ucfirst(_t('dashboard', 'no_data'));
                  } else {
                      $current_val .= fnumber_format($result_value[$i]['sdiv_value'], 'auto', false);
                  }
              }

          }

          ($result_value[$i]['sdiv_comment_display'] == 'Y') ? $comment_status = _t('dashboard', 'public') : $comment_status = _t('dashboard', 'private');
          if(!empty($result_value[$i]['sdiv_comment'])) {
            $comment  = '<div class="valuecomment">';
            $comment .= '<img src="'.THEME_ADMIN_PATH.'images/indic-comment.png" />';
            $comment .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'comment')).' ('.$comment_status.') :</strong> '.$result_value[$i]['sdiv_comment'].'</div>';
            $comment .= '</div>';
          }

          echo "<tr>\n";
          echo "<td>". formatText($result_value[$i]['date_p'], '2HTML')."</td>\n";
          echo "<td>". formatText($current_val, '2HTML');
          if(!empty($result_value[$i]['sdiv_analysis'])) {
              $analysis  = '<div class="valuecomment analysis">';
              $analysis .= '<i class="fa fa-line-chart" aria-hidden="true"></i>';
              $analysis .= '<div class="cont"><strong>'.ucfirst(_t('dashboard', 'last_analysis')).' :</strong> '.$result_value[$i]['sdiv_analysis'].'</div>';
              $analysis .= '</div>';
              echo $analysis;
          }
          if ($result_value[$i]['sdiv_statut']=='D') {
            echo "<span class=\"state\">"._t('statut','draft')."</span>";
          }
          echo "</td>\n";
          echo "<td>". $comment."</td>\n";
          echo "</tr>\n";

        }
        ?>
        </tbody>
    </table>

        <?php }
        else echo "<div class=\"info\">"._t('dashboard','novalue')."</div>";	?>
</div>

  <div>
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="project_referer" type="hidden" value="<?php echo $project_referer; ?>" id="project_referer" />
    <input name="scale_id" type="hidden" value="<?php echo $scale_id; ?>" id="scale_id" />
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <?php echo cancel_button($link_cancel); ?>
    <input name="valider" type="submit" value="<?php echo _t('btn','valid') ?>" class="button" id="valider" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
	<?php
	// Récapitulatif
	} else {

	    $table=unserialize(urldecode($table));
	    $recap_nc = _t('divers','none');
	    function empty_form($var, $recap_nc)
	    {
	      if (empty($var)) $var2 = $recap_nc;
	      else $var2 = $var;
	      return $var2;
	    }

	    $req_scale=SQL_getonescale($table[3]);
	    $resultscale2 = $sql_object -> DBSelect($req_scale);

        $display_analysis = formatText(empty_none($_POST['analysis']), '2HTML');
	    $display_comment = formatText(empty_none($_POST['comment']), '2HTML');

	    ($form_statutc == 'Y') ? $display_comment_status = _t('dashboard', 'public') : $display_comment_status = _t('dashboard', 'private');

	    $display_sdi_value = '';
	    $total = 0;
        $cnt = 0;

	    if(is_array($table[0])) {
	        $display_threshold_value = empty_none($table[2]);

	    	foreach($table[0] as &$value) {
	    	    $tmpVal = sys_number_format($value['value']);
	    	    
	    	    if($tmpVal > 0) $total += $tmpVal; // do not add negative values
	    		
	    		$display_sdi_value .= '<p>';
	    		$display_sdi_value .= mb_ucfirst(formatText($value['label'], 'HTML')).' : ';
	    		$display_sdi_value .= fnumber_format($value['value'], 'auto', false);
	    		$display_sdi_value .= ' ('.$result_sdii[0]['sdii_unit'].')';
	    		$display_sdi_value .= '</p>'.PHP_EOL;
                $cnt++;
	    	}

            // we display the total if $indicator_multiple_type == 'sum'
            if($indicator_multiple_type == 'sum') {
                $display_sdi_value .= '<p class="value-total">';
                $display_sdi_value .= mb_ucfirst(_t('dashboard', 'multivalue_total')) . ' : ' . fnumber_format($total, 'auto', false);
                $display_sdi_value .= '</p>';
            }
            // we display the total if $indicator_multiple_type == 'sum'
            if($indicator_multiple_type == 'mean') {
                $display_sdi_value .= '<p class="value-mean">';
                $display_sdi_value .= mb_ucfirst(_t('dashboard', 'multivalue_mean')) . ' : ' . fnumber_format($total / $cnt, '2', false);
                $display_sdi_value .= '</p>';
            }

	    } else {
	    	if($result_sdii[0]['sdii_nature'] == 'quantitative') {
	    		$display_sdi_value .= $table[0]." (".$result_sdii[0]['sdii_unit'].")";
	    		$display_threshold_value = empty_none($table[2]);
	    	} else {
	    		$display_sdi_value .= $a[$table[0]]." (".$result_sdii[0]['sdii_unit'].")";
	    		if($table[2] == '')$display_threshold_value = empty_none($table[2]);
	    		else $display_threshold_value = $a[$table[2]];
	    	}
	    }
        if($table['nodata'] == 1) $display_sdi_value = _t('dashboard', 'no_data');

		//afficher nom de scale
		$display_sdi_scale = formatText($resultscale2[0]['scale_denomination'], '2HTML');
		$display_sdi_date = $table[4];
		$display_sdi_statut= $table[5];
		$table = urlencode(serialize($table));
?>

<div class="contentcontainer">
<?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content" class="action-<?php echo $todo; ?>">
<h2><?php echo _t('recap','title') ;
?></h2>
<dl class="summary">
	<dt class="i-value"><?php echo mb_ucfirst(_t('dashboard','value')); ?> :</dt>
	<dd><?php echo $display_sdi_value; ?></dd>
	<dt class="i-name"><?php echo mb_ucfirst(_t('sdi','name2')); ?> :</dt>
	<dd><?php echo formatText($result_sdii[0]['sdii_name'], '2HTML'); ?></dd>
	<dt class="i-status"><?php echo mb_ucfirst(_t('divers','statut')); ?> :</dt>
	<dd><?php echo display_statut($display_sdi_statut); ?></dd>
	<dt class="i-date"><?php echo mb_ucfirst(_t('dashboard','date')); ?> :</dt>
	<dd><?php echo $display_sdi_date ;?></dd>
	<dt class="i-scale"><?php echo mb_ucfirst(_t('dashboard','scale')) ;?> :</dt>
	<dd><?php echo $display_sdi_scale ;?></dd>
	<dt class="i-threshold"><?php echo mb_ucfirst(_t('dashboard','threshold_value'));	?> :</dt>
	<dd><?php echo $display_threshold_value; ?></dd>
    <dt class="i-analysis"><?php echo mb_ucfirst(_t('dashboard','last_analysis')); ?> :</dt>
    <dd><?php echo $display_analysis ;?></dd>
	<dt class="i-comment"><?php echo mb_ucfirst(_t('dashboard','comment')) ;?> :</dt>
	<dd><?php echo $display_comment ;?></dd>
	<dt class="i-comment-status"><?php echo mb_ucfirst(_t('dashboard','comment_status')) ;?> :</dt>
	<dd><?php echo $display_comment_status ;?></dd>
</dl>
<form id="addvalue2" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
    <div>
    <input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
    <input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
    <input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
    <input name="scale_id" type="hidden" value="<?php echo $scale_id; ?>" id="scale_id" />
    <input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
    <?php echo cancel_button($link_cancel); ?>
    <input name="retour" type="button" value="<?php echo _t('btn','preview') ?>" class="button" id="retour" onclick="history.go(-1);" />
    <input name="enregistrer" type="submit" value="<?php echo _t('btn','save') ?>" class="button" id="enregistrer" />
  </div>
</form>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->
<?php
	}
?>

<script>
$(document).ready(function() {
	$(".valuecomment").hover(
		function() {
			$('.cont', this).fadeIn();
		},
		function() {
			$('.cont', this).hide();
		}
	);
});
</script>