<?php
/**
 * Dashboard module
 * 
 * Export indicators information and values into XML format
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/***********************
 * paramétrage du fichier XML
 *
 * *************************/

/*********************
 * contenu du fichier XML
 * valeurs posssibles :
 * P (format public)
 * A (format admin)
 ************************/
$format="P";

/*********************
 * liste des indicateurs
 * valeurs posssibles :
 * R (statut<>'E')
 * P (statut='P')
 ************************/
if ($format=="A")$filter_sdi="R";
else $filter_sdi="P";
/*********************
 * liste des valeurs
 * valeurs posssibles :
 * D (statut<>'E')
 * SCP (statut='P') sdiv_date_published ASC
 * SCD (statut='P') sdiv_date_published DESC
 * SCA (statut<>'E') sdiv_date_published DESC
 ************************/

if ($format=="A") $filter_value="D";
else $filter_value="SCD";

include_once("../config/define.php");
include_once("../level/display.php");
include_once("../lib/no_cache.php");
IncludeAdminLang("dashboard");

include_once(SQL.'.inc.php');
include_once('../class/class.sdi.php');

// we check if the given token is correct
// else we quit
if(!isset($_GET['token']) || $_GET['token'] != SECRET_KEY) die('Invalid token!');

$sdi_object= new sdi;

$levels=$sql_object->DBSelect(SQL_getLevelsList());

$sdi = $sql_object -> DBSelect(SQL_getListSdi($filter_sdi, 0));

header('Content-Type: text/xml');
$listing="<?xml version=\"1.0\" encoding=\"".CHARSET."\"?>".PHP_EOL."<indicators>" . PHP_EOL;


$a = 	array();

  for ($j=0;$j<count($sdi);$j++){

			if(!in_array($sdi[$j]['sdii_id'], $a)) {
				
				array_push($a, $sdi[$j]['sdii_id']);
				
				if($sdi[$j]['sdii_level'] !=0 ) {
					$level = '<level label="'.formatText($sdi[$j]['level_label'], '2XML').'">'.formatText($sdi[$j]['level_name'], '2XML').'</level>';
				} else {
					$level = '';
				}
  		
				// @todo get the whole hierarchy of levels
// 				$a = getLevelParents($levels, $sdi[$j]['sdii_level']);
// 				$a = getLevelParents($levels, 3);
// 				$b = getLevelDepth($levels, 57,0);
// 				echo $b;
// 				print_r($a);

	  	
	      $req_sdii=SQL_getInfoSdi($sdi[$j]['sdii_id']);
	      $sdii = $sql_object -> DBSelect($req_sdii);
	
	      $req_sdir=SQL_getRules( $sdi[$j]['sdii_id'], $sql_object, -1);
	      $levels_r = $sql_object -> DBSelect($req_sdir);
	
	      $req_sdie=SQL_getEvaluation( $sdi[$j]['sdii_id'], $sql_object,-1);
	      $levels_e = $sql_object -> DBSelect($req_sdie);
	
	      $req_sdip=SQL_getProvider( $sdi[$j]['sdii_id'], $sql_object,-1);
	      $levels_p = $sql_object -> DBSelect($req_sdip);
	
	      $req_scale=SQL_getlistscale(0);
	      $levelsscale = $sql_object -> DBSelect($req_scale);

	      //formattage des infos générales
	      $listing.=TAB_LINE.TAB_LINE."<indicator id=\"".$sdi[$j]['sdii_id']."\">" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($sdi[$j]['sdii_name'], '2XML')."</title>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<description>".formatText($sdii[0]['sdii_description'], '2XML')."</description>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<comment>".formatText($sdii[0]['sdii_comment'], '2XML')."</comment>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<range>".formatText($sdii[0]['sdii_range'], '2XML')."</range>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<levels>".$level."</levels>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<goal>".formatText($sdii[0]['sdii_goal'], '2XML')."</goal>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<consulting>".formatText($sdii[0]['sdii_consulting'], '2XML')."</consulting>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<unit>".formatText($sdii[0]['sdii_unit'], '2XML')."</unit>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<max_value>".formatText(empty_nc($sdii[0]['sdii_max_value']), '2XML')."</max_value>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<min_value>".formatText(empty_nc($sdii[0]['sdii_min_value']), '2XML')."</min_value>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<threshold_value>".formatText(empty_nc($sdii[0]['sdii_threshold_value']), '2XML')."</threshold_value>" . PHP_EOL;
	      $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<threshold_relative>".formatText($sdii[0]['sdii_threshold_relative'], '2XML')."</threshold_relative>" . PHP_EOL;

	      if ($format=="A"){
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<frequency>".formatText($sdii[0]['sdii_frequency'], '2XML')."</frequency>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($sdii[0]['sdii_date_crea'], '2XML')."</date_crea>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($sdii[0]['sdii_last_modify'], '2XML')."</last_modify>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<status>".formatText($sdii[0]['sdii_statut'], '2XML')."</status>" . PHP_EOL;
	        //formattage des infos du fournisseur
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<provider id=\"".$levels_p[0]['sdip_id']."\">". PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($levels_p[0]['sdip_name'], '2XML')."</title>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<service>".formatText($levels_p[0]['sdip_service'], '2XML')."</service>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<description>".formatText($levels_p[0]['sdip_description'], '2XML')."</description>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<incharge>".formatText($levels_p[0]['sdip_incharge'], '2XML')."</incharge>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<address>".formatText($levels_p[0]['sdip_address'], '2XML')."</address>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<phone>".formatText($levels_p[0]['sdip_phone'], '2XML')."</phone>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<fax>".formatText($levels_p[0]['sdip_fax'], '2XML')."</fax>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<email>".formatText($levels_p[0]['sdip_email'], '2XML')."</email>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($levels_p[0]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($levels_p[0]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."</provider>". PHP_EOL;
	
	        //formattage des infos de réglementation
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<reglementation id=\"".$levels_r[0]['sdir_id']."\">". PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($levels_r[0]['sdir_title'], '2XML')."</title>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<body>".formatText($levels_r[0]['sdir_body'], '2XML')."</body>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<referer_uri>".formatText($levels_r[0]['sdir_referer_uri'], '2XML')."</referer_uri>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<mask_uri>".formatText($levels_r[0]['sdir_mask_uri'], '2XML')."</mask_uri>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($levels_p[0]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($levels_p[0]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."</reglementation>". PHP_EOL;
	
	        //formattage des infos d'évaluation
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."<evaluation id=\"".$levels_e[0]['sdie_id']."\">". PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<scale_compare>".formatText($levels_e[0]['sdie_scale_compare'], '2XML')."</scale_compare>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<fiability>".formatText($levels_e[0]['sdie_fiability'], '2XML')."</fiability>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<accessibility>".formatText($levels_e[0]['sdie_accessibility'], '2XML')."</accessibility>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<lisibility>".formatText($levels_e[0]['sdie_lisibility'], '2XML')."</lisibility>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<relevance>".formatText($levels_e[0]['sdie_relevance'], '2XML')."</relevance>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<global_performance>".formatText($levels_e[0]['sdie_global_performance'], '2XML')."</global_performance>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($levels_p[0]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($levels_p[0]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
	        $listing.=TAB_LINE.TAB_LINE.TAB_LINE."</evaluation>". PHP_EOL;
	      }
	      
	      
	      //formattage des valeurs
	      if(isset($levelsscale[0]['scale_id'])) {
	      	$listing.= "<values>";
		      for ($z=0;$z<count($levelsscale);$z++){
		
		        $req_sdiav=SQL_getAllValue($filter_value, $levelsscale[$z]['scale_id'], $sdi[$j]['sdii_id']);
		        $levels_value = $sql_object -> DBSelect($req_sdiav);
		        if ($levels_value[0]['sdiv_value']<>""){
		          $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<scale id=\"".$levelsscale[$z]['scale_id']."\">". PHP_EOL;
		          $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<title>".formatText($levelsscale[$z]['scale_denomination'], '2XML')."</title>" . PHP_EOL;
		          for ($h=0;$h<count($levels_value);$h++){
		            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<value id=\"".$levels_value[$h]['sdiv_id']."\">". PHP_EOL;
		            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<num_value>".formatText($levels_value[$h]['sdiv_value'], '2XML')."</num_value>" . PHP_EOL;
		            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_published>".formatText($levels_value[$h]['date_p'], '2XML')."</date_published>" . PHP_EOL;
		            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<date_crea>".formatText($levels_value[$h]['date_c'], '2XML')."</date_crea>" . PHP_EOL;
		            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<last_modify>".formatText($levels_value[$h]['date_m'], '2XML')."</last_modify>" . PHP_EOL;
		            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."<statut>".formatText($levels_value[$h]['sdiv_statut'], '2XML')."</statut>" . PHP_EOL;
		            $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."</value>". PHP_EOL;
		          }
		          $listing.=TAB_LINE.TAB_LINE.TAB_LINE.TAB_LINE."</scale>". PHP_EOL;
		        }
		      }
		      $listing.= "</values>";
	      }

      	$listing.=TAB_LINE.TAB_LINE."</indicator>" . PHP_EOL;
    	}
  	}

	$listing.="</indicators>" . PHP_EOL;

	echo $listing;

?>