<?php
/**
 * Dashboard module
 * 
 * Display dashboard in back-office
 * 
 * @package linea21\modules\dashboard
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
	include_once("../lib/lib_common.php");
	ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('dashboard')) ReloadIndex('admin');
////////////

include_once("../lib/input_helpers.php");
include_once("../dashboard/common.php");
include_once("../dashboard/display.php");
include_once(override('../level/display.php', THEME_ADMIN_PATH));
include_once('../class/class.tag.php');

// getting tags menu filter
$otag = new tag();
$tags =$otag->getTags('indicator', -1, false);

$filter_menu = getMenuFilter($tags);

$firstlevels = $sql_object->DBSelect(SQL_getLevelsList(true));

$sdi = $sql_object -> DBSelect(SQL_getListSdi("R", 0));
$bdd_nb_sdi = get_unique_indicators($sdi, true);

$sdi = add_root_level($sdi, 'sdii_level', 'level_root'); // we add extra field with level root

// Number of records

$bdd_nb_sdi_display = '<span id="total-count">' .$bdd_nb_sdi['count'] .'</span> ' . _t('sdi','nb_total').'<br />'. PHP_EOL;

$link_list_scale=$rub_link."&amp;todo=list&amp;scale_id=";

if (!isset($_GET['scale_id']) && !isset($_POST['scale_id'])) {
	$scale_id = 1;
} else {
	if (isset($_POST['scale_id'])) $scale_id = $_POST['scale_id'];
	if (isset($_GET['scale_id'])) $scale_id = $_GET['scale_id'];
}

$resultscale2 = $sql_object -> DBSelect(SQL_getonescale($scale_id));


function getIndicatorsTable($levels, $indicators, $scale_id, $status, $sql_object) {
    
    global $rub_link;
    
    $sdi_object= new sdi;
    
    if($status=='all') $test = true;
    if($status=='attached') $test='Y';
    if($status=='not-attached') $test='N';

    $listing = '<div class="indicator-switcher-container right"><div class="flex-container"><span class="hint--top hint--large hint--rounded txtcenter mts" aria-label="'._t('sdi', 'strategic_indicators_only_notice').'"><i class="fa fa-info-circle" aria-hidden="true"></i></span><label for="indicator-switcher" class="label autowidth"> '.formatText(_t('sdi', 'strategic_indicators_only'), '2HTML').'<span id="strategic-indic-counter"> (-)</span></label><input name="indicator-switcher" type="checkbox" checked="checked" value="1" id="indicator-switcher" class="switch" /></div></div>' . PHP_EOL;

    $link_add=$rub_link."&amp;todo=add&amp;id=";
    $link_det=$rub_link."&amp;todo=det&amp;id=";
    
    $current_level='';
    
    $a = array(); // do not display twice an indicator
    
    if(!is_array($indicators)) return ''; // no indicators, we exit function
    
    // levels loop
    for ($i=0;$i<count($levels);$i++){
        
        
        if ($levels[$i]['level_name'] != $current_level && $current_level <> '') {
            $listing.="</tbody></table>";
        }
        if ($levels[$i]['level_id'] != $current_level) {
//             $current_level = $levels[$i]['level_id'];
//             $listing.="<h3><a href=\"\">".formatText($levels[$i]['level_name'], '2HTML')."</a></h3>";
//             $listing.="<div class=\"contboxgray\">\n";
//             $listing.="<ul class=\"filter-items\">\n";
            
            $current_level = $levels[$i]['level_id'];
            $listing .= "<h2 class=\"dashboard level-".$current_level."\" id=\"title-level-".$current_level."-".$status."\">" . formatText($levels[$i]['level_name'], '2HTML') . "</h2>".PHP_EOL;
            $listing .= '<table class="table_dashboard">' . PHP_EOL;
            $listing .= '<thead>' . PHP_EOL;
            $listing .= '<tr>' . PHP_EOL;
            $listing .= '<td class="graphic-values pt2">'.mb_ucfirst(_t('dashboard','graphic_value')).'</td>' . PHP_EOL;
            $listing .= '<td class="pt3">'.mb_ucfirst(_t('dashboard','label_value')).'</td>' . PHP_EOL;
            $listing .= '<td class="pt3">&nbsp;</td>' . PHP_EOL;
            $listing .= '</tr>' . PHP_EOL;
            $listing .= '</thead>' . PHP_EOL;
            $listing .= '<tbody class="filter-items">' . PHP_EOL;
        }
        
        // indicators loop
        for ($j=0;$j<count($indicators);$j++) {
            
            // getting tags
            $otag = new tag ();
            $display_tags = $otag->getTags ( 'indicator', $indicators[$j]['sdii_id'], true, ';' );
            $display_types = formatText(mb_ucfirst($GLOBALS['lang']['sdi']['select_type'][$indicators[$j]['sdii_type']]), '2HTML');
            
            if ($levels[$i]['level_id'] == $indicators[$j]['level_root']) {
                // setting $threshold_value
                // By default initial value
                $threshold_value = $indicators[$j]['sdii_threshold_value'];
                // if set, we get the latest for the given scale
                $r = $sql_object -> DBSelect(SQL_getlastInsertByPublicationDate($indicators[$j]['sdii_id'], $scale_id));
                if(isset($r[0]['sdiv_value']) && !is_null($r[0]['sdiv_threshold'])) {
                    $threshold_value = $r[0]['sdiv_threshold'];
                }

                $sclass = ($indicators[$j]['sdii_to_dashboard']=='Y') ? 'strategic' : 'non-strategic';

                if (!in_array($indicators[$j]['sdii_id'], $a)) {
                    //$listing.="\t<li class=\"li2".$cssclass." indicator-".$indicators[$j]['sdii_nature']."\" data-tags=\"".$display_tags."\" data-id=\"".$indicators[$j]['sdii_id']."\">\n";
                    $listing .= "<tr class=\"".$sclass." indicator indicator-".$indicators[$j]['sdii_nature']."\" data-types=\"".$display_types."\" data-tags=\"".$display_tags."\" data-id=\"".$indicators[$j]['sdii_id']."\">" . PHP_EOL;
                    $listing .= "<td class=\"graphic-values indicator-".$indicators[$j]['sdii_nature']."\">";
                    $listing.= getViz($sql_object, $scale_id, $indicators[$j], $threshold_value);
                    $listing .= "</td>";
                    $listing.="<td class=\"dashboard-indicator-label\">";
                    $listing.="<a href=\"".$link_det.$indicators[$j]['sdii_id']."&amp;scale_id=".$scale_id."\" title=\"".formatText($indicators[$j]['sdii_name'], '2ATT')."\" class=\"indic-name\">".formatTextli($indicators[$j]['sdii_name'])."</a>";

                    if($sclass == 'strategic') $listing .= '<span class="hint--top hint--rounded" aria-label="'._t('sdi', 'attached_to_dashboard').'"><i class="fa fa-star" aria-hidden="true"></i></span>' . PHP_EOL;
                    if(!empty($display_tags)) $listing.= "<i class=\"fa fa-tag\" style=\"opacity:0.3;margin:0\" title=\"" . formatText ( $display_tags, '2ATT' ) . "\"></i> ";
                    if($indicators[$j]['sdii_type'] != 'not-set') $listing.='<span class="indic-type '.$indicators[$j]['sdii_type'].'">'.formatText(mb_ucfirst($GLOBALS['lang']['sdi']['select_type'][$indicators[$j]['sdii_type']]), '2HTML').'</span>';
                    if ($indicators[$j]['sdii_statut']=='D') $listing.="<span class=\"publication-state\">"._t('statut','draft')."</span>\n";
                    $listing .= "<div class=\"indicator-level\">" . formatText($indicators[$j]['level_label'], '2HTML') . " : <span>" . formatText($indicators[$j]['level_name'], '2HTML') . "</span></div>". PHP_EOL;

                    $listing.="</td>". PHP_EOL;
                    $listing.="<td><div class=\"iconetab\"><a href=\"".$link_add.$indicators[$j]['sdii_id']."&amp;scale_id=".$scale_id."\" class=\"ico_add\" title=\""._t('dashboard','add')."\"><i class=\"fa fa-plus-circle\" aria-hidden=\"true\"></i><span>".  _t('dashboard','add')."</span></a></div></td>";
                    $listing.="</tr>". PHP_EOL;
                    
                    array_push($a, $indicators[$j]['sdii_id']); // we add the id into array for not displaying it twice
                    
                }
            }
        }
        
    }
    
    $listing.="</table>";

	// including sparkline code based on peity
    footerAddJS('../lib/js/peity-3.3.0/jquery.peity.min.js');
    footerAddInlineJS("$('.dashboard-indicator-sparkline .inlinebar').peity( 'bar', { fill: ['#5EA7AC']});"); // previous color '#8DA8CB'

    footerAddInlineJS('
            $("#indicator-switcher").on("change", function() {
                if(document.getElementById("indicator-switcher").checked) {
                    $("tbody tr.non-strategic").fadeOut(); // fadeOut() - hide()
                    $("div.indicator-switcher-container").css("opacity", "1");
                    // console.log("checked" );
                } else {
                    $("tbody tr.non-strategic").fadeIn(); // fadeIn() - show()
                    $("div.indicator-switcher-container").css("opacity", "0.5");
                    // console.log("pas checked" );
                }
                setTimeout(function() { // important to wait to get the right count
                  var cnt = $("tbody tr.indicator:visible").length;
                  // console.log("indicateurs visibles : " + cnt);
                  $("#strategic-indic-counter").text(" (" + cnt + ")");
                }, 1000);
                
            });
            $("#indicator-switcher").trigger("change");
            ');
    
    return $listing;
    
}

//affichage selectbox échelle
$resultscale = $sql_object -> DBSelect($req_list_scale);
$scale_selectbox="<h2>".formatText($resultscale2[0]['scale_denomination'], '2HTML')."</h2>";
$scale_selectbox.="<div class=\"filterselect\">";
$scale_selectbox.=ScaleSelectBox($resultscale, "scale", $scale_id, $link_list_scale);
$scale_selectbox.="</div>\n";

?>
<div id="chemin">
	<ul>
		<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
		<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','dashboard');?> </a></li>
		<li><span><?php echo _t('dashboard','list'); ?> </span></li>
	</ul>
</div>
<!--end barre haute -->

<script>
function compute_values() {

	var total_counter = 0;
	// iterate through each td based on class and add the values
	$("table").find("tbody.filter-items tr.indicator").each(function(index) {
    	// only for visible elements
    	if($(this).is(":visible")) {
    		// console.log($(this).closest('tr').is(":visible"));
    		total_counter++;
    	}
	});

	// on the fly filter selection
	$( '#current-sel' ).html('<?php echo _t('divers', 'n_selected'); ?>'.replace("#", total_counter).replace("%", $('#total-count').text())).hide().fadeIn('slow');
}

$(document).ready(function() {

	$("#content table tbody").each(
			  function() {
			    var elem = $(this);
			    if (elem.children().length == 0) {
			      elem.append("<tr><td colspan='3'><?php echo _t('divers', 'nodata'); ?></td></tr>");
			    }
			  }
			);
	
	$(".dashboard-indicator-gauge .cursor").removeAttr("title");
	$(".dashboard-indicator-gauge div.gauge.infobox").removeAttr("title");
	$(".infobox").hover(
		function() {
			$(this).next().fadeIn('fast');
		},
		function() {
			$(this).next().hide();
		});
});
</script>

<?php
if(defined('ANIMATE_PROGRESS') && ANIMATE_PROGRESS == 1) {
footerAddJS('../lib/js/waypoints/lib/jquery.waypoints.min.js');
?>
		<script>
		$(document).ready(function() {

			function animate_gauge_css(obj) {
				var tmp = $(obj).css('left'); // get position
				$(obj).css('left', 0); // set to min
		 		$( obj ).animate({left : tmp}, getRandomInt(2000, 4000)); // animate
			};

			function animate_gauge(obj) { // @todo remove when removing image gauge
				var tmp = $(obj).css('left'); // get position
				$(obj).css('left', -110); // set to min
		 		$( obj ).animate({left : tmp}, getRandomInt(2000, 4000)); // animate
			};

			function animate_raw(obj) {
				var $this = obj;
				var endval = $this.attr('data-value');
                if(isNaN(endval)) return true;
				// console.log('data-value : ' + $this.attr('data-value'));
				  $({ Counter: 0 }).animate({ Counter: endval }, {
						duration: getRandomInt(2000, 4000),
						easing: 'swing',
						step: function () {
						   $this.text(Math.ceil(this.Counter) > endval ? number_f(endval) : number_f(Math.ceil(this.Counter)));
						},
						done: function() {
							// console.log("end value : " + endval);
							$this.text(number_f(endval));
						}

				  });
			};

			/**
			* Waypoints animation - Method A
			* animate when scrolled to object position
			*/
			var waypoints_gauge = $('.dashboard-indicator-gauge div.circle').waypoint({
				  handler: function(direction) {
				    animate_gauge_css($(this.element));
				    this.destroy();
				  },
		      offset: 'bottom-in-view'
			});
			var waypoints_gauge = $('.dashboard-indicator-gauge > img.cursor').waypoint({ // @todo remove when removing image gauge
				  handler: function(direction) {
				    animate_gauge($(this.element));
				    this.destroy();
				  },
		      offset: 'bottom-in-view'
			});
			var waypoints_raw = $('.dashboard-indicator-raw > span.infobox.value:not(".boolean-mask")').waypoint({
				  handler: function(direction) {
				    animate_raw($(this.element));
				    this.destroy();
				  },
		      offset: 'bottom-in-view'
			});


			/**
			* Animate anyway - Method B
			*/
			// animate the gauges representation
// 			$('.dashboard-indicator-gauge > img.cursor').each(function(index) {
// 				animate_gauge($(this));
// 			});
// 			// animate raw representation
// 			$('.dashboard-indicator-raw > span.infobox.value:not(".boolean-mask")').each(function(index) {
// 				console.log($(this));
// 			 animate_raw($(this));
// 			});
		});
		</script>
<?php } ?>
<?php 
//print_r($sdi); 
?>
<div class="contentcontainer">
	<?php	include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));	?>
	<div id="content">
	
		<?php echo $bdd_nb_sdi_display; ?>
		<?php echo $scale_selectbox;	?>
		
		<br style="clear: both;margin-bottom:3em" />
		
		<?php echo $filter_menu; ?>
		<p id="current-sel"></p>
		
        <div>
        <?php
        if(defined('DASHBOARD_DISPLAY') && DASHBOARD_DISPLAY == 'table') {
            echo getIndicatorsTable($firstlevels, $sdi, $scale_id, 'all', $sql_object);
        } else {
            DisplayListValuesByLevelsAlt($scale_id, -1, 'admin');
        }
        ?>
        </div>
	</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->