<?php
/**
 * Export module - Excel
 * 
 * Write Excel report last page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) Word report
 */

///////////////////////////////////
// Récupération de données
///////////////////////////////////




// https://phpspreadsheet.readthedocs.io/en/latest/topics/worksheets/

// // Create a new worksheet called "Infos"
$infosWorkSheet = new \PhpOffice\PhpSpreadsheet\Worksheet\Worksheet($spreadsheet, mb_ucfirst(_t('report', 'informations')));


// we attach the "Infos" worksheet as the first worksheet in the Spreadsheet object
$spreadsheet->addSheet($infosWorkSheet, 1);
$infosWorkSheet->getTabColor()->setRGB('90c5ed');


// we display images at the bottom of generated information
$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
$drawing->setName('logo');
$drawing->setDescription('logo');
$drawing->setPath(override('../export/inc_report/logo_p.png')); // put your path and image here
$drawing->setCoordinates('B1');
$drawing->setOffsetX(10);
$drawing->setOffsetY(50);
$drawing->setRotation(0);
$drawing->getShadow()->setVisible(true);
$drawing->getShadow()->setDirection(0);
$drawing->setWorksheet($infosWorkSheet);

$infosWorkSheet->getRowDimension('1')->setRowHeight(150, 'px');


// background color
$infosWorkSheet->getStyle('A:BZ')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB($docOptions['mainBackgroundColor']);

// we start at current line 
$startline = $curline = 2;

// row 1

$infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['title']));
$infosWorkSheet->setCellValue('B'.$curline, html2rawText($report_settings['title']));
$curline++;

// row 2
$infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['divers']['date_crea']));
$infosWorkSheet->setCellValue('B'.$curline, date("d-m-Y H:i:s"));
$curline++;

// row 3
$infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['author']));
$infosWorkSheet->setCellValue('B'.$curline, html2rawText($report_settings['author']));
$curline++;

// row 4
$infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['mail_author']));
$infosWorkSheet->setCellValue('B'.$curline, html2rawText($report_settings['mail_author']));
$curline++;

// row 5
$infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['service']));
$infosWorkSheet->setCellValue('B'.$curline, html2rawText($report_settings['service_author']));
$curline++;

// row 6
$infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['address']));
$infosWorkSheet->setCellValue('B'.$curline, html2rawText($report_settings['adress_author']));
$curline++;

// row 7
if($report_settings['export_module'] == 'dashboard') {
    $infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['selected_indicators']));
    $tmplist = '';
    for($i=0; $i<count($ordered_items); $i++) {
        $tmplist .= "• ".$ordered_items[$i]['sdii_name']."\n";
    }
    $infosWorkSheet->setCellValue('B'.$curline, html2rawText($tmplist));
    $infosWorkSheet->getRowDimension($curline)->setRowHeight(100);
    $infosWorkSheet->getStyle('B'.$curline)->getAlignment()->setWrapText(true); // explicit setWrapText - see https://phpspreadsheet.readthedocs.io/en/latest/topics/recipes/
    $curline++;
}

// row 8
if($report_settings['export_module'] == 'dashboard') {
    $infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['selected_scale']));
    $tmplist = '';
    for($i=0; $i<count($scale_array); $i++) {
        $tmplist .= "• ".$scale_denomination_array[$scale_array[$i]]."\n";
    }
    $infosWorkSheet->setCellValue('B'.$curline, html2rawText($tmplist));
    $infosWorkSheet->getRowDimension($curline)->setRowHeight(100);
    $infosWorkSheet->getStyle('B'.$curline)->getAlignment()->setWrapText(true); // explicit setWrapText - see https://phpspreadsheet.readthedocs.io/en/latest/topics/recipes/
    $curline++;
    
}

// row 7 - project
// @todo to remove
// if($report_settings['export_module'] == 'project') {
//     $infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['selected_projects']));
//     $tmplist = '';
//     for($i=0; $i<count($ordered_items); $i++) {
//         $tmplist .= "• ".$ordered_items[$i]['project_name']."\n";
//         // echo $ordered_items[$i]['project_name'].'<br>';
//     }
//     $infosWorkSheet->setCellValue('B'.$curline, html2rawText($tmplist));
//     $infosWorkSheet->getRowDimension($curline)->setRowHeight(200);
//     $infosWorkSheet->getStyle('B'.$curline)->getAlignment()->setWrapText(true); // explicit setWrapText - see https://phpspreadsheet.readthedocs.io/en/latest/topics/recipes/
//     $curline++;    
// }
// row 7 - project
// we create as many rows as we have project because one cell is limitated to 409 height units.
if($report_settings['export_module'] == 'project') {
    $firstprojectLine = $curline;
    $infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['selected_projects']));
    // $tmplist = '';
    for($i=0; $i<count($ordered_items); $i++) {
        // $tmplist = "• ".$ordered_items[$i]['project_name']."\n";
        $infosWorkSheet->setCellValue('B'.$curline, html2rawText($ordered_items[$i]['project_name']));
        $infosWorkSheet->getStyle('B'.$curline)->getAlignment()->setWrapText(true); // explicit setWrapText - see https://phpspreadsheet.readthedocs.io/en/latest/topics/recipes/
        $curline++;
    }
    $infosWorkSheet->mergeCells('A'.$firstprojectLine.':A'.($curline-1));
}


// row 9
$infosWorkSheet->setCellValue('A'.$curline, mb_ucfirst($lang['report']['generated'].'('.$lang['divers']['seconds'].')'));
$infosWorkSheet->setCellValue('B'.$curline, html2rawText(round($total_time, 5)));

//////// FORMATTING 

// auto-sizing columns
foreach (range('A','B') as $col) {
    $infosWorkSheet->getColumnDimension($col)->setAutoSize(true);
}

// auto-sizing rows - not working in LibreOffice !
// then sizing again line 1 to 150px
foreach($infosWorkSheet->getRowDimensions() as $rowID) {
    $rowID->setRowHeight(-1);
}
$infosWorkSheet->getRowDimension('1')->setRowHeight(150, 'px');


// doc : https://phpspreadsheet.readthedocs.io/en/latest/topics/recipes/#valid-array-keys-for-style-applyfromarray
$styleArray = [
    'font' => [
		'bold' => (boolean) $docOptions['mainFontBold'],
        'size' => (string) $docOptions['mainFontSize'],
        'color' => ['argb' => $docOptions['mainFontColor'] ]
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
    ],
    'borders' => [
        'outline' => [
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => ['argb' => $docOptions['borderColor'] ]
        ],
        'horizontal' => [
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => ['argb' => $docOptions['borderColor'] ]
        ],
        'vertical' => [
            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
            'color' => ['argb' => $docOptions['borderColor'] ]
        ]
    ],
    'fill' => [
        'fillType' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
        'color' => ['argb' => $docOptions['mainBackgroundColor'] ]
    ]
];
$infosWorkSheet->getStyle('A'.$startline.':B'.$curline)->getAlignment()->setIndent(1); // margin - does not work on merged celle - at least in LibreOffice
$infosWorkSheet->getStyle('A'.$startline.':B'.$curline)->applyFromArray($styleArray);

// style for column 1 only
// doc : https://phpspreadsheet.readthedocs.io/en/latest/topics/recipes/#valid-array-keys-for-style-applyfromarray
$styleArray = [
    'font' => [
        'bold' => (boolean) $docOptions['headerFontBold'],
        'size' => (string) $docOptions['headerFontSize'],
        'color' => ['argb' => $docOptions['headerBackgroundColor']]
    ],
    'alignment' => [
        'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
        'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_TOP
    ]
];

$infosWorkSheet->getStyle('A'.$startline.':A'.$curline)->applyFromArray($styleArray);

?>