<?php
/**
 * Export module - pdf
 * 
 * Write pdf report first page
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

///////////////////////////////////
//	PAGE DE GARDE - RAPPORT
///////////////////////////////////

$pdf->AddPage();
$pdf->SetFont(DOC_POLICE, DOC_TITLE_STYLE, DOC_TITLE_SIZE);
$pdf->SetTextColorArray(getColor('DOC_TITLE_COLOR'));
$pdf->SetY(80);
$pdf->MultiCell(0, DOC_HEIGHT*2, formatText($report_settings['title']), 0, 'C');
$pdf->SetY($pdf->GetY()+(DOC_INTERVAL*2));
$pdf->SetFont(DOC_POLICE, 'B', 12);
$pdf->Cell(0, DOC_HEIGHT, formatText(SITE_NAME), 0, 2, 'C');
$pdf->SetXY(66, 180);

// by default we include SVG file
if(file_exists(THEME_PUBLIC_PATH.'override/export/inc_report/logo.svg')) {
	$pdf->ImageSVG(THEME_PUBLIC_PATH.'override/export/inc_report/logo.svg', $pdf->GetX(), $pdf->GetY(), $w='', $h=25, $link='', $align='', $palign='C', $border=0, $fitonpage='C');

// else include ai file
} elseif(file_exists(THEME_PUBLIC_PATH.'override/export/inc_report/logo.ai')) {	
	$pdf->ImageEps(THEME_PUBLIC_PATH.'override/export/inc_report/logo.ai', $pdf->GetX(), $pdf->GetY(), $w='', $h=25, $link=SITE_ROOT_URL.'public/', true, '', 'C', 0, false);
		
// else include eps file
} elseif(file_exists(THEME_PUBLIC_PATH.'override/export/inc_report/logo.eps')) {
	$pdf->ImageEps(THEME_PUBLIC_PATH.'override/export/inc_report/logo.eps', $pdf->GetX(), $pdf->GetY(), $w='', $h=25, $link=SITE_ROOT_URL.'public/', true, '', 'C', 0, false);
	
// else include raster file
} elseif(file_exists(THEME_PUBLIC_PATH.'override/export/inc_report/logo_g.png')) {
	$pdf->Image(THEME_PUBLIC_PATH.'override/export/inc_report/logo_g.png',$pdf->GetX(), $pdf->GetY(), 0, $h=30, '', SITE_ROOT_URL.'public/', 'M', false, 0, 'C');

// default Linea21 logo
} else {
	
	$pdf->ImageSVG('../export/inc_report/logo.svg', $pdf->GetX(), $pdf->GetY(), $w='', $h=25, $link=SITE_LINEA_URL, $align='', $palign='C', $border=0, $fitonpage='C');
}

$pdf->SetY($pdf->GetY()+(DOC_INTERVAL*15));
if(isset($report_settings['projects']) && $report_settings['projects'] == 'ALL') $pdf->MultiCell(0, DOC_HEIGHT*2, formatText(project_display_projects_completion('all')), 0, 'C');
$pdf->SetY($pdf->GetY()+(DOC_INTERVAL*2));

?>