<?php

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 2.1
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// this is supposed to be done from 2.0
@unlink('../class/class.theme.php');
@SureRemoveDir('../class/system/pChart/', true);
@SureRemoveDir('../class/system/tcpdf/', true);
@SureRemoveDir('../theme/', true);
@unlink('../dashboard/rap.php');
@unlink('../export/phpsql.process.php');
@unlink('../languages/fr/lang_theme.utf-8.php');
@unlink('../languages/es/lang_theme.utf-8.php');
@unlink('../languages/en/lang_theme.utf-8.php');
@unlink('../languages/it/lang_theme.utf-8.php');
@SureRemoveDir('../lib/js/jquery-ui/', true);
@SureRemoveDir('../lib/js/jquery-ui-multiselect/', true);
@SureRemoveDir('../lib/js/jquery.datePicker.l10n/', true);
@SureRemoveDir('../lib/js/jquery.textboxList/', true);
@SureRemoveDir('../lib/js/nicEdit/', true);
@SureRemoveDir('../lib/js/timeline/', true);
@SureRemoveDir('../lib/vendor/jQuery-File-Upload/', true);

@SureRemoveDir('../lib/vendor/cron-expression/tests/', true);
@SureRemoveDir('../lib/vendor/PHP-Color/testing/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Documentation/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Examples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/docs/', true);
@SureRemoveDir('../lib/vendor/PHPWord/samples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/tests/', true);
@SureRemoveDir('../lib/vendor/Stringy/tests/', true);

@unlink('../project/timeline-xml.php');
@unlink('../lib/js/jquery.min.js');
@unlink('../lib/js/timeline.js');

// new updates


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Generics actions : Finally we update config.ini and add new constants if necessary
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");


$l21config->setParams($config_ini);

// we update geocoder value anyway
if(isset($config_ini['GEOCODER_URL'])) $config_ini['GEOCODER_URL'] = "https://api-adresse.data.gouv.fr/search/?";

// we delete OUTPUT_SEP constant
if(isset($config_ini['ACCOUNT_UNIQUE_EMAIL'])) $l21config->rmParams(array(array('MISC_HIDDEN_SETTINGS', 'OUTPUT_SEP')));

// we delete USER_COMMUNITY constant
if(isset($config_ini['USER_COMMUNITY'])) $l21config->rmParams(array(array('MISC_HIDDEN_SETTINGS', 'USER_COMMUNITY')));

// we delete UPLOAD_MAX_MO constant
if(isset($config_ini['UPLOAD_MAX_MO'])) $l21config->rmParams(array(array('MISC_HIDDEN_SETTINGS', 'UPLOAD_MAX_MO')));

// we delete UPLOAD_MAX_MO constant
if(isset($config_ini['MAX_PHOTO_MAX_WIDTH'])) $l21config->rmParams(array(array('MISC_HIDDEN_SETTINGS', 'MAX_PHOTO_MAX_WIDTH')));

// we delete MAX_PHOTO_MIN_WIDTH constant
if(isset($config_ini['MAX_PHOTO_MIN_WIDTH'])) $l21config->rmParams(array(array('MISC_HIDDEN_SETTINGS', 'MAX_PHOTO_MIN_WIDTH')));

// we delete OVERRIDE_FOLDER constant
if(isset($config_ini['OVERRIDE_FOLDER'])) $l21config->rmParams(array(array('MISC_HIDDEN_SETTINGS', 'OVERRIDE_FOLDER')));

// we delete SQL constant
if(isset($config_ini['SQL'])) $l21config->rmParams(array(array('MISC_HIDDEN_SETTINGS', 'SQL')));

// we add ACCOUNT_UNIQUE_EMAIL constant if needed
if(!isset($config_ini['ACCOUNT_UNIQUE_EMAIL'])) $l21config->addParams(array(array('SYSTEM_SETTINGS', 'ACCOUNT_UNIQUE_EMAIL', 1)));

// we add PASSWD_CONFIRM constant if needed
if(!isset($config_ini['PASSWD_CONFIRM'])) $l21config->addParams(array(array('SYSTEM_SETTINGS', 'PASSWD_CONFIRM', 1)));

// we add DISPLAY_LEVEL_LABEL constant if needed
if(!isset($config_ini['DISPLAY_LEVEL_LABEL'])) $l21config->addParams(array(array('SYSTEM_SETTINGS', 'DISPLAY_LEVEL_LABEL', 1)));

// we add HTML_EXPORT constant if needed
if(!isset($config_ini['HTML_EXPORT'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'HTML_EXPORT', 1)));

// we add WORDEXPORT_ESCAPE constant if needed
if(!isset($config_ini['WORDEXPORT_ESCAPE'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'WORDEXPORT_ESCAPE', 1)));


// we write the new file
if($l21config->writeReleaseParams()) {
	echo "<p><strong>Writing new configuration file : /config/config.ini</strong></p>";
} else {
	echo "<p><strong>Problem writing new configuration file : /config/config.ini</strong></p>";
}

?>