<?php

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 2.4
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
@SureRemoveDir('../library/scripts/zeroclipboard/', true);
@SureRemoveDir('../lib/vendor/tcpdf/', true);
@SureRemoveDir('../lib/vendor/phpword-0.18.1/', true);
@SureRemoveDir('../templates/public/2019/less/', true);
@SureRemoveDir('../tmp/backup', true); // we delete /tmp/backup folder content

@SureRemoveDir('../templates/public/2019/less/', true);
@unlink('../templates/public/2019/tpl_home.php');
@unlink('../templates/public/2019/tpl_publication.php');

// to be sure tmp/ folder is secured
$htaccess = '# IP based access limits
order deny,allow
deny from all

# allow acces to images
<Files ~ "\.(jpq|jpeg|png|gif|svg)$">
   order deny,allow
   allow from all
</Files>';


if(!file_exists('../tmp/.htaccess') && is_writable('../tmp/')) @file_put_contents('../tmp/.htaccess', $htaccess);


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Generics actions : Finally we update config.ini and add new constants if necessary
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");


// we set admin theme to 2021
if(isset($config_ini['THEME_ADMIN'])) $config_ini['THEME_ADMIN'] = '2021';

$l21config->setParams($config_ini);


// we add REGISTRATION_ANTISPAM constant if needed
if(!isset($config_ini['SYSTEM_SETTINGS'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'REGISTRATION_ANTISPAM', 1)));


// we add PROJECT_IMPACTS constant if needed with value = 0
if(!isset($config_ini['SYSTEM_SETTINGS'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'PROJECT_IMPACTS', 0)));

// we write the new file
if($l21config->writeReleaseParams()) {
	echo "<p><strong>Writing new configuration file : /config/config.ini</strong></p>";
} else {
	echo "<p><strong>Problem writing new configuration file : /config/config.ini</strong></p>";
}

?>