/**
 * Highcharts Gantt JS v11.2.0 (2023-10-30)
 *
 * Gantt series
 *
 * (c) 2016-2021 Lars A. V. Cabrera
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/gantt",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(t,i,e,o){t.hasOwnProperty(i)||(t[i]=o.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}e(i,"Gantt/Connection.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=i.defined,o=i.error,r=i.merge,s=i.objectEach,n=t.deg2rad,a=Math.max,h=Math.min;return function(){function t(t,i,e){this.chart=void 0,this.fromPoint=void 0,this.graphics=void 0,this.pathfinder=void 0,this.toPoint=void 0,this.init(t,i,e)}return t.prototype.init=function(t,i,e){this.fromPoint=t,this.toPoint=i,this.options=e,this.chart=t.series.chart,this.pathfinder=this.chart.pathfinder},t.prototype.renderPath=function(t,i,e){var o=this.chart,r=o.styledMode,s=o.pathfinder,n=!o.options.chart.forExport&&!1!==e,a={},h=this.graphics&&this.graphics.path;s.group||(s.group=o.renderer.g().addClass("highcharts-pathfinder-group").attr({zIndex:-1}).add(o.seriesGroup)),s.group.translate(o.plotLeft,o.plotTop),h&&h.renderer||(h=o.renderer.path().add(s.group),r||h.attr({opacity:0})),h.attr(i),a.d=t,r||(a.opacity=1),h[n?"animate":"attr"](a,e),this.graphics=this.graphics||{},this.graphics.path=h},t.prototype.addMarker=function(t,i,e){var o,r,s,a,h,l,d,c,p=this.fromPoint.series.chart,u=p.pathfinder,f=p.renderer,g="start"===t?this.fromPoint:this.toPoint,x=g.getPathfinderAnchorPoint(i);i.enabled&&((c="start"===t?e[1]:e[e.length-2])&&"M"===c[0]||"L"===c[0])&&(d={x:c[1],y:c[2]},r=g.getRadiansToVector(d,x),o=g.getMarkerVector(r,i.radius,x),s=-r/n,i.width&&i.height?(h=i.width,l=i.height):h=l=2*i.radius,this.graphics=this.graphics||{},a={x:o.x-h/2,y:o.y-l/2,width:h,height:l,rotation:s,rotationOriginX:o.x,rotationOriginY:o.y},this.graphics[t]?this.graphics[t].animate(a):(this.graphics[t]=f.symbol(i.symbol).addClass("highcharts-point-connecting-path-"+t+"-marker highcharts-color-"+this.fromPoint.colorIndex).attr(a).add(u.group),f.styledMode||this.graphics[t].attr({fill:i.color||this.fromPoint.color,stroke:i.lineColor,"stroke-width":i.lineWidth,opacity:0}).animate({opacity:1},g.series.options.animation)))},t.prototype.getPath=function(t){var i=this.pathfinder,e=this.chart,s=i.algorithms[t.type],n=i.chartObstacles;return"function"!=typeof s?(o('"'+t.type+'" is not a Pathfinder algorithm.'),{path:[],obstacles:[]}):(s.requiresObstacles&&!n&&(n=i.chartObstacles=i.getChartObstacles(t),e.options.connectors.algorithmMargin=t.algorithmMargin,i.chartObstacleMetrics=i.getObstacleMetrics(n)),s(this.fromPoint.getPathfinderAnchorPoint(t.startMarker),this.toPoint.getPathfinderAnchorPoint(t.endMarker),r({chartObstacles:n,lineObstacles:i.lineObstacles||[],obstacleMetrics:i.chartObstacleMetrics,hardBounds:{xMin:0,xMax:e.plotWidth,yMin:0,yMax:e.plotHeight},obstacleOptions:{margin:t.algorithmMargin},startDirectionX:i.getAlgorithmStartDirection(t.startMarker)},t)))},t.prototype.render=function(){var t=this.fromPoint,i=t.series,o=i.chart,s=o.pathfinder,n={},l=r(o.options.connectors,i.options.connectors,t.options.connectors,this.options);!o.styledMode&&(n.stroke=l.lineColor||t.color,n["stroke-width"]=l.lineWidth,l.dashStyle&&(n.dashstyle=l.dashStyle)),n.class="highcharts-point-connecting-path highcharts-color-"+t.colorIndex,e((l=r(n,l)).marker.radius)||(l.marker.radius=h(a(Math.ceil((l.algorithmMargin||8)/2)-1,1),5));var d=this.getPath(l),c=d.path;d.obstacles&&(s.lineObstacles=s.lineObstacles||[],s.lineObstacles=s.lineObstacles.concat(d.obstacles)),this.renderPath(c,n,i.options.animation),this.addMarker("start",r(l.marker,l.startMarker),c),this.addMarker("end",r(l.marker,l.endMarker),c)},t.prototype.destroy=function(){this.graphics&&(s(this.graphics,function(t){t.destroy()}),delete this.graphics)},t}()}),e(i,"Core/Axis/NavigatorAxisComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.isTouchDevice,o=i.addEvent,r=i.correctFloat,s=i.defined,n=i.isNumber,a=i.pick,h=[];function l(){this.navigatorAxis||(this.navigatorAxis=new c(this))}function d(t){var i=this.chart,o=i.options,r=o.navigator,n=this.navigatorAxis,a=i.zooming.pinchType,h=o.rangeSelector,l=i.zooming.type;if(this.isXAxis&&(r&&r.enabled||h&&h.enabled)){if("y"===l)t.zoomed=!1;else if((!e&&"xy"===l||e&&"xy"===a)&&this.options.range){var d=n.previousZoom;s(t.newMin)?n.previousZoom=[this.min,this.max]:d&&(t.newMin=d[0],t.newMax=d[1],n.previousZoom=void 0)}}void 0!==t.zoomed&&t.preventDefault()}var c=function(){function t(t){this.axis=t}return t.compose=function(t){i.pushUnique(h,t)&&(t.keepProps.push("navigatorAxis"),o(t,"init",l),o(t,"zoom",d))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,i,e,o){var h=this.axis,l=h.chart,d=a(e,h.translate(t,!0,!h.horiz)),c=a(o,h.translate(i,!0,!h.horiz)),p=l&&l.fixedRange,u=(h.pointRange||0)/2;return s(e)||(d=r(d+u)),s(o)||(c=r(c-u)),p&&h.dataMin&&h.dataMax&&(c>=h.dataMax&&(d=r(h.dataMax-p)),d<=h.dataMin&&(c=r(h.dataMin+p))),n(d)&&n(c)||(d=c=void 0),{min:d,max:c}},t}();return c}),e(i,"Stock/Navigator/NavigatorDefaults.js",[i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"]],function(t,i){var e=t.parse,o=i.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===o.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),e(i,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,i,e,o,r){void 0===r&&(r={});var s=r.width?r.width/2:e,n=Math.round(s/3)+.5;return[["M",-s-1,.5],["L",s,.5],["L",s,(o=r.height||o)+.5],["L",-s-1,o+.5],["L",-s-1,.5],["M",-n,4],["L",-n,o-3],["M",n-1,4],["L",n-1,o-3]]}}}),e(i,"Stock/Navigator/NavigatorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/Navigator/NavigatorSymbols.js"],i["Core/Renderer/RendererRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n){var a,h=t.defaultOptions,l=t.setOptions,d=i.isTouchDevice,c=s.getRendererType,p=n.addEvent,u=n.extend,f=n.merge,g=n.pick,x=[];function v(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function m(){var t,i,e,o,r=this.legend,s=this.navigator;if(s){i=r&&r.options,e=s.xAxis,o=s.yAxis;var n=s.scrollbarHeight,a=s.scrollButtonSize;this.inverted?(s.left=s.opposite?this.chartWidth-n-s.height:this.spacing[3]+n,s.top=this.plotTop+a):(s.left=g(e.left,this.plotLeft+a),s.top=s.navigatorOptions.top||this.chartHeight-s.height-n-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(i&&"bottom"===i.verticalAlign&&"proximate"!==i.layout&&i.enabled&&!i.floating?r.legendHeight+g(i.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&o&&(this.inverted?e.options.left=o.options.left=s.left:e.options.top=o.options.top=s.top,e.setAxisSize(),o.setAxisSize())}}function y(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this),g(t.redraw,!0)&&this.redraw(t.animation))}function b(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this))}function M(){var t=this.options,i=t.navigator,e=t.rangeSelector;if((i&&i.enabled||e&&e.enabled)&&(!d&&"x"===this.zooming.type||d&&"x"===this.zooming.pinchType))return!1}function k(t){var i=t.navigator;if(i&&t.xAxis[0]){var e=t.xAxis[0].getExtremes();i.render(e.min,e.max)}}function A(t){var i=t.options.navigator||{},e=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(i.enabled||e.enabled)&&(f(!0,this.options.navigator,i),f(!0,this.options.scrollbar,e),delete t.options.navigator,delete t.options.scrollbar)}function S(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,i,s,d){e.compose(t),a=s,n.pushUnique(x,i)&&(i.prototype.callbacks.push(k),p(i,"afterAddSeries",v),p(i,"afterSetChartSize",m),p(i,"afterUpdate",y),p(i,"beforeRender",b),p(i,"beforeShowResetZoom",M),p(i,"update",A)),n.pushUnique(x,d)&&p(d,"afterUpdate",S),n.pushUnique(x,c)&&u(c().prototype.symbols,r),n.pushUnique(x,l)&&u(h,{navigator:o})}}}),e(i,"Core/Axis/ScrollbarAxis.js",[i["Core/Utilities.js"]],function(t){var i,e=t.addEvent,o=t.defined,r=t.pick,s=t.pushUnique;return function(t){var i,n=[];function a(t){var i=r(t.options&&t.options.min,t.min),e=r(t.options&&t.options.max,t.max);return{axisMin:i,axisMax:e,scrollMin:o(t.dataMin)?Math.min(i,t.min,t.dataMin,r(t.threshold,1/0)):i,scrollMax:o(t.dataMax)?Math.max(e,t.max,t.dataMax,r(t.threshold,-1/0)):e}}function h(){var t=this.scrollbar,i=t&&!t.options.opposite,e=this.horiz?2:i?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[e]+=t.size+(t.options.margin||0))}function l(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new i(t.chart.renderer,t.options.scrollbar,t.chart),e(t.scrollbar,"changed",function(i){var e,r,s=a(t),n=s.axisMin,h=s.axisMax,l=s.scrollMin,d=s.scrollMax-l;if(o(n)&&o(h)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(e=l+d*this.to,r=l+d*this.from):(e=l+d*(1-this.from),r=l+d*(1-this.to)),this.shouldUpdateExtremes(i.DOMType)){var c="mousemove"!==i.DOMType&&"touchmove"!==i.DOMType&&void 0;t.setExtremes(r,e,!0,c,i)}else this.setRange(this.from,this.to)}}))}function d(){var t,i,e,r=a(this),s=r.scrollMin,n=r.scrollMax,h=this.scrollbar,l=this.axisTitleMargin+(this.titleOffset||0),d=this.chart.scrollbarsOffsets,c=this.options.margin||0;if(h&&d){if(this.horiz)this.opposite||(d[1]+=l),h.position(this.left,this.top+this.height+2+d[1]-(this.opposite?c:0),this.width,this.height),this.opposite||(d[1]+=c),t=1;else{this.opposite&&(d[0]+=l);var p=void 0;p=h.options.opposite?this.left+this.width+2+d[0]-(this.opposite?0:c):this.opposite?0:c,h.position(p,this.top,this.width,this.height),this.opposite&&(d[0]+=c),t=0}d[t]+=h.size+(h.options.margin||0),isNaN(s)||isNaN(n)||!o(this.min)||!o(this.max)||this.min===this.max?h.setRange(0,1):(i=(this.min-s)/(n-s),e=(this.max-s)/(n-s),this.horiz&&!this.reversed||!this.horiz&&this.reversed?h.setRange(i,e):h.setRange(1-e,1-i))}}t.compose=function(t,o){s(n,o)&&(i=o),s(n,t)&&(e(t,"afterGetOffset",h),e(t,"afterInit",l),e(t,"afterRender",d))}}(i||(i={})),i}),e(i,"Stock/Scrollbar/ScrollbarDefaults.js",[i["Core/Globals.js"]],function(t){return t.isTouchDevice,{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),e(i,"Stock/Scrollbar/Scrollbar.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/ScrollbarAxis.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var s=t.defaultOptions,n=r.addEvent,a=r.correctFloat,h=r.defined,l=r.destroyObjectProperties,d=r.fireEvent,c=r.merge,p=r.pick,u=r.removeEvent,f=function(){function t(t,i,e){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(t,i,e)}return t.compose=function(i){e.compose(i,t)},t.swapXY=function(t,i){return i&&t.forEach(function(t){for(var i,e=t.length,o=0;o<e;o+=2)"number"==typeof(i=t[o+1])&&(t[o+1]=t[o+2],t[o+2]=i)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],e=this.scrollbarButtons,o=this.scrollbarGroup.element,r=this.track.element,s=this.mouseDownHandler.bind(this),a=this.mouseMoveHandler.bind(this),h=this.mouseUpHandler.bind(this),l=[[e[t[0]].element,"click",this.buttonToMinClick.bind(this)],[e[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[r,"click",this.trackClick.bind(this)],[o,"mousedown",s],[o.ownerDocument,"mousemove",a],[o.ownerDocument,"mouseup",h]];i.hasTouch&&l.push([o,"touchstart",s],[o.ownerDocument,"touchmove",a],[o.ownerDocument,"touchend",h]),l.forEach(function(t){n.apply(null,t)}),this._events=l},t.prototype.buttonToMaxClick=function(t){var i=(this.to-this.from)*p(this.options.step,.2);this.updatePosition(this.from+i,this.to+i),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var i=a(this.to-this.from)*p(this.options.step,.2);this.updatePosition(a(this.from-i),a(this.to-i)),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var i=this.options,e=i.minWidth>this.calculatedWidth?i.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-e),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-e)}},t.prototype.destroy=function(){var t=this,i=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(i){t[i]&&t[i].destroy&&(t[i]=t[i].destroy())}),i&&t===i.scrollbar&&(i.scrollbar=null,l(i.scrollbarButtons))},t.prototype.drawScrollbarButton=function(i){var e=this.renderer,o=this.scrollbarButtons,r=this.options,s=this.size,n=e.g().add(this.group);if(o.push(n),r.buttonsEnabled){var a=e.rect().addClass("highcharts-scrollbar-button").add(n);this.chart.styledMode||a.attr({stroke:r.buttonBorderColor,"stroke-width":r.buttonBorderWidth,fill:r.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:s+1,height:s+1,r:r.buttonBorderRadius},a.strokeWidth()));var h=e.path(t.swapXY([["M",s/2+(i?-1:1),s/2-3],["L",s/2+(i?-1:1),s/2+3],["L",s/2+(i?2:-2),s/2]],r.vertical)).addClass("highcharts-scrollbar-arrow").add(o[i]);this.chart.styledMode||h.attr({fill:r.buttonArrowColor})}},t.prototype.init=function(t,i,e){this.scrollbarButtons=[],this.renderer=t,this.userOptions=i,this.options=c(o,s.scrollbar,i),this.options.margin=p(this.options.margin,10),this.chart=e,this.size=p(this.options.size,this.options.height),i.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var i=this.chart.pointer.normalize(t),e=this.cursorToScrollbarPosition(i);this.chartX=e.chartX,this.chartY=e.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var i,e=this.chart.pointer.normalize(t),o=this.options.vertical?"chartY":"chartX",r=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][o])&&(i=this.cursorToScrollbarPosition(e)[o]-this[o],this.hasDragged=!0,this.updatePosition(r[0]+i,r[1]+i),this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,i,e,o){var r=this.options,s=r.buttonsEnabled,n=r.margin,a=void 0===n?0:n,h=r.vertical,l=this.rendered?"animate":"attr",d=o,c=0;this.group.show(),this.x=t,this.y=i+this.trackBorderWidth,this.width=e,this.height=o,this.xOffset=d,this.yOffset=c,h?(this.width=this.yOffset=e=c=this.size,this.xOffset=d=0,this.yOffset=c=s?this.size:0,this.barWidth=o-(s?2*e:0),this.x=t+=a):(this.height=o=this.size,this.xOffset=d=s?this.size:0,this.barWidth=e-(s?2*o:0),this.y=this.y+a),this.group[l]({translateX:t,translateY:this.y}),this.track[l]({width:e,height:o}),this.scrollbarButtons[1][l]({translateX:h?0:e-d,translateY:h?o-c:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){u.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var i=this.renderer,e=this.options,o=this.size,r=this.chart.styledMode,s=i.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=s,this.track=i.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:o,width:o}).add(s),r||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var n=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-n%2/2,y:-n%2/2}),this.scrollbarGroup=i.g().add(s),this.scrollbar=i.rect().addClass("highcharts-scrollbar-thumb").attr({height:o-n,width:o-n,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=i.path(t.swapXY([["M",-3,o/4],["L",-3,2*o/3],["M",0,o/4],["L",0,2*o/3],["M",3,o/4],["L",3,2*o/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),r||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,i){var e,o,r=this.options,s=r.vertical,n=r.minWidth,l=this.barWidth,d=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(h(l)){var c=l*Math.min(i,1);e=Math.ceil(l*(t=Math.max(t,0))),this.calculatedWidth=o=a(c-e),o<n&&(e=(l-n+o)*t,o=n);var p=Math.floor(e+this.xOffset+this.yOffset),u=o/2-.5;this.from=t,this.to=i,s?(this.scrollbarGroup[d]({translateY:p}),this.scrollbar[d]({height:o}),this.scrollbarRifles[d]({translateY:u}),this.scrollbarTop=p,this.scrollbarLeft=0):(this.scrollbarGroup[d]({translateX:p}),this.scrollbar[d]({width:o}),this.scrollbarRifles[d]({translateX:u}),this.scrollbarLeft=p,this.scrollbarTop=0),o<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===r.showFull&&(t<=0&&i>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return p(this.options.liveRedraw,i.svg&&!i.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!h(t)},t.prototype.trackClick=function(t){var i=this.chart.pointer.normalize(t),e=this.to-this.from,o=this.y+this.scrollbarTop,r=this.x+this.scrollbarLeft;this.options.vertical&&i.chartY>o||!this.options.vertical&&i.chartX>r?this.updatePosition(this.from+e,this.to+e):this.updatePosition(this.from-e,this.to-e),d(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,c(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,i){i>1&&(t=a(1-a(i-t)),i=1),t<0&&(i=a(i-t),t=0),this.from=t,this.to=i},t.defaultOptions=o,t}();return s.scrollbar=c(!0,f.defaultOptions,s.scrollbar),f}),e(i,"Stock/Navigator/Navigator.js",[i["Core/Axis/Axis.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorComposition.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s,n){var a=i.defaultOptions,h=e.hasTouch,l=e.isTouchDevice,d=n.addEvent,c=n.clamp,p=n.correctFloat,u=n.defined,f=n.destroyObjectProperties,g=n.erase,x=n.extend,v=n.find,m=n.fireEvent,y=n.isArray,b=n.isNumber,M=n.merge,k=n.pick,A=n.removeEvent,S=n.splat;function w(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];var o=[].filter.call(i,b);if(o.length)return Math[t].apply(0,o)}return function(){function i(t){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.range=void 0,this.rendered=void 0,this.scrollbarHeight=0,this.scrollButtonSize=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(t)}return i.compose=function(t,e,o){r.compose(t,e,i,o)},i.prototype.drawHandle=function(t,i,e,o){var r=this.navigatorOptions.handles.height;this.handles[i][o](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-r)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-r/2-1)})},i.prototype.drawOutline=function(t,i,e,o){var r,s,n=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),h=a/2,l=a%2/2,d=this.scrollButtonSize,c=this.size,p=this.top,u=this.height,f=p-h,g=p+u,x=this.left;e?(r=p+i+l,i=p+t+l,s=[["M",x+u,p-d-l],["L",x+u,r],["L",x,r],["M",x,i],["L",x+u,i],["L",x+u,p+c+d]],n&&s.push(["M",x+u,r-h],["L",x+u,i+h])):(x-=d,t+=x+d-l,i+=x+d-l,s=[["M",x,f],["L",t,f],["L",t,g],["M",i,g],["L",i,f],["L",x+c+2*d,p+h]],n&&s.push(["M",t-h,f],["L",i+h,f])),this.outline[o]({d:s})},i.prototype.drawMasks=function(t,i,e,o){var r,s,n,a,h=this.left,l=this.top,d=this.height;e?(n=[h,h,h],a=[l,l+t,l+i],s=[d,d,d],r=[t,i-t,this.size-i]):(n=[h,h+t,h+i],a=[l,l,l],s=[t,i-t,this.size-i],r=[d,d,d]),this.shades.forEach(function(t,i){t[o]({x:n[i],y:a[i],width:s[i],height:r[i]})})},i.prototype.renderElements=function(){var t=this,i=t.navigatorOptions,e=i.maskInside,o=t.chart,r=o.inverted,s=o.renderer,n={cursor:r?"ns-resize":"ew-resize"},a=t.navigatorGroup=s.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!e,e,!e].forEach(function(e,r){var h=s.rect().addClass("highcharts-navigator-mask"+(1===r?"-inside":"-outside")).add(a);o.styledMode||(h.attr({fill:e?i.maskFill:"rgba(0,0,0,0)"}),1===r&&h.css(n)),t.shades[r]=h}),t.outline=s.path().addClass("highcharts-navigator-outline").add(a),o.styledMode||t.outline.attr({"stroke-width":i.outlineWidth,stroke:i.outlineColor}),i.handles&&i.handles.enabled){var h=i.handles,l=h.height,d=h.width;[0,1].forEach(function(i){t.handles[i]=s.symbol(h.symbols[i],-d/2-1,0,d,l,h),o.inverted&&t.handles[i].attr({rotation:90,rotationOriginX:Math.floor(-d/2),rotationOriginY:(l+d)/2}),t.handles[i].attr({zIndex:7-i}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][i]).add(a),o.styledMode||t.handles[i].attr({fill:h.backgroundColor,stroke:h.borderColor,"stroke-width":h.lineWidth}).css(n)})}},i.prototype.update=function(t){(this.series||[]).forEach(function(t){t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),M(!0,this.chart.options.navigator,t),this.init(this.chart)},i.prototype.render=function(t,i,e,o){var r,s,n,a,h,l=this.chart,d=this.xAxis,f=d.pointRange||0,g=d.navigatorAxis.fake?l.xAxis[0]:d,x=this.navigatorEnabled,v=this.rendered,y=l.inverted,M=l.xAxis[0].minRange,A=l.xAxis[0].options.maxRange,S=this.scrollButtonSize,w=this.scrollbarHeight;if(!this.hasDragged||u(e)){if(t=p(t-f/2),i=p(i+f/2),!b(t)||!b(i)){if(!v)return;e=0,o=k(d.width,g.width)}this.left=k(d.left,l.plotLeft+S+(y?l.plotWidth:0));var C=this.size=a=k(d.len,(y?l.plotHeight:l.plotWidth)-2*S);r=y?w:a+2*S,e=k(e,d.toPixels(t,!0)),o=k(o,d.toPixels(i,!0)),b(e)&&Math.abs(e)!==1/0||(e=0,o=r);var B=d.toValue(e,!0),O=d.toValue(o,!0),E=Math.abs(p(O-B));E<M?this.grabbedLeft?e=d.toPixels(O-M-f,!0):this.grabbedRight&&(o=d.toPixels(B+M+f,!0)):u(A)&&p(E-f)>A&&(this.grabbedLeft?e=d.toPixels(O-A-f,!0):this.grabbedRight&&(o=d.toPixels(B+A+f,!0))),this.zoomedMax=c(Math.max(e,o),0,C),this.zoomedMin=c(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,o),0,C),this.range=this.zoomedMax-this.zoomedMin,C=Math.round(this.zoomedMax);var P=Math.round(this.zoomedMin);x&&(this.navigatorGroup.attr({visibility:"inherit"}),h=v&&!this.hasDragged?"animate":"attr",this.drawMasks(P,C,y,h),this.drawOutline(P,C,y,h),this.navigatorOptions.handles.enabled&&(this.drawHandle(P,0,y,h),this.drawHandle(C,1,y,h))),this.scrollbar&&(y?(n=this.top-S,s=this.left-w+(x||!g.opposite?0:(g.titleOffset||0)+g.axisTitleMargin),w=a+2*S):(n=this.top+(x?this.height:-w),s=this.left-S),this.scrollbar.position(s,n,r,w),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1))),this.rendered=!0,m(this,"afterRender")}},i.prototype.addMouseEvents=function(){var t,i,e=this,o=e.chart,r=o.container,s=[];e.mouseMoveHandler=t=function(t){e.onMouseMove(t)},e.mouseUpHandler=i=function(t){e.onMouseUp(t)},(s=e.getPartsEvents("mousedown")).push(d(o.renderTo,"mousemove",t),d(r.ownerDocument,"mouseup",i)),h&&(s.push(d(o.renderTo,"touchmove",t),d(r.ownerDocument,"touchend",i)),s.concat(e.getPartsEvents("touchstart"))),e.eventsToUnbind=s,e.series&&e.series[0]&&s.push(d(e.series[0].xAxis,"foundExtremes",function(){o.navigator.modifyNavigatorAxisExtremes()}))},i.prototype.getPartsEvents=function(t){var i=this,e=[];return["shades","handles"].forEach(function(o){i[o].forEach(function(r,s){e.push(d(r.element,t,function(t){i[o+"Mousedown"](t,s)}))})}),e},i.prototype.shadesMousedown=function(t,i){t=this.chart.pointer.normalize(t);var e,o,r,s,n=this.chart,a=this.xAxis,h=this.zoomedMin,l=this.size,d=this.range,c=this.left,p=t.chartX;n.inverted&&(p=t.chartY,c=this.top),1===i?(this.grabbedCenter=p,this.fixedWidth=d,this.dragOffset=p-h):(s=p-c-d/2,0===i?s=Math.max(0,s):2===i&&s+d>=l&&(s=l-d,this.reversedExtremes?(s-=d,o=this.getUnionExtremes().dataMin):e=this.getUnionExtremes().dataMax),s!==h&&(this.fixedWidth=d,u((r=a.navigatorAxis.toFixedRange(s,s+d,o,e)).min)&&n.xAxis[0].setExtremes(Math.min(r.min,r.max),Math.max(r.min,r.max),!0,null,{trigger:"navigator"})))},i.prototype.handlesMousedown=function(t,i){t=this.chart.pointer.normalize(t);var e=this.chart,o=e.xAxis[0],r=this.reversedExtremes;0===i?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=r?o.min:o.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=r?o.max:o.min),e.fixedRange=null},i.prototype.onMouseMove=function(t){var i,e=this,o=e.chart,r=e.navigatorSize,s=e.range,n=e.dragOffset,a=o.inverted,h=e.left;(!t.touches||0!==t.touches[0].pageX)&&(i=(t=o.pointer.normalize(t)).chartX,a&&(h=e.top,i=t.chartY),e.grabbedLeft?(e.hasDragged=!0,e.render(0,0,i-h,e.otherHandlePos)):e.grabbedRight?(e.hasDragged=!0,e.render(0,0,e.otherHandlePos,i-h)):e.grabbedCenter&&(e.hasDragged=!0,i<n?i=n:i>r+n-s&&(i=r+n-s),e.render(0,0,i-n,i-n+s)),e.hasDragged&&e.scrollbar&&k(e.scrollbar.options.liveRedraw,!l&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){e.onMouseUp(t)},0)))},i.prototype.onMouseUp=function(t){var i,e,o,r,s,n,a=this.chart,h=this.xAxis,l=this.scrollbar,d=t.DOMEvent||t,c=a.inverted,p=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!l||!l.hasDragged)||"scrollbar"===t.trigger)&&(o=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?r=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(s=this.fixedExtreme),this.zoomedMax===this.size&&(s=this.reversedExtremes?o.dataMin:o.dataMax),0===this.zoomedMin&&(r=this.reversedExtremes?o.dataMax:o.dataMin),u((n=h.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,r,s)).min)&&a.xAxis[0].setExtremes(Math.min(n.min,n.max),Math.max(n.min,n.max),!0,!this.hasDragged&&null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:d})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&b(this.zoomedMin)&&b(this.zoomedMax)&&(e=Math.round(this.zoomedMin),i=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,i,c,p),this.outline&&this.drawOutline(e,i,c,p),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,c,p),this.drawHandle(i,1,c,p)))},i.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},i.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){A(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&A(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},i.prototype.init=function(i){var e=i.options,r=e.navigator||{},n=r.enabled,a=e.scrollbar||{},h=a.enabled,l=n&&r.height||0,c=h&&a.height||0,p=a.buttonsEnabled&&c||0;this.handles=[],this.shades=[],this.chart=i,this.setBaseSeries(),this.height=l,this.scrollbarHeight=c,this.scrollButtonSize=p,this.scrollbarEnabled=h,this.navigatorEnabled=n,this.navigatorOptions=r,this.scrollbarOptions=a,this.opposite=k(r.opposite,!!(!n&&i.inverted));var u=this,f=u.baseSeries,g=i.xAxis.length,x=i.yAxis.length,v=f&&f[0]&&f[0].xAxis||i.xAxis[0]||{options:{}};if(i.isDirtyBox=!0,u.navigatorEnabled?(u.xAxis=new t(i,M({breaks:v.options.breaks,ordinal:v.options.ordinal},r.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},i.inverted?{offsets:[p,0,-p,0],width:l}:{offsets:[0,-p,0,p],height:l}),"xAxis"),u.yAxis=new t(i,M(r.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:x,isInternal:!0,reversed:k(r.yAxis&&r.yAxis.reversed,i.yAxis[0]&&i.yAxis[0].reversed,!1),zoomEnabled:!1},i.inverted?{width:l}:{height:l}),"yAxis"),f||r.series.data?u.updateNavigatorSeries(!1):0===i.series.length&&(u.unbindRedraw=d(i,"beforeRedraw",function(){i.series.length>0&&!u.series&&(u.setBaseSeries(),u.unbindRedraw())})),u.reversedExtremes=i.inverted&&!u.xAxis.reversed||!i.inverted&&u.xAxis.reversed,u.renderElements(),u.addMouseEvents()):(u.xAxis={chart:i,navigatorAxis:{fake:!0},translate:function(t,e){var o=i.xAxis[0],r=o.getExtremes(),s=o.len-2*p,n=w("min",o.options.min,r.dataMin),a=w("max",o.options.max,r.dataMax)-n;return e?t*a/s+n:s*(t-n)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},u.xAxis.navigatorAxis.axis=u.xAxis,u.xAxis.navigatorAxis.toFixedRange=o.prototype.toFixedRange.bind(u.xAxis.navigatorAxis)),i.options.scrollbar.enabled){var m=M(i.options.scrollbar,{vertical:i.inverted});!b(m.margin)&&u.navigatorEnabled&&(m.margin=i.inverted?-3:3),i.scrollbar=u.scrollbar=new s(i.renderer,m,i),d(u.scrollbar,"changed",function(t){var i=u.size,e=i*this.to,o=i*this.from;u.hasDragged=u.scrollbar.hasDragged,u.render(0,0,o,e),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){u.onMouseUp(t)})})}u.addBaseSeriesEvents(),u.addChartEvents()},i.prototype.getUnionExtremes=function(t){var i,e=this.chart.xAxis[0],o=this.xAxis,r=o.options,s=e.options;return t&&null===e.dataMin||(i={dataMin:k(r&&r.min,w("min",s.min,e.dataMin,o.dataMin,o.min)),dataMax:k(r&&r.max,w("max",s.max,e.dataMax,o.dataMax,o.max))}),i},i.prototype.setBaseSeries=function(t,i){var e=this.chart,o=this.baseSeries=[];t=t||e.options&&e.options.navigator.baseSeries||(e.series.length?v(e.series,function(t){return!t.options.isInternal}).index:0),(e.series||[]).forEach(function(i,e){!i.options.isInternal&&(i.options.showInNavigator||(e===t||i.options.id===t)&&!1!==i.options.showInNavigator)&&o.push(i)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,i)},i.prototype.updateNavigatorSeries=function(t,i){var e,o,r,s=this,n=s.chart,h=s.baseSeries,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},d=s.series=(s.series||[]).filter(function(t){var i=t.baseSeries;return!(0>h.indexOf(i))||(i&&(A(i,"updatedData",s.updatedDataHandler),delete i.navigatorSeries),t.chart&&t.destroy(),!1)}),c=s.navigatorOptions.series;h&&h.length&&h.forEach(function(t){var p=t.navigatorSeries,u=x({color:t.color,visible:t.visible},y(c)?a.navigator.series:c);if(!p||!1!==s.navigatorOptions.adaptToUpdatedData){l.name="Navigator "+h.length,r=(e=t.options||{}).navigatorOptions||{},u.dataLabels=S(u.dataLabels),(o=M(e,l,u,r)).pointRange=k(u.pointRange,r.pointRange,a.plotOptions[o.type||"line"].pointRange);var f=r.data||u.data;s.hasNavigatorData=s.hasNavigatorData||!!f,o.data=f||e.data&&e.data.slice(0),p&&p.options?p.update(o,i):(t.navigatorSeries=n.initSeries(o),t.navigatorSeries.baseSeries=t,d.push(t.navigatorSeries))}}),(c.data&&!(h&&h.length)||y(c))&&(s.hasNavigatorData=!1,(c=S(c)).forEach(function(t,i){l.name="Navigator "+(d.length+1),(o=M(a.navigator.series,{color:n.series[i]&&!n.series[i].options.isInternal&&n.series[i].color||n.options.colors[i]||n.options.colors[0]},l,t)).data=t.data,o.data&&(s.hasNavigatorData=!0,d.push(n.initSeries(o)))})),t&&this.addBaseSeriesEvents()},i.prototype.addBaseSeriesEvents=function(){var t=this,i=this,e=i.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(d(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(e){e.eventsToUnbind.push(d(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(d(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(d(e,"updatedData",t.updatedDataHandler)),e.eventsToUnbind.push(d(e,"remove",function(){this.navigatorSeries&&(g(i.series,this.navigatorSeries),u(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},i.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,i){return Math.min(t,i.xData&&i.xData.length?i.xData[0]:t)},t)},i.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var i=this.getUnionExtremes(!0);i&&(i.dataMin!==t.min||i.dataMax!==t.max)&&(t.min=i.dataMin,t.max=i.dataMax)}},i.prototype.modifyBaseAxisExtremes=function(){var t,i,e=this.chart.navigator,o=this.getExtremes(),r=o.min,s=o.max,n=o.dataMin,a=o.dataMax,h=s-r,l=e.stickToMin,d=e.stickToMax,c=k(this.options.overscroll,0),p=e.series&&e.series[0],u=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(l&&(t=(i=n)+h),d&&(t=a+c,l||(i=Math.max(n,t-h,e.getBaseSeriesMin(p&&p.xData?p.xData[0]:-Number.MAX_VALUE)))),u&&(l||d)&&b(i)&&(this.min=this.userMin=i,this.max=this.userMax=t)),e.stickToMin=e.stickToMax=null},i.prototype.updatedDataHandler=function(){var t=this.chart.navigator,i=this.navigatorSeries,e=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=k(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,e),t.stickToMin=t.shouldStickToMin(this,t),i&&!t.hasNavigatorData&&(i.options.pointStart=this.xData[0],i.setData(this.options.data,!1,null,!1))},i.prototype.shouldStickToMin=function(t,i){var e=i.getBaseSeriesMin(t.xData[0]),o=t.xAxis,r=o.max,s=o.min,n=o.options.range;return!!(b(r)&&b(s))&&(n&&r-e>0?r-e<n:s<=e)},i.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(d(this.chart,"redraw",function(){var t=this.navigator,i=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);i&&t.render(i.min,i.max)}),d(this.chart,"getMargins",function(){var t=this.navigator,i=t.opposite?"plotTop":"marginBottom";this.inverted&&(i=t.opposite?"marginRight":"plotLeft"),this[i]=(this[i]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}))},i.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(g(this.chart.xAxis,this.xAxis),g(this.chart.axes,this.xAxis)),this.yAxis&&(g(this.chart.yAxis,this.yAxis),g(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(i){t[i]&&t[i].destroy&&t[i].destroy(),t[i]=null}),[this.handles].forEach(function(t){f(t)})},i}()}),e(i,"Series/PathUtilities.js",[],function(){function t(t,i){for(var e=[],o=0;o<t.length;o++){var r=t[o][1],s=t[o][2];if("number"==typeof r&&"number"==typeof s){if(0===o)e.push(["M",r,s]);else if(o===t.length-1)e.push(["L",r,s]);else if(i){var n=t[o-1],a=t[o+1];if(n&&a){var h=n[1],l=n[2],d=a[1],c=a[2];if("number"==typeof h&&"number"==typeof d&&"number"==typeof l&&"number"==typeof c&&h!==d&&l!==c){var p=h<d?1:-1,u=l<c?1:-1;e.push(["L",r-p*Math.min(Math.abs(r-h),i),s-u*Math.min(Math.abs(s-l),i)],["C",r,s,r,s,r+p*Math.min(Math.abs(r-d),i),s+u*Math.min(Math.abs(s-c),i)])}}}else e.push(["L",r,s])}}return e}return{applyRadius:t,getLinkPath:{default:function(i){var e=i.x1,o=i.y1,r=i.x2,s=i.y2,n=i.width,a=void 0===n?0:n,h=i.inverted,l=void 0!==h&&h,d=i.radius,c=i.parentVisible,p=[["M",e,o],["L",e,o],["C",e,o,e,s,e,s],["L",e,s],["C",e,o,e,s,e,s],["L",e,s]];return c?t([["M",e,o],["L",e+a*(l?-.5:.5),o],["L",e+a*(l?-.5:.5),s],["L",r,s]],d):p},straight:function(t){var i=t.x1,e=t.y1,o=t.x2,r=t.y2,s=t.width,n=t.inverted;return t.parentVisible?[["M",i,e],["L",i+(void 0===s?0:s)*(void 0!==n&&n?-1:1),r],["L",o,r]]:[["M",i,e],["L",i,r],["L",i,r]]},curved:function(t){var i=t.x1,e=t.y1,o=t.x2,r=t.y2,s=t.offset,n=void 0===s?0:s,a=t.width,h=void 0===a?0:a,l=t.inverted,d=void 0!==l&&l;return t.parentVisible?[["M",i,e],["C",i+n,e,i-n+h*(d?-1:1),r,i+h*(d?-1:1),r],["L",o,r]]:[["M",i,e],["C",i,e,i,r,i,r],["L",o,r]]}}}}),e(i,"Gantt/PathfinderAlgorithms.js",[i["Series/PathUtilities.js"],i["Core/Utilities.js"]],function(t,i){var e=i.pick,o=Math.min,r=Math.max,s=Math.abs;function n(t,i,e){for(var o,r,s=i-1e-7,n=e||0,a=t.length-1;n<=a;)if((r=s-t[o=a+n>>1].xMin)>0)n=o+1;else{if(!(r<0))return o;a=o-1}return n>0?n-1:0}function a(t,i){for(var e,o=n(t,i.x+1)+1;o--;)if(t[o].xMax>=i.x&&(e=t[o],i.x<=e.xMax&&i.x>=e.xMin&&i.y<=e.yMax&&i.y>=e.yMin))return o;return -1}function h(t){var i=[];if(t.length){i.push(["M",t[0].start.x,t[0].start.y]);for(var e=0;e<t.length;++e)i.push(["L",t[e].end.x,t[e].end.y])}return i}function l(t,i){t.yMin=r(t.yMin,i.yMin),t.yMax=o(t.yMax,i.yMax),t.xMin=r(t.xMin,i.xMin),t.xMax=o(t.xMax,i.xMax)}var d=function(i,o,r){var n,l,d,c,p,u=[],f=r.chartObstacles,g=a(f,i),x=a(f,o),v=e(r.startDirectionX,s(o.x-i.x)>s(o.y-i.y))?"x":"y";function m(t,i,e,o,r){var s={x:t.x,y:t.y};return s[i]=e[o||i]+(r||0),s}function y(t,i,e){var o=s(i[e]-t[e+"Min"])>s(i[e]-t[e+"Max"]);return m(i,e,t,e+(o?"Max":"Min"),o?1:-1)}x>-1?(n={start:d=y(f[x],o,v),end:o},p=d):p=o,g>-1&&(d=y(l=f[g],i,v),u.push({start:i,end:d}),d[v]>=i[v]==d[v]>=p[v]&&(c=i[v="y"===v?"x":"y"]<o[v],u.push({start:d,end:m(d,v,l,v+(c?"Max":"Min"),c?1:-1)}),v="y"===v?"x":"y"));var b=u.length?u[u.length-1].end:i;d=m(b,v,p),u.push({start:b,end:d});var M=m(d,v="y"===v?"x":"y",p);return u.push({start:d,end:M}),u.push(n),{path:t.applyRadius(h(u),r.radius),obstacles:u}};function c(t,i,d){var c,p,u,f,g,x,v,m=e(d.startDirectionX,s(i.x-t.x)>s(i.y-t.y)),y=m?"x":"y",b=[],M=d.obstacleMetrics,k=o(t.x,i.x)-M.maxWidth-10,A=r(t.x,i.x)+M.maxWidth+10,S=o(t.y,i.y)-M.maxHeight-10,w=r(t.y,i.y)+M.maxHeight+10,C=!1,B=d.chartObstacles,O=n(B,A),E=n(B,k);function P(t,i,e){var r,s,a,h,l=t.x<i.x?1:-1;t.x<i.x?(r=t,s=i):(r=i,s=t),t.y<i.y?(h=t,a=i):(h=i,a=t);for(var d=l<0?o(n(B,s.x),B.length-1):0;B[d]&&(l>0&&B[d].xMin<=s.x||l<0&&B[d].xMax>=r.x);){if(B[d].xMin<=s.x&&B[d].xMax>=r.x&&B[d].yMin<=a.y&&B[d].yMax>=h.y){if(e)return{y:t.y,x:t.x<i.x?B[d].xMin-1:B[d].xMax+1,obstacle:B[d]};return{x:t.x,y:t.y<i.y?B[d].yMin-1:B[d].yMax+1,obstacle:B[d]}}d+=l}return i}function T(t,i,e,o,r){var n=r.soft,a=r.hard,h=o?"x":"y",l={x:i.x,y:i.y},d={x:i.x,y:i.y},c=t[h+"Max"]>=n[h+"Max"],p=t[h+"Min"]<=n[h+"Min"],u=t[h+"Max"]>=a[h+"Max"],f=t[h+"Min"]<=a[h+"Min"],g=s(t[h+"Min"]-i[h]),x=s(t[h+"Max"]-i[h]),v=10>s(g-x)?i[h]<e[h]:x<g;d[h]=t[h+"Min"],l[h]=t[h+"Max"];var m=P(i,d,o)[h]!==d[h],y=P(i,l,o)[h]!==l[h];return v=m?!y||v:!y&&v,v=p?!c||v:!c&&v,v=f?!u||v:!u&&v}for((O=a(B=B.slice(E,O+1),i))>-1&&(c=B[O],p=i,u=o(c.xMax-p.x,p.x-c.xMin)<o(c.yMax-p.y,p.y-c.yMin),f=T(c,p,t,u,{soft:d.hardBounds,hard:d.hardBounds}),b.push({end:i,start:v=u?{y:p.y,x:c[f?"xMax":"xMin"]+(f?1:-1)}:{x:p.x,y:c[f?"yMax":"yMin"]+(f?1:-1)}}),i=v);(O=a(B,i))>-1;)x=i[y]-t[y]<0,(v={x:i.x,y:i.y})[y]=B[O][x?y+"Max":y+"Min"]+(x?1:-1),b.push({end:i,start:v}),i=v;return{path:h(g=(g=function t(i,e,s){if(i.x===e.x&&i.y===e.y)return[];var n,h,c,p,u,f,g,x=s?"x":"y",v=d.obstacleOptions.margin,m={soft:{xMin:k,xMax:A,yMin:S,yMax:w},hard:d.hardBounds};return(u=a(B,i))>-1?(p=T(u=B[u],i,e,s,m),l(u,d.hardBounds),g=s?{y:i.y,x:u[p?"xMax":"xMin"]+(p?1:-1)}:{x:i.x,y:u[p?"yMax":"yMin"]+(p?1:-1)},(f=a(B,g))>-1&&(l(f=B[f],d.hardBounds),g[x]=p?r(u[x+"Max"]-v+1,(f[x+"Min"]+u[x+"Max"])/2):o(u[x+"Min"]+v-1,(f[x+"Max"]+u[x+"Min"])/2),i.x===g.x&&i.y===g.y?(C&&(g[x]=p?r(u[x+"Max"],f[x+"Max"])+1:o(u[x+"Min"],f[x+"Min"])-1),C=!C):C=!1),h=[{start:i,end:g}]):(n=P(i,{x:s?e.x:i.x,y:s?i.y:e.y},s),h=[{start:i,end:{x:n.x,y:n.y}}],n[s?"x":"y"]!==e[s?"x":"y"]&&(p=T(n.obstacle,n,e,!s,m),l(n.obstacle,d.hardBounds),c={x:s?n.x:n.obstacle[p?"xMax":"xMin"]+(p?1:-1),y:s?n.obstacle[p?"yMax":"yMin"]+(p?1:-1):n.y},s=!s,h=h.concat(t({x:n.x,y:n.y},c,s)))),h=h.concat(t(h[h.length-1].end,e,!s))}(t,i,m)).concat(b.reverse())),obstacles:g}}return d.requiresObstacles=!0,c.requiresObstacles=!0,{fastAvoid:c,straight:function(t,i){return{path:[["M",t.x,t.y],["L",i.x,i.y]],obstacles:[{start:t,end:i}]}},simpleConnect:d}}),e(i,"Gantt/ConnectorsDefaults.js",[],function(){return{connectors:{type:"straight",radius:0,lineWidth:1,marker:{enabled:!1,align:"center",verticalAlign:"middle",inside:!1,lineWidth:1},startMarker:{symbol:"diamond"},endMarker:{symbol:"arrow-filled"}}}}),e(i,"Gantt/PathfinderComposition.js",[i["Gantt/ConnectorsDefaults.js"],i["Core/Defaults.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r=i.setOptions,s=e.defined,n=e.error,a=e.merge,h=e.pushUnique;function l(t){var i=t.shapeArgs;if(i)return{xMin:i.x||0,xMax:(i.x||0)+(i.width||0),yMin:i.y||0,yMax:(i.y||0)+(i.height||0)};var e=t.graphic&&t.graphic.getBBox();return e?{xMin:t.plotX-e.width/2,xMax:t.plotX+e.width/2,yMin:t.plotY-e.height/2,yMax:t.plotY+e.height/2}:null}return function(i){var e=[];function o(t){var i,e,o=l(this);switch(t.align){case"right":i="xMax";break;case"left":i="xMin"}switch(t.verticalAlign){case"top":e="yMin";break;case"bottom":e="yMax"}return{x:i?o[i]:(o.xMin+o.xMax)/2,y:e?o[e]:(o.yMin+o.yMax)/2}}function d(t,i){var e;return!s(i)&&(e=l(this))&&(i={x:(e.xMin+e.xMax)/2,y:(e.yMin+e.yMax)/2}),Math.atan2(i.y-t.y,t.x-i.x)}function c(t,i,e){for(var o=2*Math.PI,r=l(this),s=r.xMax-r.xMin,n=r.yMax-r.yMin,a=Math.atan2(n,s),h=s/2,d=n/2,c=r.xMin+h,p=r.yMin+d,u={x:c,y:p},f=t,g=1,x=!1,v=1,m=1;f<-Math.PI;)f+=o;for(;f>Math.PI;)f-=o;return g=Math.tan(f),f>-a&&f<=a?(m=-1,x=!0):f>a&&f<=Math.PI-a?m=-1:f>Math.PI-a||f<=-(Math.PI-a)?(v=-1,x=!0):v=-1,x?(u.x+=v*h,u.y+=m*h*g):(u.x+=v*(n/(2*g)),u.y+=m*d),e.x!==c&&(u.x=e.x),e.y!==p&&(u.y=e.y),{x:u.x+i*Math.cos(f),y:u.y-i*Math.sin(f)}}i.compose=function(i,s,l){if(h(e,i)&&i.prototype.callbacks.push(function(t){!1!==t.options.connectors.enabled&&((t.options.pathfinder||t.series.reduce(function(t,i){return i.options&&a(!0,i.options.connectors=i.options.connectors||{},i.options.pathfinder),t||i.options&&i.options.pathfinder},!1))&&(a(!0,t.options.connectors=t.options.connectors||{},t.options.pathfinder),n('WARNING: Pathfinder options have been renamed. Use "chart.connectors" or "series.connectors" instead.')),this.pathfinder=new s(this),this.pathfinder.update(!0))}),h(e,l)){var p=l.prototype;p.getMarkerVector=c,p.getPathfinderAnchorPoint=o,p.getRadiansToVector=d}h(e,r)&&r(t)}}(o||(o={})),o}),e(i,"Gantt/Pathfinder.js",[i["Gantt/Connection.js"],i["Gantt/PathfinderAlgorithms.js"],i["Gantt/PathfinderComposition.js"],i["Core/Series/Point.js"],i["Core/Utilities.js"]],function(t,i,e,o,r){var s=r.addEvent,n=r.defined,a=r.pick,h=r.splat,l=Math.max,d=Math.min,c=function(){function i(t){this.chart=void 0,this.chartObstacles=void 0,this.chartObstacleMetrics=void 0,this.connections=void 0,this.group=void 0,this.lineObstacles=void 0,this.init(t)}return i.compose=function(t,o){e.compose(t,i,o)},i.prototype.init=function(t){this.chart=t,this.connections=[],s(t,"redraw",function(){this.pathfinder.update()})},i.prototype.update=function(i){var e=this.chart,r=this,s=r.connections;r.connections=[],e.series.forEach(function(i){i.visible&&!i.options.isInternal&&i.points.forEach(function(i){var s,n,a=i.options;a&&a.dependency&&(a.connect=a.dependency);var l=(null===(s=i.options)||void 0===s?void 0:s.connect)&&h(i.options.connect);i.visible&&!1!==i.isInside&&l&&l.forEach(function(s){(n=e.get("string"==typeof s?s:s.to))instanceof o&&n.series.visible&&n.visible&&!1!==n.isInside&&r.connections.push(new t(i,n,"string"==typeof s?{}:s))})})});for(var n=0,a=void 0,l=void 0,d=s.length,c=r.connections.length;n<d;++n){l=!1;var p=s[n];for(a=0;a<c;++a){var u=r.connections[a];if((p.options&&p.options.type)===(u.options&&u.options.type)&&p.fromPoint===u.fromPoint&&p.toPoint===u.toPoint){u.graphics=p.graphics,l=!0;break}}l||p.destroy()}delete this.chartObstacles,delete this.lineObstacles,r.renderConnections(i)},i.prototype.renderConnections=function(t){t?this.chart.series.forEach(function(t){var i=function(){var i=t.chart.pathfinder;(i&&i.connections||[]).forEach(function(i){i.fromPoint&&i.fromPoint.series===t&&i.render()}),t.pathfinderRemoveRenderEvent&&(t.pathfinderRemoveRenderEvent(),delete t.pathfinderRemoveRenderEvent)};!1===t.options.animation?i():t.pathfinderRemoveRenderEvent=s(t,"afterAnimate",i)}):this.connections.forEach(function(t){t.render()})},i.prototype.getChartObstacles=function(t){for(var i,e=this.chart.series,o=a(t.algorithmMargin,0),r=[],s=0,h=e.length;s<h;++s)if(e[s].visible&&!e[s].options.isInternal)for(var c=0,p=e[s].points.length,u=void 0,f=void 0;c<p;++c)(f=e[s].points[c]).visible&&(u=function(t){var i=t.shapeArgs;if(i)return{xMin:i.x||0,xMax:(i.x||0)+(i.width||0),yMin:i.y||0,yMax:(i.y||0)+(i.height||0)};var e=t.graphic&&t.graphic.getBBox();return e?{xMin:t.plotX-e.width/2,xMax:t.plotX+e.width/2,yMin:t.plotY-e.height/2,yMax:t.plotY+e.height/2}:null}(f))&&r.push({xMin:u.xMin-o,xMax:u.xMax+o,yMin:u.yMin-o,yMax:u.yMax+o});return r=r.sort(function(t,i){return t.xMin-i.xMin}),n(t.algorithmMargin)||(i=t.algorithmMargin=function(t){for(var i,e=t.length,o=[],r=0;r<e;++r)for(var s=r+1;s<e;++s)(i=function t(i,e,o){var r=a(o,10),s=i.yMax+r>e.yMin-r&&i.yMin-r<e.yMax+r,n=i.xMax+r>e.xMin-r&&i.xMin-r<e.xMax+r,h=s?i.xMin>e.xMax?i.xMin-e.xMax:e.xMin-i.xMax:1/0,l=n?i.yMin>e.yMax?i.yMin-e.yMax:e.yMin-i.yMax:1/0;return n&&s?r?t(i,e,Math.floor(r/2)):1/0:d(h,l)}(t[r],t[s]))<80&&o.push(i);return o.push(80),l(Math.floor(o.sort(function(t,i){return t-i})[Math.floor(o.length/10)]/2-1),1)}(r),r.forEach(function(t){t.xMin-=i,t.xMax+=i,t.yMin-=i,t.yMax+=i})),r},i.prototype.getObstacleMetrics=function(t){for(var i,e,o=0,r=0,s=t.length;s--;)i=t[s].xMax-t[s].xMin,e=t[s].yMax-t[s].yMin,o<i&&(o=i),r<e&&(r=e);return{maxHeight:r,maxWidth:o}},i.prototype.getAlgorithmStartDirection=function(t){var i="left"!==t.align&&"right"!==t.align,e="top"!==t.verticalAlign&&"bottom"!==t.verticalAlign;return i?!!e&&void 0:!!e||void 0},i}();return c.prototype.algorithms=i,c}),e(i,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),e(i,"Stock/RangeSelector/RangeSelectorComposition.js",[i["Core/Defaults.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r=t.defaultOptions,s=t.setOptions,n=e.addEvent,a=e.defined,h=e.extend,l=e.find,d=e.isNumber,c=e.merge,p=e.pick,u=[],f=[];function g(){var t,i,e=this.range,o=e.type,r=this.max,s=this.chart.time,n=function(t,i){var e="year"===o?"FullYear":"Month",r=new s.Date(t),n=s.get(e,r);return s.set(e,r,n+i),n===s.get(e,r)&&s.set("Date",r,0),r.getTime()-t};d(e)?(t=r-e,i=e):e&&(t=r+n(r,-(e.count||1)),this.chart&&(this.chart.fixedRange=r-t));var a=p(this.dataMin,Number.MIN_VALUE);return d(t)||(t=a),t<=a&&(t=a,void 0===i&&(i=n(t,e.count)),this.newMax=Math.min(t+i,p(this.dataMax,Number.MAX_VALUE))),d(r)?!d(e)&&e&&e._offsetMin&&(t+=e._offsetMin):t=void 0,t}function x(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new o(this))}function v(){var t=this.axes,i=this.rangeSelector;if(i){d(i.deferredYTDClick)&&(i.clickButton(i.deferredYTDClick),delete i.deferredYTDClick),t.forEach(function(t){t.updateNames(),t.setScale()}),this.getAxisMargins(),i.render();var e=i.options.verticalAlign;i.options.floating||("bottom"===e?this.extraBottomMargin=!0:"middle"===e||(this.extraTopMargin=!0))}}function m(t){var i,e,o,r,s=t.rangeSelector,a=function(){s&&(i=t.xAxis[0].getExtremes(),e=t.legend,r=s&&s.options.verticalAlign,d(i.min)&&s.render(i.min,i.max),e.display&&"top"===r&&r===e.options.verticalAlign&&(o=c(t.spacingBox),"vertical"===e.options.layout?o.y=t.plotTop:o.y+=s.getHeight(),e.group.placed=!1,e.align(o)))};s&&(l(u,function(i){return i[0]===t})||u.push([t,[n(t.xAxis[0],"afterSetExtremes",function(t){s&&s.render(t.min,t.max)}),n(t,"redraw",a)]]),a())}function y(){for(var t=0,i=u.length;t<i;++t){var e=u[t];if(e[0]===this){e[1].forEach(function(t){return t()}),u.splice(t,1);return}}}function b(){var t=this.rangeSelector;if(t){var i=t.getHeight();this.extraTopMargin&&(this.plotTop+=i),this.extraBottomMargin&&(this.marginBottom+=i)}}function M(){var t=this.rangeSelector;if(t&&!t.options.floating){t.render();var i=t.options.verticalAlign;"bottom"===i?this.extraBottomMargin=!0:"middle"!==i&&(this.extraTopMargin=!0)}}function k(t){var i=t.options.rangeSelector,e=this.extraBottomMargin,r=this.extraTopMargin,s=this.rangeSelector;if(i&&i.enabled&&!a(s)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=s=new o(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,s){m(this);var n=i&&i.verticalAlign||s.options&&s.options.verticalAlign;s.options.floating||("bottom"===n?this.extraBottomMargin=!0:"middle"===n||(this.extraTopMargin=!0)),(this.extraBottomMargin!==e||this.extraTopMargin!==r)&&(this.isDirtyBox=!0)}}return{compose:function(t,a,l){o=l,e.pushUnique(f,t)&&(t.prototype.minFromRange=g),e.pushUnique(f,a)&&(n(a,"afterGetContainer",x),n(a,"beforeRender",v),n(a,"destroy",y),n(a,"getMargins",b),n(a,"render",M),n(a,"update",k),a.prototype.callbacks.push(m)),e.pushUnique(f,s)&&(h(r,{rangeSelector:i.rangeSelector}),h(r.lang,i.lang))}}}),e(i,"Stock/RangeSelector/RangeSelector.js",[i["Core/Axis/Axis.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorComposition.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s){var n=i.defaultOptions,a=s.addEvent,h=s.createElement,l=s.css,d=s.defined,c=s.destroyObjectProperties,p=s.discardElement,u=s.extend,f=s.fireEvent,g=s.isNumber,x=s.merge,v=s.objectEach,m=s.pad,y=s.pick,b=s.pInt,M=s.splat,k=function(){function i(t){this.buttons=void 0,this.buttonOptions=i.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=t,this.init(t)}return i.compose=function(t,e){o.compose(t,e,i)},i.prototype.clickButton=function(i,e){var o,r,s,n,h,l,c,p=this.chart,u=this.buttonOptions[i],x=p.xAxis[0],v=p.scroller&&p.scroller.getUnionExtremes()||x||{},m=u.type,b=u.dataGrouping,k=v.dataMin,A=v.dataMax,S=x&&Math.round(Math.min(x.max,y(A,x.max))),w=u._range,C=!0;if(null!==k&&null!==A){if(p.fixedRange=w,this.setSelected(i),b&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(x||{chart:this.chart},b,!1),this.frozenStates=u.preserveDataGrouping),"month"===m||"year"===m)x?(l={range:u,max:S,chart:p,dataMin:k,dataMax:A},o=x.minFromRange.call(l),g(l.newMax)&&(S=l.newMax),C=!1):w=u;else if(w)S=Math.min((o=Math.max(S-w,k))+w,A),C=!1;else if("ytd"===m){if(x)(void 0===A||void 0===k)&&(k=Number.MAX_VALUE,A=Number.MIN_VALUE,p.series.forEach(function(t){var i=t.xData;i&&(k=Math.min(i[0],k),A=Math.max(i[i.length-1],A))}),e=!1),o=s=(c=this.getYTDExtremes(A,k,p.time.useUTC)).min,S=c.max;else{this.deferredYTDClick=i;return}}else"all"===m&&x&&(p.navigator&&p.navigator.baseSeries[0]&&(p.navigator.baseSeries[0].xAxis.options.range=void 0),o=k,S=A);C&&u._offsetMin&&d(o)&&(o+=u._offsetMin),u._offsetMax&&d(S)&&(S+=u._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=i+1),x?x.setExtremes(o,S,y(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:u}):(h=(r=M(p.options.xAxis)[0]).range,r.range=w,n=r.min,r.min=s,a(p,"load",function(){r.range=h,r.min=n})),f(this,"afterBtnClick")}},i.prototype.setSelected=function(t){this.selected=this.options.selected=t},i.prototype.init=function(t){var i=this,e=t.options.rangeSelector,o=e.buttons||i.defaultButtons.slice(),r=e.selected,s=function(){var t=i.minInput,e=i.maxInput;t&&t.blur&&f(t,"blur"),e&&e.blur&&f(e,"blur")};i.chart=t,i.options=e,i.buttons=[],i.buttonOptions=o,this.eventsToUnbind=[],this.eventsToUnbind.push(a(t.container,"mousedown",s)),this.eventsToUnbind.push(a(t,"resize",s)),o.forEach(i.computeButtonRange),void 0!==r&&o[r]&&this.clickButton(r,!1),this.eventsToUnbind.push(a(t,"load",function(){t.xAxis&&t.xAxis[0]&&a(t.xAxis[0],"setExtremes",function(e){this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==e.trigger&&"updatedData"!==e.trigger&&i.forcedDataGrouping&&!i.frozenStates&&this.setDataGrouping(!1,!1)})}))},i.prototype.updateButtonStates=function(){var t=this,i=this.chart,e=this.dropdown,o=i.xAxis[0],r=Math.round(o.max-o.min),s=!o.hasVisibleSeries,n=24*36e5,a=i.scroller&&i.scroller.getUnionExtremes()||o,h=a.dataMin,l=a.dataMax,d=t.getYTDExtremes(l,h,i.time.useUTC),c=d.min,p=d.max,u=t.selected,f=t.options.allButtonsEnabled,x=t.buttons,v=g(u);t.buttonOptions.forEach(function(i,a){var d=i._range,g=i.type,m=i.count||1,y=x[a],b=i._offsetMax-i._offsetMin,M=a===u,k=d>l-h,A=d<o.minRange,S=0,w=!1,C=!1,B=d===r;("month"===g||"year"===g)&&r+36e5>=({month:28,year:365})[g]*n*m-b&&r-36e5<=({month:31,year:366})[g]*n*m+b?B=!0:"ytd"===g?(B=p-c+b===r,w=!M):"all"===g&&(B=o.max-o.min>=l-h,C=!M&&v&&B);var O=!f&&(k||A||C||s),E=M&&B||B&&!v&&!w||M&&t.frozenStates;O?S=3:E&&(v=!0,S=2),y.state!==S&&(y.setState(S),e&&(e.options[a+1].disabled=O,2===S&&(e.selectedIndex=a+1)),0===S&&u===a&&t.setSelected())})},i.prototype.computeButtonRange=function(t){var i=t.type,e=t.count||1,o={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};o[i]?t._range=o[i]*e:("month"===i||"year"===i)&&(t._range=24*({month:30,year:365})[i]*36e5*e),t._offsetMin=y(t.offsetMin,0),t._offsetMax=y(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin},i.prototype.getInputValue=function(t){var i="min"===t?this.minInput:this.maxInput,e=this.chart.options.rangeSelector,o=this.chart.time;return i?("text"===i.type&&e.inputDateParser||this.defaultInputDateParser)(i.value,o.useUTC,o):0},i.prototype.setInputValue=function(t,i){var e=this.options,o=this.chart.time,r="min"===t?this.minInput:this.maxInput,s="min"===t?this.minDateBox:this.maxDateBox;if(r){var n=r.getAttribute("data-hc-time"),a=d(n)?Number(n):void 0;if(d(i)){var h=a;d(h)&&r.setAttribute("data-hc-time-previous",h),r.setAttribute("data-hc-time",i),a=i}r.value=o.dateFormat(this.inputTypeFormats[r.type]||e.inputEditDateFormat,a),s&&s.attr({text:o.dateFormat(e.inputDateFormat,a)})}},i.prototype.setInputExtremes=function(t,i,e){var o="min"===t?this.minInput:this.maxInput;if(o){var r=this.inputTypeFormats[o.type],s=this.chart.time;if(r){var n=s.dateFormat(r,i);o.min!==n&&(o.min=n);var a=s.dateFormat(r,e);o.max!==a&&(o.max=a)}}},i.prototype.showInput=function(t){var i="min"===t?this.minDateBox:this.maxDateBox,e="min"===t?this.minInput:this.maxInput;if(e&&i&&this.inputGroup){var o="text"===e.type,r=this.inputGroup,s=r.translateX,n=void 0===s?0:s,a=r.translateY,h=void 0===a?0:a,d=i.x,c=void 0===d?0:d,p=i.width,u=void 0===p?0:p,f=i.height,g=void 0===f?0:f,x=this.options.inputBoxWidth;l(e,{width:o?u+(x?-2:20)+"px":"auto",height:g-2+"px",border:"2px solid silver"}),o&&x?l(e,{left:n+c+"px",top:h+"px"}):l(e,{left:Math.min(Math.round(c+n-(e.offsetWidth-u)/2),this.chart.chartWidth-e.offsetWidth)+"px",top:h-(e.offsetHeight-g)/2+"px"})}},i.prototype.hideInput=function(t){var i="min"===t?this.minInput:this.maxInput;i&&l(i,{top:"-9999em",border:0,width:"1px",height:"1px"})},i.prototype.defaultInputDateParser=function(t,i,o){var r,s=t.split("/").join("-").split(" ").join("T");if(-1===s.indexOf("T")&&(s+="T00:00"),i)s+="Z";else if(e.isSafari&&!((r=s).length>6&&(r.lastIndexOf("-")===r.length-6||r.lastIndexOf("+")===r.length-6))){var n=new Date(s).getTimezoneOffset()/60;s+=n<=0?"+".concat(m(-n),":00"):"-".concat(m(n),":00")}var a=Date.parse(s);if(!g(a)){var h=t.split("-");a=Date.UTC(b(h[0]),b(h[1])-1,b(h[2]))}return o&&i&&g(a)&&(a+=o.getTimezoneOffset(a)),a},i.prototype.drawInput=function(t){var i=this.chart,o=this.div,r=this.inputGroup,s=this,a=i.renderer.style||{},d=i.renderer,c=i.options.rangeSelector,p=n.lang,f="min"===t;function v(){var e=s.maxInput,o=s.minInput,r=i.xAxis[0],n=i.scroller&&i.scroller.getUnionExtremes()||r,a=n.dataMin,h=n.dataMax,l=s.getInputValue(t);l!==Number(M.getAttribute("data-hc-time-previous"))&&g(l)&&(M.setAttribute("data-hc-time-previous",l),f&&e&&g(a)?l>Number(e.getAttribute("data-hc-time"))?l=void 0:l<a&&(l=a):o&&g(h)&&(l<Number(o.getAttribute("data-hc-time"))?l=void 0:l>h&&(l=h)),void 0!==l&&r.setExtremes(f?l:r.min,f?r.max:l,void 0,void 0,{trigger:"rangeSelectorInput"}))}var m=p[f?"rangeSelectorFrom":"rangeSelectorTo"]||"",y=d.label(m,0).addClass("highcharts-range-label").attr({padding:m?2:0,height:m?c.inputBoxHeight:0}).add(r),b=d.label("",0).addClass("highcharts-range-input").attr({padding:2,width:c.inputBoxWidth,height:c.inputBoxHeight,"text-align":"center"}).on("click",function(){s.showInput(t),s[t+"Input"].focus()});i.styledMode||b.attr({stroke:c.inputBoxBorderColor,"stroke-width":1}),b.add(r);var M=h("input",{name:t,className:"highcharts-range-selector"},void 0,o);M.setAttribute("type",function(t){if(-1!==t.indexOf("%L"))return"text";var i=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(i){return -1!==t.indexOf("%"+i)}),e=["H","k","I","l","M","S"].some(function(i){return -1!==t.indexOf("%"+i)});return i&&e?"datetime-local":i?"date":e?"time":"text"}(c.inputDateFormat||"%e %b %Y")),i.styledMode||(y.css(x(a,c.labelStyle)),b.css(x({color:"#333333"},a,c.inputStyle)),l(M,u({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:a.fontSize,fontFamily:a.fontFamily,top:"-9999em"},c.inputStyle))),M.onfocus=function(){s.showInput(t)},M.onblur=function(){M===e.doc.activeElement&&v(),s.hideInput(t),s.setInputValue(t),M.blur()};var k=!1;return M.onchange=function(){k||(v(),s.hideInput(t),M.blur())},M.onkeypress=function(t){13===t.keyCode&&v()},M.onkeydown=function(t){k=!0,(38===t.keyCode||40===t.keyCode)&&v()},M.onkeyup=function(){k=!1},{dateBox:b,input:M,label:y}},i.prototype.getPosition=function(){var t=this.chart,i=t.options.rangeSelector,e="top"===i.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:e+i.buttonPosition.y,inputTop:e+i.inputPosition.y-10}},i.prototype.getYTDExtremes=function(t,i,e){var o=this.chart.time,r=new o.Date(t),s=o.get("FullYear",r),n=e?o.Date.UTC(s,0,1):+new o.Date(s,0,1),a=r.getTime();return{max:Math.min(t||a,a),min:Math.max(i,n)}},i.prototype.render=function(t,i){var e=this.chart,o=e.renderer,r=e.container,s=e.options,n=s.rangeSelector,a=y(s.chart.style&&s.chart.style.zIndex,0)+1,l=n.inputEnabled,c=this.rendered;if(!1!==n.enabled){if(!c&&(this.group=o.g("range-selector-group").attr({zIndex:7}).add(),this.div=h("div",void 0,{position:"relative",height:0,zIndex:a}),this.buttonOptions.length&&this.renderButtons(),r.parentNode&&r.parentNode.insertBefore(this.div,r),l)){this.inputGroup=o.g("input-group").add(this.group);var p=this.drawInput("min");this.minDateBox=p.dateBox,this.minLabel=p.label,this.minInput=p.input;var u=this.drawInput("max");this.maxDateBox=u.dateBox,this.maxLabel=u.label,this.maxInput=u.input}if(l){this.setInputValue("min",t),this.setInputValue("max",i);var f=e.scroller&&e.scroller.getUnionExtremes()||e.xAxis[0]||{};if(d(f.dataMin)&&d(f.dataMax)){var g=e.xAxis[0].minRange||0;this.setInputExtremes("min",f.dataMin,Math.min(f.dataMax,this.getInputValue("max"))-g),this.setInputExtremes("max",Math.max(f.dataMin,this.getInputValue("min"))+g,f.dataMax)}if(this.inputGroup){var x=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(t){if(t){var i=t.getBBox().width;i&&(t.attr({x:x}),x+=i+n.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},i.prototype.renderButtons=function(){var t=this,i=this.buttons,o=this.chart,r=this.options,s=n.lang,l=o.renderer,d=x(r.buttonTheme),c=d&&d.states,p=d.width||28;delete d.width,delete d.states,this.buttonGroup=l.g("range-selector-buttons").add(this.group);var u=this.dropdown=h("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);a(u,"touchstart",function(){u.style.fontSize="16px"}),[[e.isMS?"mouseover":"mouseenter"],[e.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(e){var o=e[0],r=e[1];a(u,o,function(){var e=i[t.currentButtonIndex()];e&&f(e.element,r||o)})}),this.zoomText=l.label(s&&s.rangeSelectorZoom||"",0).attr({padding:r.buttonTheme.padding,height:r.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(r.labelStyle),d["stroke-width"]=y(d["stroke-width"],0)),h("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,u),this.buttonOptions.forEach(function(e,o){h("option",{textContent:e.title||e.text},void 0,u),i[o]=l.button(e.text,0,0,function(i){var r,s=e.events&&e.events.click;s&&(r=s.call(e,i)),!1!==r&&t.clickButton(o),t.isActive=!0},d,c&&c.hover,c&&c.select,c&&c.disabled).attr({"text-align":"center",width:p}).add(t.buttonGroup),e.title&&i[o].attr("title",e.title)})},i.prototype.alignElements=function(){var t=this,i=this.buttonGroup,e=this.buttons,o=this.chart,r=this.group,s=this.inputGroup,n=this.options,a=this.zoomText,h=o.options,l=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions,d=n.buttonPosition,c=n.inputPosition,p=n.verticalAlign,u=function(i,e){return l&&t.titleCollision(o)&&"top"===p&&"right"===e.align&&e.y-i.getBBox().height-12<(l.y||0)+(l.height||0)+o.spacing[0]?-40:0},f=o.plotLeft;if(r&&d&&c){var g=d.x-o.spacing[3];if(i){if(this.positionButtons(),!this.initialButtonGroupWidth){var x=0;a&&(x+=a.getBBox().width+5),e.forEach(function(t,i){x+=t.width||0,i!==e.length-1&&(x+=n.buttonSpacing)}),this.initialButtonGroupWidth=x}f-=o.spacing[3],this.updateButtonStates();var v=u(i,d);this.alignButtonGroup(v),r.placed=i.placed=o.hasLoaded}var m=0;s&&(m=u(s,c),"left"===c.align?g=f:"right"===c.align&&(g=-Math.max(o.axisOffset[1],-m)),s.align({y:c.y,width:s.getBBox().width,align:c.align,x:c.x+g-2},!0,o.spacingBox),s.placed=o.hasLoaded),this.handleCollision(m),r.align({verticalAlign:p},!0,o.spacingBox);var b=r.alignAttr.translateY,M=r.getBBox().height+20,k=0;if("bottom"===p){var A=o.legend&&o.legend.options;k=b-(M=M+(A&&"bottom"===A.verticalAlign&&A.enabled&&!A.floating?o.legend.legendHeight+y(A.margin,10):0)-20)-(n.floating?0:n.y)-(o.titleOffset?o.titleOffset[2]:0)-10}"top"===p?(n.floating&&(k=0),o.titleOffset&&o.titleOffset[0]&&(k=o.titleOffset[0]),k+=o.margin[0]-o.spacing[0]||0):"middle"===p&&(c.y===d.y?k=b:(c.y||d.y)&&(c.y<0||d.y<0?k-=Math.min(c.y,d.y):k=b-M)),r.translate(n.x,n.y+Math.floor(k));var S=this.minInput,w=this.maxInput,C=this.dropdown;n.inputEnabled&&S&&w&&(S.style.marginTop=r.translateY+"px",w.style.marginTop=r.translateY+"px"),C&&(C.style.marginTop=r.translateY+"px")}},i.prototype.alignButtonGroup=function(t,i){var e=this.chart,o=this.options,r=this.buttonGroup;this.buttons;var s=o.buttonPosition,n=e.plotLeft-e.spacing[3],a=s.x-e.spacing[3];"right"===s.align?a+=t-n:"center"===s.align&&(a-=n/2),r&&r.align({y:s.y,width:y(i,this.initialButtonGroupWidth),align:s.align,x:a},!0,e.spacingBox)},i.prototype.positionButtons=function(){var t=this.buttons,i=this.chart,e=this.options,o=this.zoomText,r=i.hasLoaded?"animate":"attr",s=e.buttonPosition,n=i.plotLeft,a=n;o&&"hidden"!==o.visibility&&(o[r]({x:y(n+s.x,n)}),a+=s.x+o.getBBox().width+5);for(var h=0,l=this.buttonOptions.length;h<l;++h)"hidden"!==t[h].visibility?(t[h][r]({x:a}),a+=(t[h].width||0)+e.buttonSpacing):t[h][r]({x:n})},i.prototype.handleCollision=function(t){var i=this,e=this.chart,o=this.buttonGroup,r=this.inputGroup,s=this.options,n=s.buttonPosition,a=s.dropdown,h=s.inputPosition,l=function(){var t=0;return i.buttons.forEach(function(i){var e=i.getBBox();e.width>t&&(t=e.width)}),t},d=function(i){if(r&&o){var e=r.alignAttr.translateX+r.alignOptions.x-t+r.getBBox().x+2,s=r.alignOptions.width,a=o.alignAttr.translateX+o.getBBox().x;return a+i>e&&e+s>a&&n.y<h.y+r.getBBox().height}return!1},c=function(){r&&o&&r.attr({translateX:r.alignAttr.translateX+(e.axisOffset[1]>=-t?0:-t),translateY:r.alignAttr.translateY+o.getBBox().height+10})};if(o){if("always"===a){this.collapseButtons(t),d(l())&&c();return}"never"===a&&this.expandButtons()}r&&o?h.align===n.align||d(this.initialButtonGroupWidth+20)?"responsive"===a?(this.collapseButtons(t),d(l())&&c()):c():"responsive"===a&&this.expandButtons():o&&"responsive"===a&&(this.initialButtonGroupWidth>e.plotWidth?this.collapseButtons(t):this.expandButtons())},i.prototype.collapseButtons=function(t){var i=this.buttons,e=this.buttonOptions,o=this.chart,r=this.dropdown,s=this.options,n=this.zoomText,a=o.userOptions.rangeSelector&&o.userOptions.rangeSelector.buttonTheme||{},h=function(t){return{text:t?"".concat(t," ▾"):"▾",width:"auto",paddingLeft:y(s.buttonTheme.paddingLeft,a.padding,8),paddingRight:y(s.buttonTheme.paddingRight,a.padding,8)}};n&&n.hide();var l=!1;e.forEach(function(t,e){var o=i[e];2!==o.state?o.hide():(o.show(),o.attr(h(t.text)),l=!0)}),l||(r&&(r.selectedIndex=0),i[0].show(),i[0].attr(h(this.zoomText&&this.zoomText.textStr)));var d=s.buttonPosition.align;this.positionButtons(),("right"===d||"center"===d)&&this.alignButtonGroup(t,i[this.currentButtonIndex()].getBBox().width),this.showDropdown()},i.prototype.expandButtons=function(){var t=this.buttons,i=this.buttonOptions,e=this.options,o=this.zoomText;this.hideDropdown(),o&&o.show(),i.forEach(function(i,o){var r=t[o];r.show(),r.attr({text:i.text,width:e.buttonTheme.width||28,paddingLeft:y(e.buttonTheme.paddingLeft,"unset"),paddingRight:y(e.buttonTheme.paddingRight,"unset")}),r.state<2&&r.setState(0)}),this.positionButtons()},i.prototype.currentButtonIndex=function(){var t=this.dropdown;return t&&t.selectedIndex>0?t.selectedIndex-1:0},i.prototype.showDropdown=function(){var t=this.buttonGroup,i=this.buttons,e=this.chart,o=this.dropdown;if(t&&o){var r=t.translateX,s=t.translateY,n=i[this.currentButtonIndex()].getBBox();l(o,{left:e.plotLeft+(void 0===r?0:r)+"px",top:(void 0===s?0:s)+.5+"px",width:n.width+"px",height:n.height+"px"}),this.hasVisibleDropdown=!0}},i.prototype.hideDropdown=function(){var t=this.dropdown;t&&(l(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},i.prototype.getHeight=function(){var t=this.options,i=this.group,e=t.inputPosition,o=t.buttonPosition,r=t.y,s=o.y,n=e.y,a=0;return t.height?t.height:(this.alignElements(),a=i?i.getBBox(!0).height+13+r:0,(n<0&&s<0||n>0&&s>0)&&(a+=Math.abs(Math.min(n,s))),a)},i.prototype.titleCollision=function(t){return!(t.options.title.text||t.options.subtitle.text)},i.prototype.update=function(t){var i=this.chart;x(!0,i.options.rangeSelector,t),this.destroy(),this.init(i),this.render()},i.prototype.destroy=function(){var t=this,e=t.minInput,o=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(function(t){return t()}),t.eventsToUnbind=void 0),c(t.buttons),e&&(e.onfocus=e.onblur=e.onchange=null),o&&(o.onfocus=o.onblur=o.onchange=null),v(t,function(e,o){e&&"chart"!==o&&(e instanceof r?e.destroy():e instanceof window.HTMLElement&&p(e)),e!==i.prototype[o]&&(t[o]=null)},this)},i}();return u(k.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),k}),e(i,"Extensions/StaticScale.js",[i["Core/Utilities.js"]],function(t){var i=t.addEvent,e=t.defined,o=t.isNumber,r=t.pick,s=t.pushUnique,n=[];function a(){var t=this.chart.options.chart;!this.horiz&&o(this.options.staticScale)&&(!t.height||t.scrollablePlotArea&&t.scrollablePlotArea.minHeight)&&(this.staticScale=this.options.staticScale)}function h(){if("adjustHeight"!==this.redrawTrigger){for(var t=0,i=this.axes||[];t<i.length;t++)!function(t){var i=t.chart,o=!!i.initiatedScale&&i.options.animation,s=t.options.staticScale;if(t.staticScale&&e(t.min)){var n=r(t.brokenAxis&&t.brokenAxis.unitLength,t.max+t.tickInterval-t.min)*s,a=(n=Math.max(n,s))-i.plotHeight;!i.scrollablePixelsY&&Math.abs(a)>=1&&(i.plotHeight=n,i.redrawTrigger="adjustHeight",i.setSize(void 0,i.chartHeight+a,o)),t.series.forEach(function(t){var e=t.sharedClipKey&&i.sharedClips[t.sharedClipKey];e&&e.attr(i.inverted?{width:i.plotHeight}:{height:i.plotHeight})})}}(i[t]);this.initiatedScale=!0}this.redrawTrigger=null}return{compose:function(t,e){if(s(n,t)&&i(t,"afterSetOptions",a),s(n,e)){var o=e.prototype;o.adjustHeight=h,i(e,"render",o.adjustHeight)}}}}),e(i,"Series/XRange/XRangeSeriesDefaults.js",[i["Core/Utilities.js"]],function(t){var i=t.correctFloat,e=t.isNumber,o=t.isObject;return{colorByPoint:!0,dataLabels:{formatter:function(){var t=this.point.partialFill;if(o(t)&&(t=t.amount),e(t)&&t>0)return i(100*t)+"%"},inside:!0,verticalAlign:"middle"},tooltip:{headerFormat:'<span style="font-size: 0.8em">{point.x} - {point.x2}</span><br/>',pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.yCategory}</b><br/>'},borderRadius:3,pointRange:0}}),e(i,"Series/XRange/XRangePoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)}),r=t.seriesTypes.column.prototype.pointClass,s=i.extend,n=function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.options=void 0,i.series=void 0,i}return o(i,t),i.getColorByCategory=function(t,i){var e=t.options.colors||t.chart.options.colors,o=e?e.length:t.chart.options.chart.colorCount,r=i.y%o,s=e&&e[r];return{colorIndex:r,color:s}},i.prototype.resolveColor=function(){var t=this.series;if(t.options.colorByPoint&&!this.options.color){var e=i.getColorByCategory(t,this);t.chart.styledMode||(this.color=e.color),this.options.colorIndex||(this.colorIndex=e.colorIndex)}else this.color||(this.color=t.color)},i.prototype.init=function(){return t.prototype.init.apply(this,arguments),this.y||(this.y=0),this},i.prototype.setState=function(){t.prototype.setState.apply(this,arguments),this.series.drawPoint(this,this.series.getAnimationVerb())},i.prototype.getLabelConfig=function(){var i=t.prototype.getLabelConfig.call(this),e=this.series.yAxis.categories;return i.x2=this.x2,i.yCategory=this.yCategory=e&&e[this.y],i.key=this.category||this.name,i},i.prototype.isValid=function(){return"number"==typeof this.x&&"number"==typeof this.x2},i}(r);return s(n.prototype,{ttBelow:!1,tooltipDateKeys:["x","x2"]}),n}),e(i,"Series/XRange/XRangeSeries.js",[i["Core/Globals.js"],i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"],i["Series/XRange/XRangeSeriesDefaults.js"],i["Series/XRange/XRangePoint.js"]],function(t,i,e,o,r,s){var n,a=this&&this.__extends||(n=function(t,i){return(n=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}n(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),h=t.noop,l=i.parse,d=e.seriesTypes.column,c=o.addEvent,p=o.clamp,u=o.defined,f=o.extend,g=o.find,x=o.isNumber,v=o.isObject,m=o.merge,y=o.pick,b=o.relativeLength,M=[];function k(){var t,i;if(this.isXAxis){t=y(this.dataMax,-Number.MAX_VALUE);for(var e=0,o=this.series;e<o.length;e++){var r=o[e];if(r.x2Data)for(var s=0,n=r.x2Data;s<n.length;s++){var a=n[s];a&&a>t&&(t=a,i=!0)}}i&&(this.dataMax=t)}}var A=function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.data=void 0,i.options=void 0,i.points=void 0,i}return a(i,t),i.compose=function(t){o.pushUnique(M,t)&&c(t,"afterGetSeriesExtremes",k)},i.prototype.init=function(){t.prototype.init.apply(this,arguments),this.options.stacking=void 0},i.prototype.getColumnMetrics=function(){var i=this,e=function(){for(var t=0,e=i.chart.series;t<e.length;t++){var o=e[t],r=o.xAxis;o.xAxis=o.yAxis,o.yAxis=r}};e();var o=t.prototype.getColumnMetrics.call(this);return e(),o},i.prototype.cropData=function(i,e,o,r){var s=t.prototype.cropData.call(this,this.x2Data,e,o,r);return s.xData=i.slice(s.start,s.end),s},i.prototype.findPointIndex=function(t){var i,e=this.cropStart,o=this.points,r=t.id;if(r){var s=g(o,function(t){return t.id===r});i=s?s.index:void 0}if(void 0===i){var s=g(o,function(i){return i.x===t.x&&i.x2===t.x2&&!i.touched});i=s?s.index:void 0}return this.cropped&&x(i)&&x(e)&&i>=e&&(i-=e),i},i.prototype.alignDataLabel=function(i){var e=i.plotX;i.plotX=y(i.dlBox&&i.dlBox.centerX,i.plotX),t.prototype.alignDataLabel.apply(this,arguments),i.plotX=e},i.prototype.translatePoint=function(t){var i,e,o,r,s,n,a=this.xAxis,h=this.yAxis,l=this.columnMetrics,d=this.options,c=d.minPointLength||0,f=(t.shapeArgs&&t.shapeArgs.width||0)/2,g=this.pointXOffset=l.offset,M=y(t.x2,t.x+(t.len||0)),k=d.borderRadius,A=this.chart.plotTop,S=this.chart.plotLeft,w=t.plotX,C=a.translate(M,0,0,0,1),B=Math.abs(C-w),O=this.chart.inverted,E=y(d.borderWidth,1)%2/2,P=l.offset,T=Math.round(l.width);c&&((i=c-B)<0&&(i=0),w-=i/2,C+=i/2),w=Math.max(w,-10),C=p(C,-10,a.len+10),u(t.options.pointWidth)&&(P-=(Math.ceil(t.options.pointWidth)-T)/2,T=Math.ceil(t.options.pointWidth)),d.pointPlacement&&x(t.plotY)&&h.categories&&(t.plotY=h.translate(t.y,0,1,0,1,d.pointPlacement));var D=Math.floor(Math.min(w,C))+E,G=Math.floor(Math.max(w,C))+E-D,I=Math.min(b("object"==typeof k?k.radius:k||0,T),Math.min(G,T)/2),j={x:D,y:Math.floor(t.plotY+P)+E,width:G,height:T,r:I};t.shapeArgs=j,O?t.tooltipPos[1]+=g+f:t.tooltipPos[0]-=f+g-j.width/2,r=(o=j.x)+j.width,o<0||r>a.len?(o=p(o,0,a.len),s=(r=p(r,0,a.len))-o,t.dlBox=m(j,{x:o,width:r-o,centerX:s?s/2:null})):t.dlBox=null;var L=t.tooltipPos,R=O?1:0,z=O?0:1,N=this.columnMetrics?this.columnMetrics.offset:-l.width/2;O?L[R]+=j.width/2:L[R]=p(L[R]+(a.reversed?-1:0)*j.width,a.left-S,a.left+a.len-S-1),L[z]=p(L[z]+(O?-1:1)*N,h.top-A,h.top+h.len-A-1),(e=t.partialFill)&&(v(e)&&(e=e.amount),x(e)||(e=0),t.partShapeArgs=m(j),n=Math.max(Math.round(B*e+t.plotX-w),0),t.clipRectArgs={x:a.reversed?j.x+B-n:j.x,y:j.y,width:n,height:j.height})},i.prototype.translate=function(){t.prototype.translate.apply(this,arguments);for(var i=0,e=this.points;i<e.length;i++){var o=e[i];this.translatePoint(o)}},i.prototype.drawPoint=function(t,i){var e=this.options,o=this.chart.renderer,r=t.shapeType,s=t.shapeArgs,n=t.partShapeArgs,a=t.clipRectArgs,h=t.state,d=e.states[h||"normal"]||{},c=void 0===h?"attr":i,p=this.pointAttribs(t,h),u=y(this.chart.options.chart.animation,d.animation),f=t.graphic,g=t.partialFill;if(t.isNull||!1===t.visible)f&&(t.graphic=f.destroy());else if(f?f.rect[i](s):(t.graphic=f=o.g("point").addClass(t.getClassName()).add(t.group||this.group),f.rect=o[r](m(s)).addClass(t.getClassName()).addClass("highcharts-partfill-original").add(f)),n&&(f.partRect?(f.partRect[i](m(n)),f.partialClipRect[i](m(a))):(f.partialClipRect=o.clipRect(a.x,a.y,a.width,a.height),f.partRect=o[r](n).addClass("highcharts-partfill-overlay").add(f).clip(f.partialClipRect))),!this.chart.styledMode&&(f.rect[i](p,u).shadow(e.shadow),n)){v(g)||(g={}),v(e.partialFill)&&(g=m(e.partialFill,g));var x=g.fill||l(p.fill).brighten(-.3).get()||l(t.color||this.color).brighten(-.3).get();p.fill=x,f.partRect[c](p,u).shadow(e.shadow)}},i.prototype.drawPoints=function(){for(var t=this.getAnimationVerb(),i=0,e=this.points;i<e.length;i++){var o=e[i];this.drawPoint(o,t)}},i.prototype.getAnimationVerb=function(){return this.chart.pointCount<(this.options.animationLimit||250)?"animate":"attr"},i.prototype.isPointInside=function(i){var e=i.shapeArgs,o=i.plotX,r=i.plotY;return e?void 0!==o&&void 0!==r&&r>=0&&r<=this.yAxis.len&&(e.x||0)+(e.width||0)>=0&&o<=this.xAxis.len:t.prototype.isPointInside.apply(this,arguments)},i.defaultOptions=m(d.defaultOptions,r),i}(d);return f(A.prototype,{pointClass:s,pointArrayMap:["x2","y"],getExtremesFromAll:!0,parallelArrays:["x","x2","y"],requireSorting:!1,type:"xrange",animate:e.series.prototype.animate,autoIncrement:h,buildKDTree:h}),e.registerSeriesType("xrange",A),A}),e(i,"Series/Gantt/GanttPoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)}),r=t.seriesTypes.xrange.prototype.pointClass,s=i.pick;return function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.options=void 0,i.series=void 0,i}return o(i,t),i.setGanttPointAliases=function(t){function i(i,e){void 0!==e&&(t[i]=e)}i("x",s(t.start,t.x)),i("x2",s(t.end,t.x2)),i("partialFill",s(t.completed,t.partialFill))},i.prototype.applyOptions=function(e,o){var r;return r=t.prototype.applyOptions.call(this,e,o),i.setGanttPointAliases(r),r},i.prototype.isValid=function(){return("number"==typeof this.start||"number"==typeof this.x)&&("number"==typeof this.end||"number"==typeof this.x2||this.milestone)},i}(r)}),e(i,"Core/Axis/BrokenAxis.js",[i["Core/Axis/Stacking/StackItem.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,r=i.find,s=i.fireEvent,n=i.isArray,a=i.isNumber,h=i.pick;return function(e){var l=[];function d(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function c(){var t;(null===(t=this.brokenAxis)||void 0===t?void 0:t.hasBreaks)&&(this.options.ordinal=!1)}function p(){var t=this.brokenAxis;if(null==t?void 0:t.hasBreaks){for(var i=this.tickPositions,e=this.tickPositions.info,o=[],r=0;r<i.length;r++)t.isInAnyBreak(i[r])||o.push(i[r]);this.tickPositions=o,this.tickPositions.info=e}}function u(){this.brokenAxis||(this.brokenAxis=new m(this))}function f(){var t,i,e=this.isDirty,o=this.options.connectNulls,r=this.points,s=this.xAxis,n=this.yAxis;if(e)for(var a=r.length;a--;){var h=r[a],l=!(null===h.y&&!1===o)&&((null===(t=null==s?void 0:s.brokenAxis)||void 0===t?void 0:t.isInAnyBreak(h.x,!0))||(null===(i=null==n?void 0:n.brokenAxis)||void 0===i?void 0:i.isInAnyBreak(h.y,!0)));h.visible=!l&&!1!==h.options.visible}}function g(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,h(this.pointArrayMap,["y"]))}function x(t,i){var e,o,r,n,l=this,d=l.points;if(null===(e=null==t?void 0:t.brokenAxis)||void 0===e?void 0:e.hasBreaks){var c=t.brokenAxis;i.forEach(function(i){o=(null==c?void 0:c.breakArray)||[],r=t.isXAxis?t.min:h(l.options.threshold,t.min);var e,p,u=null===(p=null===(e=null==t?void 0:t.options)||void 0===e?void 0:e.breaks)||void 0===p?void 0:p.filter(function(t){for(var i=!0,e=0;e<o.length;e++){var r=o[e];if(r.from===t.from&&r.to===t.to){i=!1;break}}return i});d.forEach(function(e){n=h(e["stack"+i.toUpperCase()],e[i]),o.forEach(function(i){if(a(r)&&a(n)){var o="";r<i.from&&n>i.to||r>i.from&&n<i.from?o="pointBreak":(r<i.from&&n>i.from&&n<i.to||r>i.from&&n>i.to&&n<i.from)&&(o="pointInBreak"),o&&s(t,o,{point:e,brk:i})}}),null==u||u.forEach(function(i){s(t,"pointOutsideOfBreak",{point:e,brk:i})})})})}}function v(){var i=this.currentDataGrouping,e=null==i?void 0:i.gapSize,o=this.points.slice(),r=this.yAxis,s=this.options.gapSize,n=o.length-1;if(s&&n>0){"value"!==this.options.gapUnit&&(s*=this.basePointRange),e&&e>s&&e>=this.basePointRange&&(s=e);for(var a=void 0,h=void 0;n--;)if(h&&!1!==h.visible||(h=o[n+1]),a=o[n],!1!==h.visible&&!1!==a.visible){if(h.x-a.x>s){var l=(a.x+h.x)/2;o.splice(n+1,0,{isNull:!0,x:l}),r.stacking&&this.options.stacking&&((r.stacking.stacks[this.stackKey][l]=new t(r,r.options.stackLabels,!1,l,this.stack)).total=0)}h=a}}return this.getGraphPath(o)}e.compose=function(t,e){if(i.pushUnique(l,t)&&(t.keepProps.push("brokenAxis"),o(t,"init",u),o(t,"afterInit",d),o(t,"afterSetTickPositions",p),o(t,"afterSetOptions",c)),i.pushUnique(l,e)){var r=e.prototype;r.drawBreaks=x,r.gappedPath=v,o(e,"afterGeneratePoints",f),o(e,"afterRender",g)}return t};var m=function(){function t(t){this.hasBreaks=!1,this.axis=t}return t.isInBreak=function(t,i){var e=t.repeat||1/0,o=t.from,r=t.to-t.from,s=i>=o?(i-o)%e:e-(o-i)%e;return t.inclusive?s<=r:s<r&&0!==s},t.lin2Val=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,s,n=i;for(s=0;s<o.length&&!((r=o[s]).from>=n);s++)r.to<n?n+=r.len:t.isInBreak(r,n)&&(n+=r.len);return n},t.val2Lin=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var r,s,n=i;for(s=0;s<o.length;s++)if((r=o[s]).to<=i)n-=r.len;else if(r.from>=i)break;else if(t.isInBreak(r,i)){n-=i-r.from;break}return n},t.prototype.findBreakAt=function(t,i){return r(i,function(i){return i.from<t&&t<i.to})},t.prototype.isInAnyBreak=function(i,e){var o,r,s,n=this.axis,l=n.options.breaks||[],d=l.length;if(d&&a(i)){for(;d--;)t.isInBreak(l[d],i)&&(o=!0,r||(r=h(l[d].showPoints,!n.isXAxis)));s=o&&e?o&&!r:o}return s},t.prototype.setBreaks=function(i,e){var o=this,r=o.axis,l=n(i)&&!!i.length&&!!Object.keys(i[0]).length;r.isDirty=o.hasBreaks!==l,o.hasBreaks=l,i!==r.options.breaks&&(r.options.breaks=r.userOptions.breaks=i),r.forceRedraw=!0,r.series.forEach(function(t){t.isDirty=!0}),l||r.val2lin!==t.val2Lin||(delete r.val2lin,delete r.lin2val),l&&(r.userOptions.ordinal=!1,r.lin2val=t.lin2Val,r.val2lin=t.val2Lin,r.setExtremes=function(t,i,e,s,n){if(o.hasBreaks){for(var a=this.options.breaks||[],h=void 0;h=o.findBreakAt(t,a);)t=h.to;for(;h=o.findBreakAt(i,a);)i=h.from;i<t&&(i=t)}r.constructor.prototype.setExtremes.call(this,t,i,e,s,n)},r.setAxisTranslation=function(){if(r.constructor.prototype.setAxisTranslation.call(this),o.unitLength=void 0,o.hasBreaks){var i,e,n,l,d=r.options.breaks||[],c=[],p=[],u=h(r.pointRangePadding,0),f=0,g=r.userMin||r.min,x=r.userMax||r.max;d.forEach(function(i){e=i.repeat||1/0,a(g)&&a(x)&&(t.isInBreak(i,g)&&(g+=i.to%e-g%e),t.isInBreak(i,x)&&(x-=x%e-i.from%e))}),d.forEach(function(t){if(n=t.from,e=t.repeat||1/0,a(g)&&a(x)){for(;n-e>g;)n-=e;for(;n<g;)n+=e;for(l=n;l<x;l+=e)c.push({value:l,move:"in"}),c.push({value:l+t.to-t.from,move:"out",size:t.breakSize})}}),c.sort(function(t,i){return t.value===i.value?("in"===t.move?0:1)-("in"===i.move?0:1):t.value-i.value}),i=0,n=g,c.forEach(function(t){1===(i+="in"===t.move?1:-1)&&"in"===t.move&&(n=t.value),0===i&&a(n)&&(p.push({from:n,to:t.value,len:t.value-n-(t.size||0)}),f+=t.value-n-(t.size||0))}),o.breakArray=p,a(g)&&a(x)&&a(r.min)&&(o.unitLength=x-g-f+u,s(r,"afterBreaks"),r.staticScale?r.transA=r.staticScale:o.unitLength&&(r.transA*=(x-r.min+u)/o.unitLength),u&&(r.minPixelPadding=r.transA*(r.minPointOffset||0)),r.min=g,r.max=x)}}),h(e,!0)&&r.chart.redraw()},t}();e.Additions=m}(e||(e={})),e}),e(i,"Core/Axis/GridAxis.js",[i["Core/Axis/Axis.js"],i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r,s=i.dateFormats,n=e.addEvent,a=e.defined,h=e.erase,l=e.find,d=e.isArray,c=e.isNumber,p=e.merge,u=e.pick,f=e.timeUnits,g=e.wrap;(o=r||(r={}))[o.top=0]="top",o[o.right=1]="right",o[o.bottom=2]="bottom",o[o.left=3]="left";var x=[];function v(t){return e.isObject(t,!0)}function m(t,i){var e={width:0,height:0};if(i.forEach(function(i){var o,r=t[i],s=0,n=0;v(r)&&(s=(o=v(r.label)?r.label:{}).getBBox?o.getBBox().height:0,o.textStr&&!c(o.textPxLength)&&(o.textPxLength=o.getBBox().width),n=c(o.textPxLength)?Math.round(o.textPxLength):0,o.textStr&&(n=Math.round(o.getBBox().width)),e.height=Math.max(s,e.height),e.width=Math.max(n,e.width))}),"treegrid"===this.options.type&&this.treeGrid&&this.treeGrid.mapOfPosToGridNode){var o=this.treeGrid.mapOfPosToGridNode[-1].height||0;e.width+=this.options.labels.indentation*(o-1)}return e}function y(){var t=this.grid;(t&&t.columns||[]).forEach(function(t){t.getOffset()})}function b(t){if(!0===(this.options.grid||{}).enabled){var i=this.axisTitle,e=this.height,o=this.horiz,s=this.left,n=this.offset,a=this.opposite,h=this.options,l=this.top,d=this.width,c=this.tickSize(),p=i&&i.getBBox().width,f=h.title.x,g=h.title.y,x=u(h.title.margin,o?5:10),v=i?this.chart.renderer.fontMetrics(i).f:0,m=(o?l+e:s)+(o?1:-1)*(a?-1:1)*(c?c[0]/2:0)+(this.side===r.bottom?v:0);t.titlePosition.x=o?s-(p||0)/2-x+f:m+(a?d:0)+n+f,t.titlePosition.y=o?m-(a?e:0)+(a?v:-v)/2+n+g:l-x+g}}function M(){var i,e=this.chart,o=this.options.grid,r=void 0===o?{}:o,s=this.userOptions;if(r.enabled&&((i=this.options).labels.align=u(i.labels.align,"center"),this.categories||(i.showLastLabel=!1),this.labelRotation=0,i.labels.rotation=0,i.minTickInterval=1),r.columns)for(var n=this.grid.columns=[],a=this.grid.columnIndex=0;++a<r.columns.length;){var l=p(s,r.columns[r.columns.length-a-1],{isInternal:!0,linkedTo:0,type:"category",scrollbar:{enabled:!1}});delete l.grid.columns;var d=new t(this.chart,l,"yAxis");d.grid.isColumn=!0,d.grid.columnIndex=a,h(e.axes,d),h(e[this.coll]||[],d),n.push(d)}}function k(){var t=this.grid,i=this.options;if(!0===(i.grid||{}).enabled){var e=this.min||0,o=this.max||0;if(this.maxLabelDimensions=this.getMaxLabelDimensions(this.ticks,this.tickPositions),this.rightWall&&this.rightWall.destroy(),this.grid&&this.grid.isOuterAxis()&&this.axisLine){var s=i.lineWidth;if(s){var n=this.getLinePath(s),a=n[0],h=n[1],l=((this.tickSize("tick")||[1])[0]-1)*(this.side===r.top||this.side===r.left?-1:1);if("M"===a[0]&&"L"===h[0]&&(this.horiz?(a[2]+=l,h[2]+=l):(a[1]+=l,h[1]+=l)),!this.horiz&&this.chart.marginRight){var d=["L",this.left,a[2]||0],c=[a,d],p=["L",this.chart.chartWidth-this.chart.marginRight,this.toPixels(o+this.tickmarkOffset)],u=[["M",h[1]||0,this.toPixels(o+this.tickmarkOffset)],p];this.grid.upperBorder||e%1==0||(this.grid.upperBorder=this.grid.renderBorder(c)),this.grid.upperBorder&&(this.grid.upperBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.upperBorder.animate({d:c})),this.grid.lowerBorder||o%1==0||(this.grid.lowerBorder=this.grid.renderBorder(u)),this.grid.lowerBorder&&(this.grid.lowerBorder.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.lowerBorder.animate({d:u}))}this.grid.axisLineExtra?(this.grid.axisLineExtra.attr({stroke:i.lineColor,"stroke-width":i.lineWidth}),this.grid.axisLineExtra.animate({d:n})):this.grid.axisLineExtra=this.grid.renderBorder(n),this.axisLine[this.showAxis?"show":"hide"]()}}if((t&&t.columns||[]).forEach(function(t){return t.render()}),!this.horiz&&this.chart.hasRendered&&(this.scrollbar||this.linkedParent&&this.linkedParent.scrollbar)){for(var f=this.tickmarkOffset,g=this.tickPositions[this.tickPositions.length-1],x=this.tickPositions[0],v=void 0,m=void 0;(v=this.hiddenLabels.pop())&&v.element;)v.show();for(;(m=this.hiddenMarks.pop())&&m.element;)m.show();(v=this.ticks[x].label)&&(e-x>f?this.hiddenLabels.push(v.hide()):v.show()),(v=this.ticks[g].label)&&(g-o>f?this.hiddenLabels.push(v.hide()):v.show());var y=this.ticks[g].mark;y&&g-o<f&&g-o>0&&this.ticks[g].isLast&&this.hiddenMarks.push(y.hide())}}}function A(){var t=this.tickPositions&&this.tickPositions.info,i=this.options,e=i.grid||{},o=this.userOptions.labels||{};e.enabled&&(this.horiz?(this.series.forEach(function(t){t.options.pointRange=0}),t&&i.dateTimeLabelFormats&&i.labels&&!a(o.align)&&(!1===i.dateTimeLabelFormats[t.unitName].range||t.count>1)&&(i.labels.align="left",a(o.x)||(i.labels.x=3))):"treegrid"!==this.options.type&&this.grid&&this.grid.columns&&(this.minPointOffset=this.tickInterval))}function S(t){var i,e=this.options,o=t.userOptions,r=e&&v(e.grid)?e.grid:{};!0===r.enabled&&(i=p(!0,{className:"highcharts-grid-axis "+(o.className||""),dateTimeLabelFormats:{hour:{list:["%H:%M","%H"]},day:{list:["%A, %e. %B","%a, %e. %b","%E"]},week:{list:["Week %W","W%W"]},month:{list:["%B","%b","%o"]}},grid:{borderWidth:1},labels:{padding:2,style:{fontSize:"0.9em"}},margin:0,title:{text:null,reserveSpace:!1,rotation:0},units:[["millisecond",[1,10,100]],["second",[1,10]],["minute",[1,5,15]],["hour",[1,6]],["day",[1]],["week",[1]],["month",[1]],["year",null]]},o),"xAxis"===this.coll&&(a(o.linkedTo)&&!a(o.tickPixelInterval)&&(i.tickPixelInterval=350),!a(o.tickPixelInterval)&&a(o.linkedTo)&&!a(o.tickPositioner)&&!a(o.tickInterval)&&(i.tickPositioner=function(t,e){var o=this.linkedParent&&this.linkedParent.tickPositions&&this.linkedParent.tickPositions.info;if(o){for(var r=i.units||[],s=void 0,n=1,a="year",h=0;h<r.length;h++){var l=r[h];if(l&&l[0]===o.unitName){s=h;break}}var d=c(s)&&r[s+1];if(d){a=d[0]||"year";var p=d[1];n=p&&p[0]||1}else"year"===o.unitName&&(n=10*o.count);var u=f[a];return this.tickInterval=u*n,this.chart.time.getTimeTicks({unitRange:u,count:n,unitName:a},t,e,this.options.startOfWeek)}})),p(!0,this.options,i),this.horiz&&(e.minPadding=u(o.minPadding,0),e.maxPadding=u(o.maxPadding,0)),c(e.grid.borderWidth)&&(e.tickWidth=e.lineWidth=r.borderWidth))}function w(t){var i=t.userOptions,e=i&&i.grid||{},o=e.columns;e.enabled&&o&&p(!0,this.options,o[o.length-1])}function C(){(this.grid.columns||[]).forEach(function(t){return t.setScale()})}function B(t){var i=this.horiz,e=this.maxLabelDimensions,o=this.options.grid,r=void 0===o?{}:o;if(r.enabled&&e){var s=2*this.options.labels.distance,n=i?r.cellHeight||s+e.height:s+e.width;d(t.tickSize)?t.tickSize[0]=n:t.tickSize=[n,0]}}function O(){this.axes.forEach(function(t){(t.grid&&t.grid.columns||[]).forEach(function(t){t.setAxisSize(),t.setAxisTranslation()})})}function E(t){var i=this.grid;(i.columns||[]).forEach(function(i){return i.destroy(t.keepEvents)}),i.columns=void 0}function P(t){var i=t.userOptions||{},e=i.grid||{};e.enabled&&a(e.borderColor)&&(i.tickColor=i.lineColor=e.borderColor),this.grid||(this.grid=new j(this)),this.hiddenLabels=[],this.hiddenMarks=[]}function T(t){var i=this.label,e=this.axis,o=e.reversed,s=e.chart,n=e.options.grid||{},a=e.options.labels,h=a.align,l=r[e.side],d=t.tickmarkOffset,p=e.tickPositions,u=this.pos-d,f=c(p[t.index+1])?p[t.index+1]-d:(e.max||0)+d,g=e.tickSize("tick"),x=g?g[0]:0,v=g?g[1]/2:0;if(!0===n.enabled){var m,y=void 0,b=void 0,M=void 0;if("top"===l?m=(y=e.top+e.offset)-x:"bottom"===l?y=(m=s.chartHeight-e.bottom+e.offset)+x:(y=e.top+e.len-(e.translate(o?f:u)||0),m=e.top+e.len-(e.translate(o?u:f)||0)),"right"===l?M=(b=s.chartWidth-e.right+e.offset)+x:"left"===l?b=(M=e.left+e.offset)-x:(b=Math.round(e.left+(e.translate(o?f:u)||0))-v,M=Math.min(Math.round(e.left+(e.translate(o?u:f)||0))-v,e.left+e.len)),this.slotWidth=M-b,t.pos.x="left"===h?b:"right"===h?M:b+(M-b)/2,t.pos.y=m+(y-m)/2,i){var k=s.renderer.fontMetrics(i),A=i.getBBox().height;if(a.useHTML)t.pos.y+=k.b+-(A/2);else{var S=Math.round(A/k.h);t.pos.y+=(k.b-(k.h-k.f))/2+-((S-1)*k.h/2)}}t.pos.x+=e.horiz&&a.x||0}}function D(t){var e=t.axis,o=t.value;if(e.options.grid&&e.options.grid.enabled){var r=e.tickPositions,s=(e.linkedParent||e).series[0],n=o===r[0],a=o===r[r.length-1],h=s&&l(s.options.data,function(t){return t[e.isXAxis?"x":"y"]===o}),d=void 0;h&&s.is("gantt")&&(d=p(h),i.seriesTypes.gantt.prototype.pointClass.setGanttPointAliases(d)),t.isFirst=n,t.isLast=a,t.point=d}}function G(){var t=this.options,i=t.grid||{},e=this.categories,o=this.tickPositions,r=o[0],s=o[o.length-1],n=this.linkedParent&&this.linkedParent.min,a=this.linkedParent&&this.linkedParent.max,h=n||this.min,l=a||this.max,d=this.tickInterval;!0===i.enabled&&!e&&(this.horiz||this.isLinked)&&(r<h&&r+d>h&&!t.startOnTick&&(o[0]=h),s>l&&s-d<l&&!t.endOnTick&&(o[o.length-1]=l))}function I(t){var i,e=this.options.grid;return!0===(void 0===e?{}:e).enabled&&this.categories?this.tickInterval:t.apply(this,(i=arguments,Array.prototype.slice.call(i,1)))}var j=function(){function t(t){this.axis=t}return t.prototype.isOuterAxis=function(){var t=this.axis,i=t.chart,e=t.grid.columnIndex,o=t.linkedParent&&t.linkedParent.grid.columns||t.grid.columns,r=e?t.linkedParent:t,s=-1,n=0;return(i[t.coll]||[]).forEach(function(i,e){i.side!==t.side||i.options.isInternal||(n=e,i!==r||(s=e))}),n===s&&(!c(e)||o.length===e)},t.prototype.renderBorder=function(t){var i=this.axis,e=i.chart.renderer,o=i.options,r=e.path(t).addClass("highcharts-axis-line").add(i.axisBorder);return e.styledMode||r.attr({stroke:o.lineColor,"stroke-width":o.lineWidth,zIndex:7}),r},t}();return s.E=function(t){return this.dateFormat("%a",t,!0).charAt(0)},s.W=function(t){var i=this,e=new this.Date(t);["Hours","Milliseconds","Minutes","Seconds"].forEach(function(t){i.set(t,e,0)});var o=(this.get("Day",e)+6)%7,r=new this.Date(e.valueOf());this.set("Date",r,this.get("Date",e)-o+3);var s=new this.Date(this.get("FullYear",r),0,1);return 4!==this.get("Day",s)&&(this.set("Month",e,0),this.set("Date",e,1+(11-this.get("Day",s))%7)),(1+Math.floor((r.valueOf()-s.valueOf())/6048e5)).toString()},{compose:function(t,i,o){return e.pushUnique(x,t)&&(t.keepProps.push("grid"),t.prototype.getMaxLabelDimensions=m,g(t.prototype,"unsquish",I),n(t,"init",P),n(t,"afterGetOffset",y),n(t,"afterGetTitlePosition",b),n(t,"afterInit",M),n(t,"afterRender",k),n(t,"afterSetAxisTranslation",A),n(t,"afterSetOptions",S),n(t,"afterSetOptions",w),n(t,"afterSetScale",C),n(t,"afterTickSize",B),n(t,"trimTicks",G),n(t,"destroy",E)),e.pushUnique(x,i)&&n(i,"afterSetChartSize",O),e.pushUnique(x,o)&&(n(o,"afterGetLabelPosition",T),n(o,"labelFormat",D)),t}}}),e(i,"Gantt/Tree.js",[i["Core/Utilities.js"]],function(t){var i=t.extend,e=t.isNumber,o=t.pick;function r(t,s,n,a,h,l){var d,c,p=l&&l.after,u=l&&l.before,f={data:a,depth:n-1,id:t,level:n,parent:s||""},g=0,x=0;"function"==typeof u&&u(f,l);var v=(h[t]||[]).map(function(i){var o=r(i.id,t,n+1,i,h,l),s=i.start||NaN,a=!0===i.milestone?s:i.end||NaN;return d=!e(d)||s<d?s:d,c=!e(c)||a>c?a:c,g=g+1+o.descendants,x=Math.max(o.height+1,x),o});return a&&(a.start=o(a.start,d),a.end=o(a.end,c)),i(f,{children:v,descendants:g,height:x}),"function"==typeof p&&p(f,l),f}return{getNode:r,getTree:function(t,i){return r("",null,1,null,t.reduce(function(t,i){var e=o(i.parent,"");return void 0===t[e]&&(t[e]=[]),t[e].push(i),t},{}),i)}}}),e(i,"Core/Axis/TreeGrid/TreeGridTick.js",[i["Core/Utilities.js"]],function(t){var i=t.addEvent,e=t.isObject,o=t.isNumber,r=t.pick,s=t.wrap,n=[];function a(){this.treeGrid||(this.treeGrid=new d(this))}function h(t,i,s,n,a,h,l,d,c){var p,u,f,g,x,v=r(this.options&&this.options.labels,h),m=this.pos,y=this.axis,b="treegrid"===y.options.type,M=t.apply(this,[i,s,n,a,v,l,d,c]);return b&&(p=v&&e(v.symbol,!0)?v.symbol:{},u=v&&o(v.indentation)?v.indentation:0,x=(g=(f=y.treeGrid.mapOfPosToGridNode)&&f[m])&&g.depth||1,M.x+=(p.width||0)+2*(p.padding||0)+(x-1)*u),M}function l(t){var s,n,a,h,l,d,c,p,u,f,g,x,v,m,y,b=this,M=b.pos,k=b.axis,A=b.label,S=k.treeGrid.mapOfPosToGridNode,w=k.options,C=r(b.options&&b.options.labels,w&&w.labels),B=C&&e(C.symbol,!0)?C.symbol:{},O=S&&S[M],E=O&&O.depth,P="treegrid"===w.type,T=k.tickPositions.indexOf(M)>-1,D="highcharts-treegrid-node-",G=k.chart.styledMode;P&&O&&A&&A.element&&A.addClass(D+"level-"+E),t.apply(b,Array.prototype.slice.call(arguments,1)),P&&A&&A.element&&O&&O.descendants&&O.descendants>0&&(v=k.treeGrid.isCollapsed(O),s={color:!G&&A.styles&&A.styles.color||"",collapsed:v,group:A.parentGroup,options:B,renderer:A.renderer,show:T,xy:A.xy},a=!(n=b.treeGrid).labelIcon,h=s.renderer,l=s.xy,c=(d=s.options).width||0,p=d.height||0,u={x:l.x-c/2-(d.padding||0),y:l.y-p/2},f=s.collapsed?90:180,g=s.show&&o(u.y),(x=n.labelIcon)||(n.labelIcon=x=h.path(h.symbols[d.type](d.x||0,d.y||0,c,p)).addClass("highcharts-label-icon").add(s.group)),x[g?"show":"hide"](),h.styledMode||x.attr({cursor:"pointer",fill:r(s.color,"#666666"),"stroke-width":1,stroke:d.lineColor,strokeWidth:d.lineWidth||0}),x[a?"attr":"animate"]({translateX:u.x,translateY:u.y,rotation:f}),m=D+(v?"collapsed":"expanded"),y=D+(v?"expanded":"collapsed"),A.addClass(m).removeClass(y),G||A.css({cursor:"pointer"}),[A,b.treeGrid.labelIcon].forEach(function(t){t&&!t.attachedTreeGridEvents&&(i(t.element,"mouseover",function(){A.addClass("highcharts-treegrid-node-active"),A.renderer.styledMode||A.css({textDecoration:"underline"})}),i(t.element,"mouseout",function(){var t;t=e(C.style)?C.style:{},A.removeClass("highcharts-treegrid-node-active"),A.renderer.styledMode||A.css({textDecoration:t.textDecoration})}),i(t.element,"click",function(){b.treeGrid.toggleCollapse()}),t.attachedTreeGridEvents=!0)}))}var d=function(){function e(t){this.tick=t}return e.compose=function(e){t.pushUnique(n,e)&&(i(e,"init",a),s(e.prototype,"getLabelPosition",h),s(e.prototype,"renderLabel",l),e.prototype.collapse=function(t){this.treeGrid.collapse(t)},e.prototype.expand=function(t){this.treeGrid.expand(t)},e.prototype.toggleCollapse=function(t){this.treeGrid.toggleCollapse(t)})},e.prototype.collapse=function(t){var i=this.tick,e=i.axis,o=e.brokenAxis;if(o&&e.treeGrid.mapOfPosToGridNode){var s=i.pos,n=e.treeGrid.mapOfPosToGridNode[s],a=e.treeGrid.collapse(n);o.setBreaks(a,r(t,!0))}},e.prototype.destroy=function(){this.labelIcon&&this.labelIcon.destroy()},e.prototype.expand=function(t){var i=this.tick,e=i.axis,o=e.brokenAxis;if(o&&e.treeGrid.mapOfPosToGridNode){var s=i.pos,n=e.treeGrid.mapOfPosToGridNode[s],a=e.treeGrid.expand(n);o.setBreaks(a,r(t,!0))}},e.prototype.toggleCollapse=function(t){var i=this.tick,e=i.axis,o=e.brokenAxis;if(o&&e.treeGrid.mapOfPosToGridNode){var s=i.pos,n=e.treeGrid.mapOfPosToGridNode[s],a=e.treeGrid.toggleCollapse(n);o.setBreaks(a,r(t,!0))}},e}();return d}),e(i,"Series/TreeUtilities.js",[i["Core/Color/Color.js"],i["Core/Utilities.js"]],function(t,i){var e=i.extend,o=i.isArray,r=i.isNumber,s=i.isObject,n=i.merge,a=i.pick;return{getColor:function(i,e){var o,r,s,n,h,l,d,c=e.index,p=e.mapOptionsToLevel,u=e.parentColor,f=e.parentColorIndex,g=e.series,x=e.colors,v=e.siblings,m=g.points,y=g.chart.options.chart;return i&&(r=m[i.i],s=p[i.level]||{},r&&s.colorByPoint&&(h=r.index%(x?x.length:y.colorCount),n=x&&x[h]),g.chart.styledMode||(l=a(r&&r.options.color,s&&s.color,n,u&&((o=s&&s.colorVariation)&&"brightness"===o.key&&c&&v?t.parse(u).brighten(o.to*(c/v)).get():u),g.color)),d=a(r&&r.options.colorIndex,s&&s.colorIndex,h,f,e.colorIndex)),{color:l,colorIndex:d}},getLevelOptions:function(t){var i,e,h,l,d,c,p={};if(s(t))for(l=r(t.from)?t.from:1,c=t.levels,e={},i=s(t.defaults)?t.defaults:{},o(c)&&(e=c.reduce(function(t,e){var o,h,d;return s(e)&&r(e.level)&&(h=a((d=n({},e)).levelIsConstant,i.levelIsConstant),delete d.levelIsConstant,delete d.level,s(t[o=e.level+(h?0:l-1)])?n(!0,t[o],d):t[o]=d),t},{})),d=r(t.to)?t.to:1,h=0;h<=d;h++)p[h]=n({},i,s(e[h])?e[h]:{});return p},setTreeValues:function t(i,o){var r=o.before,s=o.idRoot,n=o.mapIdToNode[s],h=!1!==o.levelIsConstant,l=o.points[i.i],d=l&&l.options||{},c=[],p=0;i.levelDynamic=i.level-(h?0:n.level),i.name=a(l&&l.name,""),i.visible=s===i.id||!0===o.visible,"function"==typeof r&&(i=r(i,o)),i.children.forEach(function(r,s){var n=e({},o);e(n,{index:s,siblings:i.children.length,visible:i.visible}),r=t(r,n),c.push(r),r.visible&&(p+=r.val)});var u=a(d.value,p);return i.visible=u>=0&&(p>0||i.visible),i.children=c,i.childrenTotal=p,i.isLeaf=i.visible&&!p,i.val=u,i},updateRootId:function(t){var i,e;return s(t)&&(e=s(t.options)?t.options:{},i=a(t.rootNode,e.rootId,""),s(t.userOptions)&&(t.userOptions.rootId=i),t.rootNode=i),i}}}),e(i,"Core/Axis/TreeGrid/TreeGridAxis.js",[i["Core/Axis/BrokenAxis.js"],i["Core/Axis/GridAxis.js"],i["Gantt/Tree.js"],i["Core/Axis/TreeGrid/TreeGridTick.js"],i["Series/TreeUtilities.js"],i["Core/Utilities.js"]],function(t,i,e,o,r,s){var n,a=r.getLevelOptions,h=s.addEvent,l=s.find,d=s.fireEvent,c=s.isArray,p=s.isObject,u=s.isString,f=s.merge,g=s.pick,x=s.wrap,v=[];function m(t,i){var e=t.collapseEnd||0,o=t.collapseStart||0;return e>=i&&(o-=.5),{from:o,to:e,showPoints:!1}}function y(t,i,o){var r,s,n=[],a=[],h={},d="boolean"==typeof i&&i,c={},f=-1,g=e.getTree(t,{after:function(t){var i=c[t.pos],e=0,o=0;i.children.forEach(function(t){o+=(t.descendants||0)+1,e=Math.max((t.height||0)+1,e)}),i.descendants=o,i.height=e,i.collapsed&&a.push(i)},before:function(t){var i,e,o=p(t.data,!0)?t.data:{},r=u(o.name)?o.name:"",s=h[t.parent],a=p(s,!0)?c[s.pos]:null;d&&p(a,!0)&&(i=l(a.children,function(t){return t.name===r}))?(e=i.pos,i.nodes.push(t)):e=f++,!c[e]&&(c[e]=i={depth:a?a.depth+1:0,name:r,id:o.id,nodes:[t],children:[],pos:e},-1!==e&&n.push(r),p(a,!0)&&a.children.push(i)),u(t.id)&&(h[t.id]=t),i&&!0===o.collapsed&&(i.collapsed=!0),t.pos=e}});return r=c,{categories:n,mapOfIdToNode:h,mapOfPosToGridNode:c=(s=function(t,i,e){var r=t.nodes,n=i+(-1===i?0:o-1),a=(n-i)/2,h=i+a;return r.forEach(function(t){var e=t.data;p(e,!0)&&(e.y=i+(e.seriesIndex||0),delete e.seriesIndex),t.pos=h}),e[h]=t,t.pos=h,t.tickmarkOffset=a+.5,t.collapseStart=n+.5,t.children.forEach(function(t){s(t,n+1,e),n=(t.collapseEnd||0)-.5}),t.collapseEnd=n+.5,e})(r["-1"],-1,{}),collapsedNodes:a,tree:g}}function b(t){t.target.axes.filter(function(t){return"treegrid"===t.options.type}).forEach(function(i){var e,o,r=i.options||{},s=r.labels,n=r.uniqueNames,h=r.max,l=!i.treeGrid.mapOfPosToGridNode||i.series.some(function(t){return!t.hasRendered||t.isDirtyData||t.isDirty}),d=0;if(l){if(e=i.series.reduce(function(t,i){return i.visible&&((i.options.data||[]).forEach(function(e){i.options.keys&&i.options.keys.length&&(e=i.pointClass.prototype.optionsToObject.call({series:i},e),i.pointClass.setGanttPointAliases(e)),p(e,!0)&&(e.seriesIndex=d,t.push(e))}),!0===n&&d++),t},[]),h&&e.length<h)for(var u=e.length;u<=h;u++)e.push({name:u+"​"});o=y(e,n||!1,!0===n?d:1),i.categories=o.categories,i.treeGrid.mapOfPosToGridNode=o.mapOfPosToGridNode,i.hasNames=!0,i.treeGrid.tree=o.tree,i.series.forEach(function(t){var i=(t.options.data||[]).map(function(i){return c(i)&&t.options.keys&&t.options.keys.length&&e.forEach(function(t){i.indexOf(t.x)>=0&&i.indexOf(t.x2)>=0&&(i=t)}),p(i,!0)?f(i):i});t.visible&&t.setData(i,!1)}),i.treeGrid.mapOptionsToLevel=a({defaults:s,from:1,levels:s&&s.levels,to:i.treeGrid.tree&&i.treeGrid.tree.height}),"beforeRender"===t.type&&(i.treeGrid.collapsedNodes=o.collapsedNodes)}})}function M(t,i){var e,o,r,s=this.treeGrid.mapOptionsToLevel||{},a="treegrid"===this.options.type,h=this.ticks,l=h[i];a&&this.treeGrid.mapOfPosToGridNode?((e=s[(r=this.treeGrid.mapOfPosToGridNode[i]).depth])&&(o={labels:e}),!l&&n?h[i]=l=new n(this,i,void 0,void 0,{category:r.name,tickmarkOffset:r.tickmarkOffset,options:o}):(l.parameters.category=r.name,l.options=o,l.addLabel())):t.apply(this,Array.prototype.slice.call(arguments,1))}function k(t,i,e,o){var r=this,s="treegrid"===e.type;r.treeGrid||(r.treeGrid=new S(r)),s&&(h(i,"beforeRender",b),h(i,"beforeRedraw",b),h(i,"addSeries",function(t){if(t.options.data){var i=y(t.options.data,e.uniqueNames||!1,1);r.treeGrid.collapsedNodes=(r.treeGrid.collapsedNodes||[]).concat(i.collapsedNodes)}}),h(r,"foundExtremes",function(){r.treeGrid.collapsedNodes&&r.treeGrid.collapsedNodes.forEach(function(t){var i=r.treeGrid.collapse(t);r.brokenAxis&&(r.brokenAxis.setBreaks(i,!1),r.treeGrid.collapsedNodes&&(r.treeGrid.collapsedNodes=r.treeGrid.collapsedNodes.filter(function(i){return t.collapseStart!==i.collapseStart||t.collapseEnd!==i.collapseEnd})))})}),h(r,"afterBreaks",function(){"yAxis"===r.coll&&!r.staticScale&&r.chart.options.chart.height&&(r.isDirty=!0)}),e=f({grid:{enabled:!0},labels:{align:"left",levels:[{level:void 0},{level:1,style:{fontWeight:"bold"}}],symbol:{type:"triangle",x:-5,y:-5,height:10,width:10,padding:5}},uniqueNames:!1},e,{reversed:!0,grid:{columns:void 0}})),t.apply(r,[i,e,o]),s&&(r.hasNames=!0,r.options.showLastLabel=!0)}function A(t){var i=this.options;"treegrid"===i.type?(this.min=g(this.userMin,i.min,this.dataMin),this.max=g(this.userMax,i.max,this.dataMax),d(this,"foundExtremes"),this.setAxisTranslation(),this.tickmarkOffset=.5,this.tickInterval=1,this.tickPositions=this.treeGrid.mapOfPosToGridNode?this.treeGrid.getTickPositions():[]):t.apply(this,Array.prototype.slice.call(arguments,1))}var S=function(){function r(t){this.axis=t}return r.compose=function(r,a,h,l){if(s.pushUnique(v,r)){-1===r.keepProps.indexOf("treeGrid")&&r.keepProps.push("treeGrid");var d=r.prototype;x(d,"generateTick",M),x(d,"init",k),x(d,"setTickInterval",A),d.utils={getNode:e.getNode}}return s.pushUnique(v,l)&&!n&&(n=l),i.compose(r,a,l),t.compose(r,h),o.compose(l),r},r.prototype.setCollapsedStatus=function(t){var i=this.axis,e=i.chart;i.series.forEach(function(i){var o=i.options.data;if(t.id&&o){var r=e.get(t.id),s=o[i.data.indexOf(r)];r&&s&&(r.collapsed=t.collapsed,s.collapsed=t.collapsed)}})},r.prototype.collapse=function(t){var i=this.axis,e=i.options.breaks||[],o=m(t,i.max);return e.push(o),t.collapsed=!0,i.treeGrid.setCollapsedStatus(t),e},r.prototype.expand=function(t){var i=this.axis,e=i.options.breaks||[],o=m(t,i.max);return t.collapsed=!1,i.treeGrid.setCollapsedStatus(t),e.reduce(function(t,i){return(i.to!==o.to||i.from!==o.from)&&t.push(i),t},[])},r.prototype.getTickPositions=function(){var t=this.axis,i=Math.floor(t.min/t.tickInterval)*t.tickInterval,e=Math.ceil(t.max/t.tickInterval)*t.tickInterval;return Object.keys(t.treeGrid.mapOfPosToGridNode||{}).reduce(function(o,r){var s=+r;return s>=i&&s<=e&&!(t.brokenAxis&&t.brokenAxis.isInAnyBreak(s))&&o.push(s),o},[])},r.prototype.isCollapsed=function(t){var i=this.axis,e=i.options.breaks||[],o=m(t,i.max);return e.some(function(t){return t.from===o.from&&t.to===o.to})},r.prototype.toggleCollapse=function(t){return this.isCollapsed(t)?this.expand(t):this.collapse(t)},r}();return S}),e(i,"Series/Gantt/GanttSeries.js",[i["Core/Axis/Axis.js"],i["Core/Chart/Chart.js"],i["Series/Gantt/GanttPoint.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Axis/Tick.js"],i["Core/Utilities.js"],i["Core/Axis/TreeGrid/TreeGridAxis.js"]],function(t,i,e,o,r,s,n){var a,h=this&&this.__extends||(a=function(t,i){return(a=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}a(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),l=o.series,d=o.seriesTypes.xrange,c=s.extend,p=s.isNumber,u=s.merge;s.splat,n.compose(t,i,l,r);var f=function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.data=void 0,i.options=void 0,i.points=void 0,i}return h(i,t),i.prototype.drawPoint=function(t,i){var e,o=this.options,r=this.chart.renderer,s=t.shapeArgs,n=t.plotY,a=t.graphic,h=t.selected&&"select",l=o.stacking&&!o.borderRadius;t.options.milestone?p(n)&&null!==t.y&&!1!==t.visible?(e=r.symbols.diamond(s.x||0,s.y||0,s.width||0,s.height||0),a?a[i]({d:e}):t.graphic=a=r.path(e).addClass(t.getClassName(),!0).add(t.group||this.group),this.chart.styledMode||t.graphic.attr(this.pointAttribs(t,h)).shadow(o.shadow,null,l)):a&&(t.graphic=a.destroy()):d.prototype.drawPoint.call(this,t,i)},i.prototype.translatePoint=function(t){var i,e;d.prototype.translatePoint.call(this,t),t.options.milestone&&(e=(i=t.shapeArgs).height||0,t.shapeArgs={x:(i.x||0)-e/2,y:i.y,width:e,height:e})},i.defaultOptions=u(d.defaultOptions,{grouping:!1,dataLabels:{enabled:!0},tooltip:{headerFormat:'<span style="font-size: 0.8em">{series.name}</span><br/>',pointFormat:null,pointFormatter:function(){var t,i,e=this.series,o=e.xAxis,r=e.tooltipOptions.dateTimeLabelFormats,s=o.options.startOfWeek,n=e.tooltipOptions,a=n.xDateFormat,h=this.options.milestone,l="<b>"+(this.name||this.yCategory)+"</b>";return n.pointFormat?this.tooltipFormatter(n.pointFormat):(!a&&p(this.start)&&(a=e.chart.time.getDateFormat(o.closestPointRange,this.start,s,r||{})),t=e.chart.time.dateFormat(a,this.start),i=e.chart.time.dateFormat(a,this.end),l+="<br/>",h?l+=t+"<br/>":l+="Start: "+t+"<br/>End: "+i+"<br/>",l)}},connectors:{type:"simpleConnect",animation:{reversed:!0},radius:0,startMarker:{enabled:!0,symbol:"arrow-filled",radius:4,fill:"#fa0",align:"left"},endMarker:{enabled:!1,align:"right"}}}),i}(d);return c(f.prototype,{pointArrayMap:["start","end","y"],pointClass:e,setData:l.prototype.setData}),o.registerSeriesType("gantt",f),f}),e(i,"Core/Chart/GanttChart.js",[i["Core/Chart/Chart.js"],i["Core/Defaults.js"],i["Core/Utilities.js"]],function(t,i,e){var o,r,s=this&&this.__extends||(o=function(t,i){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}o(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),n=i.getOptions,a=e.isArray,h=e.merge,l=e.splat,d=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return s(i,t),i.prototype.init=function(i,e){var o,r=n(),s=i.xAxis,d=i.yAxis;i.xAxis=i.yAxis=void 0;var c=h(!0,{chart:{type:"gantt"},title:{text:""},legend:{enabled:!1},navigator:{series:{type:"gantt"},yAxis:{type:"category"}}},i,{isGantt:!0});i.xAxis=s,i.yAxis=d,c.xAxis=(a(i.xAxis)?i.xAxis:[i.xAxis||{},{}]).map(function(t,i){return 1===i&&(o=0),h(r.xAxis,{grid:{enabled:!0},opposite:!0,linkedTo:o},t,{type:"datetime"})}),c.yAxis=l(i.yAxis||{}).map(function(t){return h(r.yAxis,{grid:{enabled:!0},staticScale:50,reversed:!0,type:t.categories?t.type:"treegrid"},t)}),t.prototype.init.call(this,c,e)},i}(t);return(r=d||(d={})).ganttChart=function(t,i,e){return new r(t,i,e)},d}),e(i,"Extensions/ArrowSymbols.js",[i["Core/Utilities.js"]],function(t){var i=[];function e(t,i,e,o){return[["M",t,i+o/2],["L",t+e,i],["L",t,i+o/2],["L",t+e,i+o]]}function o(t,i,o,r){return e(t,i,o/2,r)}function r(t,i,e,o){return[["M",t+e,i],["L",t,i+o/2],["L",t+e,i+o],["Z"]]}function s(t,i,e,o){return r(t,i,e/2,o)}return{compose:function(n){if(t.pushUnique(i,n)){var a=n.prototype.symbols;a.arrow=e,a["arrow-filled"]=r,a["arrow-filled-half"]=s,a["arrow-half"]=o,a["triangle-left"]=r,a["triangle-left-half"]=s}}}}),e(i,"Extensions/CurrentDateIndication.js",[i["Core/Utilities.js"]],function(t){var i=t.addEvent,e=t.merge,o=t.wrap,r=[],s={color:"#ccd3ff",width:2,label:{format:"%a, %b %d %Y, %H:%M",formatter:function(t,i){return this.axis.chart.time.dateFormat(i||"",t)},rotation:0,style:{fontSize:"0.7em"}}};function n(){var t=this.options,i=t.currentDateIndicator;if(i){var o="object"==typeof i?e(s,i):e(s);o.value=Date.now(),o.className="highcharts-current-date-indicator",t.plotLines||(t.plotLines=[]),t.plotLines.push(o)}}function a(){this.label&&this.label.attr({text:this.getLabelText(this.options.label)})}function h(t,i){var e=this.options;return e&&e.className&&-1!==e.className.indexOf("highcharts-current-date-indicator")&&e.label&&"function"==typeof e.label.formatter?(e.value=Date.now(),e.label.formatter.call(this,e.value,e.label.format)):t.call(this,i)}return{compose:function(e,s){t.pushUnique(r,e)&&i(e,"afterSetOptions",n),t.pushUnique(r,s)&&(i(s,"render",a),o(s.prototype,"getLabelText",h))}}}),e(i,"masters/modules/gantt.src.js",[i["Core/Globals.js"],i["Gantt/Connection.js"],i["Stock/Navigator/Navigator.js"],i["Gantt/Pathfinder.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Stock/RangeSelector/RangeSelector.js"],i["Extensions/StaticScale.js"],i["Series/XRange/XRangeSeries.js"],i["Core/Chart/GanttChart.js"],i["Extensions/ArrowSymbols.js"],i["Extensions/CurrentDateIndication.js"]],function(t,i,e,o,r,s,n,a,h,l,d){t.Connection=i,t.GanttChart=h,t.ganttChart=h.ganttChart,t.Navigator=e,t.Pathfinder=o,t.RangeSelector=s,t.Scrollbar=r,l.compose(t.SVGRenderer),d.compose(t.Axis,t.PlotLineOrBand),o.compose(t.Chart,t.Point),e.compose(t.Axis,t.Chart,t.Series),s.compose(t.Axis,t.Chart),r.compose(t.Axis),a.compose(t.Axis),n.compose(t.Axis,t.Chart)})});//# sourceMappingURL=gantt.js.map