/**
 * Highcharts JS v11.2.0 (2023-10-30)
 *
 * Wind barb series module
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/windbarb",["highcharts"],function(o){return t(o),t.Highcharts=o,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var o=t?t._modules:{};function e(t,o,e,r){t.hasOwnProperty(o)||(t[o]=r.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:o,module:t[o]}})))}e(o,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),e(o,"Series/OnSeriesComposition.js",[o["Series/Column/ColumnSeries.js"],o["Core/Series/Series.js"],o["Core/Utilities.js"]],function(t,o,e){var r,i=t.prototype,n=o.prototype,s=e.defined,a=e.stableSort;return function(t){var o=[];function r(t){return n.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function p(){i.translate.apply(this);var t,o,e,r,n,p,l,u,c,h=this,f=h.options,d=h.chart,b=h.points,y=f.onSeries,v=y&&d.get(y),g=v&&v.options.step,m=v&&v.points,x=d.inverted,S=h.xAxis,j=h.yAxis,w=b.length-1,O=f.onKey||"y",C=m&&m.length,L=0;if(v&&v.visible&&C)for(L=(v.pointXOffset||0)+(v.barW||0)/2,u=v.currentDataGrouping,p=m[C-1].x+(u?u.totalRange:0),a(b,function(t,o){return t.x-o.x}),O="plot"+O[0].toUpperCase()+O.substr(1);C--&&b[w]&&"break"!==function(){if(n=m[C],(e=b[w]).y=n.y,n.x<=e.x&&void 0!==n[O]){if(e.x<=p&&(e.plotY=n[O],n.x<e.x&&!g&&(l=m[C+1])&&void 0!==l[O])){if(s(e.plotX)&&v.is("spline")){for(var r=[n.plotX||0,n.plotY||0],i=[l.plotX||0,l.plotY||0],a=(null===(t=n.controlPoints)||void 0===t?void 0:t.high)||r,u=(null===(o=l.controlPoints)||void 0===o?void 0:o.low)||i,h=function(t,o){return Math.pow(1-t,3)*r[o]+3*(1-t)*(1-t)*t*a[o]+3*(1-t)*t*t*u[o]+t*t*t*i[o]},f=0,d=1,y=void 0,x=0;x<100;x++){var S=(f+d)/2,L=h(S,0);if(null===L)break;if(.25>Math.abs(L-e.plotX)){y=S;break}L<e.plotX?f=S:d=S}s(y)&&(e.plotY=h(y,1),e.y=j.toValue(e.plotY,!0))}else c=(e.x-n.x)/(l.x-n.x),e.plotY+=c*(l[O]-n[O]),e.y+=c*(l.y-n.y)}if(w--,C++,w<0)return"break"}}(););b.forEach(function(t,o){var e;t.plotX+=L,(void 0===t.plotY||x)&&(t.plotX>=0&&t.plotX<=S.len?x?(t.plotY=S.translate(t.x,0,1,0,1),t.plotX=s(t.y)?j.translate(t.y,0,0,0,1):0):t.plotY=(S.opposite?0:h.yAxis.len)+S.offset:t.shapeArgs={}),(r=b[o-1])&&r.plotX===t.plotX&&(void 0===r.stackIndex&&(r.stackIndex=0),e=r.stackIndex+1),t.stackIndex=e}),this.onSeries=v}t.compose=function(t){if(e.pushUnique(o,t)){var i=t.prototype;i.getPlotBox=r,i.translate=p}return t},t.getPlotBox=r,t.translate=p}(r||(r={})),r}),e(o,"Series/Windbarb/WindbarbPoint.js",[o["Series/Column/ColumnSeries.js"],o["Core/Utilities.js"]],function(t,o){var e,r=this&&this.__extends||(e=function(t,o){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,o){t.__proto__=o}||function(t,o){for(var e in o)Object.prototype.hasOwnProperty.call(o,e)&&(t[e]=o[e])})(t,o)},function(t,o){if("function"!=typeof o&&null!==o)throw TypeError("Class extends value "+String(o)+" is not a constructor or null");function r(){this.constructor=t}e(t,o),t.prototype=null===o?Object.create(o):(r.prototype=o.prototype,new r)}),i=o.isNumber;return function(t){function o(){var o=null!==t&&t.apply(this,arguments)||this;return o.beaufort=void 0,o.beaufortLevel=void 0,o.direction=void 0,o.options=void 0,o.series=void 0,o.value=void 0,o}return r(o,t),o.prototype.isValid=function(){return i(this.value)&&this.value>=0},o}(t.prototype.pointClass)}),e(o,"Series/Windbarb/WindbarbSeriesDefaults.js",[],function(){return{dataGrouping:{enabled:!0,approximation:"windbarb",groupPixelWidth:30},lineWidth:2,onSeries:null,states:{hover:{lineWidthPlus:0}},tooltip:{pointFormat:'<span style="color:{point.color}">●</span> {series.name}: <b>{point.value}</b> ({point.beaufort})<br/>'},vectorLength:20,colorKey:"value",yOffset:-20,xOffset:0}}),e(o,"Series/Windbarb/WindbarbSeries.js",[o["Core/Animation/AnimationUtilities.js"],o["Extensions/DataGrouping/ApproximationRegistry.js"],o["Core/Globals.js"],o["Series/OnSeriesComposition.js"],o["Core/Series/SeriesRegistry.js"],o["Core/Utilities.js"],o["Series/Windbarb/WindbarbPoint.js"],o["Series/Windbarb/WindbarbSeriesDefaults.js"]],function(t,o,e,r,i,n,s,a){var p,l=this&&this.__extends||(p=function(t,o){return(p=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,o){t.__proto__=o}||function(t,o){for(var e in o)Object.prototype.hasOwnProperty.call(o,e)&&(t[e]=o[e])})(t,o)},function(t,o){if("function"!=typeof o&&null!==o)throw TypeError("Class extends value "+String(o)+" is not a constructor or null");function e(){this.constructor=t}p(t,o),t.prototype=null===o?Object.create(o):(e.prototype=o.prototype,new e)}),u=t.animObject,c=i.seriesTypes.column,h=n.extend,f=n.merge,d=n.pick,b=function(t){function o(){var o=null!==t&&t.apply(this,arguments)||this;return o.data=void 0,o.options=void 0,o.points=void 0,o}return l(o,t),o.prototype.init=function(o,e){t.prototype.init.call(this,o,e)},o.prototype.pointAttribs=function(t,o){var e=this.options,r=t.color||this.color,i=this.options.lineWidth;return o&&(r=e.states[o].color||r,i=(e.states[o].lineWidth||i)+(e.states[o].lineWidthPlus||0)),{stroke:r,"stroke-width":i}},o.prototype.windArrow=function(t){var o,e=t.beaufortLevel,r=this.options.vectorLength/20,i=1.943844*t.value,n=-10;if(t.isNull)return[];if(0===e)return this.chart.renderer.symbols.circle(-10*r,-10*r,20*r,20*r);var s=[["M",0,7*r],["L",-1.5*r,7*r],["L",0,10*r],["L",1.5*r,7*r],["L",0,7*r],["L",0,-10*r]];if((o=(i-i%50)/50)>0)for(;o--;)s.push(-10===n?["L",0,n*r]:["M",0,n*r],["L",5*r,n*r+2],["L",0,n*r+4]),i-=50,n+=7;if((o=(i-i%10)/10)>0)for(;o--;)s.push(-10===n?["L",0,n*r]:["M",0,n*r],["L",7*r,n*r]),i-=10,n+=3;if((o=(i-i%5)/5)>0)for(;o--;)s.push(-10===n?["L",0,n*r]:["M",0,n*r],["L",4*r,n*r]),i-=5,n+=3;return s},o.prototype.drawPoints=function(){for(var t=this.chart,o=this.yAxis,e=t.inverted,r=this.options.vectorLength/2,i=0,n=this.points;i<n.length;i++){var s=n[i],a=s.plotX,p=s.plotY;!1===this.options.clip||t.isInsidePlot(a,0)?(s.graphic||(s.graphic=this.chart.renderer.path().add(this.markerGroup).addClass("highcharts-point highcharts-color-"+d(s.colorIndex,s.series.colorIndex))),s.graphic.attr({d:this.windArrow(s),translateX:a+this.options.xOffset,translateY:p+this.options.yOffset,rotation:s.direction}),this.chart.styledMode||s.graphic.attr(this.pointAttribs(s))):s.graphic&&(s.graphic=s.graphic.destroy()),s.tooltipPos=[a+this.options.xOffset+(e&&!this.onSeries?r:0),p+this.options.yOffset-(e?0:r+o.pos-t.plotTop)]}},o.prototype.animate=function(t){t?this.markerGroup.attr({opacity:.01}):this.markerGroup.animate({opacity:1},u(this.options.animation))},o.prototype.markerAttribs=function(t,o){return{}},o.prototype.getExtremes=function(){return{}},o.prototype.shouldShowTooltip=function(o,e,r){return void 0===r&&(r={}),r.ignoreX=this.chart.inverted,r.ignoreY=!r.ignoreX,t.prototype.shouldShowTooltip.call(this,o,e,r)},o.defaultOptions=f(c.defaultOptions,a),o}(c);return r.compose(b),h(b.prototype,{beaufortFloor:[0,.3,1.6,3.4,5.5,8,10.8,13.9,17.2,20.8,24.5,28.5,32.7],beaufortName:["Calm","Light air","Light breeze","Gentle breeze","Moderate breeze","Fresh breeze","Strong breeze","Near gale","Gale","Strong gale","Storm","Violent storm","Hurricane"],invertible:!1,parallelArrays:["x","value","direction"],pointArrayMap:["value","direction"],pointClass:s,trackerGroups:["markerGroup"],translate:function(){var t=this.beaufortFloor,o=this.beaufortName;r.translate.call(this);for(var e=0,i=this.points;e<i.length;e++){for(var n=i[e],s=0;s<t.length&&!(t[s]>n.value);s++);n.beaufortLevel=s-1,n.beaufort=o[s-1]}}}),i.registerSeriesType("windbarb",b),o.windbarb||(o.windbarb=function(t,o){for(var r=0,i=0,n=0,s=t.length;n<s;n++)r+=t[n]*Math.cos(o[n]*e.deg2rad),i+=t[n]*Math.sin(o[n]*e.deg2rad);return[t.reduce(function(t,o){return t+o},0)/t.length,Math.atan2(i,r)/e.deg2rad]}),b}),e(o,"masters/modules/windbarb.src.js",[],function(){})});//# sourceMappingURL=windbarb.js.map