/*
 * L.LayerGroup is a class to combine several layers so you can manipulate the group (e.g. add/remove it) as one layer.
 */

L.LayerGroup = L.Class.extend({
	initialize: function(layers) {
		this._layers = {};
		
		if (layers) {
			for (var i = 0, len = layers.length; i < len; i++) {
				this.addLayer(layers[i]);
			}
		}
	},
	
	addLayer: function(layer) {
		var id = L.Util.stamp(layer);
		this._layers[id] = layer;
		
		if (this._map) {
			this._map.addLayer(layer);
		}
		return this;
	},
	
	removeLayer: function(layer) {
		var id = L.Util.stamp(layer);
		delete this._layers[id];
		
		if (this._map) {
			this._map.removeLayer(layer);
		}
		return this;
	},
	
	clearLayers: function() {
		this._iterateLayers(this.removeLayer, this);
		return this;
	},

	onAdd: function(map) {
		this._map = map;
		this._iterateLayers(map.addLayer, map);
	},
	
	onRemove: function(map) {
		this._iterateLayers(map.removeLayer, map);
		delete this._map;
	},
	
	_iterateLayers: function(method, context) {
		for (var i in this._layers) {
			if (this._layers.hasOwnProperty(i)) {
				method.call(context, this._layers[i]);
			}
		}
	}
});