<?php
/**
 * Mail module
 * 
 * Provide a function to format emails and get them ready to be sent
 * 
 * @package linea21\modules\mail
 * @author $Author$ - Simon Georget <simon@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

// ////////// Check Inclusion de pages ////////////
if (! class_exists ( 'auth' )) {
	include_once ("../lib/lib_common.php");
	ReloadIndex ( 'admin' );
}
// //////////

/**
 * Prepare email by setting recipient, subject, html and text bodies
 * Email is set regarding passed action ($a ['action'])
 * @param array $a Provide 'action' and wanted information to send
 * @return array $email Returns a formatted array containing email informations
 */
function prepare_email($a) {
	/**
	 * Préparation du mail
	 * $email_html_body
	 * $email_txt_body
	 * $email_subject
	 * $email_recipient
	 */
	$email = array ();
	
	$user_path = THEME_PUBLIC_PATH.'override/mail/defined/';
	
	if(file_exists($user_path.$a ['action'].'.php')) {
	    // Important : do not replace by include_once() because it will works only once !!! 
	    include($user_path.$a ['action'].'.php');
	    logfile ( LOG_MAINFILE, array ('[action] preparing email', 'using user defined template : ' . $user_path.$a ['action'].'.php'));
	    
	} else {
	   
	    logfile ( LOG_MAINFILE, array ('[action] preparing email', 'using default template : ' . $a ['action']));
	    
    	switch ($a ['action']) {
    	    
    		// USERS
    		case 'add_user' :
    			
    			$email ['html_body'] = _t ( 'user', 'mail_add_body1' ) . "<br />\n";
    			$email ['html_body'] .= _t ( 'user', 'mail_add_body2' ) . "<br /><br />\n";
    			$email ['html_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "<br />\n";
    			$email ['html_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "<br />\n";
    			
    			$email ['txt_body'] = _t ( 'user', 'mail_add_body1' ) . "\n";
    			$email ['txt_body'] .= _t ( 'user', 'mail_add_body2' ) . "\n\n";
    			$email ['txt_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "\n";
    			$email ['txt_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "\n";
    			
    			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_add_subject' ) ) . ' - ' . SITE_NAME;
    			$email ['recipient'] = $a['recipient'];
    			
    			break;
    			
    		case 'change_pass' :
    			
    			$email ['html_body'] = _t ( 'user', 'mail_changepass_body1' ) . "<br />\n";
    			$email ['html_body'] .= _t ( 'user', 'mail_changepass_body2' ) . "<br /><br />\n";
    			$email ['html_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "<br />\n";
    			$email ['html_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "<br />\n";
    			
    			$email ['txt_body'] = _t ( 'user', 'mail_changepass_body1' ) . "\n";
    			$email ['txt_body'] .= _t ( 'user', 'mail_changepass_body2' ) . "\n";
    			$email ['txt_body'] .= _t ( 'user', 'login' ) . " : " . $a['login'] . "\n";
    			$email ['txt_body'] .= _t ( 'user', 'password' ) . " : " . $a['password'] . "\n";
    			
    			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_changepass_subject' ) ) . ' - ' . SITE_NAME;
    			$email ['recipient'] = $a['recipient'];
    			
    			break;
    			
    		case 'forgot_pass' :
    			
    			$email ['html_body'] = _t ( 'user', 'mail_forgotpass_body1' ) . "<br />\n";
    			$email ['html_body'] .= '<em>' . _t ( 'user', 'mail_forgotpass_body2' ) . "</em><br /><br />\n";
    			$email ['html_body'] .= "<a href='" . get_permalink ( $a['linkpassword'] ) . "'>" . get_permalink ( $a['linkpassword'] ) . "</a><br />\n";
    			
    			$email ['txt_body'] = _t ( 'user', 'mail_forgotpass_body1' ) . "\n";
    			$email ['txt_body'] .= _t ( 'user', 'mail_forgotpass_body2' ) . "\n";
    			$email ['txt_body'] .= get_permalink ( $a['linkpassword'] ) . "\n";
    			
    			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_forgotpass_subject' ) ) . ' - ' . SITE_NAME;
    			$email ['recipient'] = $a['recipient'];
    			
    			break;
    			
    		case 'change_mail' :
    			
    			$email ['html_body'] = _t ( 'user', 'mail_changemail_body1' ) . "<br />\n";
    			
    			$email ['txt_body'] = _t ( 'user', 'mail_changemail_body1' ) . "\n";
    			
    			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_changemail_subject' ) ) . ' - ' . SITE_NAME;
    			$email ['recipient'] = $a['recipient'];
    			
    			break;
    			
    		case 'change_login' :
    			
    			$email ['html_body'] = _t ( 'user', 'mail_changelogin_body1' ) . '<b>' . $a['login'] . "</b><br />\n";
    			
    			$email ['txt_body'] = _t ( 'user', 'mail_changelogin_body1' ) . $a['login'] . "\n";
    			
    			$email ['subject'] = mb_ucfirst ( _t ( 'user', 'mail_changelogin_subject' ) ) . ' - ' . SITE_NAME;
    			$email ['recipient'] = $a['recipient'];
    			
    			break;
    		
    		case 'user_pm' :
    			
    			if (isset($a ['reply_to'])) $emailsender = " (<a href=\"mailto:".$a ['reply_to']."\">" . formatText ( $a ['reply_to'], '2HTML' ) . "</a>) ";
    			else $emailsender = '';
    			
    			$email ['html_body'] = '';
    			if (isset($a ['copy_information'])) $email ['html_body'] .= $a ['copy_information'];
    			
    			$email ['html_body'] .= "<p>" . sprintf ( _t ( 'contact', 'pm_contact_from' ), $a['userlink'], $_SESSION ['userlogin'], $emailsender, SITE_NAME ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<div><strong>" . formatText ( _t ( 'contact', 'body' )). " : </strong></div>" . PHP_EOL;
    			$email ['html_body'] .= "<div>" . formatText ( $a ['body'], '2HTML' ). "</div></b><br />" . PHP_EOL. PHP_EOL;
    			$email ['html_body'] .= "<div>" . sprintf ( _t ( 'contact', 'pm_contact_reply' ), $a['userlink'] ) ."</div>" . PHP_EOL. PHP_EOL;
    			
    			$email ['txt_body'] = '';
    			if (isset($a ['copy_information'])) $email ['txt_body'] .= strip_tags ($a ['copy_information']);
    			$email ['txt_body'] .= strip_tags ( sprintf ( _t ( 'contact', 'pm_contact_from' ), $a['userlink'], $_SESSION ['userlogin'], $emailsender, SITE_NAME )) . PHP_EOL. PHP_EOL;
    			$email ['txt_body'] .= strip_tags ( _t ( 'contact', 'body' )) . " : " . PHP_EOL . PHP_EOL;
    			$email ['txt_body'] .= strip_tags ( formatText ( $a ['body'], '2HTML' )) . PHP_EOL . PHP_EOL;
    			$email ['txt_body'] .= strip_tags (sprintf ( _t ( 'contact', 'pm_contact_reply' ), $a['userlink'] )) . PHP_EOL. $a['userlink'] . PHP_EOL . PHP_EOL;
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( formatText ( $a ['subject'], '2HTML' ). ' - %s', SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			if (isset($a ['reply_to'])) $email ['reply_to'] = array($a ['reply_to']);
    			
    			break;
    		
    		// comment
    		case 'moderate_comment' :
    			
    			$email ['html_body'] = "<p>" . sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], "<a href=\"" . $a ['item_link'] . "\">" . $a ['item_title'] . "</a> (" . $a ['item_type'] . ")" ) . " : </p>" . PHP_EOL;
    			$email ['html_body'] .= "<div><em>" . formatText ( $a ['body'], '2HTML' ) . "</em></div>" . PHP_EOL;
    			$email ['html_body'] .= "<p><a href=" . $a ['moderate_link'] . ">" . ucfirst ( _t ( 'comment', 'mail_body2' ) ) . "</a> ";
    			$email ['html_body'] .= "(" . _t ( 'comment', 'mail_body_auth' ) . ")</p>" . PHP_EOL;
    			
    			$email ['txt_body'] = sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], $a ['item_title'] . ' (' . $a ['item_type'] . ') : ' ) . PHP_EOL;
    			$email ['txt_body'] .= " - " . $a ['item_link'] . PHP_EOL . PHP_EOL;
    			$email ['txt_body'] .= formatText ( $a ['body'], '2HTML' ) . PHP_EOL . PHP_EOL;
    			$email ['txt_body'] .= ucfirst ( _t ( 'comment', 'mail_body2' ) ) . ' : ' . $a ['moderate_link'] . PHP_EOL;
    			$email ['txt_body'] .= "(" . _t ( 'comment', 'mail_body_auth' ) . ")" . PHP_EOL;
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'comment', 'mail_subject_moderate' ), SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			if (isset($a ['reply_to'])) $email ['reply_to'] = array($a ['reply_to']);
    			
    			break;
    		
    		case 'notify_comment' :
    			
    			$unsubscribe_link = $a ['unsubscribe_link'] . '&email=' . $a ['recipient'];
    			
    			$email ['html_body'] = "<p>" . sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], "<a href=\"" . $a ['item_link'] . "\">" . $a ['item_title'] . "</a> (" . $a ['item_type'] . ")" ) . " : </p>" . PHP_EOL;
    			$email ['html_body'] .= "<div><em>" . formatText ( $a ['body'], '2HTML' ) . "</em></div>" . PHP_EOL;
    			if (! isset ( $a ['adminuser'] )) {
    				$email ['html_body'] .= "<p>" . ucfirst ( _t ( 'comment', 'mail_body3' ) ) . "<a href=\"" . $unsubscribe_link . "\">" . $unsubscribe_link . "</a></p>" . PHP_EOL;
    			}
    			
    			$email ['txt_body'] = sprintf ( _t ( 'comment', 'mail_body1' ), $a ['name'], $a ['item_title'] . ' (' . $a ['item_type'] . ') : ' ) . PHP_EOL;
    			$email ['txt_body'] .= " - " . $a ['item_link'] . PHP_EOL . PHP_EOL;
    			$email ['txt_body'] .= formatText ( $a ['body'], '2HTML' ) . PHP_EOL . PHP_EOL;
    			if (! isset ( $a ['adminuser'] )) {
    				$email ['txt_body'] .= ucfirst ( _t ( 'comment', 'mail_body3' ) ) . $unsubscribe_link . PHP_EOL;
    			}
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'comment', 'mail_subject_newcomment' ), SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			
    			break;
    		
    		// workgroups
    		case 'file_alert' :
    			
    			if (isset ( $a ['is_shared'] ) && $a ['is_shared'] === true) {
    				$intro = _t ( 'workshop', 'mail_file_body1b' );
    				$url = get_permalink ( $a['wlinkworkgroups'] );
    				$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_file_subject_b' ), SITE_NAME ) );
    			} else {
    				$intro = sprintf ( _t ( 'workshop', 'mail_file_body1' ), $a ['wname'] );
    				$url = get_permalink ( $a ['wlinkfiles'] );
    				$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_file_subject' ), $a ['wname'], SITE_NAME ) );
    			}
    			$email ['html_body'] = "<p>" . $intro . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . sprintf ( _t ( 'workshop', 'mail_file_body2' ), $a ['owner'] ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<em>" . PHP_EOL;
    			if (isset ( $a ['files'] )) {
    				foreach ( $a ['files'] as $file ) {
    					$email ['html_body'] .= "- " . $file . "<br />" . PHP_EOL;
    				}
    			}
    			$email ['html_body'] .= "</em><br /><br />" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
    			$email ['html_body'] .= "<a href=" . $url . ">" . $url . "</a></p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_auth' ) . "</p>" . PHP_EOL;
    			
    			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
    			
    			$email ['recipient'] = $a ['recipient'];
    			
    			break;
    		
    		case 'topic_alert' :
    			
    			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'mail_topic_body1' ), $a ['owner'], formatText ( $a ['topic_subject'], '2HTML' ), formatText ( $a ['wname'], '2HTML' ) ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_msg_content' ) . " :</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p><em>" . formatText ( $a ['topic_body'], '2HTML' ) . "</em></p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
    			$email ['html_body'] .= "<a href=\"" . get_permalink ( $a ['wlinkforum'] ) . "\">" . get_permalink ( $a ['wlinkforum'] ) . "</a></p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_auth' ) . "</p>" . PHP_EOL;
    			
    			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_topic_subject' ), $a ['wname'], SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			break;
    		
    		case 'post_alert' :
    			
    			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'mail_post_body1' ), $a ['owner'], formatText ( $a ['topic_subject'], '2HTML' ), formatText ( $a ['wname'], '2HTML' ) ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_msg_content' ) . " :</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p><em>" . formatText ( $a ['topic_body'], '2HTML' ) . "</em></p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
    			$email ['html_body'] .= "<a href=\"" . get_permalink ( $a ['wlinkforum'] ) . "\">" . get_permalink ( $a ['wlinkforum'] ) . "</a></p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_auth' ) . "</p>" . PHP_EOL;
    			
    			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_post_subject' ), $a ['wname'], SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			break;
    		
    		case 'event_alert' :
    			
    			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'mail_calendar_body1' ), $a ['owner'], formatText ( $a ['task_subject'], '2HTML' ), $a ['wname'], formatText ( $a ['task_date'], '2HTML' ) ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_calendar_body2' ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p><em>" . formatText ( $a ['task_body'], '2HTML' ) . "</em></p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br />" . PHP_EOL;
    			$email ['html_body'] .= "<a href=\"" . get_permalink ( $a ['wlinkcalendar'] ) . "\">" . get_permalink ( $a ['wlinkcalendar'] ) . "</a></p>" . PHP_EOL;
    			// $email ['html_body'] .= "<p>"._t('workshop','mail_body_auth') . "</p>".PHP_EOL;
    			
    			$email ['txt_body'] = strip_tags ( $email ['html_body'] );
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_calendar_subject' ), $a ['wname'], SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			
    			break;
    			
    		
    		case 'workgroup_request' :
    			
    			$email ['html_body'] = "<p>" . sprintf ( _t ( 'workshop', 'workgroup_request' ), $_SESSION ['userlogin'] ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . $a ['wgroups'] . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p><em>" . _t ( 'divers', 'comment' ) . "</em> : " . formatText ( $a['comment'], '2HTML' ) . "</p>" . PHP_EOL;
    			$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br /><a href=" . $a ['moderate_link'] . ">" . $a ['moderate_link'] . "</a><br />";
    			$email ['html_body'] .= "(" . _t ( 'workshop', 'mail_body_auth' ) . ")</p>" . PHP_EOL;
    			
    			$email ['txt_body'] = strip_tags ( sprintf ( _t ( 'workshop', 'workgroup_request' ), $_SESSION ['userlogin'] ) ) . PHP_EOL;
    			$email ['txt_body'] .= strip_tags ( $a ['wgroups'] ) . PHP_EOL . PHP_EOL;
    			$email ['txt_body'] .= _t ( 'divers', 'comment' ) . ' : ' . formatText ( $a['comment'], '2HTML' ) . PHP_EOL . PHP_EOL;
    			$email ['txt_body'] .= ucfirst ( _t ( 'workshop', 'mail_body_url' ) ) . ' : ' . $a ['moderate_link'] . PHP_EOL;
    			$email ['txt_body'] .= "(" . _t ( 'workshop', 'mail_body_auth' ) . ")" . PHP_EOL;
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_request_subject' ) . ' - %s', SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			if (isset($a ['reply_to'])) $email ['reply_to'] = array($a ['reply_to']);
    			
    			break;
    		
    		
    		case 'workgroup_response' :
    			
    			$email ['html_body'] = "<p>" . sprintf($a ['message'], '"<strong>' . $a['wgname'] . '</strong>"') . "</p>" . PHP_EOL;
    			if($a['flag'] == 'accepted') {
    				$email ['html_body'] .= "<p>" . _t ( 'workshop', 'mail_body_url' ) . "<br /><a href=" . $a ['wglink'] . ">" . $a ['wglink'] . "</a><br />";
    				$email ['html_body'] .= "(" . _t ( 'workshop', 'mail_body_auth' ) . ")</p>" . PHP_EOL;
    			}
    
    			$email ['txt_body'] = strip_tags ( sprintf($a ['message'], '"<strong>' . $a['wgname'] . '</strong>"') ) . PHP_EOL . PHP_EOL;
    			if($a['flag'] == 'accepted') {
    				$email ['txt_body'] .= ucfirst ( _t ( 'workshop', 'mail_body_url' ) ) . ' : ' . $a ['wglink'] . PHP_EOL;
    				$email ['txt_body'] .= "(" . _t ( 'workshop', 'mail_body_auth' ) . ")" . PHP_EOL;
    			}
    			
    			$email ['subject'] = mb_ucfirst ( sprintf ( _t ( 'workshop', 'mail_request_subject' ) . ' "%s"' . ' - %s', $a['wgname'], SITE_NAME ) );
    			$email ['recipient'] = $a ['recipient'];
    			
    			break;
    			
    		// Yellowpages / directory
    		case 'confirm_entry' :
    			
    			$email ['html_body'] = _t ( 'yp', 'mail_body1' ) . "<br />";
    			$email ['html_body'] .= "<a href=\"" . $a ['link_entry'] . "\">" . $a ['link_entry'] . "</a><br/>\n";
    			
    			$email ['txt_body'] = strip_tags ( _t ( 'yp', 'mail_body1' ) . "\n" );
    			$email ['txt_body'] .= $a ['link_entry'] . "\n";
    			
    			$email ['subject'] = mb_ucfirst ( _t ( 'yp', 'confirm_subscription' ) . ' - ' . SITE_NAME );
    			$email ['recipient'] = $a ['recipient'];
    			break;
    		
    		// added from back-office - notification sent to submitter
    		case 'add_entry' :
    			$email ['html_body'] = _t ( 'yp', 'mail_body_added1' ) . "<br />";
    			$email ['html_body'] .= "<a href=\"" . $a ['link_entry'] . "\">" . $a ['link_entry'] . "</a><br/><br />\n";
    			$email ['html_body'] .= _t ( 'yp', 'mail_body_added2' ) . "<br /><br />";
    			
    			$email ['txt_body'] = strip_tags ( _t ( 'yp', 'mail_body_added1' ) . "\n" );
    			$email ['txt_body'] .= $a ['link_entry'] . "\n";
    			$email ['txt_body'] .= strip_tags ( _t ( 'yp', 'mail_body_added2' ) . "\n" );
    			
    			$email ['subject'] = mb_ucfirst ( _t ( 'yp', 'mail_subject_added' ) . ' - ' . SITE_NAME );
    			$email ['recipient'] = $a ['recipient'];
    			
    			break;
    			
    		case 'vote_threshold' :
    		    
    		    $email ['html_body']  = sprintf( _t ( 'like', 'over_threshold_body' ), VOTE_THRESHOLD) . "<br />";
    		    $email ['html_body'] .= "<a href=\"" . $a ['link'] . "\">" . $a ['link'] . "</a><br/><br />\n";
    		    
    		    $email ['txt_body']  = strip_tags (sprintf( _t ( 'like', 'over_threshold_body' ), VOTE_THRESHOLD)). "\n" ;
    		    $email ['txt_body'] .= $a ['link'] . "\n";
    		    
    		    $email ['subject'] = mb_ucfirst (sprintf(  _t ( 'like', 'over_threshold_subject' ), VOTE_THRESHOLD) ) . ' - ' . SITE_NAME;
    		    $email ['recipient'] = $a['recipient'];
    		    
    		    break;
    		    
    		case 'task_reminder' :
    		    $email ['html_body']  = sprintf( _t ( 'task', 'reminder_body' ), $a['link'], $a['task_project'], $a['task_label']) . "<br /><br />";
    		    $email ['html_body'] .= _t ( 'task', 'reminder_body2' ) . "<br/><br />\n";
    		    
    		    $email ['txt_body']  = strip_tags(sprintf( _t ( 'task', 'reminder_body' ), $a['link'], $a['task_project'], $a['task_label'])). "\n\n" ;
    		    $email ['txt_body'] .= strip_tags(_t ( 'task', 'reminder_body2' )). "\n" ;
    		    $email ['txt_body'] .= $a['link'] . "\n";
    		    
    		    $email ['subject'] = mb_ucfirst ( _t ( 'task', 'reminder_subject' )) . ' - ' . SITE_NAME;
    		    $email ['recipient'] = $a['recipient'];
    		    
    		    break;
    		
    		default :
    			exit ();
    	}
	}
	
	
	// adding common content 
	// $a['wrap'] not implemented yet
	if(!isset($a['wrap']) || (isset($a['wrap']) && $a['wrap'] == true)) {
		
		// preparing footers
		if(isset($a['html_footer'])) {
			$html_footer = $a['html_footer'];
		} else {
		    if(file_exists($user_path.'html-footer.php')) {
		      // Important : do not replace by include_once() because it will works only once !!! 
		      include($user_path.'html-footer.php');
		      logfile (LOG_MAINFILE, array ('[action] preparing email', 'using defined html footer template : ' . $user_path.'html-footer.php'));
        
		    } else {
		        logfile (LOG_MAINFILE, array ('[action] preparing email', 'using default html footer template'));
		        $html_footer = "<a href=\"" . SITE_ROOT_URL . "public/\" title=\""._t ( 'mail', 'reach_website' )."\">" . SITE_NAME . "</a><br /><a href=\"mailto:" . SITE_MAIL . "\" title=\""._t ( 'contact', 'contact_us' )."\">" . _t ( 'contact', 'contact_us' ) . "</a>";
			 
		    }
		}
		
		if(isset($a['txt_footer'])) {
			$txt_footer = $a['txt_footer'];
		} else {
		    
		    if(file_exists($user_path.'txt-footer.php')) {
		        
		        // Important : do not replace by include_once() because it will works only once !!! 
		        include($user_path.'txt-footer.php');
		        logfile (LOG_MAINFILE, array ('[action] preparing email', 'using defined txt footer template : ' . $user_path.'txt-footer.php'));
		        
		    } else {
		        
		        logfile (LOG_MAINFILE, array ('[action] preparing email', 'using default txt footer template'));
		        $txt_footer = strip_tags ( _t ( 'mail', 'footer' ) );
		        $txt_footer .= "\n-------------------\n";
		        $txt_footer .= SITE_ROOT_URL . "public/ - " . _t ( 'contact', 'contact_us' ) . " : " . SITE_MAIL;
		        
		    }
		    
			
		}
		
		// preparing headers
		if(isset($a['html_header'])) {
			$html_header = $a['html_header'];
		} else {
			$html_header = _t ( 'mail', 'header_hello' ) . "<br /><br />";
		}
		if(isset($a['txt_header'])) {
			$txt_header = $a['txt_header'];
		} else {
			$txt_header = _t ( 'mail', 'header_hello' ). "\n\n" ;
		}
		// We add common content to bodies
		$email ['txt_body']  = $txt_header . $email ['txt_body'] . $txt_footer;
		    
		// no html template is given or wanted
		if(defined('HTML_MAIL_TEMPLATE') && HTML_MAIL_TEMPLATE == 0) {
		    $email ['html_body'] = $html_header . $email ['html_body'] . _t ( 'mail', 'footer' ) . "<br />-----------------<br />" . $html_footer;
		    
		// we wrap all this in html template
		} else {
		    $content = file_get_contents(override('../mail/html-template.html'));
		    
		    // Encode the image string data into base64 to embed in template
		    $img = base64_encode(file_get_contents(THEME_PUBLIC_PATH.'images/email-logo.png'));
		    $logo_footer = '<a href="'.SITE_ROOT_URL.'public/" title="'._t ( 'mail', 'reach_website' ).'"><img style="max-width:200px;height:auto;" src="data:image/png;base64,'.$img.'" /></a>';
		    
		    $content = str_replace('{{subject}}',  $email ['subject'], $content);
		    $content = str_replace('{{sitename}}', SITE_NAME, $content);
		    $content = str_replace('{{header}}', $html_header, $content);
		    $content = str_replace('{{logo}}', $logo_footer, $content);
		    $content = str_replace('{{footer}}', $html_footer, $content);
		    $content = str_replace('{{body}}', $email ['html_body'] . _t ( 'mail', 'footer' ), $content);
		    
		    $email ['html_body'] = $content;
		}
	}
	
	
	
	return $email;
}

?>
