<?php
/**
 * Newsletter module
 * 
 * Provides basics methods called from public templates
 * These methods can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\modules\newsletter
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once(override('../newsletter/'.SQL.'.inc.php'));

if(!function_exists('displayNewsletter')) {

  function displayNewsletter($id) {

    $data=$GLOBALS['sql_object']->DBSelect(SQL_getNewsletter($id));

    $content=''.PHP_EOL;
    if($data!=0)
    {
    	$id = $data[0]['newsletter_id'];
      $title=formatText($data[0]['newsletter_title'], '2HTML');
      $body=formatText($data[0]['newsletter_body'], '2HTML');

      $posted_on=formatText($data[0]['published_date_display'], '2HTML');

      $content.='<h2>'.$title.'</h2>'.PHP_EOL;
      $content.='<p class="published_by">'.PHP_EOL;
      $content.=_t('statut','published_on') . ' ' .$posted_on.' ';
      $content.='</p>'.PHP_EOL;
      $content.='<div>'.$body.'</div>'.PHP_EOL;
    }
    else
    {
      $content.='<p class="info">'._t('divers','nodata').'</p>';
    }

    echo $content;
    
    return $id;
  }
}

if(!function_exists('newslettersList')) {

  function newslettersList($id) {

    $data=$GLOBALS['sql_object']->DBSelect(SQL_getPublishedNewsletters($id));
    
    $str = '';
    
    if(isset($data[0]['newsletter_id'])) {
      $str .= '<ul id="newsletternav">'.PHP_EOL;
      for($i=0; $i<count($data); $i++) {
        $title=formatText($data[$i]['newsletter_title'], '2HTML');
        $posted_on=formatText($data[$i]['published_date_display'], '2HTML');
        $link = array('rub'=> $GLOBALS['links'][U_L]['newsletter']['linkvalue'],'id'=>$data[$i]['newsletter_id'],'name'=>$title);

        $str .= '<li><a href="'.HrefMaker($link).'">'.$title.'</a> <em>('._t('statut','published_on') . ' ' .$posted_on.')</em></li>'.PHP_EOL;
      }
      $str .='</ul>'.PHP_EOL;
    }
    return $str;
  }
}

?>