<?php
/**
 * Plugins module
 * 
 * Display plugins list in back-office
 * 
 * @package linea21\core\plugins
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')) {
  include_once ("../lib/lib_common.php");
  ReloadIndex('admin');
}

$plugins = availablePlugins();

?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home') ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"> <?php echo _t('menu','plugins'); ?> </a></li>
</ul>
</div>
<!--end barre haute -->
<div class="contentcontainer"><?php include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));?>
<div id="content">
<div id="plugins_list">
<h2><?php echo _t('plugins','list'); ?></h2>
<?php if(count($plugins)>0) ?>
<ul>
<?php foreach($plugins as $plugin) { ?>
	<li style="border-bottom: 1px dotted #ccc; margin: 1em 0; min-height: 85px">
		<?php
		$plug = new plugin($plugin);
		$infos = $plug->getPluginInfo();

		if($plug->hasImage()) echo '<img src="'.$plug->imagePath().'" style="float:right;" alt="'.$plug->getVar('name').'" />';
		echo '<strong>'. $infos['shortname'] . '</strong> - ' . _t('plugins', 'author') .' : '.  $infos['author'].' - ' . _t('plugins', 'version') .' : '.$infos['version'].'<br />';
		echo _t('plugins', 'description') .' : '.$infos['description'].'<br />';
		echo _t('plugins', 'compatibility') .' : '.$infos['compatibility'].'<br />';
		echo _t('plugins', 'homepage') .' : ';
		if(!empty($infos['homepage'])) echo '<a href="'.$infos['homepage'].'">'.$infos['homepage'].'</a>';
		else echo empty_nc('');
		echo '<br />'.PHP_EOL;
		echo '<div class="links">';
		if($plug->is_active()) {
		  echo '<span style="color:#0BC221">'._t('plugins', 'enabled'). '</span> | ';
		  echo '<a href="index.php?rub=plugins&amp;todo=disable&amp;name='.$plug->getVar('name').'">'._t('plugins','disable').'</a>';
		  if($plug->hasAdvancedSettings()) echo ' | <a href="index.php?rub=plugins&amp;current='.$plug->getVar('name').'">'._t('plugins','access').'</a>';
		} else {
		  echo '<span style="color:#FF0000">'. _t('plugins', 'disabled'). '</span> | ';
		  echo '<a href="index.php?rub=plugins&amp;todo=enable&amp;name='.$plug->getVar('name').'">'._t('plugins','enable').'</a>';
		}
		echo ' | <a href="index.php?rub=system&amp;todo=edit_files&amp;plugin='.$plug->getVar('name').'">'._t('plugins','edit_files').'</a>';
		echo '</div>';
		if(!is_writable($plug->getVar('relative_url'))) {
			echo '<p class="error">'._t('plugins', 'folder_not_writable').'</p>';
		}
		?></li>
		<?php
} // closing foreach instruction
?>
</ul>
</div>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->