<?php
/**
 * Project module
 * 
 * Script to send reminder based on defined tasks
 * Should be called using a cronjob
 * 
 * @package linea21\modules\project
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../config/define.php');
include_once('../class/class.project.php');
include_once('../class/class.project_task.php');
include_once(override('../mail/mail_actions.php'));
include_once(override('../mail/send.php'));
include_once('../project/'.SQL . '.inc.php');
include_once('../languages/' . U_L . '/lang_common.' . CHARSET . '.php');
include_once('../languages/' . U_L . '/lang_project.' . CHARSET . '.php');

@set_time_limit(0); // suppression du timeout

$otask = new projectTask();

// necessary for cron / CLI call
chdir (__DIR__);

// if called from command-line (cron)
// Crontab syntax
// * * * * * /usr/bin/php -q /var/www/linea21/admin/send.php token=mySecretToken
// * * * * * /usr/bin/php /home/simon/www/linea21_dev/admin/cron.php token=6255533e95978ff87c168b71e413frd4
// OR
// * * * * * curl -s http://yourinstall.com/admin/cron.php
// * * * * * /usr/bin/curl http://localhost/linea21_dev/admin/cron.php?token=6255533e95978ff87c168b71e413frd4
if (PHP_SAPI === 'cli') {

	// we get the given token
	parse_str($argv[1], $_GET);
	$source = 'cron_call';

} else {
	$source = $_SERVER["REQUEST_URI"];
}

// we check if the given token is correct
// else we quit
if(!isset($_GET['token']) || $_GET['token'] != SECRET_KEY) die('Invalid token!');


// sélection des tâches 
$tasks = $GLOBALS['sql_object']->DBSelect(SQL_get_project_tasks_for_reminder());



if(!is_array($tasks)) exit();

// pour chacune des tâches, on récupère l'échéance du prochain envoi
foreach ($tasks as $task) {
    
    // print_r($task);

    $r = $GLOBALS['sql_object']->DBSelect(SQL_get_next_reminder_date($task['task_id'], $task['task_reminder_freq']));
    
    //echo '-- Date du jour : '.date('Y-m-d'). ' / prochain envoi : '. formatDate($r[0]['next_send'], true) .  ' <br />';

    // c'est l'heure d'envoyer le rappel !!!!
    if(formatDate($r[0]['next_send'], true) == date('Y-m-d')) {
        
        // echo '<h1>'. $task['task_id'].'</h1>';
        
        $a = array();
        
        $a['link'] = SITE_ROOT_URL.'admin/index.php?rub=project&todo=mod&id='.$task['task_project_id'];
        $a['task_label'] = $task['task_label'];
        $a['task_project'] = $task['project_name'];
        $a['action'] ='task_reminder';
        
        $users = $GLOBALS['sql_object']->DBSelect(SQL_getAssociatedManagers($task['task_project_id']));
        
        // s'il y a des utilisateurs
        if(is_array($users)) {
            
            foreach($users as $user) {
                $a['recipient'] = $user['profile_email'];

                $emailContainer = prepare_email($a);
                $r = send_email($emailContainer);
                if($r) $otask->update_lastsend($task['task_id'], $GLOBALS['sql_object']);
            }
        }
    }
    
}

?>