<?php
/**
 * Default accessibility italian file
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>


<?php
// set HTML Title
SetHTMLTitle('Carta d\'accessibilità Linea21');
setBreadcrumb(array('Carta d\'accessibilità Linea21' => false));
?>

<div id="accessibilita">
<h1>Carta d'accessibilità Linea21</h1>
<div class="sub-title">Questo sito è concepito
per essere letto da tutti gli internauti, indipendentemente dai loro
handicap, dal mezzo utilizzato e dall'hardware.</div>


<h2>Access key</h2>
<p>La maggiorparte dei naviganti autorizza l'esecuzione dei link
attraverso una combinazione di tasti definita sul sito. <br />
Tutte le pagine di questo sito contengono questi <span xml:lang="en">accesskey</span>
:</p>
<dl>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['accessibility']['accesskey'] ?></kbd>
	:</dt>
	<dd>Carta d'accessibilità</dd>
	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['home']['accesskey'] ?></kbd>
	:</dt>
	<dd>Home</dd>
	<dt xml:lang="en">Access key <kbd>2</kbd> :</dt>
	<dd>Contenuto</dd>

	<dt xml:lang="en">Access key <kbd><?php echo $GLOBALS['links'][U_L]['search']['accesskey'] ?></kbd>
	:</dt>
	<dd>Ricerca</dd>
</dl>
<br style="clear: both;" />
<h2 style="margin-top: 1em">Rispetto degli standard</h2>
<ul>
	<li>Tutte le pagine di questo sito sono state convalidate <abbr title="HyperText Markup Language">HTML</abbr>5.</li>
	<li>Tutte le pagine di questo sito rispettano i valori semantici. i tags H1 sono utilizzati per i titoli principali i tags H2 per i
	sottotitoli.</li>
</ul>


<h2>Aiuto alla navigazione</h2>
<ul>
	<li>Tutte le pagine di questo sito contengono gli elementi di
	navigazione e di relazione tra esse. <br />
	<pre>
			<code>
&lt;link rel="home" title="home" href="home" /&gt;
&lt;link rel="search" title="ricerca" href="ricerca" /&gt;
&lt;link rel="help" title="Carta d'accessibilità Linea21" href="accessibilita" /&gt;
			</code>
		</pre></li>
	<li>La home page e tutte le altre pagine includono un campo di ricerca (access key <kbd>4</kbd>).</li>
</ul>

<h2>Link</h2>
<ul>
	<li>La maggior parte dei link hanno un attributo "titolo" che descrive
	il link in dettaglio.</li>
	<li>I link sono scritti per avere un senso fuori contesto.</li>
	<li>I linguaggi di script sono utilizzati per migliorare il confort di
	navigazione, tuttavia la loro disattivazione non comporta nessuna
	restrizione di accessibilità al contenuto e alla navigazione.</li>
</ul>

<h2>Immmagini</h2>
<ul>
	<li>Tutte le immagini decorative sono incluse sotto forma di stile <abbr
		title="Cascading Style Sheet">CSS</abbr>.</li>
	<li>Le immagini relative al contenuto utilizzano tutti i tags
	descrittivi <acronym title="Alternative">Alt</acronym>.</li>
</ul>

<h2>Moduli</h2>
<ul>
	<li>Uno sforzo è stato fatto per rendere i moduli accessibili :
	l'utilizzo del tag 'LABEL' associa un senso ad ogni campo.</li>
</ul>

<h2>Visual design</h2>
<ul>
	<li>Questo sito utilizza i fogli di stile in cascata (<abbr
		title="Cascading Style Sheet">CSS</abbr>) per la presentazione
	grafica. Se il vostro browser non supporta <abbr
		title="Cascading Style Sheet">CSS</abbr>, il contenuto del sito resta
	leggibile.</li>
	<li>Questo sito utilizza esclusivamente delle dimensioni dei caratteri
	relative, compatibili con l'opzione "dimensioni del testo" specificata
	dall'utente nel visual browser. Attraverso la scorciatoia <kbd>ctrl +
	rotella del mouse</kbd>, potete cambiare la dimensione del testo.</li>
</ul>


<h2>Avvertenze - responsabilità</h2>
<ul>
	<li>Il contenuto pubblicato su questo sito non proviene da <a
		href="<?php echo SITE_LINEA_URL; ?>">Linea21</a>, non possiamo
	garantire un'accessibilità perfetta dei dati contenuti alla radice
	dell'applicazione.</li>
	<li>Non esitate a segnalarci i punti deboli o a renderci partecipi
	delle vostre osservazioni relative all'accessibilità dell'informazione
	contenuta in questo sito : <a href="mailto:<?php echo MAIL_LINEA; ?>"><?php echo MAIL_LINEA; ?></a></li>
</ul>

<h2>Riferimenti</h2>
<ul>
	<li><a href="https://www.w3.org/TR/WCAG21/"
		title="Web Content Accessibility Guidelines (WCAG) 2.1" hreflang="en">normas</a> Web Content Accessibility Guidelines (WCAG) 2.1 (<abbr title="World Wide Web Consortium">W3C</abbr>)</li>
</ul>

<h2>Utility gratuite</h2>
<ul>
	<li><a href="http://validator.w3.org/" hreflang="en">W3C MarkUp
	Validation Service</a> : controllo della sintassi delle pagine <abbr
		title="HyperText Markup Language ">HTML</abbr> et <abbr
		title="eXtensible HyperText Markup Language">XHTML</abbr>.</li>
	<li><a href="http://jigsaw.w3.org/css-validator/" hreflang="en">W3C CSS Validation service</a> : controllo di conformità sintattica dei fogli
	di stile in cascata.</li>
	<li><a href="https://wave.webaim.org/" title="Access to WAVE Web Accessibility Evaluation Tools" hreflang="en">WAVE tool</a></li>
	<li><a href="http://www.w3.org/People/Raggett/tidy/"
		title="Clean up your Web pages with HTML TIDY" hreflang="en"><abbr
		title="HyperText Markup Language ">HTML</abbr> Tidy</a> : un utility
	che corregge rapidamente la maggior parte degli errori di sintassi del
	linguaggio <abbr title="HyperText Markup Language">HTML</abbr> ed
	offre qualche consiglio di accessibilità.</li>
	<li><a href="http://www.delorie.com/web/wpbcv.html" hreflang="en">Web
	Page Backward Compatibility Viewer</a> : permette di rendersi conto
	dell'aspetto di una pagina Web all'interno di un software più vecchio o
	meno potente.</li>
</ul>
</div>