<?php
/**
 * Default dashboard template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

$GLOBALS['filters'][U_L]['scale']['active'] = 0; // filter activation
SetHTMLTitle(_t('dashboard','section')); // HTML title
//////////////////////////////////////////
/////récupération des variables GET et POST
//////////////////////////////////////////
include_once(override('../dashboard/display.php'));

// if $_REQUEST['parentid'] is not fired, ID's value goes to $scale_id var
if(isset($_REQUEST['id'])) {
	$scale_id=$_REQUEST['id'];
} else {
	$scale_id=1;
}
// if parentid is fired, ID's value goes to $sdi_id var
// and parentid's value goes to $scale_id
if (isset($_REQUEST['parentid'])) {
  $sdi_id=$_REQUEST['id'];
  $scale_id=$_REQUEST['parentid'];
}

isset($_REQUEST['altmode']) ? $altmode = true : $altmode = false;


$scale = $GLOBALS['sql_object'] -> DBSelect(SQL_getonescale($scale_id));


//////////////////////////////////////////
/////affichage tableau de bord
//////////////////////////////////////////

if(!isset($_REQUEST['parentid'])) {

  if ( ActiveItemKey($GLOBALS['activeitem']) == 'dashboard') {
	
    setBreadcrumb(array(ucfirst(_t('dashboard','section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue']))));

		
	$link_mainlist = array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue']);
		
    //////////////////////////////////////////
    /////affichage liste des indicateurs
    //////////////////////////////////////////

    echo getDataVizSwitcher($altmode, $scale_id);
    
    
    if(isset($_REQUEST['filter']) && $_REQUEST['filter'] == $GLOBALS['filters'][U_L]['tag']['linkvalue'] ) {
        
        // getting tags
        include_once('../class/class.tag.php');
        $otag = new tag;
        $current_tag = $otag->getTagById($_REQUEST['id']);
        
        if($current_tag) echo '<h2 class="tag-filtered">'.sprintf(_t('selected', 'by_tag'), '<span>'.$current_tag['name'].'</span>').'</h2>';
        
        echo '<div class="primary-nav-container"><div class="switchnav">';
        echo '<a class="button" href="'.HrefMaker($link_mainlist).'" title="'._t('divers','goto_currentlist').'">'._t('divers','goto_currentlist').'</a>'.PHP_EOL;
        echo '</div></div>';
    }    

    echo "<h1>"._t('dashboard','list_public'). " - " . formatText($scale[0]['scale_denomination'], '2HTML') ."</h1>".PHP_EOL;
    
    GetScaleFilter();
    
    $slot = get_page_slot('dashboard'); // default slot
    if($slot) $chapo = $slot;
    else $chapo = _t('dashboard','h1_public_comment');
    echo '<div class="sub-title">'.$chapo.'</div>'.PHP_EOL;

    if( $altmode ) {
        DisplayListProjectByLevelsWithIndicators('P', $GLOBALS['filters'][U_L]['scale']['linkvalue'], 1);
    } else {
    	DisplayListValuesByLevelsAlt($scale_id, $GLOBALS['filters'][U_L]['scale']['linkvalue']);
    	// DisplayListValuesByLevels($scale_id, $GLOBALS['filters'][U_L]['scale']['linkvalue']);
    }
  }
?>
<?php 
if(defined('ANIMATE_PROGRESS') && ANIMATE_PROGRESS == 1) { 
footerAddJS('../lib/js/waypoints/lib/jquery.waypoints.min.js');
?>
		<script>
		$(document).ready(function() {

			function animate_gauge_css(obj) {
				var tmp = $(obj).css('left'); // get position
				$(obj).css('left', 0); // set to min
		 		$( obj ).animate({left : tmp}, getRandomInt(2000, 4000)); // animate
			};
			
			function animate_gauge(obj) {	// @todo remove when removing image gauge
				var tmp = $(obj).css('left'); // get position
				$(obj).css('left', -110); // set to min
		 		$( obj ).animate({left : tmp}, getRandomInt(2000, 4000)); // animate
			};

			function animate_raw(obj) {
				var $this = obj;
				var endval = $this.attr('data-value');
				if(isNaN(endval)) return true;
				$({ Counter: 0 }).animate({ Counter: endval }, {
					duration: getRandomInt(2000, 4000),
					easing: 'swing',
					step: function () {
					   $this.text(Math.ceil(this.Counter) > endval ? number_f(endval) : number_f(Math.ceil(this.Counter)));
					},
					done: function() {
						// console.log("end value : " + endval);
						$this.text(number_f(endval));
					}
					
			  });
			};

			/**
			* Waypoints animation - Method A
			* animate when scrolled to object position
			*/
			var waypoints_gauge = $('.dashboard-indicator-gauge div.circle').waypoint({
				  handler: function(direction) {
				    animate_gauge_css($(this.element));
				    this.destroy();
				  }, 
		      offset: 'bottom-in-view'     
			});
			
			var waypoints_gauge = $('.dashboard-indicator-gauge > img.cursor').waypoint({ // @todo remove when removing image gauge
				  handler: function(direction) {
				    animate_gauge($(this.element));
				    this.destroy();
				  }, 
		      offset: 'bottom-in-view'     
			});
			var waypoints_raw = $('.dashboard-indicator-raw > span.infobox.value:not(".boolean-mask")').waypoint({
				  handler: function(direction) {
				    animate_raw($(this.element));
				    this.destroy();
				  }, 
		      offset: 'bottom-in-view'     
			});

			
			/**
			* Animate anyway - Method B
			*/
			// animate the gauges representation
// 			$('.dashboard-indicator-gauge > img.cursor').each(function(index) {
// 				animate_gauge($(this));
// 			});
// 			// animate raw representation
// 			$('.dashboard-indicator-raw > span.infobox.value:not(".boolean-mask")').each(function(index) {
// 				console.log($(this));
// 			 animate_raw($(this));
// 			});
		});
		</script>
<?php } ?>  

<?php
} else {
  //////////////////////////////////////////
  /////affichage détail d'un indicateur
  //////////////////////////////////////////

  // set HTML Title
  $result=$GLOBALS['sql_object']->DBSelect(SQL_getOnesdiname($sdi_id));
  if(!is_array($result)) error_redirect(); // if no record found, we redirect to error page();
  SetHTMLTitle(formatText($result[0]['sdii_name'], '2HTML'));
  setBreadcrumb(array(ucfirst(_t('dashboard','section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue']))));
  // setBreadcrumb(array(formatText($result[0]['sdii_name'], '2HTML') => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['dashboard']['linkvalue'], 'id' => $sdi_id, 'parentid' => $scale_id, 'name' => formatText($result[0]['sdii_name'], '2HTML')))));
  setBreadcrumb(array(formatText($result[0]['sdii_name'], '2HTML') => false));
  
  
  echo '<div>'.PHP_EOL;
  if(commentEnabled('indicator')) {
    postCommentAction(array('module'=> 'indicator', 'module_id'=> $sdi_id, 'module_pid' => $scale_id));
    echo '<div id="anchor-comments">'.PHP_EOL;
    echo getCommentsAnchor(array('module'=> 'indicator', 'module_id'=> $sdi_id));
    echo getPostCommentAnchor();
    echo '</div>'.PHP_EOL;
  }
  
  DisplayOneSdi($sdi_id, $scale_id);
  
  if(commentEnabled('indicator')) {
    echo '<h3>'._t('comment', 'section').'</h3>'.PHP_EOL;
    echo '<div id="comments">'.PHP_EOL;
    displayComments(array('module'=> 'indicator', 'module_id'=> $sdi_id, 'order_by' => 'ASC'), false, true);
    displayCommentForm(array('module'=> 'indicator', 'module_id'=> $sdi_id, 'module_pid' => $scale_id));
    echo '</div>'.PHP_EOL;
  }
  echo '</div>'.PHP_EOL;

  echo '<script>
		$(document).ready(function() {
		   var cboxOptions = { iframe:true, innerWidth: "80%", innerHeight: "85%", maxWidth: "1080px", maxHeight: "960px"  } // to call chart on multi-values indicators
	       $(".see-detail-chart").colorbox(cboxOptions);
	       $(window).resize(function(){ $.colorbox.resize({ width: window.innerWidth > parseInt(cboxOptions.maxWidth) ? cboxOptions.maxWidth : cboxOptions.width, height: window.innerHeight > parseInt(cboxOptions.maxHeight) ? cboxOptions.maxHeight : cboxOptions.height }); });

			$(".valuecomment").hover(
				function() {
					$(".cont", this).fadeIn();
				},
				function() {
					$(".cont", this).hide();
				}
			);
		})
		</script>';
}?>