<?php
/**
 * Default search and search results template
 * 
 * This file can be overriden. Discover logic and examples on :
 * @url http://dev.linea21.com/projects/linea21/wiki/Override
 * @url http://dev.linea21.com/projects/linea21/wiki/Personnalisation_de_l%27interface_publique
 * 
 * @package linea21\core\public
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>

<?php
include_once(override('../search/display.php'));

if(ActiveItemKey($GLOBALS['activeitem'])=='search-result') {
  SetHTMLTitle(_t('search','section')); // set HTML title
  SetHTMLTitle(_t('search','result')); // set HTML title
  setBreadcrumb(array(ucfirst(_t('search','section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['search']['linkvalue']))));
  setBreadcrumb(array(ucfirst(_t('search','result')) => false));

  echo '<h1>'._t('search','result').'</h1>';

  if(!isset($_REQUEST['search']) || strlen($_REQUEST['search']) <= 2) {
    echo '<div class="info">';
    echo _t('search','min_length');
    echo '</div>';
  } else {
    $str=strip_tags($_REQUEST['search']);
    $searchtype=isset($_REQUEST['searchtype']) ? $_REQUEST['searchtype'] : 'one';
    echo '<h2>'._t('search','keywords') .'\''.formatText($str,'2HTML').'\'</h2>'.PHP_EOL;

    $start_time = getmicrotime();
    DisplayPublicResults($str, $searchtype);
    $end_time = getmicrotime();
    DisplayQueryTime($start_time, $end_time);
    logfile(LOG_MAINFILE,array('[action] performing search', $str, 'PUBLIC', $searchtype, i2c_realip()));
    footerAddJS('../lib/js/jquery.easyMark.js');
    // we remove words < 3 chars
    $keywords = preg_replace(array('/\b\w{1,2}\b/','/\s+/'),array('',' '),$_REQUEST['search']);
    $js = "$('#main div').easymark('highlight', '".formatText($keywords, '2ATT')."');";
    footerAddInlineJS($js);
  }
}

if(ActiveItemKey($GLOBALS['activeitem'])=='search') {
  SetHTMLTitle(_t('menu','advancedsearch')); // set HTML title
  setBreadcrumb(array(ucfirst(_t('search','section')) => HrefMaker(array('rub'=> $GLOBALS['links'][U_L]['search']['linkvalue']))));
  setBreadcrumb(array(ucfirst(_t('menu','advancedsearch')) => false));

  echo '<h1>'.mb_ucfirst(_t('menu','advancedsearch')).'</h1>';
  DisplayAdvancedSearchForm();
}
?>