<?php
/**
 * @package linea21\templates\admin
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @param  $rub : connu de admin/index.php
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * displayitem()
 * affichage des items du menu. Prise en charge de leur ETAT : actif ou non
 *
 * @param string $rubactive
 * @param string $currentrub
 * @param string $accesskey
 * @return string $content
 */

function displayitem($rubactive, $currentrub, $accesskey)
{
  $content = "<li><a href=\"index.php?rub=" . $currentrub . "\" accesskey=\"" . $accesskey . "\" title=\"" . _t('menu_alt', $currentrub) . "\" id=\"menu_".$currentrub."\" >" . mb_ucfirst(_t('menu_alt', $currentrub)) . "</a></li>\n";
  return $content;
}

$menu_constructor_com = '';
$menu_constructor_gestion = '';
$menu_constructor_config = '';

if (MOD_NEWS === 1 && $l21auth->hasRight('news')) $menu_constructor_com .= displayitem($rub, 'news', 'a');


if (MOD_PUBLICATION === 1 && $l21auth->hasRight('publication')) $menu_constructor_com .= displayitem($rub, 'publication', 'd');

if (MOD_NEWSLETTER === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'newsletter', 'r');
if (MOD_COMMENT === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'comment', '');
if (MOD_LIBRARY === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'library', 'l');
if (MOD_PAGE === 1 && $l21auth->isSuperAdmin()) $menu_constructor_com .= displayitem($rub, 'page', 'c');

if (MOD_WORKSHOP === 1 && $l21auth->hasRight('workshop')) $menu_constructor_gestion .= displayitem($rub, 'workshop', 'g');
if (MOD_PROJECT === 1 && $l21auth->hasRight('project')) $menu_constructor_gestion .= displayitem($rub, 'project', 'p');
if (MOD_SDI === 1 && $l21auth->hasRight('sdi')) $menu_constructor_gestion .= displayitem($rub, 'sdi', 'b');
if (MOD_DASHBOARD === 1 && $l21auth->hasRight('dashboard')) $menu_constructor_gestion .= displayitem($rub, 'dashboard', 'i');
if (MOD_YELLOWPAGES === 1 && $l21auth->hasRight('yellowpages')) $menu_constructor_gestion .= displayitem($rub, 'yellowpages', 'y');

if (MOD_USER === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'user', 'u');
if (MOD_LEVEL === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'level', 'l');
if (MOD_SCALE === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'scale', 'e');
if (MOD_TAG === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'tag', 'n');
if (MOD_SYSTEM === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'system', 'n');
if (MOD_PLUGINS === 1 && $l21auth->isSuperAdmin()) $menu_constructor_config .= displayitem($rub, 'plugins', 'o');
?>
<a href="<?php echo SITE_LINEA_URL; ?>" id="l21_logo" title="<?php echo SITE_LINEA_NAME; ?>"><span><?php echo SITE_LINEA_NAME; ?></span></a>
<div class="wrap-menu txtcenter" id="main-menu-wrapper">
<nav id="main-menu">
    <ul class="containermenu">
    	<li><a href="index.php" class="menu" id="menu_home"><?php echo $GLOBALS['lang']['menu_alt']['home_dashboard'];?></a></li><!--   @whitespace
		 --><li class="menu" id="menu_com"><?php echo $GLOBALS['lang']['menu_alt']['communication'];?>
    	<ul class="sub_menu" id="menu_com_list">
    	<?php $dispatcher->notify(new sfEvent('primary_menu', 'admin_menu_com.menu_start'));?>
    	<?php echo $menu_constructor_com; ?>
    	<?php $dispatcher->notify(new sfEvent('primary_menu', 'admin_menu_com.menu_end'));?>
    	</ul>
    	</li><!--   @whitespace
		 --><li class="menu" id="menu_gestion"><?php echo $GLOBALS['lang']['menu_alt']['suivi_gestion'];?>
    	<ul class="sub_menu" id="menu_gestion_list">
    	<?php $dispatcher->notify(new sfEvent('primary_menu', 'admin_menu_gestion.menu_start'));?>
    	<?php echo $menu_constructor_gestion; ?>
    	<?php $dispatcher->notify(new sfEvent('primary_menu', 'admin_menu_gestion.menu_end'));?>
    	</ul>
    	</li><!--   @whitespace
		 --><li class="menu" id="menu_config"><?php echo $GLOBALS['lang']['menu_alt']['configuration'];?>
    	<ul class="sub_menu" id="menu_config_list">
    	<?php $dispatcher->notify(new sfEvent('primary_menu', 'admin_menu_config.menu_start'));?>
    	<?php echo $menu_constructor_config; ?>
    	<?php $dispatcher->notify(new sfEvent('primary_menu', 'admin_menu_config.menu_end'));?>
    	</ul>
    	</li><!--   @whitespace
		 --><li><a href="#aide" class="menu" id="menu_help_interface"><?php echo _t('help','title');?></a></li>
    </ul>
</nav>
</div>