<?php
/**
 * Workgroup module
 * 
 * Workgroup detail page
 * 
 * @package linea21\modules\workshop
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];
//////////// Check Inclusion de pages ////////////
if (!class_exists('auth')){
  include_once("../lib/lib_common.php");
  ReloadIndex('admin');
}
////////////

//////////// Check Droits utilisateur ////////////
if (!$l21auth->hasRight('workshop') && !$l21auth->isSuperAdmin())
	ReloadIndex('admin');
////////////

include_once('../class/class.workshop.php');
$workshop_object = new workshop;
include_once("../lib/input_helpers.php");

// From that page, the administrator is able to import users from another group
// we do that if needed
if(isset($_POST['valider'])) {

	if(isset($_POST['workshop_import']) && $_POST['workshop_import'] != 0) {
		$workshop_object= new workshop;
		$r = $workshop_object->importUsers($id, $_POST['workshop_import'], $sql_object);
	}
	
}
	
$req_det= SQL_getoneCompleteWorkshop($id);
$result=$sql_object->DBSelect($req_det);

// Do record exists?
if(!isset($result[0]['workshop_denomination'])) redirect_to('@module_default');

if ($result[0]['workshop_statut']<>'P' && !$l21auth->isSuperAdmin()){
  ReloadIndex('admin');
}

$link_det=$rub_link."&amp;todo=det&amp;id=";
$link_sup=$rub_link."&amp;todo=sup&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";
$link_det_u="index.php?rub=user&amp;todo=det&amp;id=";
$link_det_level="index.php?rub=level&amp;todo=det&amp;id=";

$link_sup_u=$rub_link."&amp;todo=sup_u&amp;id=";
$link_add_u=$rub_link."&amp;todo=add_u&amp;id=";
$link_list_cal=$rub_link."&amp;todo=list_cal&amp;id=";
$link_list_com=$rub_link."&amp;todo=list_com&amp;id=";
$link_sup_rep="index.php?rub=workshoprep&amp;todo=sup&amp;id=";
$link_mod_rep="index.php?rub=workshoprep&amp;todo=mod&amp;id=";
$link_det_rep="index.php?rub=workshoprep&amp;todo=det&amp;id=";
$link_add_rep="index.php?rub=workshoprep&amp;todo=add&amp;work_id=";

$workshop_denomination=formatText($result[0]['workshop_denomination'], '2HTML');
$workshop_resume=empty_nc(formatText($result[0]['workshop_resume'], '2HTML'));
$workshop_comment=empty_nc(formatText($result[0]['workshop_comment'], '2HTML'));
$level_denomination=empty_none(formatText($result[0]['level_name'], '2HTML'));

$workshop_statut=display_statut($result[0]['workshop_statut']);
$display_date_crea=$result[0]['workshop_date_crea_display'];
$display_last_modify=$result[0]['workshop_last_modify_display'];

// getting associated projects
$projects = $sql_object->DBSelect(SQL_getAssociatedProjects($id, array('P', 'PA')));

if(isset($projects[0]['project_id'])) {
	
	$workshop_projects = '<ul>';
	for($i=0; $i < count($projects); $i++) {
		$link_project = 'index.php?rub=project&amp;todo=det&amp;id='.$projects[$i]['project_id'];
		$workshop_projects .= '<li><a href = "'. $link_project .'" title="'. $projects[$i]['project_name'].'">'. $projects[$i]['project_name'] . '</a></li>';
	}
	$workshop_projects .= '</ul>';
} else $workshop_projects = empty_none('');


// select-box de workshops
$data=$sql_object->DBSelect(SQL_get_all_workshop());
$select_workshop=WorkshopSelectBox($data, "workshop_import", $id);

$import_users  ='<div id="import-users-box">';
// $import_users .= '<div class="box-title"><a href="#" class="import-users">' . _t('workshop', 'import_users') . '</a></div>';
$import_users .= '<div><form method="post" action="'.$_SERVER['SCRIPT_NAME'].'" id="importusers" class="secondary-form">';
$import_users .= '<div class="box-toggle"><h4>'._t('workshop','import_users').'</h4>';
$import_users .= '<div class="flex-container box-content row">';
$import_users .= '<div class="w150p" style="margin-top:1.5em;">' . _t('workshop', 'import_from') . '</div>';
$import_users .= '<div class="item-fluid" style="margin-top:0.6em;">'.$select_workshop.'</div>';
$import_users .= '<div class="w150p" style="  "><input name="rub" type="hidden" value="'.$rub.'" id="rub" />';
$import_users .= '<input name="todo" type="hidden" value="'.$todo.'" id="todo" />';
$import_users .= '<input name="id" type="hidden" value="' . $id . '" id="id_workshop" />';
$import_users .= '<input type="submit" id="valider" class="button" value="'._t('btn','valid').'" name="valider" />';
$import_users .= '</div>';
$import_users .= '</div><!-- closing box-content --></div>';
$import_users .= '</form></div>';
$import_users .= '</div>';
		
if($result[0]['workshop_restricted'] == 1) {
	$workshop_restricted = _t('divers', 'yes');
} else {
	$workshop_restricted = _t('divers', 'no');
}

if($result[0]['workshop_visible'] == 1) {
    $workshop_visible = _t('divers', 'yes');
} else {
    $workshop_visible = _t('divers', 'no');
}

$workshop_object= new workshop ;

$req_user=SQL_getWorkshopUserList($id);
$result_user = $sql_object -> DBSelect($req_user);

//récupération des organisateurs du workshop
$workshop_organizer='';
$j=0;
for($i=0; $i<count($result_user); $i++) {
  if ($result_user[$i]['jwu_user_right']=='O'){
    $j++;
    if ($j<>1) $workshop_organizer.=", ";
    $workshop_organizer.=$result_user[$i]['user_login'];
  }
}

// formattage des données

//prepa affichage des infos générales
$reca_generals="<h3 class=\"part\">\n"._t('workshop','generals')." : </h3>\n";
$reca_generals.="<dl class=\"summary\">\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','title'))." :</dt>\n";
$reca_generals.="<dd>". $workshop_denomination."</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','resume')). " :</dt>\n";
$reca_generals.="<dd>".$workshop_resume."</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','organizer'))." :</dt>\n";
$reca_generals.="<dd>".$workshop_organizer. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','restricted')). " :</dt>\n";
$reca_generals.="<dd>".$workshop_restricted."</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','visible')). " :</dt>\n";
$reca_generals.="<dd>".$workshop_visible."</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','level'))." :</dt>\n";
if ($l21auth->isSuperAdmin() && $result[0]['level_id'] != 0)
$reca_generals.="<dd><a href=\"".$link_det_level.$result[0]['level_id']."\" title=\"".$level_denomination."\">".$level_denomination."</a></dd>\n";
else $reca_generals.="<dd>".$level_denomination."</dd>\n";

$reca_generals.="<dt>".mb_ucfirst(_t('divers','date_crea')) ." :</dt>\n";
$reca_generals.="<dd>". $display_date_crea. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','last_modify')) ." :</dt>\n";
$reca_generals.="<dd>". $display_last_modify. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('divers','statut'))." :</dt>\n";
$reca_generals.="<dd>". $workshop_statut. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','comment'))." :</dt>\n";
$reca_generals.="<dd>". $workshop_comment. "</dd>\n";
$reca_generals.="<dt>".mb_ucfirst(_t('workshop','associated_projects'))." :</dt>\n";
$reca_generals.="<dd>". $workshop_projects. "</dd>\n";
$reca_generals.="</dl>\n";


// Récuperation des différentes parties

//prepa affichage des utilisateurs du workgroup

if($result_user==false) $contents_user="<div class=\"info\">"._t('workshop','no_user')."</div>";
else {
  $contents_user= "<table class=\"table2 multisort\">\n";
  $contents_user.="<thead>\n";
  $contents_user.="<tr>\n";
  $contents_user.="<td>".mb_ucfirst(_t('workshop','user'))."</td>\n";
  $contents_user.="<td class=\"sorter-false\"> <span class=\"visually-hidden\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  $contents_user.="</tr>\n";
  $contents_user.="</thead>\n";
  $contents_user.="<tbody>\n";
  $mailing_list='';

  

  for($i=0; $i<count($result_user); $i++) {
      
      if(!empty($result_user[$i]['profile_firstname']) && !empty($result_user[$i]['profile_lastname'])) {
          $name = formatText($result_user[$i]['profile_firstname'].' '.$result_user[$i]['profile_lastname'] . ' ('.$result_user[$i]['user_login'].')', '2HTML');
      }
      elseif(!empty($result_user[$i]['profile_firstname']) || $result_user[$i]['profile_lastname']) {
          $name = formatText($result_user[$i]['user_login'] . ' - ' .$result_user[$i]['profile_firstname'].' '.$result_user[$i]['profile_lastname'], '2HTML');
      } else {
          $name = formatText($result_user[$i]['user_login'], '2HTML');
      }

  	if ($result_user[$i]['jwu_user_right']=='A') {
  		$class=' class="to-moderate" ';
  	} else {
  		$class='';
  	}
    $contents_user.="<tr".$class.">\n";
    $contents_user.="<td>";
    if ($l21auth->isSuperAdmin())
        $contents_user.="<a href=\"".$link_det_u.$result_user[$i]['jwu_user_id']."\" title=\"".formatText(_t('workshop','user'), '2HTML')."\">".$name."</a>\n";
    else
        $contents_user.="<span>".$name."</span>";
    
    if ($result_user[$i]['jwu_user_right']=='O')
    	$contents_user.=" <span class=\"text_det_it\">["._t('statut', 'O')."]</span> ";
    if ($result_user[$i]['jwu_user_right']=='A')
    	$contents_user.=" <span class=\"text_det_it pending-user\">("._t('statut', 'pending').")</span> ";
    $contents_user.="</td>\n";
    if ($l21auth->isWorkgroupOrganiser($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin()){
      $contents_user.="<td><div class=\"iconetab\">";
	  
      if ($result_user[$i]['jwu_user_right']=='A') {
      	$contents_user.="<a href=\"../workshop/_user.php?action=unaccept&amp;id=".$id."&amp;u_id=".$result_user[$i]['jwu_user_id']."\" title=\""._t('workshop','del_user')."\" class=\"ico_sup unaccept-user\"><i class=\"fa fa-times\" aria-hidden=\"true\"></i><span>" . _t('workshop','del_user') . "</span></a>\n";
      } else {
      	$contents_user.="<a href=\"".$link_sup_u.$id."&amp;u_id=".$result_user[$i]['jwu_user_id']."\" title=\""._t('workshop','del_user')."\" class=\"ico_sup\"><i class=\"fa fa-trash\"></i><span>" . _t('workshop','del_user') . "</span></a>\n";
      }
      $contents_user.="<a href=\"mailto:".$result_user[$i]['profile_email']."\" title=\"".$result_user[$i]['profile_email']."\" class=\"ico_mail\"><i class=\"fa fa-envelope\" aria-hidden=\"true\"></i></a>";
      
      if ($result_user[$i]['jwu_user_right']=='A') {
      	$contents_user.="<a href=\"../workshop/_user.php?action=accept&amp;id=".$id."&amp;u_id=".$result_user[$i]['jwu_user_id']."\" title=\""._t('workshop','add_new_user')."\" class=\"ico_approve accept-user\"><i class=\"fa fa-check\" aria-hidden=\"true\"></i><span>" . _t('workshop','add_new_user') . "</span></a>\n";
      } else {
      	if($result_user[$i]['jwu_user_right'] == "O") {
      		$newstatus = 'U';
      		$title_status = _t('workshop','convert_to_subscriber');
      	}
      	else {
      		$newstatus = 'O';
      		$title_status = _t('workshop','convert_to_moderator');
      	}
      	$contents_user.="<a href=\"../workshop/_user.php?action=changestatus&amp;convert=".$newstatus."&amp;id=".$id."&amp;u_id=".$result_user[$i]['jwu_user_id']."\" title=\"".$title_status."\" class=\"ico_approve change-status change-status-to-".$newstatus."\"><i class=\"fa fa-exchange\" aria-hidden=\"true\"></i><span>" . $title_status . "</span></a>\n";
      }
      $contents_user.="</div>";
      $contents_user.="</td>";

    }
    else $contents_user.="<td>&nbsp;</td>\n";
    $contents_user.="</tr>\n";
    $mailing_list.=$result_user[$i]['profile_email'].MAIL_SEPARATOR;
  }
  $contents_user.="</tbody>";
  $contents_user.="</table>";
}

$cntOrganisers = $workshop_object->get_workshop_nb_users($id, $sql_object, 'O');
$cntMembers = $workshop_object->get_workshop_nb_users($id, $sql_object, 'U');
$totalMembers = $cntOrganisers + $cntMembers;

$counter = sprintf('<p class="members-count">'. _t('workshop', 'nb_members') .'</p>', $totalMembers);

$reca_user ="<br class=\"brendstep\" />\n";
$reca_user.="<div class=\"toggle_title\">\n";
$reca_user.="<a id=\"workshopuser\" href=\"#\">"._t('workshop','user')."</a>\n";
$reca_user.="</div>\n";
$reca_user.="<div id=\"workshop_user\" style=\"display:block;\" class=\"mtm\">\n";
if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin()) {
	$reca_user.="<a href=\"".$link_add_u.$id."\" title=\""._t('workshop','add_new_user')."\" class=\"ico_add2\"><i class=\"fa fa-plus-circle\" aria-hidden=\"true\"></i><span>".  _t('workshop','add_new_user')."</span></a>";
	$reca_user.="<a href=\"#\" id=\"import-users\" title=\""._t('workshop','import_users')."\" class=\"ico_add2\"><i class=\"fa fa-users\" aria-hidden=\"true\"></i><span>".  _t('workshop','import_users')."</span></a><br class=\"brendstep\" />";
	
	$reca_user.=$import_users;
}
$reca_user.=$counter;
$reca_user.=$contents_user;
if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin())
$reca_user.="<div class=\"mailing_list\"><a href=\"mailto:".$mailing_list."\" title=\""._t('workshop','mailing_list')."\"><i class=\"fa fa-envelope\" aria-hidden=\"true\"></i> &nbsp;"._t('workshop','mailing_list')."</a></div>";
$reca_user.="</div>\n";
$reca_user.="<br class=\"brendstep\" />\n";

//prepa affichage des rapports d'un workgroup

$req_workshop_report= SQL_getWorkshopReportList($id);
$result_report=$sql_object->DBSelect($req_workshop_report);

//$workshop_report_object= new workshop_report ;

$link_res_sup="?rub=resources&amp;todo=sup&amp;id=&amp;parent=".$id."&amp;type=P&amp;id=";
$link_mod=$rub_link."&amp;todo=mod&amp;id=";

if($result_report==0) {
  $contents_report="<div class=\"info\">"._t('workshop','no_report')."</div>";
} else {
  $contents_report= "<table class=\"table2 multisort\">\n";
  $contents_report.="<thead>\n";
  $contents_report.="<tr>\n";
  $contents_report.="<td>".mb_ucfirst(_t('workshop','title_report'))."</td>\n";
  $contents_report.="<td>".mb_ucfirst(_t('divers','statut'))."</td>\n";
  $contents_report.="<td>".mb_ucfirst(_t('divers','date_crea'))."</td>\n";
  $contents_report.="<td class=\"sorter-false\"> <span class=\"visually-hidden\">".mb_ucfirst(_t('divers','actions'))."</span></td>\n";
  $contents_report.="</tr>\n";
  $contents_report.="</thead>\n";
  $contents_report.="<tbody>\n";

  for($i=0; $i<count($result_report); $i++) {

    $workshop_report_title=formatText(cutText($result_report[$i]['workrep_title'], 70, 1), '2HTML');

    $contents_report.="<tr>\n";
    $contents_report.="<td style=\"width:50%\"><a href=\"".$link_det_rep.$result_report[$i]['workrep_id']."\" title=\"".formatText($result_report[$i]['workrep_title'], '2ATT')."\">".$workshop_report_title."</a></td>\n";
    $contents_report.="<td>".display_statut($result_report[$i]['workrep_statut'])."</td>\n";
    $contents_report.="<td>".$result_report[$i]['workrep_date_crea_display']."</td>\n";
    if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin()){
      $contents_report.="<td><div class=\"iconetab\"><a href=\"".$link_sup_rep.$result_report[$i]['workrep_id']."\" title=\""._t('workshop','del_report')."\" class=\"ico_sup\"><i class=\"fa fa-trash\"></i><span>" . _t('workshop','del_report') . "</span></a>\n";
      $contents_report.="<a href=\"".$link_mod_rep.$result_report[$i]['workrep_id']."\" title=\""._t('workshop','mod_report')."\" class=\"ico_mod\"><i class=\"fa fa-pencil-square-o\"></i><span>" . _t('workshop','mod_report') . "</span></a></div></td>";
    }
    else $contents_report.="<td>&nbsp;</td>\n";
    $contents_report.="</tr>\n";
  }

  $contents_report.="</tbody>";
  $contents_report.="</table>";
}

$reca_report='';
$reca_report.="<div class=\"toggle_title\">\n";
$reca_report.="<a id=\"resreport\" href=\"#\">"._t('workshop','report')."</a>\n";
$reca_report.="</div>\n";
$reca_report.="<div id=\"res_report\" style=\"display:none;\" class=\"mtm\">\n";
if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin())
$reca_report.="<a href=\"".$link_add_rep.$id."\" title=\""._t('workshop','add_new_report')."\" class=\"ico_add2\"><i class=\"fa fa-plus-circle\" aria-hidden=\"true\"></i><span>".  _t('workshop','add_new_report')."</span></a><br class=\"brendstep\" />";
$reca_report.=$contents_report;
$reca_report.="</div>\n";
$reca_report.="<br class=\"brendstep\" />\n";

$navtitle=_t('workshop','det')." : ".$workshop_denomination;

// ajax code
$js = '$("a.accept-user, a.change-status").click(function() {

			var el = this;
			var url = $(el).attr("href") + "&mode=ajax";
			// $(el).unbind("click"); // prevent new click

			$.ajax({
				type: "GET",
				url: url,
				dataType: "json",
				success: function(data){
					if(data.status==1) {
						alertify.success(data.msg);
						var parentel = $(el).closest("tr");
						if(data.action == "accept") {
							$(parentel).find("span.pending-user").fadeOut();
							$(parentel).removeClass("to-moderate");
							$(el).fadeOut();
						}
						if(data.action == "changestatus") {
							var url = $(el).attr("href");
							if(data.newstatus == "O") {
								$(parentel).find("td:first").append("<span class=\"text_det_it\"> ['._t('statut', 'O').']<\/span> ").hide().fadeIn("slow");
								$(el).attr("href", url.replace("convert=O", "convert=U"));
								$(el).removeClass("change-status-to-O");
								$(el).addClass("change-status-to-U");
								$(el).attr("title", "'. _t('workshop', 'convert_to_subscriber') .'");
								$(el).find("span").html("'. _t('workshop', 'convert_to_subscriber') .'");
							}
							if(data.newstatus == "U") {
								$(parentel).find("td:first span.text_det_it").fadeOut("slow");
								$(el).attr("href", url.replace("convert=U", "convert=O"));
								$(el).removeClass("change-status-to-U");
								$(el).addClass("change-status-to-O");
								$(el).attr("title", "'. _t('workshop', 'convert_to_moderator') .'");
								$(el).find("span").html("'. _t('workshop', 'convert_to_moderator') .'");
							}
						}
					} else {
						alertify.error(data.msg);
					}
				}
			});

			return false;

			});
			
			$("a.unaccept-user").click(function() {

			var el = this;
			var url = $(this).attr("href") + "&mode=ajax";
			$(el).unbind("click"); // prevent new click
	
			$.ajax({
				type: "GET",
				url: url,
				dataType: "json",
				success: function(data){
					if(data.status==1) {
						alertify.success(data.msg);
						$(el).closest("tr").fadeOut();
					} else {
						alertify.error(data.msg);
					}
				}
			});
				
			return false;
			
			});
		';

footerAddInlineJS($js);

// Ability to sort table
addDynamicCSS('../lib/js/jquery.tablesorter/theme.default.css');
footerAddJS('../lib/js/jquery.tablesorter/jquery.tablesorter.min.js');
$str = '$("table.multisort").tablesorter({	});';
footerAddInlineJS($str);
$str = '$("#import-users-box div.box-toggle").hide();';
$str .= '$("#import-users").click( function() { $("#import-users-box div.box-toggle").fadeToggle("slow"); return false; });';
footerAddInlineJS($str);
?>
<div id="chemin">
<ul>
	<li><a href="index.php" class="chemin_home"><?php echo _t('way','home'); ?></a></li>
	<li><a href="<?php echo $rub_link; ?>" id="chemin_<?php echo $rub; ?>" class="chemin_rub"><?php echo _t('menu','workshop');?></a></li>
	<li><span><?php echo formatnavTitle($navtitle); ?></span></li>
</ul>
</div>
<!--end barre haute -->

<div class="contentcontainer"><?php
include_once(override($dir.'/menurub.php', THEME_ADMIN_PATH));
?>
<div id="content"><?php
afflinkbar($todo,$id, $lang);
echo "<h2>".formatTitleh2($workshop_denomination)."</h2>\n";
if ($l21auth->isSuperAdmin()){
  echo "<a href=\"".$link_sup.$id."\" title=\""._t('workshop','sup')."\" class=\"ico_sup2\"><i class=\"fa fa-trash\"></i><span>" . _t('workshop','sup') . "</span></a>";
}
if ($l21auth->isSuperAdmin() || $l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id)){
  echo "<a href=\"".$link_mod.$id."\" title=\""._t('workshop','mod')."\" class=\"ico_mod2\"><i class=\"fa fa-pencil-square-o\"></i><span>" . _t('workshop','mod') . "</span></a><br class=\"brendstep\" />";
}
echo $reca_generals;
echo $reca_user;
echo $reca_report;

// Ability to drag'n drop items
if ($l21auth->isWorkgroupOrganiser ($l21auth->GetSessionElement('id'), $sql_object, $id) || $l21auth->isSuperAdmin()) {
	footerAddJS('../lib/js/TableDnD/dist/jquery.tablednd.1.0.5.min.js');
	dragTableSettings();
}
?>
</div> <!-- closing #content -->
</div> <!-- closing .contentcontainer -->