<?php
/**
 * Export module - pdf
 * 
 * Extend TCPDF adding header and footer
 * 
 * @package linea21\utils\export
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

// extended TCPF with custom functions
class eTCPDF extends TCPDF {


  //Page header
  public function Header() {

    global $report_settings;
    global $lang;
    
    // we set the logo
		
	// by default we include SVG file
	if (file_exists ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo.svg' )) {
		$this->ImageSVG ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo.svg', 18, 4, 0, 7, $link= SITE_ROOT_URL.'public/', $align='C', $palign='', $border=0, $fitonpage=false);
		
	// else include ai file
	} elseif (file_exists ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo.ai' )) {
		$this->ImageEps ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo.ai', 18, 4, 0, $h = 7, $link = SITE_ROOT_URL.'public/', true, '', 'C', 0, false );
		
	// else include eps file
	} elseif (file_exists ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo.eps' )) {
		$this->ImageEps ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo.eps', 18, 4, 0, $h = 7, $link = SITE_ROOT_URL.'public/', true, '', 'C', 0, false );
		
	// else include raster file
	} elseif (file_exists ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo_p.png' )) {
		$this->Image ( THEME_PUBLIC_PATH . 'override/export/inc_report/logo_p.png', 18, 4, 0, 7, '', SITE_ROOT_URL.'public/', 'T', false, 300, '', false, false, 0, false, false, false);
	
	// default Linea21 logo
	} else {
		
		$this->ImageSVG('../export/inc_report/logo.svg', 18, 4, 0, 7, $link=SITE_LINEA_URL, $align='C', $palign='', $border=0, $fitonpage=false);
	}
    

    $today = date("d/m/Y");
    $content = formatText($report_settings['title']);

    $this->SetTextColorArray(getColor('DOC_COLOR_HEADER'));
    $this->SetFont(DOC_POLICE, 'B', MIN_SIZE);
    // Title
    $this->Cell(0, MIN_SIZE, SITE_NAME . ' - ' .$today, 0, 1, 'R', 0, '', 0, false, 'M', 'M');
    $this->SetFont(DOC_POLICE, '', MIN_SIZE);
    $this->Cell(0, MIN_SIZE, $content, 0, 1, 'R', 0, '', 0, false, 'M', 'M');
    $this->SetLineStyle(array('color'=> array(100,100,100)));
    $this->Line($this->GetX(), $this->GetY(), $this->GetX()+180, $this->GetY());
  }


  // Page footer
  public function Footer() {

    global $report_settings;
    global $lang;
    $content = $report_settings['author'];
    if(!empty($report_settings['mail_author']))  {
      $content .= ' ('.$report_settings['mail_author'].')';
      $mailto='mailto:'.$report_settings['mail_author'];
    } else $mailto='';
    $content_comp = !empty($report_settings['service_author']) ? ' / '.$report_settings['service_author'] : '';
    $content_comp.= !empty($report_settings['adress_author']) ? ' / '.$report_settings['adress_author'] : '';

    $this->SetTextColorArray(getColor('DOC_COLOR_HEADER'));
    $this->SetFont(DOC_POLICE, '', MIN_SIZE);
    $this->SetY(-10);
    $this->SetLineStyle(array('color'=> array(100,100,100)));
    $this->Line($this->GetX(), $this->GetY(), $this->GetX()+180, $this->GetY());

    $this->Cell($this->GetStringWidth($content), MIN_SIZE, $content, 0, 0, 'L', 0, $mailto);
  	$this->Cell(0, MIN_SIZE, $content_comp, 0, 0, 'L');
  	// right align is not possible @see http://sourceforge.net/p/tcpdf/discussion/435311/thread/35236b34/ 
  	$this->Cell(0, MIN_SIZE, $lang['divers']['page'].' ' . $this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, 0, 'R');
  }

}
?>