<?php

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 2.1
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// this is supposed to be done from 2.0
@unlink('../class/class.theme.php');
@SureRemoveDir('../class/system/pChart/', true);
@SureRemoveDir('../class/system/tcpdf/', true);
@SureRemoveDir('../theme/', true);
@unlink('../dashboard/rap.php');
@unlink('../export/phpsql.process.php');
@unlink('../languages/fr/lang_theme.utf-8.php');
@unlink('../languages/es/lang_theme.utf-8.php');
@unlink('../languages/en/lang_theme.utf-8.php');
@unlink('../languages/it/lang_theme.utf-8.php');
@SureRemoveDir('../lib/js/jquery-ui/', true);
@SureRemoveDir('../lib/js/jquery-ui-multiselect/', true);
@SureRemoveDir('../lib/js/jquery.datePicker.l10n/', true);
@SureRemoveDir('../lib/js/jquery.textboxList/', true);
@SureRemoveDir('../lib/js/nicEdit/', true);
@SureRemoveDir('../lib/js/timeline/', true);
@SureRemoveDir('../lib/vendor/jQuery-File-Upload/', true);

@SureRemoveDir('../lib/vendor/cron-expression/tests/', true);
@SureRemoveDir('../lib/vendor/PHP-Color/testing/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Documentation/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Examples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/docs/', true);
@SureRemoveDir('../lib/vendor/PHPWord/samples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/tests/', true);
@SureRemoveDir('../lib/vendor/Stringy/tests/', true);

@unlink('../project/timeline-xml.php');
@unlink('../lib/js/jquery.min.js');
@unlink('../lib/js/timeline.js');

// new updates


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Generics actions : Finally we update config.ini and add new constants if necessary
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");



$l21config->setParams($config_ini);

// we add MOD_VOTE constant
if(!isset($config_ini['MOD_VOTE'])) $l21config->addParams(array(array('MODULES_SETTINGS', 'MOD_VOTE', 1)));

// we add VOTE_MODULES constant if needed
if(!isset($config_ini['VOTE_MODULES'])) $l21config->addParams(array(array('SYSTEM_SETTINGS', 'VOTE_MODULES', 'project,contribute')));

// we add VOTE_THRESHOLD constant if needed
if(!isset($config_ini['VOTE_THRESHOLD'])) $l21config->addParams(array(array('SYSTEM_SETTINGS', 'VOTE_THRESHOLD', 200)));

// we add PASSWD_STRENGTH constant if needed
if(!isset($config_ini['PASSWD_STRENGTH'])) $l21config->addParams(array(array('SYSTEM_SETTINGS', 'PASSWD_STRENGTH', "aA0/")));

// we add BASE64IMAGE_AUTOSAVE constant if needed
if(!isset($config_ini['BASE64IMAGE_AUTOSAVE'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'BASE64IMAGE_AUTOSAVE', 1)));

// we add CKE_ALLOW_EXTRACONTENT constant if needed
if(!isset($config_ini['CKE_ALLOW_EXTRACONTENT'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'CKE_ALLOW_EXTRACONTENT', 'iframe(*)[*]{*};span(*)[*];div(*)[*];p(*)[*];*[id];*(*)*[data-];')));

// we add BASE64IMAGE_AUTOSAVE constant if needed
if(!isset($config_ini['CHART_DEFAULT_SIZE'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'CHART_DEFAULT_SIZE', '900x640')));


// we write the new file
if($l21config->writeReleaseParams()) {
	echo "<p><strong>Writing new configuration file : /config/config.ini</strong></p>";
} else {
	echo "<p><strong>Problem writing new configuration file : /config/config.ini</strong></p>";
}

?>