<?php

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// UPDATE FROM VERSION 2.1
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// this is supposed to be done from 2.0
@unlink('../class/class.theme.php');
@SureRemoveDir('../class/system/pChart/', true);
@SureRemoveDir('../class/system/tcpdf/', true);
@SureRemoveDir('../theme/', true);
@unlink('../dashboard/rap.php');
@unlink('../export/phpsql.process.php');
@unlink('../languages/fr/lang_theme.utf-8.php');
@unlink('../languages/es/lang_theme.utf-8.php');
@unlink('../languages/en/lang_theme.utf-8.php');
@unlink('../languages/it/lang_theme.utf-8.php');
@SureRemoveDir('../lib/js/jquery-ui/', true);
@SureRemoveDir('../lib/js/jquery-ui-multiselect/', true);
@SureRemoveDir('../lib/js/jquery.datePicker.l10n/', true);
@SureRemoveDir('../lib/js/jquery.textboxList/', true);
@SureRemoveDir('../lib/js/nicEdit/', true);
@SureRemoveDir('../lib/js/timeline/', true);
@SureRemoveDir('../lib/vendor/jQuery-File-Upload/', true);

@SureRemoveDir('../lib/vendor/cron-expression/tests/', true);
@SureRemoveDir('../lib/vendor/PHP-Color/testing/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Documentation/', true);
@SureRemoveDir('../lib/vendor/PHP-Excel/Examples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/docs/', true);
@SureRemoveDir('../lib/vendor/PHPWord/samples/', true);
@SureRemoveDir('../lib/vendor/PHPWord/tests/', true);
@SureRemoveDir('../lib/vendor/Stringy/tests/', true);

@unlink('../project/timeline-xml.php');
@unlink('../lib/js/jquery.min.js');
@unlink('../lib/js/timeline.js');

// new updates


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Generics actions : Finally we update config.ini and add new constants if necessary
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// we parse the current config.ini file (before update)
$config_ini = parse_ini_file("../config/config.ini");


// we set admin theme to 2021
if(isset($config_ini['THEME_ADMIN'])) $config_ini['THEME_ADMIN'] = '2021';

$l21config->setParams($config_ini);


// we add CHART_MIN_VALUES constant if needed
if(!isset($config_ini['CHART_MIN_VALUES'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'CHART_MIN_VALUES', 2)));

// we add PROJECT_TASK constant if needed
if(!isset($config_ini['PROJECT_TASK'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'PROJECT_TASK', 1)));

// we add PROJECT_TASK_SYNC constant if needed
if(!isset($config_ini['PROJECT_TASK_SYNC'])) $l21config->addParams(array(array('MISC_HIDDEN_SETTINGS', 'PROJECT_TASK_SYNC', 1)));


// we write the new file
if($l21config->writeReleaseParams()) {
	echo "<p><strong>Writing new configuration file : /config/config.ini</strong></p>";
} else {
	echo "<p><strong>Problem writing new configuration file : /config/config.ini</strong></p>";
}

?>
