<?php
/**
 * Common helpers
 * 
 * Provides common helpers
 * 
 * @package linea21\utils\lib
 * @author $Author$ - linea21 <info@linea21.com>
 * @version $Id$ 
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

function get_checkbox($data, $name, $fieldname, $fieldname_id, $selected = array()) {
	
	$html = "";
	$cnt = 0;
	
	if(is_array($data)) {
    	foreach ($data as $item) {
    		
    		$idname = str_replace('[]', '', $name) . '-';
    		
    		if( is_null($fieldname)) {
    		   $finalityname = formatText($item, '2HTML');
    		   $fieldValue = $finalityname;
    		   $fieldID = $cnt;
    		} else {
    		  $finalityname = formatText($item[$fieldname], '2HTML');
    		  $fieldID = $item[$fieldname_id];
    		  $fieldValue = $fieldID;
    		}
    		
    		if(in_array($fieldValue, $selected)) $ischecked=" checked";
    		else $ischecked="";
    		$html .= '<input type="checkbox" class="checkbox" name="' . $name . '" id="'.$idname.$fieldID.'" value="' . $fieldValue . '"' . $ischecked . ' />'.PHP_EOL;
    		$html .= '<label for="'.$idname.$fieldID.'">' . $finalityname . '</label><br />'.PHP_EOL;
    		$cnt++;
    	}
	}
	
	return $html;
}

function get_level_option($parent, $dep, $data, $selected, $exclude) {
	
    $html = "";
    
    $prefix = str_repeat("&nbsp;",$dep*3);
    
    foreach ($data as $item) {
        
        // $current_label = ' <span class="label-info">(' .formatText( $item['level_label'], '2HTML'). ')</span>';
        if(defined('DISPLAY_LEVEL_LABEL') && DISPLAY_LEVEL_LABEL == 1) $current_label = '<span class="level-label">' .formatText( $item['level_label'], '2HTML'). ' : </span> ';
        else $current_label ='';
            
        $current_id=$item['level_id'];
        
        $current_name =cutText(formatText($item['level_name'], '2HTML'), 70);
        if(!empty($item['level_code'])) $code = ' ['.$item['level_code'].'] '; else $code = '';
        $current_lname = $current_label . $code . $current_name ;
        
        if ($parent == $item['level_parent']) {
            $current_id == $selected ? $mask = ' selected="selected"' : $mask = '';
            $current_id == $exclude ? $excmask = ' disabled' : $excmask = '';
            
            $html .= "\t<option class=\"level-".$dep."\"" . $mask . " value=\"".$item['level_id']."\"".$excmask.">" . $prefix . ' ' . $current_lname. "</option>\n";
            $html .= get_level_option($item['level_id'], ($dep + 1), $data, $selected, $exclude);
        }
        
    }
    return $html;

}

/**
 * LevelSelectBox()
 * Génére une select-box pour les niveaux
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select
 */
function LevelSelectBox($data, $field_name, $current = 0, $exclude = 0)
{
	

	$select = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">";
	$select .= "<option value=\"0\">" . mb_ucfirst(_t('divers','none')) . "</option>";
	$select .= get_level_option(0, 0, $data, $current, $exclude);
	$select .= "</select>";

	return $select;
}

function get_scale_option($parent, $dep, $data, $selected, $exclude) {
    
    $html = "";
    
    $prefix = str_repeat("&nbsp;",$dep*3);
    
    foreach ($data as $item) {
        
        $current_id=$item['scale_id'];
        
        $current_name =cutText(formatText($item['scale_denomination'], '2HTML'), 70);
        
        if ($parent == $item['scale_root']) {
            $current_id == $selected ? $mask = ' selected="selected"' : $mask = '';
            $current_id == $exclude ? $excmask = ' disabled' : $excmask = '';
            
            $html .= "\t<option class=\"scale-".$dep."\"" . $mask . " value=\"".$item['scale_id']."\"".$excmask.">" . $prefix . ' ' . $current_name. "</option>\n";
            $html .= get_scale_option($item['scale_id'], ($dep + 1), $data, $selected, $exclude);
        }
        
    }
    return $html;
}

/**
 * ScaleSelectBox()
 * Génére une select-box pour les échelles
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_scale
 * @param string $URL
 * @return string $select_scale
 */
function ScaleSelectBox($data, $field_name, $current_scale = 0, $URL = -1, $exclude = 0)
{
    
    $select = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">";
    $select .= "<option value=\"0\">" . mb_ucfirst(_t('divers','select_choice')) . "</option>";
    $select .= get_scale_option(0, 0, $data, $current_scale, $exclude);
    $select .= "</select>";
    
    if ($URL <> -1) {
        $js = "	$('#". $field_name ."').change(function() {
					  	if($(this).val() != 0) window.location = '".str_replace('&amp;', '&', $URL)."' + $(this).val();
					  });";
        
        footerAddInlineJS($js);
    }
    
    return $select;
    
//   $scale_list = '';
//   for ($i = 0;$i < count($data);$i++) {
//     if ($data[$i]['scale_id'] == $current_scale) {
//       $mask = " selected=\"selected\"";
//     } else $mask = "";
//     $scale_display = formatText(cutText($data[$i]['scale_denomination'], 78));
//     if ($URL <> -1)$scale_list .= "<option value=\"" . $URL . $data[$i]['scale_id'] . "\"" . $mask . ">" . $scale_display . "</option>\n";
//     else $scale_list .= "<option value=\"" . $data[$i]['scale_id'] . "\"" . $mask . ">" . $scale_display . "</option>\n";
//   }

//   $select_scale = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
//   $select_scale .= "<option value=\"0\">" . mb_ucfirst(_t('divers','select_choice')) . "</option>\n";

//   $select_scale .= $scale_list;
//   $select_scale .= "</select>\n";

//   if ($URL <> -1) {
//   	$js = "	$('#". $field_name ."').change(function() {
// 					  	if($(this).val() != 0) window.location = $(this).val();
// 					  });";
  	 
//   	footerAddInlineJS($js);
//   }

//   return $select_scale;
}

/**
 * TasksReminderSelectBox()
 * Génére une select-box pour les rappels de tâches (module projet)
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select_reminder
 */
function TasksReminderSelectBox($data, $field_name, $current = 0)
{
    $reminder_list = '';
    foreach ($data as $key => $v) {
        if ($v == $current) {
            $mask = " selected=\"selected\"";
        } else $mask = "";
        $name = _t('task', 'reminder_freq_'.$key);
        $reminder_list .= "<option value=\"" . $v. "\"" . $mask . ">" . $name . "</option>\n";
    }
    
    $select_reminder  = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"shorttextfield\">\n";
    $select_reminder .= $reminder_list;
    $select_reminder .= "</select>\n";
    
    return $select_reminder;
}

/**
 * TasksReminderStatusRadio()
 * Génére une jolie liste de radio-bttuon pour les status de tâches (module projet)
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @param string $URL
 * @return string $select_priority
 */
function TasksReminderStatusRadio($data, $field_name, $current = 0)
{
    
    $status_list = '';
    foreach ($data as $key) {
        if ($key == $current) {
            $mask = ' checked="checked"';
        } else $mask = "";
        $name = _t('task', 'status_'.$key);
        $status_list .= '<li><input type="radio" class="radio" value="' . $key. '" id="' . $key. '" name="' . $field_name. '"' . $mask . ' />'.PHP_EOL;
        $status_list .= '<label for="' . $key. '"  class="task-status-'.$key.'">' . $name . '</option></li>'.PHP_EOL;
    }
    
    $radio_status  = '<ul class="task-status-input">'.PHP_EOL;
    $radio_status .= $status_list;
    $radio_status .= '</ul>'.PHP_EOL;
    
    return $radio_status;
}

/**
 * PrioritySelectBox()
 * Génére une select-box pour les priorités
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_priority
 * @param string $URL
 * @return string $select_priority
 */
function PrioritySelectBox($data, $field_name, $current_priority = 0)
{
  $priority_list = '';
  for ($i = 0;$i < count($data);$i++) {
    if ($data[$i]['priority_id'] == $current_priority) {
      $mask = " selected=\"selected\"";
    } else $mask = "";
    $priority_display = formatText(cutText($data[$i]['priority_name'], 55));
    $priority_list .= "<option value=\"" . $data[$i]['priority_id'] . "\"" . $mask . ">" . $priority_display . "</option>\n";
  }

  $select_priority  = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select_priority .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";

  $select_priority .= $priority_list;
  $select_priority .= "</select>\n";

  return $select_priority;
}

/**
 * selectBox()
 * Génére une select-box générique
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select
 */
function selectBox($data, $field_name, $current = 0, $default = null, $exclude = array(), $use_value = false, $class = 'textfield')
{

	if($current === 0 && !is_null($default) ) $current = $default;
	$list = '';

	if(is_array($data)) {
    	foreach ($data as $key => $value) {
    		if ($key == $current) {
    			$mask = " selected=\"selected\"";
    		} else $mask = "";
    
    		if($use_value == false) {
        		if(!in_array($key, $exclude)) {
        			$list .= "<option value=\"" . $key . "\"" . $mask . ">" . mb_ucfirst($value) . "</option>\n";
        		}
    		} else {
    		    if ($value == $current) $mask = " selected=\"selected\"";
    		    if(!in_array($value, $exclude)) {
    		        $list .= "<option value=\"" . $value . "\"" . $mask . ">" . mb_ucfirst($value) . "</option>\n";
    		    }
    		}
    	}
	}

	$select = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"".$class."\">\n";
	$select .= $list;
	$select .= "</select>\n";

	return $select;
}

function _getProjectHierarchy($data, $depth, $current_projects, $exclude) {
    
    global $sql_object;
    
    // begin with an empty $options string
    $options = '';

    // loop through all items in this level
    foreach($data as $key => &$item)
    {
        // echo "$key <br ><br>";
        // where only interested in numeric items
        // as those are the actual children
        if( !is_numeric( $key ) )
        {
            // otherwise continue
            continue;
        }
        
        if(!empty($item['level_code'])) $code = ' ['.$item['level_code'].'] '; else $code = '';
        
        $level_label = $code. $item['level_name'] ;
        $level_label = formatText(cutText($level_label, 90), '2HTML');
        
        $options .='<option value="-1" data-id="'.$item['level_id'].'" disabled>'.str_repeat("&nbsp;", $depth*6). $level_label.'</option>'.PHP_EOL;
        
        $projects = $GLOBALS['sql_object']->DBSelect(SQL_getProjectsList(0, 999, 'all', 'LEVEL', $item['level_id']));
        
        if (is_array($projects)) {
            
            for ($i = 0; $i < count($projects); $i ++) {
                $project_name = formatText(cutText($projects[$i]['complete_project_name'], 80), '2HTML');
                $complete_project_name = $projects[$i]['complete_project_name'];
                
                if(!in_array($projects[$i]['project_id'], $exclude)) {
                    
                    if (in_array($projects[$i]['project_id'], $current_projects)) {

                        $mask = " selected=\"selected\"";
                    } else $mask = "";
                    
                    $options .= '<option value="' . $projects[$i]['project_id'] . '" data-id="' . $item['level_id'] . '"'.$mask.'>' . str_repeat("&nbsp;", ($depth+1)*6) . $project_name . '</option>'.PHP_EOL;
                }
            }
        }
        
        // call this funcion recursively
        // with the next level ($item)
        // it will figure out again whether that level has numeric children as well
        // returns a new complete set, if applicable, otherwise an empty string
        if(isset($item['children'])) $options .= _getProjectHierarchy($item['children'], $depth+1, $current_projects, $exclude);
        
    }
    return $options;
}


function ProjectSelectBoxByLevels($data, $field_name, $current_projects = array(), $exclude= array(), $multiple = false)
{  

    if($multiple) {
        $multiAttr =' multiple="multiple"';
        $nameSuffix = '[]';
    }
    else {
        $multiAttr = '';
        $nameSuffix = '';
    }
    
    // if only one value is given we put it in array
    if(is_numeric($current_projects)) $current_projects = array($current_projects); 
    
    $opts = _getProjectHierarchy($data, 0, $current_projects, $exclude);
    
    $select_project = "<select name=\"" . $field_name . $nameSuffix . "\" id=\"" . $field_name . "\" class=\"textfield\"".$multiAttr.">\n";
    $select_project .= "<option value=\"0\">" . _t('divers','none') . "</option>\n";
    $select_project .= $opts;
    $select_project .= "</select>\n";
    
    return $select_project;
}

/**
 * ProjectSelectBox()
 * Génére une select-box pour les projets
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current_project
 * @param string $URL
 * @return string $select_project
 * @todo remove ? not used anymore
 */
function ProjectSelectBox($data, $field_name, $current_project = 0, $URL = -1, $exclude= array())
{

  $project_list = '';
  if(is_array($data)) {
      for ($i = 0;$i < count($data);$i++) {
        if(!in_array($data[$i]['project_id'], $exclude)) {
          if ($data[$i]['project_id'] == $current_project) {
            $mask = " selected=\"selected\"";
          } else $mask = "";
          $project_display = formatText(cutText($data[$i]['project_name'], 78));
          if ($URL <> -1) $project_list .= "<option value=\"" . $URL . $data[$i]['project_id'] . "\"" . $mask . ">" . $project_display . "</option>\n";
          else $project_list .= "<option value=\"" . $data[$i]['project_id'] . "\"" . $mask . ">" . $project_display . "</option>\n";
        }
      }
  }

  $select_project = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select_project .= "<option value=\"0\">" . _t('divers','none') . "</option>\n";

  $select_project .= $project_list;
  $select_project .= "</select>\n";

  if ($URL <> -1) {
  	$js = "	$('#". $field_name ."').change(function() {
					  	window.location = $(this).val();
					  });";
  
  	footerAddInlineJS($js);
  }

  return $select_project;
}

/**
 * WorkshopSelectBox()
 * Generate a workshop select-box
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select
 */
function WorkshopSelectBox($data, $field_name, $current = 0)
{
  $list = '';
  if(is_array($data)) {
      for ($i = 0;$i < count($data);$i++) {
        $display = formatText(cutText($data[$i]['workshop_denomination'], 78));
        if($data[$i]['workshop_id'] != "" && $data[$i]['workshop_id'] != $current) $list .= "<option value=\"" . $data[$i]['workshop_id'] . "\">" . $display . "</option>\n";
      }
  }
  $select = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
  $select .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";
  $select .= $list;
  $select .= "</select>\n";

  return $select;
}

/**
 * SDIMultiSelectBox()
 * Generate a SDI multiple select-box
 * (using jquery)
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $select
 */
function SDIMultiSelectBox($data, $field_name, $current, $disabled = false)
{
	if($disabled) { $disabled = 'disabled'; } else { $disabled = ''; }
  $list = '';
  if(is_array($data)) {
      
      // first iteration to display selected indicators first
      $notSelected = $selected = array();
      
      for ($i = 0;$i < count($data);$i++) {
          
          if (!in_array ($data[$i]['sdii_id'], $current)) {
              array_push($notSelected, $data[$i]);
          } else {
              array_push($selected, $data[$i]);
          }
          
      }
      $data = array_merge($selected, $notSelected);

      for ($i = 0;$i < count($data);$i++) {
        if (in_array ($data[$i]['sdii_id'], $current)) {
          $mask = " selected=\"selected\"";
        } else $mask = "";
        $display = formatText(cutText($data[$i]['sdii_name'], 200));
        $list .= "<option value=\"" . $data[$i]['sdii_id'] . "\"" . $mask . ">" . $display . "</option>\n";
      }
  }
  $select  = "<select name=\"" . $field_name . "[]\" id=\"" . $field_name . "\" multiple=\"multiple\" ".$disabled.">\n";
  //$select .= "<option value=\"0\">" . _t('divers','select_choice') . "</option>\n";
  $select .= $list;
  $select .= "</select>\n";


  return $select;
}

/**
 * workgroupsCheckbox()
 * Return Workgroups checkboxes
 *
 * @param array $data
 * @param string $field_name
 * @param integer $current
 * @return string $content
 */
function workgroupsCheckbox($data, $field_name, $current = array())
{
  $content = '';
  if(!is_array($data)) return '<div>'. _t('divers', 'none') .'</div>' . PHP_EOL;

  for ($i = 0; $i < count($data);$i++) {
    if (in_array($data[$i]['id'],$current)) {
      $mask = ' checked="checked"';
    } else $mask = "";
    
    if($data[$i]['workshop_statut'] != 'P') $status = ' <span class="small">['. display_statut($data[$i]['workshop_statut']) . ']</span>';
    else $status ='';

    $wg_name = formatText($data[$i]['name']);
    $wg_id = $data[$i]['id'];
    $content .= '<input class="checkbox css-checkbox" type="checkbox" name="'.$field_name.'" id="wg_'.$wg_id.'"  value="' .$wg_id . '"' . $mask . ' />' . PHP_EOL;
    $content .= '<label class="css-label" for="wg_'.$wg_id.'">'. $wg_name. $status . '</label><br />' . PHP_EOL;
  }

  return $content;
}

/**
 * CultureSelectBox()
 * Generate a select-box with available languages
 * @param string $field_name
 * @param mixed $current
 * @return string $select
 */
function CultureSelectBox($field_name, $current = -1)
{
  $list = '';
  $array = culture::getInstance()->availableCultures();

  foreach($array as $culture => $value) {
    if ($culture == $current) {
      $mask = ' selected="selected"';
    } else $mask = "";
    $str= ucfirst($value['Language']);
    if(isset($value['Country'])) $str.= ' ('.ucfirst($value['Country']).')';
    $list .= '<option value="' . $culture . '"' . $mask . '>' . $str . '</option>'.PHP_EOL;
  }

  $select  = '<select name="' . $field_name . '" id="' . $field_name . '">'.PHP_EOL;
  $select .= $list;
  $select .= '</select>'.PHP_EOL;


  return $select;
}

/**
 * input_date()
 * Return input fields
 * with good direction
 * depending on DATE_FORMAT
 * as filter criteria
 * @param string $y
 * @param string $m
 * @param string $d
 * @return string $content
 */
function input_date($y, $m, $d) {

  $content = '';

  if(DATE_FORMAT == 'dd-mm-yyyy')
  {
    $content.='<input name="date_d" type="text" class="" size="2" id="date_d" maxlength="2" value="'.$d.'" />'.PHP_EOL;
    $content.='<input name="date_m" type="text" class="" size="2" id="date_m" maxlength="2" value="'.$m.'" />'.PHP_EOL;
    $content.='<input name="date_y" type="text" class="" size="4" id="date_y" maxlength="4" value="'.$y.'" />'.PHP_EOL;
  }
  elseif(DATE_FORMAT == 'yyyy-mm-dd')
  {
    $content.='<input name="date_y" type="text" class="" size="4" id="date_y" maxlength="4" value="'.$y.'" />'.PHP_EOL;
    $content.='<input name="date_m" type="text" class="" size="2" id="date_m" maxlength="2" value="'.$m.'" />'.PHP_EOL;
    $content.='<input name="date_d" type="text" class="" size="2" id="date_d" maxlength="2" value="'.$d.'" />'.PHP_EOL;
  }
  else
  {
    system_error();
  }
  return $content;
}

?>