/**
 * Highstock JS v11.2.0 (2023-10-30)
 *
 * Indicator series type for Highcharts Stock
 *
 * (c) 2010-2021 Paweł Fus
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/indicators/pivot-points",["highcharts","highcharts/modules/stock"],function(o){return t(o),t.Highcharts=o,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var o=t?t._modules:{};function n(t,o,n,e){t.hasOwnProperty(o)||(t[o]=e.apply(null,n),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:o,module:t[o]}})))}n(o,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[o["Core/Series/SeriesRegistry.js"]],function(t){var o,n=this&&this.__extends||(o=function(t,n){return(o=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,o){t.__proto__=o}||function(t,o){for(var n in o)Object.prototype.hasOwnProperty.call(o,n)&&(t[n]=o[n])})(t,n)},function(t,n){if("function"!=typeof n&&null!==n)throw TypeError("Class extends value "+String(n)+" is not a constructor or null");function e(){this.constructor=t}o(t,n),t.prototype=null===n?Object.create(n):(e.prototype=n.prototype,new e)});function e(o,n){var e,i=o.series.pointArrayMap,r=i.length;for(t.seriesTypes.sma.prototype.pointClass.prototype[n].call(o);r--;)o[e="dataLabel"+i[r]]&&o[e].element&&o[e].destroy(),o[e]=null}return function(t){function o(){var o=null!==t&&t.apply(this,arguments)||this;return o.P=void 0,o.pivotLine=void 0,o.series=void 0,o}return n(o,t),o.prototype.destroyElements=function(){e(this,"destroyElements")},o.prototype.destroy=function(){e(this,"destroyElements")},o}(t.seriesTypes.sma.prototype.pointClass)}),n(o,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[o["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],o["Core/Series/SeriesRegistry.js"],o["Core/Utilities.js"]],function(t,o,n){var e,i=this&&this.__extends||(e=function(t,o){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,o){t.__proto__=o}||function(t,o){for(var n in o)Object.prototype.hasOwnProperty.call(o,n)&&(t[n]=o[n])})(t,o)},function(t,o){if("function"!=typeof o&&null!==o)throw TypeError("Class extends value "+String(o)+" is not a constructor or null");function n(){this.constructor=t}e(t,o),t.prototype=null===o?Object.create(o):(n.prototype=o.prototype,new n)}),r=o.seriesTypes.sma,a=n.merge,s=n.extend,p=n.defined,l=n.isArray,c=function(t){function o(){var o=null!==t&&t.apply(this,arguments)||this;return o.data=void 0,o.options=void 0,o.points=void 0,o.endPoint=void 0,o.plotEndPoint=void 0,o}return i(o,t),o.prototype.toYData=function(t){return[t.P]},o.prototype.translate=function(){var o=this;t.prototype.translate.apply(o),o.points.forEach(function(t){o.pointArrayMap.forEach(function(n){p(t[n])&&(t["plot"+n]=o.yAxis.toPixels(t[n],!0))})}),o.plotEndPoint=o.xAxis.toPixels(o.endPoint,!0)},o.prototype.getGraphPath=function(o){for(var n,e,i,r=this,a=[[],[],[],[],[],[],[],[],[]],s=r.pointArrayMap.length,l=r.plotEndPoint,c=[],u=o.length;u--;){for(i=0,e=o[u];i<s;i++)p(e[n=r.pointArrayMap[i]])&&a[i].push({plotX:e.plotX,plotY:e["plot"+n],isNull:!1},{plotX:l,plotY:e["plot"+n],isNull:!1},{plotX:l,plotY:null,isNull:!0});l=e.plotX}return a.forEach(function(o){c=c.concat(t.prototype.getGraphPath.call(r,o))}),c},o.prototype.drawDataLabels=function(){var o,n,e,i,r=this,a=r.pointArrayMap;r.options.dataLabels.enabled&&(n=r.points.length,a.concat([!1]).forEach(function(s,p){for(i=n;i--;)e=r.points[i],s?(e.y=e[s],e.pivotLine=s,e.plotY=e["plot"+s],o=e["dataLabel"+s],p&&(e["dataLabel"+a[p-1]]=e.dataLabel),e.dataLabels||(e.dataLabels=[]),e.dataLabels[0]=e.dataLabel=o=o&&o.element?o:null):e["dataLabel"+a[p-1]]=e.dataLabel;t.prototype.drawDataLabels.call(r)}))},o.prototype.getValues=function(t,o){var n,e,i,r,a,s,p,c=o.period,u=t.xData,d=t.yData,f=d?d.length:0,h=this[o.algorithm+"Placement"],y=[],v=[],P=[];if(!(u.length<c)&&l(d[0])&&4===d[0].length){for(p=c+1;p<=f+c;p+=c)i=u.slice(p-c-1,p),r=d.slice(p-c-1,p),e=i.length,n=i[e-1],s=h(this.getPivotAndHLC(r)),a=y.push([n].concat(s)),v.push(n),P.push(y[a-1].slice(1));return this.endPoint=i[0]+(n-i[0])/e*c,{values:y,xData:v,yData:P}}},o.prototype.getPivotAndHLC=function(t){var o=t[t.length-1][3],n=-1/0,e=1/0;return t.forEach(function(t){n=Math.max(n,t[1]),e=Math.min(e,t[2])}),[(n+e+o)/3,n,e,o]},o.prototype.standardPlacement=function(t){var o=t[1]-t[2];return[null,null,t[0]+o,2*t[0]-t[2],t[0],2*t[0]-t[1],t[0]-o,null,null]},o.prototype.camarillaPlacement=function(t){var o=t[1]-t[2];return[t[3]+1.5*o,t[3]+1.25*o,t[3]+1.1666*o,t[3]+1.0833*o,t[0],t[3]-1.0833*o,t[3]-1.1666*o,t[3]-1.25*o,t[3]-1.5*o]},o.prototype.fibonacciPlacement=function(t){var o=t[1]-t[2];return[null,t[0]+o,t[0]+.618*o,t[0]+.382*o,t[0],t[0]-.382*o,t[0]-.618*o,t[0]-o,null]},o.defaultOptions=a(r.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}}),o}(r);return s(c.prototype,{nameBase:"Pivot Points",pointArrayMap:["R4","R3","R2","R1","P","S1","S2","S3","S4"],pointValKey:"P",pointClass:t}),o.registerSeriesType("pivotpoints",c),c}),n(o,"masters/indicators/pivot-points.src.js",[],function(){})});//# sourceMappingURL=pivot-points.js.map