/**
 * Highstock JS v11.2.0 (2023-10-30)
 *
 * Highcharts Stock as a plugin for Highcharts
 *
 * (c) 2010-2021 Torstein Honsi
 *
 * License: www.highcharts.com/license
 */!function(t){"object"==typeof module&&module.exports?(t.default=t,module.exports=t):"function"==typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(i){return t(i),t.Highcharts=i,t}):t("undefined"!=typeof Highcharts?Highcharts:void 0)}(function(t){"use strict";var i=t?t._modules:{};function e(t,i,e,o){t.hasOwnProperty(i)||(t[i]=o.apply(null,e),"function"==typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:i,module:t[i]}})))}e(i,"Core/Axis/BrokenAxis.js",[i["Core/Axis/Stacking/StackItem.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,s=i.find,r=i.fireEvent,n=i.isArray,a=i.isNumber,h=i.pick;return function(e){var l=[];function p(){void 0!==this.brokenAxis&&this.brokenAxis.setBreaks(this.options.breaks,!1)}function d(){var t;(null===(t=this.brokenAxis)||void 0===t?void 0:t.hasBreaks)&&(this.options.ordinal=!1)}function u(){var t=this.brokenAxis;if(null==t?void 0:t.hasBreaks){for(var i=this.tickPositions,e=this.tickPositions.info,o=[],s=0;s<i.length;s++)t.isInAnyBreak(i[s])||o.push(i[s]);this.tickPositions=o,this.tickPositions.info=e}}function c(){this.brokenAxis||(this.brokenAxis=new m(this))}function f(){var t,i,e=this.isDirty,o=this.options.connectNulls,s=this.points,r=this.xAxis,n=this.yAxis;if(e)for(var a=s.length;a--;){var h=s[a],l=!(null===h.y&&!1===o)&&((null===(t=null==r?void 0:r.brokenAxis)||void 0===t?void 0:t.isInAnyBreak(h.x,!0))||(null===(i=null==n?void 0:n.brokenAxis)||void 0===i?void 0:i.isInAnyBreak(h.y,!0)));h.visible=!l&&!1!==h.options.visible}}function g(){this.drawBreaks(this.xAxis,["x"]),this.drawBreaks(this.yAxis,h(this.pointArrayMap,["y"]))}function v(t,i){var e,o,s,n,l=this,p=l.points;if(null===(e=null==t?void 0:t.brokenAxis)||void 0===e?void 0:e.hasBreaks){var d=t.brokenAxis;i.forEach(function(i){o=(null==d?void 0:d.breakArray)||[],s=t.isXAxis?t.min:h(l.options.threshold,t.min);var e,u,c=null===(u=null===(e=null==t?void 0:t.options)||void 0===e?void 0:e.breaks)||void 0===u?void 0:u.filter(function(t){for(var i=!0,e=0;e<o.length;e++){var s=o[e];if(s.from===t.from&&s.to===t.to){i=!1;break}}return i});p.forEach(function(e){n=h(e["stack"+i.toUpperCase()],e[i]),o.forEach(function(i){if(a(s)&&a(n)){var o="";s<i.from&&n>i.to||s>i.from&&n<i.from?o="pointBreak":(s<i.from&&n>i.from&&n<i.to||s>i.from&&n>i.to&&n<i.from)&&(o="pointInBreak"),o&&r(t,o,{point:e,brk:i})}}),null==c||c.forEach(function(i){r(t,"pointOutsideOfBreak",{point:e,brk:i})})})})}}function x(){var i=this.currentDataGrouping,e=null==i?void 0:i.gapSize,o=this.points.slice(),s=this.yAxis,r=this.options.gapSize,n=o.length-1;if(r&&n>0){"value"!==this.options.gapUnit&&(r*=this.basePointRange),e&&e>r&&e>=this.basePointRange&&(r=e);for(var a=void 0,h=void 0;n--;)if(h&&!1!==h.visible||(h=o[n+1]),a=o[n],!1!==h.visible&&!1!==a.visible){if(h.x-a.x>r){var l=(a.x+h.x)/2;o.splice(n+1,0,{isNull:!0,x:l}),s.stacking&&this.options.stacking&&((s.stacking.stacks[this.stackKey][l]=new t(s,s.options.stackLabels,!1,l,this.stack)).total=0)}h=a}}return this.getGraphPath(o)}e.compose=function(t,e){if(i.pushUnique(l,t)&&(t.keepProps.push("brokenAxis"),o(t,"init",c),o(t,"afterInit",p),o(t,"afterSetTickPositions",u),o(t,"afterSetOptions",d)),i.pushUnique(l,e)){var s=e.prototype;s.drawBreaks=v,s.gappedPath=x,o(e,"afterGeneratePoints",f),o(e,"afterRender",g)}return t};var m=function(){function t(t){this.hasBreaks=!1,this.axis=t}return t.isInBreak=function(t,i){var e=t.repeat||1/0,o=t.from,s=t.to-t.from,r=i>=o?(i-o)%e:e-(o-i)%e;return t.inclusive?r<=s:r<s&&0!==r},t.lin2Val=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var s,r,n=i;for(r=0;r<o.length&&!((s=o[r]).from>=n);r++)s.to<n?n+=s.len:t.isInBreak(s,n)&&(n+=s.len);return n},t.val2Lin=function(i){var e=this.brokenAxis,o=e&&e.breakArray;if(!o||!a(i))return i;var s,r,n=i;for(r=0;r<o.length;r++)if((s=o[r]).to<=i)n-=s.len;else if(s.from>=i)break;else if(t.isInBreak(s,i)){n-=i-s.from;break}return n},t.prototype.findBreakAt=function(t,i){return s(i,function(i){return i.from<t&&t<i.to})},t.prototype.isInAnyBreak=function(i,e){var o,s,r,n=this.axis,l=n.options.breaks||[],p=l.length;if(p&&a(i)){for(;p--;)t.isInBreak(l[p],i)&&(o=!0,s||(s=h(l[p].showPoints,!n.isXAxis)));r=o&&e?o&&!s:o}return r},t.prototype.setBreaks=function(i,e){var o=this,s=o.axis,l=n(i)&&!!i.length&&!!Object.keys(i[0]).length;s.isDirty=o.hasBreaks!==l,o.hasBreaks=l,i!==s.options.breaks&&(s.options.breaks=s.userOptions.breaks=i),s.forceRedraw=!0,s.series.forEach(function(t){t.isDirty=!0}),l||s.val2lin!==t.val2Lin||(delete s.val2lin,delete s.lin2val),l&&(s.userOptions.ordinal=!1,s.lin2val=t.lin2Val,s.val2lin=t.val2Lin,s.setExtremes=function(t,i,e,r,n){if(o.hasBreaks){for(var a=this.options.breaks||[],h=void 0;h=o.findBreakAt(t,a);)t=h.to;for(;h=o.findBreakAt(i,a);)i=h.from;i<t&&(i=t)}s.constructor.prototype.setExtremes.call(this,t,i,e,r,n)},s.setAxisTranslation=function(){if(s.constructor.prototype.setAxisTranslation.call(this),o.unitLength=void 0,o.hasBreaks){var i,e,n,l,p=s.options.breaks||[],d=[],u=[],c=h(s.pointRangePadding,0),f=0,g=s.userMin||s.min,v=s.userMax||s.max;p.forEach(function(i){e=i.repeat||1/0,a(g)&&a(v)&&(t.isInBreak(i,g)&&(g+=i.to%e-g%e),t.isInBreak(i,v)&&(v-=v%e-i.from%e))}),p.forEach(function(t){if(n=t.from,e=t.repeat||1/0,a(g)&&a(v)){for(;n-e>g;)n-=e;for(;n<g;)n+=e;for(l=n;l<v;l+=e)d.push({value:l,move:"in"}),d.push({value:l+t.to-t.from,move:"out",size:t.breakSize})}}),d.sort(function(t,i){return t.value===i.value?("in"===t.move?0:1)-("in"===i.move?0:1):t.value-i.value}),i=0,n=g,d.forEach(function(t){1===(i+="in"===t.move?1:-1)&&"in"===t.move&&(n=t.value),0===i&&a(n)&&(u.push({from:n,to:t.value,len:t.value-n-(t.size||0)}),f+=t.value-n-(t.size||0))}),o.breakArray=u,a(g)&&a(v)&&a(s.min)&&(o.unitLength=v-g-f+c,r(s,"afterBreaks"),s.staticScale?s.transA=s.staticScale:o.unitLength&&(s.transA*=(v-s.min+c)/o.unitLength),c&&(s.minPixelPadding=s.transA*(s.minPointOffset||0)),s.min=g,s.max=v)}}),h(e,!0)&&s.chart.redraw()},t}();e.Additions=m}(e||(e={})),e}),e(i,"masters/modules/broken-axis.src.js",[i["Core/Globals.js"],i["Core/Axis/BrokenAxis.js"]],function(t,i){i.compose(t.Axis,t.Series)}),e(i,"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}}),e(i,"Extensions/DataGrouping/ApproximationDefaults.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e=i.arrayMax,o=i.arrayMin,s=i.correctFloat,r=i.extend,n=i.isNumber;function a(t){var i=t.length,e=h(t);return n(e)&&i&&(e=s(e/i)),e}function h(t){var i,e=t.length;if(!e&&t.hasNulls)i=null;else if(e)for(i=0;e--;)i+=t[e];return i}var l={average:a,averages:function(){var t=[];return[].forEach.call(arguments,function(i){t.push(a(i))}),void 0===t[0]?void 0:t},close:function(t){return t.length?t[t.length-1]:t.hasNulls?null:void 0},high:function(t){return t.length?e(t):t.hasNulls?null:void 0},hlc:function(i,e,o){if(i=t.high(i),e=t.low(e),o=t.close(o),n(i)||n(e)||n(o))return[i,e,o]},low:function(t){return t.length?o(t):t.hasNulls?null:void 0},ohlc:function(i,e,o,s){if(i=t.open(i),e=t.high(e),o=t.low(o),s=t.close(s),n(i)||n(e)||n(o)||n(s))return[i,e,o,s]},open:function(t){return t.length?t[0]:t.hasNulls?null:void 0},range:function(i,e){return(i=t.low(i),e=t.high(e),n(i)||n(e))?[i,e]:null===i&&null===e?null:void 0},sum:h};return r(t,l),l}),e(i,"Extensions/DataGrouping/DataGroupingDefaults.js",[],function(){return{common:{groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %e %b, %H:%M:%S.%L","%A, %e %b, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %e %b, %H:%M:%S","%A, %e %b, %H:%M:%S","-%H:%M:%S"],minute:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],hour:["%A, %e %b, %H:%M","%A, %e %b, %H:%M","-%H:%M"],day:["%A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],week:["Week from %A, %e %b %Y","%A, %e %b","-%A, %e %b %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},seriesSpecific:{line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5},hlc:{groupPixelWidth:5},heikinashi:{groupPixelWidth:10}},units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]]}}),e(i,"Extensions/DataGrouping/DataGroupingAxisComposition.js",[i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Utilities.js"]],function(t,i){var e,o=i.addEvent,s=i.extend,r=i.merge,n=i.pick,a=[];function h(t){var i=this,e=i.series;e.forEach(function(t){t.groupPixelWidth=void 0}),e.forEach(function(e){e.groupPixelWidth=i.getGroupPixelWidth&&i.getGroupPixelWidth(),e.groupPixelWidth&&(e.hasProcessed=!0),e.applyGrouping(!!t.hasExtremesChanged)})}function l(){for(var i,e,o=this.series,s=o.length,r=0,a=!1;s--;)(e=o[s].options.dataGrouping)&&(r=Math.max(r,n(e.groupPixelWidth,t.common.groupPixelWidth)),i=(o[s].processedXData||o[s].data).length,(o[s].groupPixelWidth||i>this.chart.plotSizeX/r||i&&e.forced)&&(a=!0));return a?r:0}function p(){this.series.forEach(function(t){t.hasProcessed=!1})}function d(t,i){var o;if(i=n(i,!0),t||(t={forced:!1,units:null}),this instanceof e)for(o=this.series.length;o--;)this.series[o].update({dataGrouping:t},!1);else this.chart.options.series.forEach(function(i){i.dataGrouping="boolean"==typeof t?t:r(t,i.dataGrouping)});this.ordinal&&(this.ordinal.slope=void 0),i&&this.chart.redraw()}return{compose:function(t){e=t,i.pushUnique(a,t)&&(o(t,"afterSetScale",p),o(t,"postProcessData",h),s(t.prototype,{applyGrouping:h,getGroupPixelWidth:l,setDataGrouping:d}))}}}),e(i,"Extensions/DataGrouping/DataGroupingSeriesComposition.js",[i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Core/Axis/DateTimeAxis.js"],i["Core/Defaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o,s,r){var n=s.series.prototype,a=r.addEvent,h=r.defined,l=r.error,p=r.extend,d=r.isNumber,u=r.merge,c=r.pick,f=n.generatePoints,g=[];function v(t){var o,s,r=this.chart,a=this.options.dataGrouping,p=!1!==this.allowDG&&a&&c(a.enabled,r.options.isStock),u=this.reserveSpace(),f=this.currentDataGrouping,g=!1;p&&!this.requireSorting&&(this.requireSorting=g=!0);var v=!1==!(this.isCartesian&&!this.isDirty&&!this.xAxis.isDirty&&!this.yAxis.isDirty&&!t)||!p;if(g&&(this.requireSorting=!1),!v){this.destroyGroupedData();var x=a.groupAll?this.xData:this.processedXData,m=a.groupAll?this.yData:this.processedYData,y=r.plotSizeX,b=this.xAxis,M=b.options.ordinal,S=this.groupPixelWidth,A=void 0,k=void 0;if(S&&x&&x.length&&y){k=!0,this.isDirty=!0,this.points=null;var C,w=b.getExtremes(),D=w.min,O=w.max,E=M&&b.ordinal&&b.ordinal.getGroupIntervalFactor(D,O,this)||1,T=S*(O-D)/y*E,P=b.getTimeTicks(e.Additions.prototype.normalizeTimeTickInterval(T,a.units||i.units),Math.min(D,x[0]),Math.max(O,x[x.length-1]),b.options.startOfWeek,x,this.closestPointRange),B=n.groupData.apply(this,[x,m,P,a.approximation]),j=B.groupedXData,G=B.groupedYData,R=0;for(a&&a.smoothed&&j.length&&(a.firstAnchor="firstPoint",a.anchor="middle",a.lastAnchor="lastPoint",l(32,!1,r,{"dataGrouping.smoothed":"use dataGrouping.anchor"})),A=1;A<P.length;A++)P.info.segmentStarts&&-1!==P.info.segmentStarts.indexOf(A)||(R=Math.max(P[A]-P[A-1],R));(o=P.info).gapSize=R,this.closestPointRange=P.info.totalRange,this.groupMap=B.groupMap,this.currentDataGrouping=o,function(t,i,e){var o,s=t.options.dataGrouping,r=t.currentDataGrouping&&t.currentDataGrouping.gapSize;if(s&&t.xData&&r&&t.groupMap){var n=i.length-1,a=s.anchor,h=c(s.firstAnchor,a),l=c(s.lastAnchor,a);if(a&&"start"!==a){var p=r*({middle:.5,end:1})[a];for(o=i.length-1;o--&&o>0;)i[o]+=p}if(h&&"start"!==h&&t.xData[0]>=i[0]){var u=t.groupMap[0].start,f=t.groupMap[0].length,g=void 0;d(u)&&d(f)&&(g=u+(f-1)),i[0]=({middle:i[0]+.5*r,end:i[0]+r,firstPoint:t.xData[0],lastPoint:g&&t.xData[g]})[h]}if(l&&"start"!==l&&r&&i[n]>=e-r){var v=t.groupMap[t.groupMap.length-1].start;i[n]=({middle:i[n]+.5*r,end:i[n]+r,firstPoint:v&&t.xData[v],lastPoint:t.xData[t.xData.length-1]})[l]}}}(this,j,O),u&&(h((C=j)[0])&&d(b.min)&&d(b.dataMin)&&C[0]<b.min&&((!h(b.options.min)&&b.min<=b.dataMin||b.min===b.dataMin)&&(b.min=Math.min(C[0],b.min)),b.dataMin=Math.min(C[0],b.dataMin)),h(C[C.length-1])&&d(b.max)&&d(b.dataMax)&&C[C.length-1]>b.max&&((!h(b.options.max)&&d(b.dataMax)&&b.max>=b.dataMax||b.max===b.dataMax)&&(b.max=Math.max(C[C.length-1],b.max)),b.dataMax=Math.max(C[C.length-1],b.dataMax))),a.groupAll&&(this.allGroupedData=G,j=(s=this.cropData(j,G,b.min,b.max)).xData,G=s.yData,this.cropStart=s.start),this.processedXData=j,this.processedYData=G}else this.groupMap=null;this.hasGroupedData=k,this.preventGraphAnimation=(f&&f.totalRange)!==(o&&o.totalRange)}}function x(){this.groupedData&&(this.groupedData.forEach(function(t,i){t&&(this.groupedData[i]=t.destroy?t.destroy():null)},this),this.groupedData.length=0)}function m(){f.apply(this),this.destroyGroupedData(),this.groupedData=this.hasGroupedData?this.points:null}function y(){return this.is("arearange")?"range":this.is("ohlc")?"ohlc":this.is("hlc")?"hlc":this.is("column")||this.options.cumulative?"sum":"average"}function b(i,e,o,s){var r,n,a,l=this,p=l.data,c=l.options&&l.options.data,f=[],g=[],v=[],x=i.length,m=!!e,y=[],b=l.pointArrayMap,M=b&&b.length,S=["x"].concat(b||["y"]),A=this.options.dataGrouping&&this.options.dataGrouping.groupAll,k=0,C=0,w="function"==typeof s?s:s&&t[s]?t[s]:t[l.getDGApproximation&&l.getDGApproximation()||"average"];if(M)for(var D=b.length;D--;)y.push([]);else y.push([]);for(var O=M||1,E=0;E<=x;E++)if(!(i[E]<o[0])){for(;void 0!==o[k+1]&&i[E]>=o[k+1]||E===x;){r=o[k],l.dataGroupInfo={start:A?C:l.cropStart+C,length:y[0].length},a=w.apply(l,y),l.pointClass&&!h(l.dataGroupInfo.options)&&(l.dataGroupInfo.options=u(l.pointClass.prototype.optionsToObject.call({series:l},l.options.data[l.cropStart+C])),S.forEach(function(t){delete l.dataGroupInfo.options[t]})),void 0!==a&&(f.push(r),g.push(a),v.push(l.dataGroupInfo)),C=E;for(var T=0;T<O;T++)y[T].length=0,y[T].hasNulls=!1;if(k+=1,E===x)break}if(E===x)break;if(b)for(var P=l.options.dataGrouping&&l.options.dataGrouping.groupAll?E:l.cropStart+E,B=p&&p[P]||l.pointClass.prototype.applyOptions.apply({series:l},[c[P]]),j=void 0,T=0;T<M;T++)d(j=B[b[T]])?y[T].push(j):null===j&&(y[T].hasNulls=!0);else d(n=m?e[E]:null)?y[0].push(n):null===n&&(y[0].hasNulls=!0)}return{groupedXData:f,groupedYData:g,groupMap:v}}function M(t){var e=t.options,s=this.type,r=this.chart.options.plotOptions,n=this.useCommonDataGrouping&&i.common,a=i.seriesSpecific,h=o.defaultOptions.plotOptions[s].dataGrouping;if(r&&(a[s]||n)){var l=this.chart.rangeSelector;h||(h=u(i.common,a[s])),e.dataGrouping=u(n,h,r.series&&r.series.dataGrouping,r[s].dataGrouping,this.userOptions.dataGrouping,!e.isInternal&&l&&d(l.selected)&&l.buttonOptions[l.selected].dataGrouping)}}return{compose:function(t){var i=t.prototype.pointClass;r.pushUnique(g,i)&&a(i,"update",function(){if(this.dataGroup)return l(24,!1,this.series.chart),!1}),r.pushUnique(g,t)&&(a(t,"afterSetOptions",M),a(t,"destroy",x),p(t.prototype,{applyGrouping:v,destroyGroupedData:x,generatePoints:m,getDGApproximation:y,groupData:b}))},groupData:b}}),e(i,"Extensions/DataGrouping/DataGrouping.js",[i["Extensions/DataGrouping/DataGroupingAxisComposition.js"],i["Extensions/DataGrouping/DataGroupingDefaults.js"],i["Extensions/DataGrouping/DataGroupingSeriesComposition.js"],i["Core/Templating.js"],i["Core/Utilities.js"]],function(t,i,e,o,s){var r=o.format,n=s.addEvent,a=s.extend,h=s.isNumber,l=[];function p(t){var e,o,s,n,l,p=this.chart,d=p.time,u=t.labelConfig,c=u.series,f=c.options,g=c.tooltipOptions,v=f.dataGrouping,x=c.xAxis,m=g.xDateFormat,y=g[t.isFooter?"footerFormat":"headerFormat"];x&&"datetime"===x.options.type&&v&&h(u.key)&&(o=c.currentDataGrouping,s=v.dateTimeLabelFormats||i.common.dateTimeLabelFormats,o?(n=s[o.unitName],1===o.count?m=n[0]:(m=n[1],e=n[2])):!m&&s&&x.dateTime&&(m=x.dateTime.getXDateFormat(u.x,g.dateTimeLabelFormats)),l=d.dateFormat(m,u.key),e&&(l+=d.dateFormat(e,u.key+o.totalRange-1)),c.chart.styledMode&&(y=this.styledModeFormat(y)),t.text=r(y,{point:a(u.point,{key:l}),series:c},p),t.preventDefault())}return{compose:function(i,o,r){t.compose(i),e.compose(o),r&&s.pushUnique(l,r)&&n(r,"headerFormatter",p)},groupData:e.groupData}}),e(i,"masters/modules/datagrouping.src.js",[i["Core/Globals.js"],i["Extensions/DataGrouping/ApproximationDefaults.js"],i["Extensions/DataGrouping/ApproximationRegistry.js"],i["Extensions/DataGrouping/DataGrouping.js"]],function(t,i,e,o){t.dataGrouping={approximationDefaults:i,approximations:e},o.compose(t.Axis,t.Series,t.Tooltip)}),e(i,"Extensions/Annotations/NavigationBindingsUtilities.js",[i["Core/Utilities.js"]],function(t){var i=t.defined,e=t.isNumber,o=t.pick,s={backgroundColor:"string",borderColor:"string",borderRadius:"string",color:"string",fill:"string",fontSize:"string",labels:"string",name:"string",stroke:"string",title:"string"};return{annotationsFieldsTypes:s,getAssignedAxis:function(t){return t.filter(function(t){var i=t.axis.getExtremes(),s=i.min,r=i.max,n=o(t.axis.minPointOffset,0);return e(s)&&e(r)&&t.value>=s-n&&t.value<=r+n&&!t.axis.options.isInternal})[0]},getFieldType:function(t,e){var o=s[t],r=typeof e;return i(o)&&(r=o),({string:"text",number:"number",boolean:"checkbox"})[r]}}}),e(i,"Extensions/MouseWheelZoom/MouseWheelZoom.js",[i["Core/Utilities.js"],i["Extensions/Annotations/NavigationBindingsUtilities.js"]],function(t,i){var e,o,s,r=t.addEvent,n=t.isObject,a=t.pick,h=t.defined,l=t.merge,p=t.isNumber,d=i.getAssignedAxis,u=[],c={enabled:!0,sensitivity:1.1},f=function(t){var i=t.options;h(e)&&clearTimeout(e),h(o)||(o=i.startOnTick,s=i.endOnTick),(o||s)&&(i.startOnTick=!1,i.endOnTick=!1),e=setTimeout(function(){if(h(o)&&h(s)){i.startOnTick=o,i.endOnTick=s;var e=t.getExtremes(),r=e.min,n=e.max;t.forceRedraw=!0,t.setExtremes(r,n),o=s=void 0}},400)},g=function(t,i,e){if(!h(e))return .5;var o=(e-i.pos)/i.len,s=i.isXAxis;return s&&!i.reversed!=!t.inverted||!s&&i.reversed?1-o:o},v=function(t,i,e,o,s){var r=i.isXAxis,n=!1;if(h(i.max)&&h(i.min)&&h(i.dataMax)&&h(i.dataMin)){r||f(i);var l,d,u=i.max-i.min,c=p(s)?s:i.min+u/2,v=g(t,i,e),x=u*o,m=a(i.options.max,i.dataMax)-a(i.options.min,i.dataMin),y=i.options.min?0:m*i.options.minPadding,b=i.options.max?0:m*i.options.maxPadding,M=a(i.options.min,i.dataMin)-y,S=m+b+y,A=((l=c-x*v)+(d=x)>M+S&&(d>S?(d=S,l=M):l=M+S-d),d>S&&(d=S),l<M&&(l=M),{rangeStart:l,rangeWidth:d}),k=A.rangeStart<a(i.options.min,M)||A.rangeStart===i.min&&A.rangeWidth>S&&A.rangeStart+A.rangeWidth<a(i.options.max,Number.MIN_VALUE)||A.rangeWidth===i.max-i.min;h(o)&&!k?(i.setExtremes(A.rangeStart,A.rangeStart+A.rangeWidth,!1),n=!0):i.setExtremes(void 0,void 0,!1)}return n},x=function(t,i,e,o,s,r,n){var h=a(n.type,t.zooming.type,""),l=/x/.test(h),p=/y/.test(h),d=e.toValue(s),u=o.toValue(r);if(t.inverted){var c=o.pos+o.len;d=e.toValue(r),u=o.toValue(s);var f=s;s=r,r=c-f+o.pos}var g=l&&v(t,e,s,i,d),x=p&&v(t,o,r,i,u),m=g||x;return m&&t.redraw(!1),m};function m(){var t,i=this,e=this,o=n(t=e.zooming.mouseWheel)?l(c,t):l(c,{enabled:!h(t)||t});o.enabled&&r(this.container,"wheel",function(t){t=i.pointer.normalize(t);var s=!e.pointer.inClass(t.target,"highcharts-no-mousewheel");if(e.isInsidePlot(t.chartX-e.plotLeft,t.chartY-e.plotTop)&&s){var r=o.sensitivity||1.1,n=t.detail||(t.deltaY||0)/120,a=d(i.pointer.getCoordinates(t).xAxis),h=d(i.pointer.getCoordinates(t).yAxis);x(e,Math.pow(r,n),a?a.axis:e.xAxis[0],h?h.axis:e.yAxis[0],t.chartX,t.chartY,o)&&t.preventDefault&&t.preventDefault()}})}return{compose:function(t){-1===u.indexOf(t)&&(u.push(t),r(t,"afterGetContainer",m))}}}),e(i,"masters/modules/mouse-wheel-zoom.src.js",[i["Core/Globals.js"],i["Extensions/MouseWheelZoom/MouseWheelZoom.js"]],function(t,i){i.compose(t.Chart)}),e(i,"Series/DataModifyComposition.js",[i["Core/Axis/Axis.js"],i["Core/Series/Point.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var s,r=i.prototype.tooltipFormatter,n=o.addEvent,a=o.arrayMax,h=o.arrayMin,l=o.correctFloat,p=o.defined,d=o.isArray,u=o.isNumber,c=o.isString,f=o.pick;return function(t){var i=[];function e(t,i,e){!this.isXAxis&&(this.series.forEach(function(e){"compare"===t&&"boolean"!=typeof i?e.setCompare(i,!1):"cumulative"!==t||c(i)||e.setCumulative(i,!1)}),f(e,!0)&&this.chart.redraw())}function s(t){var i=this,e=i.series.chart.numberFormatter,o=function(o){t=t.replace("{point."+o+"}",(i[o]>0&&"change"===o?"+":"")+e(i[o],f(i.series.tooltipOptions.changeDecimals,2)))};return p(i.change)&&o("change"),p(i.cumulativeSum)&&o("cumulativeSum"),r.apply(this,[t])}function g(){var t,i=this.options.compare;("percent"===i||"value"===i||this.options.cumulative)&&(t=new S(this),"percent"===i||"value"===i?t.initCompare(i):t.initCumulative()),this.dataModify=t}function v(t){var i=t.dataExtremes,e=i.activeYData;if(this.dataModify&&i){var o=void 0;this.options.compare?o=[this.dataModify.modifyValue(i.dataMin),this.dataModify.modifyValue(i.dataMax)]:this.options.cumulative&&d(e)&&e.length>=2&&(o=S.getCumulativeExtremes(e)),o&&(i.dataMin=h(o),i.dataMax=a(o))}}function x(t,i){this.options.compare=this.userOptions.compare=t,this.update({},f(i,!0)),this.dataModify&&("value"===t||"percent"===t)?this.dataModify.initCompare(t):this.points.forEach(function(t){delete t.change})}function m(){if(this.xAxis&&this.processedYData&&this.dataModify){var t=this.processedXData,i=this.processedYData,e=i.length,o=!0===this.options.compareStart?0:1,s=-1,r=void 0;for(this.pointArrayMap&&(s=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y")),r=0;r<e-o;r++){var n=i[r]&&s>-1?i[r][s]:i[r];if(u(n)&&0!==n&&t[r+o]>=(this.xAxis.min||0)){this.dataModify.compareValue=n;break}}}}function y(t,i){this.setModifier("compare",t,i)}function b(t,i){t=f(t,!1),this.options.cumulative=this.userOptions.cumulative=t,this.update({},f(i,!0)),this.dataModify?this.dataModify.initCumulative():this.points.forEach(function(t){delete t.cumulativeSum})}function M(t,i){this.setModifier("cumulative",t,i)}t.compose=function(t,r,a){if(o.pushUnique(i,t)){var h=t.prototype;h.setCompare=x,h.setCumulative=b,n(t,"afterInit",g),n(t,"afterGetExtremes",v),n(t,"afterProcessData",m)}if(o.pushUnique(i,r)){var l=r.prototype;l.setCompare=y,l.setModifier=e,l.setCumulative=M}return o.pushUnique(i,a)&&(a.prototype.tooltipFormatter=s),t};var S=function(){function t(t){this.series=t}return t.prototype.modifyValue=function(){return 0},t.getCumulativeExtremes=function(t){var i=1/0,e=-1/0;return t.reduce(function(t,o){var s=t+o;return i=Math.min(i,s,t),e=Math.max(e,s,t),s}),[i,e]},t.prototype.initCompare=function(t){this.modifyValue=function(i,e){null===i&&(i=0);var o=this.compareValue;if(void 0!==i&&void 0!==o){if("value"===t?i-=o:i=100*(i/o)-(100===this.series.options.compareBase?0:100),void 0!==e){var s=this.series.points[e];s&&(s.change=i)}return i}return 0}},t.prototype.initCumulative=function(){this.modifyValue=function(t,i){if(null===t&&(t=0),void 0!==t&&void 0!==i){var e=i>0?this.series.points[i-1]:null;e&&e.cumulativeSum&&(t=l(e.cumulativeSum+t));var o=this.series.points[i];return o&&(o.cumulativeSum=t),t}return 0}},t}();t.Additions=S}(s||(s={})),s}),e(i,"Core/Axis/NavigatorAxisComposition.js",[i["Core/Globals.js"],i["Core/Utilities.js"]],function(t,i){var e=t.isTouchDevice,o=i.addEvent,s=i.correctFloat,r=i.defined,n=i.isNumber,a=i.pick,h=[];function l(){this.navigatorAxis||(this.navigatorAxis=new d(this))}function p(t){var i=this.chart,o=i.options,s=o.navigator,n=this.navigatorAxis,a=i.zooming.pinchType,h=o.rangeSelector,l=i.zooming.type;if(this.isXAxis&&(s&&s.enabled||h&&h.enabled)){if("y"===l)t.zoomed=!1;else if((!e&&"xy"===l||e&&"xy"===a)&&this.options.range){var p=n.previousZoom;r(t.newMin)?n.previousZoom=[this.min,this.max]:p&&(t.newMin=p[0],t.newMax=p[1],n.previousZoom=void 0)}}void 0!==t.zoomed&&t.preventDefault()}var d=function(){function t(t){this.axis=t}return t.compose=function(t){i.pushUnique(h,t)&&(t.keepProps.push("navigatorAxis"),o(t,"init",l),o(t,"zoom",p))},t.prototype.destroy=function(){this.axis=void 0},t.prototype.toFixedRange=function(t,i,e,o){var h=this.axis,l=h.chart,p=a(e,h.translate(t,!0,!h.horiz)),d=a(o,h.translate(i,!0,!h.horiz)),u=l&&l.fixedRange,c=(h.pointRange||0)/2;return r(e)||(p=s(p+c)),r(o)||(d=s(d-c)),u&&h.dataMin&&h.dataMax&&(d>=h.dataMax&&(p=s(h.dataMax-u)),p<=h.dataMin&&(d=s(h.dataMin+u))),n(p)&&n(d)||(p=d=void 0),{min:p,max:d}},t}();return d}),e(i,"Stock/Navigator/NavigatorDefaults.js",[i["Core/Color/Color.js"],i["Core/Series/SeriesRegistry.js"]],function(t,i){var e=t.parse,o=i.seriesTypes;return{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:e("#667aff").setOpacity(.3).get(),outlineColor:"#999999",outlineWidth:1,series:{type:void 0===o.areaspline?"line":"areaspline",fillOpacity:.05,lineWidth:1,compare:null,sonification:{enabled:!1},dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,labels:{align:"left",style:{color:"#000000",fontSize:"0.7em",opacity:.6,textOutline:"2px contrast"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}}),e(i,"Stock/Navigator/NavigatorSymbols.js",[],function(){return{"navigator-handle":function(t,i,e,o,s){void 0===s&&(s={});var r=s.width?s.width/2:e,n=Math.round(r/3)+.5;return[["M",-r-1,.5],["L",r,.5],["L",r,(o=s.height||o)+.5],["L",-r-1,o+.5],["L",-r-1,.5],["M",-n,4],["L",-n,o-3],["M",n-1,4],["L",n-1,o-3]]}}}),e(i,"Stock/Navigator/NavigatorComposition.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/Navigator/NavigatorSymbols.js"],i["Core/Renderer/RendererRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o,s,r,n){var a,h=t.defaultOptions,l=t.setOptions,p=i.isTouchDevice,d=r.getRendererType,u=n.addEvent,c=n.extend,f=n.merge,g=n.pick,v=[];function x(){this.navigator&&this.navigator.setBaseSeries(null,!1)}function m(){var t,i,e,o,s=this.legend,r=this.navigator;if(r){i=s&&s.options,e=r.xAxis,o=r.yAxis;var n=r.scrollbarHeight,a=r.scrollButtonSize;this.inverted?(r.left=r.opposite?this.chartWidth-n-r.height:this.spacing[3]+n,r.top=this.plotTop+a):(r.left=g(e.left,this.plotLeft+a),r.top=r.navigatorOptions.top||this.chartHeight-r.height-n-((null===(t=this.scrollbar)||void 0===t?void 0:t.options.margin)||0)-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?this.rangeSelector.getHeight():0)-(i&&"bottom"===i.verticalAlign&&"proximate"!==i.layout&&i.enabled&&!i.floating?s.legendHeight+g(i.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0)),e&&o&&(this.inverted?e.options.left=o.options.left=r.left:e.options.top=o.options.top=r.top,e.setAxisSize(),o.setAxisSize())}}function y(t){!this.navigator&&!this.scroller&&(this.options.navigator.enabled||this.options.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this),g(t.redraw,!0)&&this.redraw(t.animation))}function b(){var t=this.options;(t.navigator.enabled||t.scrollbar.enabled)&&(this.scroller=this.navigator=new a(this))}function M(){var t=this.options,i=t.navigator,e=t.rangeSelector;if((i&&i.enabled||e&&e.enabled)&&(!p&&"x"===this.zooming.type||p&&"x"===this.zooming.pinchType))return!1}function S(t){var i=t.navigator;if(i&&t.xAxis[0]){var e=t.xAxis[0].getExtremes();i.render(e.min,e.max)}}function A(t){var i=t.options.navigator||{},e=t.options.scrollbar||{};!this.navigator&&!this.scroller&&(i.enabled||e.enabled)&&(f(!0,this.options.navigator,i),f(!0,this.options.scrollbar,e),delete t.options.navigator,delete t.options.scrollbar)}function k(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}return{compose:function(t,i,r,p){e.compose(t),a=r,n.pushUnique(v,i)&&(i.prototype.callbacks.push(S),u(i,"afterAddSeries",x),u(i,"afterSetChartSize",m),u(i,"afterUpdate",y),u(i,"beforeRender",b),u(i,"beforeShowResetZoom",M),u(i,"update",A)),n.pushUnique(v,p)&&u(p,"afterUpdate",k),n.pushUnique(v,d)&&c(d().prototype.symbols,s),n.pushUnique(v,l)&&c(h,{navigator:o})}}}),e(i,"Core/Axis/ScrollbarAxis.js",[i["Core/Utilities.js"]],function(t){var i,e=t.addEvent,o=t.defined,s=t.pick,r=t.pushUnique;return function(t){var i,n=[];function a(t){var i=s(t.options&&t.options.min,t.min),e=s(t.options&&t.options.max,t.max);return{axisMin:i,axisMax:e,scrollMin:o(t.dataMin)?Math.min(i,t.min,t.dataMin,s(t.threshold,1/0)):i,scrollMax:o(t.dataMax)?Math.max(e,t.max,t.dataMax,s(t.threshold,-1/0)):e}}function h(){var t=this.scrollbar,i=t&&!t.options.opposite,e=this.horiz?2:i?3:1;t&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[e]+=t.size+(t.options.margin||0))}function l(){var t=this;t.options&&t.options.scrollbar&&t.options.scrollbar.enabled&&(t.options.scrollbar.vertical=!t.horiz,t.options.startOnTick=t.options.endOnTick=!1,t.scrollbar=new i(t.chart.renderer,t.options.scrollbar,t.chart),e(t.scrollbar,"changed",function(i){var e,s,r=a(t),n=r.axisMin,h=r.axisMax,l=r.scrollMin,p=r.scrollMax-l;if(o(n)&&o(h)){if(t.horiz&&!t.reversed||!t.horiz&&t.reversed?(e=l+p*this.to,s=l+p*this.from):(e=l+p*(1-this.from),s=l+p*(1-this.to)),this.shouldUpdateExtremes(i.DOMType)){var d="mousemove"!==i.DOMType&&"touchmove"!==i.DOMType&&void 0;t.setExtremes(s,e,!0,d,i)}else this.setRange(this.from,this.to)}}))}function p(){var t,i,e,s=a(this),r=s.scrollMin,n=s.scrollMax,h=this.scrollbar,l=this.axisTitleMargin+(this.titleOffset||0),p=this.chart.scrollbarsOffsets,d=this.options.margin||0;if(h&&p){if(this.horiz)this.opposite||(p[1]+=l),h.position(this.left,this.top+this.height+2+p[1]-(this.opposite?d:0),this.width,this.height),this.opposite||(p[1]+=d),t=1;else{this.opposite&&(p[0]+=l);var u=void 0;u=h.options.opposite?this.left+this.width+2+p[0]-(this.opposite?0:d):this.opposite?0:d,h.position(u,this.top,this.width,this.height),this.opposite&&(p[0]+=d),t=0}p[t]+=h.size+(h.options.margin||0),isNaN(r)||isNaN(n)||!o(this.min)||!o(this.max)||this.min===this.max?h.setRange(0,1):(i=(this.min-r)/(n-r),e=(this.max-r)/(n-r),this.horiz&&!this.reversed||!this.horiz&&this.reversed?h.setRange(i,e):h.setRange(1-e,1-i))}}t.compose=function(t,o){r(n,o)&&(i=o),r(n,t)&&(e(t,"afterGetOffset",h),e(t,"afterInit",l),e(t,"afterRender",p))}}(i||(i={})),i}),e(i,"Stock/Scrollbar/ScrollbarDefaults.js",[i["Core/Globals.js"]],function(t){return t.isTouchDevice,{height:10,barBorderRadius:5,buttonBorderRadius:0,buttonsEnabled:!1,liveRedraw:void 0,margin:void 0,minWidth:6,opposite:!0,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:0,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"none",trackBackgroundColor:"rgba(255, 255, 255, 0.001)",trackBorderColor:"#cccccc",trackBorderRadius:5,trackBorderWidth:1}}),e(i,"Stock/Scrollbar/Scrollbar.js",[i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/ScrollbarAxis.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o,s){var r=t.defaultOptions,n=s.addEvent,a=s.correctFloat,h=s.defined,l=s.destroyObjectProperties,p=s.fireEvent,d=s.merge,u=s.pick,c=s.removeEvent,f=function(){function t(t,i,e){this._events=[],this.chart=void 0,this.chartX=0,this.chartY=0,this.from=0,this.group=void 0,this.options=void 0,this.renderer=void 0,this.scrollbar=void 0,this.scrollbarButtons=[],this.scrollbarGroup=void 0,this.scrollbarLeft=0,this.scrollbarRifles=void 0,this.scrollbarStrokeWidth=1,this.scrollbarTop=0,this.size=0,this.to=0,this.track=void 0,this.trackBorderWidth=1,this.userOptions=void 0,this.x=0,this.y=0,this.init(t,i,e)}return t.compose=function(i){e.compose(i,t)},t.swapXY=function(t,i){return i&&t.forEach(function(t){for(var i,e=t.length,o=0;o<e;o+=2)"number"==typeof(i=t[o+1])&&(t[o+1]=t[o+2],t[o+2]=i)}),t},t.prototype.addEvents=function(){var t=this.options.inverted?[1,0]:[0,1],e=this.scrollbarButtons,o=this.scrollbarGroup.element,s=this.track.element,r=this.mouseDownHandler.bind(this),a=this.mouseMoveHandler.bind(this),h=this.mouseUpHandler.bind(this),l=[[e[t[0]].element,"click",this.buttonToMinClick.bind(this)],[e[t[1]].element,"click",this.buttonToMaxClick.bind(this)],[s,"click",this.trackClick.bind(this)],[o,"mousedown",r],[o.ownerDocument,"mousemove",a],[o.ownerDocument,"mouseup",h]];i.hasTouch&&l.push([o,"touchstart",r],[o.ownerDocument,"touchmove",a],[o.ownerDocument,"touchend",h]),l.forEach(function(t){n.apply(null,t)}),this._events=l},t.prototype.buttonToMaxClick=function(t){var i=(this.to-this.from)*u(this.options.step,.2);this.updatePosition(this.from+i,this.to+i),p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.buttonToMinClick=function(t){var i=a(this.to-this.from)*u(this.options.step,.2);this.updatePosition(a(this.from-i),a(this.to-i)),p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.cursorToScrollbarPosition=function(t){var i=this.options,e=i.minWidth>this.calculatedWidth?i.minWidth:0;return{chartX:(t.chartX-this.x-this.xOffset)/(this.barWidth-e),chartY:(t.chartY-this.y-this.yOffset)/(this.barWidth-e)}},t.prototype.destroy=function(){var t=this,i=t.chart.scroller;t.removeEvents(),["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(i){t[i]&&t[i].destroy&&(t[i]=t[i].destroy())}),i&&t===i.scrollbar&&(i.scrollbar=null,l(i.scrollbarButtons))},t.prototype.drawScrollbarButton=function(i){var e=this.renderer,o=this.scrollbarButtons,s=this.options,r=this.size,n=e.g().add(this.group);if(o.push(n),s.buttonsEnabled){var a=e.rect().addClass("highcharts-scrollbar-button").add(n);this.chart.styledMode||a.attr({stroke:s.buttonBorderColor,"stroke-width":s.buttonBorderWidth,fill:s.buttonBackgroundColor}),a.attr(a.crisp({x:-.5,y:-.5,width:r+1,height:r+1,r:s.buttonBorderRadius},a.strokeWidth()));var h=e.path(t.swapXY([["M",r/2+(i?-1:1),r/2-3],["L",r/2+(i?-1:1),r/2+3],["L",r/2+(i?2:-2),r/2]],s.vertical)).addClass("highcharts-scrollbar-arrow").add(o[i]);this.chart.styledMode||h.attr({fill:s.buttonArrowColor})}},t.prototype.init=function(t,i,e){this.scrollbarButtons=[],this.renderer=t,this.userOptions=i,this.options=d(o,r.scrollbar,i),this.options.margin=u(this.options.margin,10),this.chart=e,this.size=u(this.options.size,this.options.height),i.enabled&&(this.render(),this.addEvents())},t.prototype.mouseDownHandler=function(t){var i=this.chart.pointer.normalize(t),e=this.cursorToScrollbarPosition(i);this.chartX=e.chartX,this.chartY=e.chartY,this.initPositions=[this.from,this.to],this.grabbedCenter=!0},t.prototype.mouseMoveHandler=function(t){var i,e=this.chart.pointer.normalize(t),o=this.options.vertical?"chartY":"chartX",s=this.initPositions||[];this.grabbedCenter&&(!t.touches||0!==t.touches[0][o])&&(i=this.cursorToScrollbarPosition(e)[o]-this[o],this.hasDragged=!0,this.updatePosition(s[0]+i,s[1]+i),this.hasDragged&&p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}))},t.prototype.mouseUpHandler=function(t){this.hasDragged&&p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMType:t.type,DOMEvent:t}),this.grabbedCenter=this.hasDragged=this.chartX=this.chartY=null},t.prototype.position=function(t,i,e,o){var s=this.options,r=s.buttonsEnabled,n=s.margin,a=void 0===n?0:n,h=s.vertical,l=this.rendered?"animate":"attr",p=o,d=0;this.group.show(),this.x=t,this.y=i+this.trackBorderWidth,this.width=e,this.height=o,this.xOffset=p,this.yOffset=d,h?(this.width=this.yOffset=e=d=this.size,this.xOffset=p=0,this.yOffset=d=r?this.size:0,this.barWidth=o-(r?2*e:0),this.x=t+=a):(this.height=o=this.size,this.xOffset=p=r?this.size:0,this.barWidth=e-(r?2*o:0),this.y=this.y+a),this.group[l]({translateX:t,translateY:this.y}),this.track[l]({width:e,height:o}),this.scrollbarButtons[1][l]({translateX:h?0:e-p,translateY:h?o-d:0})},t.prototype.removeEvents=function(){this._events.forEach(function(t){c.apply(null,t)}),this._events.length=0},t.prototype.render=function(){var i=this.renderer,e=this.options,o=this.size,s=this.chart.styledMode,r=i.g("scrollbar").attr({zIndex:e.zIndex}).hide().add();this.group=r,this.track=i.rect().addClass("highcharts-scrollbar-track").attr({r:e.trackBorderRadius||0,height:o,width:o}).add(r),s||this.track.attr({fill:e.trackBackgroundColor,stroke:e.trackBorderColor,"stroke-width":e.trackBorderWidth});var n=this.trackBorderWidth=this.track.strokeWidth();this.track.attr({x:-n%2/2,y:-n%2/2}),this.scrollbarGroup=i.g().add(r),this.scrollbar=i.rect().addClass("highcharts-scrollbar-thumb").attr({height:o-n,width:o-n,r:e.barBorderRadius||0}).add(this.scrollbarGroup),this.scrollbarRifles=i.path(t.swapXY([["M",-3,o/4],["L",-3,2*o/3],["M",0,o/4],["L",0,2*o/3],["M",3,o/4],["L",3,2*o/3]],e.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup),s||(this.scrollbar.attr({fill:e.barBackgroundColor,stroke:e.barBorderColor,"stroke-width":e.barBorderWidth}),this.scrollbarRifles.attr({stroke:e.rifleColor,"stroke-width":1})),this.scrollbarStrokeWidth=this.scrollbar.strokeWidth(),this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%2/2,-this.scrollbarStrokeWidth%2/2),this.drawScrollbarButton(0),this.drawScrollbarButton(1)},t.prototype.setRange=function(t,i){var e,o,s=this.options,r=s.vertical,n=s.minWidth,l=this.barWidth,p=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(h(l)){var d=l*Math.min(i,1);e=Math.ceil(l*(t=Math.max(t,0))),this.calculatedWidth=o=a(d-e),o<n&&(e=(l-n+o)*t,o=n);var u=Math.floor(e+this.xOffset+this.yOffset),c=o/2-.5;this.from=t,this.to=i,r?(this.scrollbarGroup[p]({translateY:u}),this.scrollbar[p]({height:o}),this.scrollbarRifles[p]({translateY:c}),this.scrollbarTop=u,this.scrollbarLeft=0):(this.scrollbarGroup[p]({translateX:u}),this.scrollbar[p]({width:o}),this.scrollbarRifles[p]({translateX:c}),this.scrollbarLeft=u,this.scrollbarTop=0),o<=12?this.scrollbarRifles.hide():this.scrollbarRifles.show(),!1===s.showFull&&(t<=0&&i>=1?this.group.hide():this.group.show()),this.rendered=!0}},t.prototype.shouldUpdateExtremes=function(t){return u(this.options.liveRedraw,i.svg&&!i.isTouchDevice&&!this.chart.boosted)||"mouseup"===t||"touchend"===t||!h(t)},t.prototype.trackClick=function(t){var i=this.chart.pointer.normalize(t),e=this.to-this.from,o=this.y+this.scrollbarTop,s=this.x+this.scrollbarLeft;this.options.vertical&&i.chartY>o||!this.options.vertical&&i.chartX>s?this.updatePosition(this.from+e,this.to+e):this.updatePosition(this.from-e,this.to-e),p(this,"changed",{from:this.from,to:this.to,trigger:"scrollbar",DOMEvent:t})},t.prototype.update=function(t){this.destroy(),this.init(this.chart.renderer,d(!0,this.options,t),this.chart)},t.prototype.updatePosition=function(t,i){i>1&&(t=a(1-a(i-t)),i=1),t<0&&(i=a(i-t),t=0),this.from=t,this.to=i},t.defaultOptions=o,t}();return r.scrollbar=d(!0,f.defaultOptions,r.scrollbar),f}),e(i,"Stock/Navigator/Navigator.js",[i["Core/Axis/Axis.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Core/Axis/NavigatorAxisComposition.js"],i["Stock/Navigator/NavigatorComposition.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Utilities.js"]],function(t,i,e,o,s,r,n){var a=i.defaultOptions,h=e.hasTouch,l=e.isTouchDevice,p=n.addEvent,d=n.clamp,u=n.correctFloat,c=n.defined,f=n.destroyObjectProperties,g=n.erase,v=n.extend,x=n.find,m=n.fireEvent,y=n.isArray,b=n.isNumber,M=n.merge,S=n.pick,A=n.removeEvent,k=n.splat;function C(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];var o=[].filter.call(i,b);if(o.length)return Math[t].apply(0,o)}return function(){function i(t){this.baseSeries=void 0,this.chart=void 0,this.handles=void 0,this.height=void 0,this.left=void 0,this.navigatorEnabled=void 0,this.navigatorGroup=void 0,this.navigatorOptions=void 0,this.navigatorSeries=void 0,this.navigatorSize=void 0,this.opposite=void 0,this.outline=void 0,this.range=void 0,this.rendered=void 0,this.scrollbarHeight=0,this.scrollButtonSize=void 0,this.shades=void 0,this.size=void 0,this.top=void 0,this.xAxis=void 0,this.yAxis=void 0,this.zoomedMax=void 0,this.zoomedMin=void 0,this.init(t)}return i.compose=function(t,e,o){s.compose(t,e,i,o)},i.prototype.drawHandle=function(t,i,e,o){var s=this.navigatorOptions.handles.height;this.handles[i][o](e?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(t,10)+.5-s)}:{translateX:Math.round(this.left+parseInt(t,10)),translateY:Math.round(this.top+this.height/2-s/2-1)})},i.prototype.drawOutline=function(t,i,e,o){var s,r,n=this.navigatorOptions.maskInside,a=this.outline.strokeWidth(),h=a/2,l=a%2/2,p=this.scrollButtonSize,d=this.size,u=this.top,c=this.height,f=u-h,g=u+c,v=this.left;e?(s=u+i+l,i=u+t+l,r=[["M",v+c,u-p-l],["L",v+c,s],["L",v,s],["M",v,i],["L",v+c,i],["L",v+c,u+d+p]],n&&r.push(["M",v+c,s-h],["L",v+c,i+h])):(v-=p,t+=v+p-l,i+=v+p-l,r=[["M",v,f],["L",t,f],["L",t,g],["M",i,g],["L",i,f],["L",v+d+2*p,u+h]],n&&r.push(["M",t-h,f],["L",i+h,f])),this.outline[o]({d:r})},i.prototype.drawMasks=function(t,i,e,o){var s,r,n,a,h=this.left,l=this.top,p=this.height;e?(n=[h,h,h],a=[l,l+t,l+i],r=[p,p,p],s=[t,i-t,this.size-i]):(n=[h,h+t,h+i],a=[l,l,l],r=[t,i-t,this.size-i],s=[p,p,p]),this.shades.forEach(function(t,i){t[o]({x:n[i],y:a[i],width:r[i],height:s[i]})})},i.prototype.renderElements=function(){var t=this,i=t.navigatorOptions,e=i.maskInside,o=t.chart,s=o.inverted,r=o.renderer,n={cursor:s?"ns-resize":"ew-resize"},a=t.navigatorGroup=r.g("navigator").attr({zIndex:8,visibility:"hidden"}).add();if([!e,e,!e].forEach(function(e,s){var h=r.rect().addClass("highcharts-navigator-mask"+(1===s?"-inside":"-outside")).add(a);o.styledMode||(h.attr({fill:e?i.maskFill:"rgba(0,0,0,0)"}),1===s&&h.css(n)),t.shades[s]=h}),t.outline=r.path().addClass("highcharts-navigator-outline").add(a),o.styledMode||t.outline.attr({"stroke-width":i.outlineWidth,stroke:i.outlineColor}),i.handles&&i.handles.enabled){var h=i.handles,l=h.height,p=h.width;[0,1].forEach(function(i){t.handles[i]=r.symbol(h.symbols[i],-p/2-1,0,p,l,h),o.inverted&&t.handles[i].attr({rotation:90,rotationOriginX:Math.floor(-p/2),rotationOriginY:(l+p)/2}),t.handles[i].attr({zIndex:7-i}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][i]).add(a),o.styledMode||t.handles[i].attr({fill:h.backgroundColor,stroke:h.borderColor,"stroke-width":h.lineWidth}).css(n)})}},i.prototype.update=function(t){(this.series||[]).forEach(function(t){t.baseSeries&&delete t.baseSeries.navigatorSeries}),this.destroy(),M(!0,this.chart.options.navigator,t),this.init(this.chart)},i.prototype.render=function(t,i,e,o){var s,r,n,a,h,l=this.chart,p=this.xAxis,f=p.pointRange||0,g=p.navigatorAxis.fake?l.xAxis[0]:p,v=this.navigatorEnabled,x=this.rendered,y=l.inverted,M=l.xAxis[0].minRange,A=l.xAxis[0].options.maxRange,k=this.scrollButtonSize,C=this.scrollbarHeight;if(!this.hasDragged||c(e)){if(t=u(t-f/2),i=u(i+f/2),!b(t)||!b(i)){if(!x)return;e=0,o=S(p.width,g.width)}this.left=S(p.left,l.plotLeft+k+(y?l.plotWidth:0));var w=this.size=a=S(p.len,(y?l.plotHeight:l.plotWidth)-2*k);s=y?C:a+2*k,e=S(e,p.toPixels(t,!0)),o=S(o,p.toPixels(i,!0)),b(e)&&Math.abs(e)!==1/0||(e=0,o=s);var D=p.toValue(e,!0),O=p.toValue(o,!0),E=Math.abs(u(O-D));E<M?this.grabbedLeft?e=p.toPixels(O-M-f,!0):this.grabbedRight&&(o=p.toPixels(D+M+f,!0)):c(A)&&u(E-f)>A&&(this.grabbedLeft?e=p.toPixels(O-A-f,!0):this.grabbedRight&&(o=p.toPixels(D+A+f,!0))),this.zoomedMax=d(Math.max(e,o),0,w),this.zoomedMin=d(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(e,o),0,w),this.range=this.zoomedMax-this.zoomedMin,w=Math.round(this.zoomedMax);var T=Math.round(this.zoomedMin);v&&(this.navigatorGroup.attr({visibility:"inherit"}),h=x&&!this.hasDragged?"animate":"attr",this.drawMasks(T,w,y,h),this.drawOutline(T,w,y,h),this.navigatorOptions.handles.enabled&&(this.drawHandle(T,0,y,h),this.drawHandle(w,1,y,h))),this.scrollbar&&(y?(n=this.top-k,r=this.left-C+(v||!g.opposite?0:(g.titleOffset||0)+g.axisTitleMargin),C=a+2*k):(n=this.top+(v?this.height:-C),r=this.left-k),this.scrollbar.position(r,n,s,C),this.scrollbar.setRange(this.zoomedMin/(a||1),this.zoomedMax/(a||1))),this.rendered=!0,m(this,"afterRender")}},i.prototype.addMouseEvents=function(){var t,i,e=this,o=e.chart,s=o.container,r=[];e.mouseMoveHandler=t=function(t){e.onMouseMove(t)},e.mouseUpHandler=i=function(t){e.onMouseUp(t)},(r=e.getPartsEvents("mousedown")).push(p(o.renderTo,"mousemove",t),p(s.ownerDocument,"mouseup",i)),h&&(r.push(p(o.renderTo,"touchmove",t),p(s.ownerDocument,"touchend",i)),r.concat(e.getPartsEvents("touchstart"))),e.eventsToUnbind=r,e.series&&e.series[0]&&r.push(p(e.series[0].xAxis,"foundExtremes",function(){o.navigator.modifyNavigatorAxisExtremes()}))},i.prototype.getPartsEvents=function(t){var i=this,e=[];return["shades","handles"].forEach(function(o){i[o].forEach(function(s,r){e.push(p(s.element,t,function(t){i[o+"Mousedown"](t,r)}))})}),e},i.prototype.shadesMousedown=function(t,i){t=this.chart.pointer.normalize(t);var e,o,s,r,n=this.chart,a=this.xAxis,h=this.zoomedMin,l=this.size,p=this.range,d=this.left,u=t.chartX;n.inverted&&(u=t.chartY,d=this.top),1===i?(this.grabbedCenter=u,this.fixedWidth=p,this.dragOffset=u-h):(r=u-d-p/2,0===i?r=Math.max(0,r):2===i&&r+p>=l&&(r=l-p,this.reversedExtremes?(r-=p,o=this.getUnionExtremes().dataMin):e=this.getUnionExtremes().dataMax),r!==h&&(this.fixedWidth=p,c((s=a.navigatorAxis.toFixedRange(r,r+p,o,e)).min)&&n.xAxis[0].setExtremes(Math.min(s.min,s.max),Math.max(s.min,s.max),!0,null,{trigger:"navigator"})))},i.prototype.handlesMousedown=function(t,i){t=this.chart.pointer.normalize(t);var e=this.chart,o=e.xAxis[0],s=this.reversedExtremes;0===i?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=s?o.min:o.max):(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=s?o.max:o.min),e.fixedRange=null},i.prototype.onMouseMove=function(t){var i,e=this,o=e.chart,s=e.navigatorSize,r=e.range,n=e.dragOffset,a=o.inverted,h=e.left;(!t.touches||0!==t.touches[0].pageX)&&(i=(t=o.pointer.normalize(t)).chartX,a&&(h=e.top,i=t.chartY),e.grabbedLeft?(e.hasDragged=!0,e.render(0,0,i-h,e.otherHandlePos)):e.grabbedRight?(e.hasDragged=!0,e.render(0,0,e.otherHandlePos,i-h)):e.grabbedCenter&&(e.hasDragged=!0,i<n?i=n:i>s+n-r&&(i=s+n-r),e.render(0,0,i-n,i-n+r)),e.hasDragged&&e.scrollbar&&S(e.scrollbar.options.liveRedraw,!l&&!this.chart.boosted)&&(t.DOMType=t.type,setTimeout(function(){e.onMouseUp(t)},0)))},i.prototype.onMouseUp=function(t){var i,e,o,s,r,n,a=this.chart,h=this.xAxis,l=this.scrollbar,p=t.DOMEvent||t,d=a.inverted,u=this.rendered&&!this.hasDragged?"animate":"attr";(this.hasDragged&&(!l||!l.hasDragged)||"scrollbar"===t.trigger)&&(o=this.getUnionExtremes(),this.zoomedMin===this.otherHandlePos?s=this.fixedExtreme:this.zoomedMax===this.otherHandlePos&&(r=this.fixedExtreme),this.zoomedMax===this.size&&(r=this.reversedExtremes?o.dataMin:o.dataMax),0===this.zoomedMin&&(s=this.reversedExtremes?o.dataMax:o.dataMin),c((n=h.navigatorAxis.toFixedRange(this.zoomedMin,this.zoomedMax,s,r)).min)&&a.xAxis[0].setExtremes(Math.min(n.min,n.max),Math.max(n.min,n.max),!0,!this.hasDragged&&null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:p})),"mousemove"!==t.DOMType&&"touchmove"!==t.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=this.hasDragged=this.dragOffset=null),this.navigatorEnabled&&b(this.zoomedMin)&&b(this.zoomedMax)&&(e=Math.round(this.zoomedMin),i=Math.round(this.zoomedMax),this.shades&&this.drawMasks(e,i,d,u),this.outline&&this.drawOutline(e,i,d,u),this.navigatorOptions.handles.enabled&&Object.keys(this.handles).length===this.handles.length&&(this.drawHandle(e,0,d,u),this.drawHandle(i,1,d,u)))},i.prototype.removeEvents=function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(t){t()}),this.eventsToUnbind=void 0),this.removeBaseSeriesEvents()},i.prototype.removeBaseSeriesEvents=function(){var t=this.baseSeries||[];this.navigatorEnabled&&t[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&t.forEach(function(t){A(t,"updatedData",this.updatedDataHandler)},this),t[0].xAxis&&A(t[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},i.prototype.init=function(i){var e=i.options,s=e.navigator||{},n=s.enabled,a=e.scrollbar||{},h=a.enabled,l=n&&s.height||0,d=h&&a.height||0,u=a.buttonsEnabled&&d||0;this.handles=[],this.shades=[],this.chart=i,this.setBaseSeries(),this.height=l,this.scrollbarHeight=d,this.scrollButtonSize=u,this.scrollbarEnabled=h,this.navigatorEnabled=n,this.navigatorOptions=s,this.scrollbarOptions=a,this.opposite=S(s.opposite,!!(!n&&i.inverted));var c=this,f=c.baseSeries,g=i.xAxis.length,v=i.yAxis.length,x=f&&f[0]&&f[0].xAxis||i.xAxis[0]||{options:{}};if(i.isDirtyBox=!0,c.navigatorEnabled?(c.xAxis=new t(i,M({breaks:x.options.breaks,ordinal:x.options.ordinal},s.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",type:"datetime",index:g,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},i.inverted?{offsets:[u,0,-u,0],width:l}:{offsets:[0,-u,0,u],height:l}),"xAxis"),c.yAxis=new t(i,M(s.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:v,isInternal:!0,reversed:S(s.yAxis&&s.yAxis.reversed,i.yAxis[0]&&i.yAxis[0].reversed,!1),zoomEnabled:!1},i.inverted?{width:l}:{height:l}),"yAxis"),f||s.series.data?c.updateNavigatorSeries(!1):0===i.series.length&&(c.unbindRedraw=p(i,"beforeRedraw",function(){i.series.length>0&&!c.series&&(c.setBaseSeries(),c.unbindRedraw())})),c.reversedExtremes=i.inverted&&!c.xAxis.reversed||!i.inverted&&c.xAxis.reversed,c.renderElements(),c.addMouseEvents()):(c.xAxis={chart:i,navigatorAxis:{fake:!0},translate:function(t,e){var o=i.xAxis[0],s=o.getExtremes(),r=o.len-2*u,n=C("min",o.options.min,s.dataMin),a=C("max",o.options.max,s.dataMax)-n;return e?t*a/r+n:r*(t-n)/a},toPixels:function(t){return this.translate(t)},toValue:function(t){return this.translate(t,!0)}},c.xAxis.navigatorAxis.axis=c.xAxis,c.xAxis.navigatorAxis.toFixedRange=o.prototype.toFixedRange.bind(c.xAxis.navigatorAxis)),i.options.scrollbar.enabled){var m=M(i.options.scrollbar,{vertical:i.inverted});!b(m.margin)&&c.navigatorEnabled&&(m.margin=i.inverted?-3:3),i.scrollbar=c.scrollbar=new r(i.renderer,m,i),p(c.scrollbar,"changed",function(t){var i=c.size,e=i*this.to,o=i*this.from;c.hasDragged=c.scrollbar.hasDragged,c.render(0,0,o,e),this.shouldUpdateExtremes(t.DOMType)&&setTimeout(function(){c.onMouseUp(t)})})}c.addBaseSeriesEvents(),c.addChartEvents()},i.prototype.getUnionExtremes=function(t){var i,e=this.chart.xAxis[0],o=this.xAxis,s=o.options,r=e.options;return t&&null===e.dataMin||(i={dataMin:S(s&&s.min,C("min",r.min,e.dataMin,o.dataMin,o.min)),dataMax:S(s&&s.max,C("max",r.max,e.dataMax,o.dataMax,o.max))}),i},i.prototype.setBaseSeries=function(t,i){var e=this.chart,o=this.baseSeries=[];t=t||e.options&&e.options.navigator.baseSeries||(e.series.length?x(e.series,function(t){return!t.options.isInternal}).index:0),(e.series||[]).forEach(function(i,e){!i.options.isInternal&&(i.options.showInNavigator||(e===t||i.options.id===t)&&!1!==i.options.showInNavigator)&&o.push(i)}),this.xAxis&&!this.xAxis.navigatorAxis.fake&&this.updateNavigatorSeries(!0,i)},i.prototype.updateNavigatorSeries=function(t,i){var e,o,s,r=this,n=r.chart,h=r.baseSeries,l={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:void 0,isInternal:!0,states:{inactive:{opacity:1}}},p=r.series=(r.series||[]).filter(function(t){var i=t.baseSeries;return!(0>h.indexOf(i))||(i&&(A(i,"updatedData",r.updatedDataHandler),delete i.navigatorSeries),t.chart&&t.destroy(),!1)}),d=r.navigatorOptions.series;h&&h.length&&h.forEach(function(t){var u=t.navigatorSeries,c=v({color:t.color,visible:t.visible},y(d)?a.navigator.series:d);if(!u||!1!==r.navigatorOptions.adaptToUpdatedData){l.name="Navigator "+h.length,s=(e=t.options||{}).navigatorOptions||{},c.dataLabels=k(c.dataLabels),(o=M(e,l,c,s)).pointRange=S(c.pointRange,s.pointRange,a.plotOptions[o.type||"line"].pointRange);var f=s.data||c.data;r.hasNavigatorData=r.hasNavigatorData||!!f,o.data=f||e.data&&e.data.slice(0),u&&u.options?u.update(o,i):(t.navigatorSeries=n.initSeries(o),t.navigatorSeries.baseSeries=t,p.push(t.navigatorSeries))}}),(d.data&&!(h&&h.length)||y(d))&&(r.hasNavigatorData=!1,(d=k(d)).forEach(function(t,i){l.name="Navigator "+(p.length+1),(o=M(a.navigator.series,{color:n.series[i]&&!n.series[i].options.isInternal&&n.series[i].color||n.options.colors[i]||n.options.colors[0]},l,t)).data=t.data,o.data&&(r.hasNavigatorData=!0,p.push(n.initSeries(o)))})),t&&this.addBaseSeriesEvents()},i.prototype.addBaseSeriesEvents=function(){var t=this,i=this,e=i.baseSeries||[];e[0]&&e[0].xAxis&&e[0].eventsToUnbind.push(p(e[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes)),e.forEach(function(e){e.eventsToUnbind.push(p(e,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)})),e.eventsToUnbind.push(p(e,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)})),!1!==t.navigatorOptions.adaptToUpdatedData&&e.xAxis&&e.eventsToUnbind.push(p(e,"updatedData",t.updatedDataHandler)),e.eventsToUnbind.push(p(e,"remove",function(){this.navigatorSeries&&(g(i.series,this.navigatorSeries),c(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)}))})},i.prototype.getBaseSeriesMin=function(t){return this.baseSeries.reduce(function(t,i){return Math.min(t,i.xData&&i.xData.length?i.xData[0]:t)},t)},i.prototype.modifyNavigatorAxisExtremes=function(){var t=this.xAxis;if(void 0!==t.getExtremes){var i=this.getUnionExtremes(!0);i&&(i.dataMin!==t.min||i.dataMax!==t.max)&&(t.min=i.dataMin,t.max=i.dataMax)}},i.prototype.modifyBaseAxisExtremes=function(){var t,i,e=this.chart.navigator,o=this.getExtremes(),s=o.min,r=o.max,n=o.dataMin,a=o.dataMax,h=r-s,l=e.stickToMin,p=e.stickToMax,d=S(this.options.overscroll,0),u=e.series&&e.series[0],c=!!this.setExtremes;!(this.eventArgs&&"rangeSelectorButton"===this.eventArgs.trigger)&&(l&&(t=(i=n)+h),p&&(t=a+d,l||(i=Math.max(n,t-h,e.getBaseSeriesMin(u&&u.xData?u.xData[0]:-Number.MAX_VALUE)))),c&&(l||p)&&b(i)&&(this.min=this.userMin=i,this.max=this.userMax=t)),e.stickToMin=e.stickToMax=null},i.prototype.updatedDataHandler=function(){var t=this.chart.navigator,i=this.navigatorSeries,e=t.reversedExtremes?0===Math.round(t.zoomedMin):Math.round(t.zoomedMax)>=Math.round(t.size);t.stickToMax=S(this.chart.options.navigator&&this.chart.options.navigator.stickToMax,e),t.stickToMin=t.shouldStickToMin(this,t),i&&!t.hasNavigatorData&&(i.options.pointStart=this.xData[0],i.setData(this.options.data,!1,null,!1))},i.prototype.shouldStickToMin=function(t,i){var e=i.getBaseSeriesMin(t.xData[0]),o=t.xAxis,s=o.max,r=o.min,n=o.options.range;return!!(b(s)&&b(r))&&(n&&s-e>0?s-e<n:r<=e)},i.prototype.addChartEvents=function(){this.eventsToUnbind||(this.eventsToUnbind=[]),this.eventsToUnbind.push(p(this.chart,"redraw",function(){var t=this.navigator,i=t&&(t.baseSeries&&t.baseSeries[0]&&t.baseSeries[0].xAxis||this.xAxis[0]);i&&t.render(i.min,i.max)}),p(this.chart,"getMargins",function(){var t=this.navigator,i=t.opposite?"plotTop":"marginBottom";this.inverted&&(i=t.opposite?"marginRight":"plotLeft"),this[i]=(this[i]||0)+(t.navigatorEnabled||!this.inverted?t.height+t.scrollbarHeight:0)+t.navigatorOptions.margin}))},i.prototype.destroy=function(){var t=this;this.removeEvents(),this.xAxis&&(g(this.chart.xAxis,this.xAxis),g(this.chart.axes,this.xAxis)),this.yAxis&&(g(this.chart.yAxis,this.yAxis),g(this.chart.axes,this.yAxis)),(this.series||[]).forEach(function(t){t.destroy&&t.destroy()}),["series","xAxis","yAxis","shades","outline","scrollbarTrack","scrollbarRifles","scrollbarGroup","scrollbar","navigatorGroup","rendered"].forEach(function(i){t[i]&&t[i].destroy&&t[i].destroy(),t[i]=null}),[this.handles].forEach(function(t){f(t)})},i}()}),e(i,"Stock/RangeSelector/RangeSelectorDefaults.js",[],function(){return{lang:{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"",rangeSelectorTo:"→"},rangeSelector:{allButtonsEnabled:!1,buttons:void 0,buttonSpacing:5,dropdown:"responsive",enabled:void 0,verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputBoxBorderColor:"none",inputBoxHeight:17,inputBoxWidth:void 0,inputDateFormat:"%e %b %Y",inputDateParser:void 0,inputEditDateFormat:"%Y-%m-%d",inputEnabled:!0,inputPosition:{align:"right",x:0,y:0},inputSpacing:5,selected:void 0,buttonPosition:{align:"left",x:0,y:0},inputStyle:{color:"#334eff",cursor:"pointer",fontSize:"0.8em"},labelStyle:{color:"#666666",fontSize:"0.8em"}}}}),e(i,"Stock/RangeSelector/RangeSelectorComposition.js",[i["Core/Defaults.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Core/Utilities.js"]],function(t,i,e){var o,s=t.defaultOptions,r=t.setOptions,n=e.addEvent,a=e.defined,h=e.extend,l=e.find,p=e.isNumber,d=e.merge,u=e.pick,c=[],f=[];function g(){var t,i,e=this.range,o=e.type,s=this.max,r=this.chart.time,n=function(t,i){var e="year"===o?"FullYear":"Month",s=new r.Date(t),n=r.get(e,s);return r.set(e,s,n+i),n===r.get(e,s)&&r.set("Date",s,0),s.getTime()-t};p(e)?(t=s-e,i=e):e&&(t=s+n(s,-(e.count||1)),this.chart&&(this.chart.fixedRange=s-t));var a=u(this.dataMin,Number.MIN_VALUE);return p(t)||(t=a),t<=a&&(t=a,void 0===i&&(i=n(t,e.count)),this.newMax=Math.min(t+i,u(this.dataMax,Number.MAX_VALUE))),p(s)?!p(e)&&e&&e._offsetMin&&(t+=e._offsetMin):t=void 0,t}function v(){this.options.rangeSelector&&this.options.rangeSelector.enabled&&(this.rangeSelector=new o(this))}function x(){var t=this.axes,i=this.rangeSelector;if(i){p(i.deferredYTDClick)&&(i.clickButton(i.deferredYTDClick),delete i.deferredYTDClick),t.forEach(function(t){t.updateNames(),t.setScale()}),this.getAxisMargins(),i.render();var e=i.options.verticalAlign;i.options.floating||("bottom"===e?this.extraBottomMargin=!0:"middle"===e||(this.extraTopMargin=!0))}}function m(t){var i,e,o,s,r=t.rangeSelector,a=function(){r&&(i=t.xAxis[0].getExtremes(),e=t.legend,s=r&&r.options.verticalAlign,p(i.min)&&r.render(i.min,i.max),e.display&&"top"===s&&s===e.options.verticalAlign&&(o=d(t.spacingBox),"vertical"===e.options.layout?o.y=t.plotTop:o.y+=r.getHeight(),e.group.placed=!1,e.align(o)))};r&&(l(c,function(i){return i[0]===t})||c.push([t,[n(t.xAxis[0],"afterSetExtremes",function(t){r&&r.render(t.min,t.max)}),n(t,"redraw",a)]]),a())}function y(){for(var t=0,i=c.length;t<i;++t){var e=c[t];if(e[0]===this){e[1].forEach(function(t){return t()}),c.splice(t,1);return}}}function b(){var t=this.rangeSelector;if(t){var i=t.getHeight();this.extraTopMargin&&(this.plotTop+=i),this.extraBottomMargin&&(this.marginBottom+=i)}}function M(){var t=this.rangeSelector;if(t&&!t.options.floating){t.render();var i=t.options.verticalAlign;"bottom"===i?this.extraBottomMargin=!0:"middle"!==i&&(this.extraTopMargin=!0)}}function S(t){var i=t.options.rangeSelector,e=this.extraBottomMargin,s=this.extraTopMargin,r=this.rangeSelector;if(i&&i.enabled&&!a(r)&&this.options.rangeSelector&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=r=new o(this)),this.extraBottomMargin=!1,this.extraTopMargin=!1,r){m(this);var n=i&&i.verticalAlign||r.options&&r.options.verticalAlign;r.options.floating||("bottom"===n?this.extraBottomMargin=!0:"middle"===n||(this.extraTopMargin=!0)),(this.extraBottomMargin!==e||this.extraTopMargin!==s)&&(this.isDirtyBox=!0)}}return{compose:function(t,a,l){o=l,e.pushUnique(f,t)&&(t.prototype.minFromRange=g),e.pushUnique(f,a)&&(n(a,"afterGetContainer",v),n(a,"beforeRender",x),n(a,"destroy",y),n(a,"getMargins",b),n(a,"render",M),n(a,"update",S),a.prototype.callbacks.push(m)),e.pushUnique(f,r)&&(h(s,{rangeSelector:i.rangeSelector}),h(s.lang,i.lang))}}}),e(i,"Stock/RangeSelector/RangeSelector.js",[i["Core/Axis/Axis.js"],i["Core/Defaults.js"],i["Core/Globals.js"],i["Stock/RangeSelector/RangeSelectorComposition.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"]],function(t,i,e,o,s,r){var n=i.defaultOptions,a=r.addEvent,h=r.createElement,l=r.css,p=r.defined,d=r.destroyObjectProperties,u=r.discardElement,c=r.extend,f=r.fireEvent,g=r.isNumber,v=r.merge,x=r.objectEach,m=r.pad,y=r.pick,b=r.pInt,M=r.splat,S=function(){function i(t){this.buttons=void 0,this.buttonOptions=i.prototype.defaultButtons,this.initialButtonGroupWidth=0,this.options=void 0,this.chart=t,this.init(t)}return i.compose=function(t,e){o.compose(t,e,i)},i.prototype.clickButton=function(i,e){var o,s,r,n,h,l,d,u=this.chart,c=this.buttonOptions[i],v=u.xAxis[0],x=u.scroller&&u.scroller.getUnionExtremes()||v||{},m=c.type,b=c.dataGrouping,S=x.dataMin,A=x.dataMax,k=v&&Math.round(Math.min(v.max,y(A,v.max))),C=c._range,w=!0;if(null!==S&&null!==A){if(u.fixedRange=C,this.setSelected(i),b&&(this.forcedDataGrouping=!0,t.prototype.setDataGrouping.call(v||{chart:this.chart},b,!1),this.frozenStates=c.preserveDataGrouping),"month"===m||"year"===m)v?(l={range:c,max:k,chart:u,dataMin:S,dataMax:A},o=v.minFromRange.call(l),g(l.newMax)&&(k=l.newMax),w=!1):C=c;else if(C)k=Math.min((o=Math.max(k-C,S))+C,A),w=!1;else if("ytd"===m){if(v)(void 0===A||void 0===S)&&(S=Number.MAX_VALUE,A=Number.MIN_VALUE,u.series.forEach(function(t){var i=t.xData;i&&(S=Math.min(i[0],S),A=Math.max(i[i.length-1],A))}),e=!1),o=r=(d=this.getYTDExtremes(A,S,u.time.useUTC)).min,k=d.max;else{this.deferredYTDClick=i;return}}else"all"===m&&v&&(u.navigator&&u.navigator.baseSeries[0]&&(u.navigator.baseSeries[0].xAxis.options.range=void 0),o=S,k=A);w&&c._offsetMin&&p(o)&&(o+=c._offsetMin),c._offsetMax&&p(k)&&(k+=c._offsetMax),this.dropdown&&(this.dropdown.selectedIndex=i+1),v?v.setExtremes(o,k,y(e,!0),void 0,{trigger:"rangeSelectorButton",rangeSelectorButton:c}):(h=(s=M(u.options.xAxis)[0]).range,s.range=C,n=s.min,s.min=r,a(u,"load",function(){s.range=h,s.min=n})),f(this,"afterBtnClick")}},i.prototype.setSelected=function(t){this.selected=this.options.selected=t},i.prototype.init=function(t){var i=this,e=t.options.rangeSelector,o=e.buttons||i.defaultButtons.slice(),s=e.selected,r=function(){var t=i.minInput,e=i.maxInput;t&&t.blur&&f(t,"blur"),e&&e.blur&&f(e,"blur")};i.chart=t,i.options=e,i.buttons=[],i.buttonOptions=o,this.eventsToUnbind=[],this.eventsToUnbind.push(a(t.container,"mousedown",r)),this.eventsToUnbind.push(a(t,"resize",r)),o.forEach(i.computeButtonRange),void 0!==s&&o[s]&&this.clickButton(s,!1),this.eventsToUnbind.push(a(t,"load",function(){t.xAxis&&t.xAxis[0]&&a(t.xAxis[0],"setExtremes",function(e){this.max-this.min!==t.fixedRange&&"rangeSelectorButton"!==e.trigger&&"updatedData"!==e.trigger&&i.forcedDataGrouping&&!i.frozenStates&&this.setDataGrouping(!1,!1)})}))},i.prototype.updateButtonStates=function(){var t=this,i=this.chart,e=this.dropdown,o=i.xAxis[0],s=Math.round(o.max-o.min),r=!o.hasVisibleSeries,n=24*36e5,a=i.scroller&&i.scroller.getUnionExtremes()||o,h=a.dataMin,l=a.dataMax,p=t.getYTDExtremes(l,h,i.time.useUTC),d=p.min,u=p.max,c=t.selected,f=t.options.allButtonsEnabled,v=t.buttons,x=g(c);t.buttonOptions.forEach(function(i,a){var p=i._range,g=i.type,m=i.count||1,y=v[a],b=i._offsetMax-i._offsetMin,M=a===c,S=p>l-h,A=p<o.minRange,k=0,C=!1,w=!1,D=p===s;("month"===g||"year"===g)&&s+36e5>=({month:28,year:365})[g]*n*m-b&&s-36e5<=({month:31,year:366})[g]*n*m+b?D=!0:"ytd"===g?(D=u-d+b===s,C=!M):"all"===g&&(D=o.max-o.min>=l-h,w=!M&&x&&D);var O=!f&&(S||A||w||r),E=M&&D||D&&!x&&!C||M&&t.frozenStates;O?k=3:E&&(x=!0,k=2),y.state!==k&&(y.setState(k),e&&(e.options[a+1].disabled=O,2===k&&(e.selectedIndex=a+1)),0===k&&c===a&&t.setSelected())})},i.prototype.computeButtonRange=function(t){var i=t.type,e=t.count||1,o={millisecond:1,second:1e3,minute:6e4,hour:36e5,day:864e5,week:6048e5};o[i]?t._range=o[i]*e:("month"===i||"year"===i)&&(t._range=24*({month:30,year:365})[i]*36e5*e),t._offsetMin=y(t.offsetMin,0),t._offsetMax=y(t.offsetMax,0),t._range+=t._offsetMax-t._offsetMin},i.prototype.getInputValue=function(t){var i="min"===t?this.minInput:this.maxInput,e=this.chart.options.rangeSelector,o=this.chart.time;return i?("text"===i.type&&e.inputDateParser||this.defaultInputDateParser)(i.value,o.useUTC,o):0},i.prototype.setInputValue=function(t,i){var e=this.options,o=this.chart.time,s="min"===t?this.minInput:this.maxInput,r="min"===t?this.minDateBox:this.maxDateBox;if(s){var n=s.getAttribute("data-hc-time"),a=p(n)?Number(n):void 0;if(p(i)){var h=a;p(h)&&s.setAttribute("data-hc-time-previous",h),s.setAttribute("data-hc-time",i),a=i}s.value=o.dateFormat(this.inputTypeFormats[s.type]||e.inputEditDateFormat,a),r&&r.attr({text:o.dateFormat(e.inputDateFormat,a)})}},i.prototype.setInputExtremes=function(t,i,e){var o="min"===t?this.minInput:this.maxInput;if(o){var s=this.inputTypeFormats[o.type],r=this.chart.time;if(s){var n=r.dateFormat(s,i);o.min!==n&&(o.min=n);var a=r.dateFormat(s,e);o.max!==a&&(o.max=a)}}},i.prototype.showInput=function(t){var i="min"===t?this.minDateBox:this.maxDateBox,e="min"===t?this.minInput:this.maxInput;if(e&&i&&this.inputGroup){var o="text"===e.type,s=this.inputGroup,r=s.translateX,n=void 0===r?0:r,a=s.translateY,h=void 0===a?0:a,p=i.x,d=void 0===p?0:p,u=i.width,c=void 0===u?0:u,f=i.height,g=void 0===f?0:f,v=this.options.inputBoxWidth;l(e,{width:o?c+(v?-2:20)+"px":"auto",height:g-2+"px",border:"2px solid silver"}),o&&v?l(e,{left:n+d+"px",top:h+"px"}):l(e,{left:Math.min(Math.round(d+n-(e.offsetWidth-c)/2),this.chart.chartWidth-e.offsetWidth)+"px",top:h-(e.offsetHeight-g)/2+"px"})}},i.prototype.hideInput=function(t){var i="min"===t?this.minInput:this.maxInput;i&&l(i,{top:"-9999em",border:0,width:"1px",height:"1px"})},i.prototype.defaultInputDateParser=function(t,i,o){var s,r=t.split("/").join("-").split(" ").join("T");if(-1===r.indexOf("T")&&(r+="T00:00"),i)r+="Z";else if(e.isSafari&&!((s=r).length>6&&(s.lastIndexOf("-")===s.length-6||s.lastIndexOf("+")===s.length-6))){var n=new Date(r).getTimezoneOffset()/60;r+=n<=0?"+".concat(m(-n),":00"):"-".concat(m(n),":00")}var a=Date.parse(r);if(!g(a)){var h=t.split("-");a=Date.UTC(b(h[0]),b(h[1])-1,b(h[2]))}return o&&i&&g(a)&&(a+=o.getTimezoneOffset(a)),a},i.prototype.drawInput=function(t){var i=this.chart,o=this.div,s=this.inputGroup,r=this,a=i.renderer.style||{},p=i.renderer,d=i.options.rangeSelector,u=n.lang,f="min"===t;function x(){var e=r.maxInput,o=r.minInput,s=i.xAxis[0],n=i.scroller&&i.scroller.getUnionExtremes()||s,a=n.dataMin,h=n.dataMax,l=r.getInputValue(t);l!==Number(M.getAttribute("data-hc-time-previous"))&&g(l)&&(M.setAttribute("data-hc-time-previous",l),f&&e&&g(a)?l>Number(e.getAttribute("data-hc-time"))?l=void 0:l<a&&(l=a):o&&g(h)&&(l<Number(o.getAttribute("data-hc-time"))?l=void 0:l>h&&(l=h)),void 0!==l&&s.setExtremes(f?l:s.min,f?s.max:l,void 0,void 0,{trigger:"rangeSelectorInput"}))}var m=u[f?"rangeSelectorFrom":"rangeSelectorTo"]||"",y=p.label(m,0).addClass("highcharts-range-label").attr({padding:m?2:0,height:m?d.inputBoxHeight:0}).add(s),b=p.label("",0).addClass("highcharts-range-input").attr({padding:2,width:d.inputBoxWidth,height:d.inputBoxHeight,"text-align":"center"}).on("click",function(){r.showInput(t),r[t+"Input"].focus()});i.styledMode||b.attr({stroke:d.inputBoxBorderColor,"stroke-width":1}),b.add(s);var M=h("input",{name:t,className:"highcharts-range-selector"},void 0,o);M.setAttribute("type",function(t){if(-1!==t.indexOf("%L"))return"text";var i=["a","A","d","e","w","b","B","m","o","y","Y"].some(function(i){return -1!==t.indexOf("%"+i)}),e=["H","k","I","l","M","S"].some(function(i){return -1!==t.indexOf("%"+i)});return i&&e?"datetime-local":i?"date":e?"time":"text"}(d.inputDateFormat||"%e %b %Y")),i.styledMode||(y.css(v(a,d.labelStyle)),b.css(v({color:"#333333"},a,d.inputStyle)),l(M,c({position:"absolute",border:0,boxShadow:"0 0 15px rgba(0,0,0,0.3)",width:"1px",height:"1px",padding:0,textAlign:"center",fontSize:a.fontSize,fontFamily:a.fontFamily,top:"-9999em"},d.inputStyle))),M.onfocus=function(){r.showInput(t)},M.onblur=function(){M===e.doc.activeElement&&x(),r.hideInput(t),r.setInputValue(t),M.blur()};var S=!1;return M.onchange=function(){S||(x(),r.hideInput(t),M.blur())},M.onkeypress=function(t){13===t.keyCode&&x()},M.onkeydown=function(t){S=!0,(38===t.keyCode||40===t.keyCode)&&x()},M.onkeyup=function(){S=!1},{dateBox:b,input:M,label:y}},i.prototype.getPosition=function(){var t=this.chart,i=t.options.rangeSelector,e="top"===i.verticalAlign?t.plotTop-t.axisOffset[0]:0;return{buttonTop:e+i.buttonPosition.y,inputTop:e+i.inputPosition.y-10}},i.prototype.getYTDExtremes=function(t,i,e){var o=this.chart.time,s=new o.Date(t),r=o.get("FullYear",s),n=e?o.Date.UTC(r,0,1):+new o.Date(r,0,1),a=s.getTime();return{max:Math.min(t||a,a),min:Math.max(i,n)}},i.prototype.render=function(t,i){var e=this.chart,o=e.renderer,s=e.container,r=e.options,n=r.rangeSelector,a=y(r.chart.style&&r.chart.style.zIndex,0)+1,l=n.inputEnabled,d=this.rendered;if(!1!==n.enabled){if(!d&&(this.group=o.g("range-selector-group").attr({zIndex:7}).add(),this.div=h("div",void 0,{position:"relative",height:0,zIndex:a}),this.buttonOptions.length&&this.renderButtons(),s.parentNode&&s.parentNode.insertBefore(this.div,s),l)){this.inputGroup=o.g("input-group").add(this.group);var u=this.drawInput("min");this.minDateBox=u.dateBox,this.minLabel=u.label,this.minInput=u.input;var c=this.drawInput("max");this.maxDateBox=c.dateBox,this.maxLabel=c.label,this.maxInput=c.input}if(l){this.setInputValue("min",t),this.setInputValue("max",i);var f=e.scroller&&e.scroller.getUnionExtremes()||e.xAxis[0]||{};if(p(f.dataMin)&&p(f.dataMax)){var g=e.xAxis[0].minRange||0;this.setInputExtremes("min",f.dataMin,Math.min(f.dataMax,this.getInputValue("max"))-g),this.setInputExtremes("max",Math.max(f.dataMin,this.getInputValue("min"))+g,f.dataMax)}if(this.inputGroup){var v=0;[this.minLabel,this.minDateBox,this.maxLabel,this.maxDateBox].forEach(function(t){if(t){var i=t.getBBox().width;i&&(t.attr({x:v}),v+=i+n.inputSpacing)}})}}this.alignElements(),this.rendered=!0}},i.prototype.renderButtons=function(){var t=this,i=this.buttons,o=this.chart,s=this.options,r=n.lang,l=o.renderer,p=v(s.buttonTheme),d=p&&p.states,u=p.width||28;delete p.width,delete p.states,this.buttonGroup=l.g("range-selector-buttons").add(this.group);var c=this.dropdown=h("select",void 0,{position:"absolute",width:"1px",height:"1px",padding:0,border:0,top:"-9999em",cursor:"pointer",opacity:1e-4},this.div);a(c,"touchstart",function(){c.style.fontSize="16px"}),[[e.isMS?"mouseover":"mouseenter"],[e.isMS?"mouseout":"mouseleave"],["change","click"]].forEach(function(e){var o=e[0],s=e[1];a(c,o,function(){var e=i[t.currentButtonIndex()];e&&f(e.element,s||o)})}),this.zoomText=l.label(r&&r.rangeSelectorZoom||"",0).attr({padding:s.buttonTheme.padding,height:s.buttonTheme.height,paddingLeft:0,paddingRight:0}).add(this.buttonGroup),this.chart.styledMode||(this.zoomText.css(s.labelStyle),p["stroke-width"]=y(p["stroke-width"],0)),h("option",{textContent:this.zoomText.textStr,disabled:!0},void 0,c),this.buttonOptions.forEach(function(e,o){h("option",{textContent:e.title||e.text},void 0,c),i[o]=l.button(e.text,0,0,function(i){var s,r=e.events&&e.events.click;r&&(s=r.call(e,i)),!1!==s&&t.clickButton(o),t.isActive=!0},p,d&&d.hover,d&&d.select,d&&d.disabled).attr({"text-align":"center",width:u}).add(t.buttonGroup),e.title&&i[o].attr("title",e.title)})},i.prototype.alignElements=function(){var t=this,i=this.buttonGroup,e=this.buttons,o=this.chart,s=this.group,r=this.inputGroup,n=this.options,a=this.zoomText,h=o.options,l=h.exporting&&!1!==h.exporting.enabled&&h.navigation&&h.navigation.buttonOptions,p=n.buttonPosition,d=n.inputPosition,u=n.verticalAlign,c=function(i,e){return l&&t.titleCollision(o)&&"top"===u&&"right"===e.align&&e.y-i.getBBox().height-12<(l.y||0)+(l.height||0)+o.spacing[0]?-40:0},f=o.plotLeft;if(s&&p&&d){var g=p.x-o.spacing[3];if(i){if(this.positionButtons(),!this.initialButtonGroupWidth){var v=0;a&&(v+=a.getBBox().width+5),e.forEach(function(t,i){v+=t.width||0,i!==e.length-1&&(v+=n.buttonSpacing)}),this.initialButtonGroupWidth=v}f-=o.spacing[3],this.updateButtonStates();var x=c(i,p);this.alignButtonGroup(x),s.placed=i.placed=o.hasLoaded}var m=0;r&&(m=c(r,d),"left"===d.align?g=f:"right"===d.align&&(g=-Math.max(o.axisOffset[1],-m)),r.align({y:d.y,width:r.getBBox().width,align:d.align,x:d.x+g-2},!0,o.spacingBox),r.placed=o.hasLoaded),this.handleCollision(m),s.align({verticalAlign:u},!0,o.spacingBox);var b=s.alignAttr.translateY,M=s.getBBox().height+20,S=0;if("bottom"===u){var A=o.legend&&o.legend.options;S=b-(M=M+(A&&"bottom"===A.verticalAlign&&A.enabled&&!A.floating?o.legend.legendHeight+y(A.margin,10):0)-20)-(n.floating?0:n.y)-(o.titleOffset?o.titleOffset[2]:0)-10}"top"===u?(n.floating&&(S=0),o.titleOffset&&o.titleOffset[0]&&(S=o.titleOffset[0]),S+=o.margin[0]-o.spacing[0]||0):"middle"===u&&(d.y===p.y?S=b:(d.y||p.y)&&(d.y<0||p.y<0?S-=Math.min(d.y,p.y):S=b-M)),s.translate(n.x,n.y+Math.floor(S));var k=this.minInput,C=this.maxInput,w=this.dropdown;n.inputEnabled&&k&&C&&(k.style.marginTop=s.translateY+"px",C.style.marginTop=s.translateY+"px"),w&&(w.style.marginTop=s.translateY+"px")}},i.prototype.alignButtonGroup=function(t,i){var e=this.chart,o=this.options,s=this.buttonGroup;this.buttons;var r=o.buttonPosition,n=e.plotLeft-e.spacing[3],a=r.x-e.spacing[3];"right"===r.align?a+=t-n:"center"===r.align&&(a-=n/2),s&&s.align({y:r.y,width:y(i,this.initialButtonGroupWidth),align:r.align,x:a},!0,e.spacingBox)},i.prototype.positionButtons=function(){var t=this.buttons,i=this.chart,e=this.options,o=this.zoomText,s=i.hasLoaded?"animate":"attr",r=e.buttonPosition,n=i.plotLeft,a=n;o&&"hidden"!==o.visibility&&(o[s]({x:y(n+r.x,n)}),a+=r.x+o.getBBox().width+5);for(var h=0,l=this.buttonOptions.length;h<l;++h)"hidden"!==t[h].visibility?(t[h][s]({x:a}),a+=(t[h].width||0)+e.buttonSpacing):t[h][s]({x:n})},i.prototype.handleCollision=function(t){var i=this,e=this.chart,o=this.buttonGroup,s=this.inputGroup,r=this.options,n=r.buttonPosition,a=r.dropdown,h=r.inputPosition,l=function(){var t=0;return i.buttons.forEach(function(i){var e=i.getBBox();e.width>t&&(t=e.width)}),t},p=function(i){if(s&&o){var e=s.alignAttr.translateX+s.alignOptions.x-t+s.getBBox().x+2,r=s.alignOptions.width,a=o.alignAttr.translateX+o.getBBox().x;return a+i>e&&e+r>a&&n.y<h.y+s.getBBox().height}return!1},d=function(){s&&o&&s.attr({translateX:s.alignAttr.translateX+(e.axisOffset[1]>=-t?0:-t),translateY:s.alignAttr.translateY+o.getBBox().height+10})};if(o){if("always"===a){this.collapseButtons(t),p(l())&&d();return}"never"===a&&this.expandButtons()}s&&o?h.align===n.align||p(this.initialButtonGroupWidth+20)?"responsive"===a?(this.collapseButtons(t),p(l())&&d()):d():"responsive"===a&&this.expandButtons():o&&"responsive"===a&&(this.initialButtonGroupWidth>e.plotWidth?this.collapseButtons(t):this.expandButtons())},i.prototype.collapseButtons=function(t){var i=this.buttons,e=this.buttonOptions,o=this.chart,s=this.dropdown,r=this.options,n=this.zoomText,a=o.userOptions.rangeSelector&&o.userOptions.rangeSelector.buttonTheme||{},h=function(t){return{text:t?"".concat(t," ▾"):"▾",width:"auto",paddingLeft:y(r.buttonTheme.paddingLeft,a.padding,8),paddingRight:y(r.buttonTheme.paddingRight,a.padding,8)}};n&&n.hide();var l=!1;e.forEach(function(t,e){var o=i[e];2!==o.state?o.hide():(o.show(),o.attr(h(t.text)),l=!0)}),l||(s&&(s.selectedIndex=0),i[0].show(),i[0].attr(h(this.zoomText&&this.zoomText.textStr)));var p=r.buttonPosition.align;this.positionButtons(),("right"===p||"center"===p)&&this.alignButtonGroup(t,i[this.currentButtonIndex()].getBBox().width),this.showDropdown()},i.prototype.expandButtons=function(){var t=this.buttons,i=this.buttonOptions,e=this.options,o=this.zoomText;this.hideDropdown(),o&&o.show(),i.forEach(function(i,o){var s=t[o];s.show(),s.attr({text:i.text,width:e.buttonTheme.width||28,paddingLeft:y(e.buttonTheme.paddingLeft,"unset"),paddingRight:y(e.buttonTheme.paddingRight,"unset")}),s.state<2&&s.setState(0)}),this.positionButtons()},i.prototype.currentButtonIndex=function(){var t=this.dropdown;return t&&t.selectedIndex>0?t.selectedIndex-1:0},i.prototype.showDropdown=function(){var t=this.buttonGroup,i=this.buttons,e=this.chart,o=this.dropdown;if(t&&o){var s=t.translateX,r=t.translateY,n=i[this.currentButtonIndex()].getBBox();l(o,{left:e.plotLeft+(void 0===s?0:s)+"px",top:(void 0===r?0:r)+.5+"px",width:n.width+"px",height:n.height+"px"}),this.hasVisibleDropdown=!0}},i.prototype.hideDropdown=function(){var t=this.dropdown;t&&(l(t,{top:"-9999em",width:"1px",height:"1px"}),this.hasVisibleDropdown=!1)},i.prototype.getHeight=function(){var t=this.options,i=this.group,e=t.inputPosition,o=t.buttonPosition,s=t.y,r=o.y,n=e.y,a=0;return t.height?t.height:(this.alignElements(),a=i?i.getBBox(!0).height+13+s:0,(n<0&&r<0||n>0&&r>0)&&(a+=Math.abs(Math.min(n,r))),a)},i.prototype.titleCollision=function(t){return!(t.options.title.text||t.options.subtitle.text)},i.prototype.update=function(t){var i=this.chart;v(!0,i.options.rangeSelector,t),this.destroy(),this.init(i),this.render()},i.prototype.destroy=function(){var t=this,e=t.minInput,o=t.maxInput;t.eventsToUnbind&&(t.eventsToUnbind.forEach(function(t){return t()}),t.eventsToUnbind=void 0),d(t.buttons),e&&(e.onfocus=e.onblur=e.onchange=null),o&&(o.onfocus=o.onblur=o.onchange=null),x(t,function(e,o){e&&"chart"!==o&&(e instanceof s?e.destroy():e instanceof window.HTMLElement&&u(e)),e!==i.prototype[o]&&(t[o]=null)},this)},i}();return c(S.prototype,{defaultButtons:[{type:"month",count:1,text:"1m",title:"View 1 month"},{type:"month",count:3,text:"3m",title:"View 3 months"},{type:"month",count:6,text:"6m",title:"View 6 months"},{type:"ytd",text:"YTD",title:"View year to date"},{type:"year",count:1,text:"1y",title:"View 1 year"},{type:"all",text:"All",title:"View all"}],inputTypeFormats:{"datetime-local":"%Y-%m-%dT%H:%M:%S",date:"%Y-%m-%d",time:"%H:%M:%S"}}),S}),e(i,"Core/Axis/OrdinalAxis.js",[i["Core/Axis/Axis.js"],i["Core/Globals.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e,o){var s,r=o.addEvent,n=o.correctFloat,a=o.css,h=o.defined,l=o.error,p=o.pick,d=o.timeUnits,u=[];return function(t){function s(t,i,e,o,s,r,n){void 0===s&&(s=[]),void 0===r&&(r=0);var a,p,u,c,f,g={},v=this.options.tickPixelInterval,x=this.chart.time,m=[],y=0,b=[],M=-Number.MAX_VALUE;if(!this.options.ordinal&&!this.options.breaks||!s||s.length<3||void 0===i)return x.getTimeTicks.apply(x,arguments);var S=s.length;for(a=0;a<S;a++){if(f=a&&s[a-1]>e,s[a]<i&&(y=a),a===S-1||s[a+1]-s[a]>5*r||f){if(s[a]>M){for(p=x.getTimeTicks(t,s[y],s[a],o);p.length&&p[0]<=M;)p.shift();p.length&&(M=p[p.length-1]),m.push(b.length),b=b.concat(p)}y=a+1}if(f)break}if(p){if(c=p.info,n&&c.unitRange<=d.hour){for(y=1,a=b.length-1;y<a;y++)x.dateFormat("%d",b[y])!==x.dateFormat("%d",b[y-1])&&(g[b[y]]="day",u=!0);u&&(g[b[0]]="day"),c.higherRanks=g}c.segmentStarts=m,b.info=c}else l(12,!1,this.chart);if(n&&h(v)){for(var A=b.length,k=[],C=[],w=void 0,D=void 0,O=void 0,E=void 0,T=void 0,P=A;P--;)D=this.translate(b[P]),O&&(C[P]=O-D),k[P]=O=D;for(C.sort(),(E=C[Math.floor(C.length/2)])<.6*v&&(E=null),P=b[A-1]>e?A-1:A,O=void 0;P--;)T=Math.abs(O-(D=k[P])),O&&T<.8*v&&(null===E||T<.8*E)?(g[b[P]]&&!g[b[P+1]]?(w=P+1,O=D):w=P,b.splice(w,1)):O=D}return b}function c(t){var i=this.ordinal.positions;if(!i)return t;var e,o=i.length-1;return(t<0?t=i[0]:t>o?t=i[o]:(o=Math.floor(t),e=t-o),void 0!==e&&void 0!==i[o])?i[o]+(e?e*(i[o+1]-i[o]):0):t}function f(t){var i=this.ordinal,e=this.old?this.old.min:this.min,o=this.old?this.old.transA:this.transA,s=i.positions;if(!s)return t;var r=n((t-e)*o+this.minPixelPadding);if(t>=s[0]&&t<=s[s.length-1]||(s=i.getExtendedPositions()),s&&s.length){var a=s.indexOf(t),h=-1!==a?a:n(i.getIndexOfPoint(r,s)),l=n(h%1);if(h>=0&&h<=s.length-1){var p=s[Math.floor(h)],d=s[Math.ceil(h)];return s[Math.floor(h)]+l*(d-p)}}return t}function g(i,e){var o=t.Additions.findIndexOf(i,e,!0);if(i[o]===e)return o;var s=(e-i[o])/(i[o+1]-i[o]);return o+s}function v(){this.ordinal||(this.ordinal=new t.Additions(this))}function x(){this.isXAxis&&h(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&h(this.userMin)&&(this.min+=this.options.overscroll))}function m(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)}function y(){this.ordinal&&(this.ordinal.beforeSetTickPositions(),this.tickInterval=this.ordinal.postProcessTickInterval(this.tickInterval))}function b(t){var i=this.xAxis[0],e=i.options.overscroll,o=t.originalEvent.chartX,s=this.options.chart.panning,r=!1;if(s&&"y"!==s.type&&i.options.ordinal&&i.series.length){var n=this.mouseDownX,h=i.getExtremes(),l=h.dataMax,p=h.min,d=h.max,u=this.hoverPoints,c=i.closestPointRange||i.ordinal&&i.ordinal.overscrollPointsRange,f=Math.round((n-o)/(i.translationSlope*(i.ordinal.slope||c))),g=i.ordinal.getExtendedPositions(),v={ordinal:{positions:g,extendedOrdinalPositions:g}},x=i.index2val,m=i.val2lin,y=void 0,b=void 0,M=void 0,S=void 0;v.ordinal.positions?Math.abs(f)>1&&(u&&u.forEach(function(t){t.setState()}),f<0?(M=v,S=i.ordinal.positions?i:v):(M=i.ordinal.positions?i:v,S=v),l>(b=S.ordinal.positions)[b.length-1]&&b.push(l),this.fixedRange=d-p,(y=i.navigatorAxis.toFixedRange(void 0,void 0,x.apply(M,[m.apply(M,[p,!0])+f]),x.apply(S,[m.apply(S,[d,!0])+f]))).min>=Math.min(h.dataMin,p)&&y.max<=Math.max(l,d)+e&&i.setExtremes(y.min,y.max,!0,!1,{trigger:"pan"}),this.mouseDownX=o,a(this.container,{cursor:"move"})):r=!0}else r=!0;r||s&&/y/.test(s.type)?e&&(i.max=i.dataMax+e):t.preventDefault()}function M(){var t=this.xAxis;t&&t.options.ordinal&&delete t.ordinal.index}function S(t,i){var e,o,s=this.ordinal,r=s.positions,n=s.slope;if(!r)return t;var a=r.length;if(r[0]<=t&&r[a-1]>=t)e=g(r,t);else{if(!((o=s.getExtendedPositions&&s.getExtendedPositions())&&o.length))return t;var h=o.length;n||(n=(o[h-1]-o[0])/h);var l=g(o,r[0]);if(t>=o[0]&&t<=o[h-1])e=g(o,t)-l;else{if(!i)return t;if(t<o[0]){var p=o[0]-t,d=p/n;e=-l-d}else{var p=t-o[h-1],d=p/n;e=d+h-l}}}return i?e:n*(e||0)+s.offset}t.compose=function(t,i,e){if(o.pushUnique(u,t)){var n=t.prototype;n.getTimeTicks=s,n.index2val=c,n.lin2val=f,n.val2lin=S,n.ordinal2lin=n.val2lin,r(t,"afterInit",v),r(t,"foundExtremes",x),r(t,"afterSetScale",m),r(t,"initialAxisTranslation",y)}return o.pushUnique(u,e)&&r(e,"pan",b),o.pushUnique(u,i)&&r(i,"updatedData",M),t};var A=function(){function t(t){this.index={},this.axis=t}return t.prototype.beforeSetTickPositions=function(){var t,i,e,o,s,r,n,a,h=this.axis,l=h.ordinal,d=h.getExtremes(),u=d.min,c=d.max,f=null===(t=h.brokenAxis)||void 0===t?void 0:t.hasBreaks,g=h.options.ordinal,v=[],x=Number.MAX_VALUE,m=!1,y=!1,b=!1;if(g||f){var M=0;if(h.series.forEach(function(t,o){if(e=[],o>0&&"highcharts-navigator-series"!==t.options.id&&t.processedXData.length>1&&(y=M!==t.processedXData[1]-t.processedXData[0]),M=t.processedXData[1]-t.processedXData[0],t.boosted&&(b=t.boosted),t.reserveSpace()&&(!1!==t.takeOrdinalPosition||f)&&(i=(v=v.concat(t.processedXData)).length,v.sort(function(t,i){return t-i}),x=Math.min(x,p(t.closestPointRange,x)),i)){for(o=0;o<i-1;)v[o]!==v[o+1]&&e.push(v[o+1]),o++;e[0]!==v[0]&&e.unshift(v[0]),v=e}}),y&&b&&(v.pop(),v.shift()),(i=v.length)>2){for(o=v[1]-v[0],a=i-1;a--&&!m;)v[a+1]-v[a]!==o&&(m=!0);!h.options.keepOrdinalPadding&&(v[0]-u>o||c-v[v.length-1]>o)&&(m=!0)}else h.options.overscroll&&(2===i?x=v[1]-v[0]:1===i?(x=h.options.overscroll,v=[v[0],v[0]+x]):x=l.overscrollPointsRange);m||h.forceOrdinal?(h.options.overscroll&&(l.overscrollPointsRange=x,v=v.concat(l.getOverscrollPositions())),l.positions=v,s=h.ordinal2lin(Math.max(u,v[0]),!0),r=Math.max(h.ordinal2lin(Math.min(c,v[v.length-1]),!0),1),l.slope=n=(c-u)/(r-s),l.offset=u-s*n):(l.overscrollPointsRange=p(h.closestPointRange,l.overscrollPointsRange),l.positions=h.ordinal.slope=l.offset=void 0)}h.isOrdinal=g&&m,l.groupIntervalFactor=null},t.findIndexOf=function(t,i,e){for(var o,s=0,r=t.length-1;s<r;)t[o=Math.ceil((s+r)/2)]<=i?s=o:r=o-1;return t[s]===i?s:e?s:-1},t.prototype.getExtendedPositions=function(){var t,o=this,s=o.axis,r=s.constructor.prototype,n=s.chart,a=s.series[0].currentDataGrouping,h=a?a.count+a.unitName:"raw",l=s.options.overscroll,p=s.getExtremes(),d=void 0,u=o.index;return u||(u=o.index={}),u[h]||((t={series:[],chart:n,forceOrdinal:!1,getExtremes:function(){return{min:p.dataMin,max:p.dataMax+l}},applyGrouping:r.applyGrouping,getGroupPixelWidth:r.getGroupPixelWidth,getTimeTicks:r.getTimeTicks,options:{ordinal:!0},ordinal:{getGroupIntervalFactor:this.getGroupIntervalFactor},ordinal2lin:r.ordinal2lin,getIndexOfPoint:r.getIndexOfPoint,val2lin:r.val2lin}).ordinal.axis=t,s.series.forEach(function(s){(d={xAxis:t,xData:s.xData.slice(),chart:n,groupPixelWidth:s.groupPixelWidth,destroyGroupedData:i.noop,getProcessedData:e.prototype.getProcessedData,applyGrouping:e.prototype.applyGrouping,reserveSpace:e.prototype.reserveSpace,visible:s.visible}).xData=d.xData.concat(o.getOverscrollPositions()),d.options={dataGrouping:a?{firstAnchor:"firstPoint",anchor:"middle",lastAnchor:"lastPoint",enabled:!0,forced:!0,approximation:"open",units:[[a.unitName,[a.count]]]}:{enabled:!1}},t.series.push(d),s.processData.apply(d)}),t.applyGrouping({hasExtremesChanged:!0}),d.closestPointRange!==d.basePointRange&&d.currentDataGrouping&&(t.forceOrdinal=!0),s.ordinal.beforeSetTickPositions.apply({axis:t}),u[h]=t.ordinal.positions),u[h]},t.prototype.getGroupIntervalFactor=function(t,i,e){this.axis;var o,s,r=e.processedXData,n=r.length,a=[],h=this.groupIntervalFactor;if(!h){for(s=0;s<n-1;s++)a[s]=r[s+1]-r[s];a.sort(function(t,i){return t-i}),o=a[Math.floor(n/2)],t=Math.max(t,r[0]),i=Math.min(i,r[n-1]),this.groupIntervalFactor=h=n*o/(i-t)}return h},t.prototype.getIndexOfPoint=function(i,e){var o,s=this.axis,r=this.positions?this.positions[0]:0,a=function(t){var i=s.min,e=s.max;return!!(h(i)&&h(e))&&t.points.some(function(t){return t.x>=i&&t.x<=e})};s.series.forEach(function(t){var i,e=null===(i=t.points)||void 0===i?void 0:i[0];h(null==e?void 0:e.plotX)&&(e.plotX<o||!h(o))&&a(t)&&(o=e.plotX)}),null!=o||(o=s.minPixelPadding);var l=s.translationSlope*(this.slope||s.closestPointRange||this.overscrollPointsRange),p=n((i-o)/l);return t.findIndexOf(e,r,!0)+p},t.prototype.getOverscrollPositions=function(){var t=this.axis,i=t.options.overscroll,e=this.overscrollPointsRange,o=[],s=t.dataMax;if(h(e))for(;s<=t.dataMax+i;)o.push(s+=e);return o},t.prototype.postProcessTickInterval=function(t){var i=this.axis,e=this.slope;return e?i.options.breaks?i.closestPointRange||t:t/(e/i.closestPointRange):t},t}();t.Additions=A}(s||(s={})),s}),e(i,"Series/HLC/HLCPoint.js",[i["Core/Series/SeriesRegistry.js"]],function(t){var i,e=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)});return function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.close=void 0,i.high=void 0,i.low=void 0,i.options=void 0,i.plotClose=void 0,i.series=void 0,i}return e(i,t),i}(t.seriesTypes.column.prototype.pointClass)}),e(i,"Series/HLC/HLCSeriesDefaults.js",[],function(){return{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0}}),e(i,"Series/HLC/HLCSeries.js",[i["Series/HLC/HLCPoint.js"],i["Series/HLC/HLCSeriesDefaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o){var s,r=this&&this.__extends||(s=function(t,i){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}s(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),n=e.seriesTypes.column,a=o.extend,h=o.merge,l=function(t){function e(){var i=null!==t&&t.apply(this,arguments)||this;return i.data=void 0,i.options=void 0,i.points=void 0,i.yData=void 0,i}return r(e,t),e.prototype.extendStem=function(t,i,e){var o=t[0],s=t[1];"number"==typeof o[2]&&(o[2]=Math.max(e+i,o[2])),"number"==typeof s[2]&&(s[2]=Math.min(e-i,s[2]))},e.prototype.getPointPath=function(t,i){var e=i.strokeWidth(),o=t.series,s=e%2/2,r=Math.round(t.plotX)-s,n=Math.round(t.shapeArgs.width/2),a=t.plotClose,h=[["M",r,Math.round(t.yBottom)],["L",r,Math.round(t.plotHigh)]];return null!==t.close&&(a=Math.round(t.plotClose)+s,h.push(["M",r,a],["L",r+n,a]),o.extendStem(h,e/2,a)),h},e.prototype.drawSinglePoint=function(t){var i,e=t.series,o=e.chart,s=t.graphic;void 0!==t.plotY&&(s||(t.graphic=s=o.renderer.path().add(e.group)),o.styledMode||s.attr(e.pointAttribs(t,t.selected&&"select")),i=e.getPointPath(t,s),s[s?"animate":"attr"]({d:i}).addClass(t.getClassName(),!0))},e.prototype.drawPoints=function(){this.points.forEach(this.drawSinglePoint)},e.prototype.init=function(){t.prototype.init.apply(this,arguments),this.options.stacking=void 0},e.prototype.pointAttribs=function(i,e){var o=t.prototype.pointAttribs.call(this,i,e);return delete o.fill,o},e.prototype.toYData=function(t){return[t.high,t.low,t.close]},e.prototype.translate=function(){var i=this,e=i.yAxis,o=this.pointArrayMap&&this.pointArrayMap.slice()||[],s=o.map(function(t){return"plot".concat(t.charAt(0).toUpperCase()+t.slice(1))});s.push("yBottom"),o.push("low"),t.prototype.translate.apply(i),i.points.forEach(function(t){o.forEach(function(o,r){var n=t[o];null!==n&&(i.dataModify&&(n=i.dataModify.modifyValue(n)),t[s[r]]=e.toPixels(n,!0))}),t.tooltipPos[1]=t.plotHigh+e.pos-i.chart.plotTop})},e.defaultOptions=h(n.defaultOptions,i),e}(n);return a(l.prototype,{pointClass:t,animate:null,directTouch:!1,pointArrayMap:["high","low","close"],pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},pointValKey:"close"}),e.registerSeriesType("hlc",l),l}),e(i,"Series/OHLC/OHLCPoint.js",[i["Core/Series/SeriesRegistry.js"]],function(t){var i,e=this&&this.__extends||(i=function(t,e){return(i=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,e)},function(t,e){if("function"!=typeof e&&null!==e)throw TypeError("Class extends value "+String(e)+" is not a constructor or null");function o(){this.constructor=t}i(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)});return function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.open=void 0,i.options=void 0,i.plotOpen=void 0,i.series=void 0,i}return e(i,t),i.prototype.getClassName=function(){return t.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":" highcharts-point-down")},i.prototype.resolveUpColor=function(){this.open<this.close&&!this.options.color&&this.series.options.upColor&&(this.color=this.series.options.upColor)},i.prototype.resolveColor=function(){t.prototype.resolveColor.call(this),this.resolveUpColor()},i.prototype.getZone=function(){var i=t.prototype.getZone.call(this);return this.resolveUpColor(),i},i.prototype.applyOptions=function(){return t.prototype.applyOptions.apply(this,arguments),this.resolveColor&&this.resolveColor(),this},i}(t.seriesTypes.hlc.prototype.pointClass)}),e(i,"Series/OHLC/OHLCSeriesDefaults.js",[],function(){return{tooltip:{pointFormat:'<span style="color:{point.color}">●</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'}}}),e(i,"Series/OHLC/OHLCSeries.js",[i["Series/OHLC/OHLCPoint.js"],i["Series/OHLC/OHLCSeriesDefaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o){var s,r=this&&this.__extends||(s=function(t,i){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}s(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),n=e.seriesTypes.hlc,a=o.addEvent,h=o.extend,l=o.merge,p=[];function d(t){var i=t.options,e=i.dataGrouping;e&&i.useOhlcData&&"highcharts-navigator-series"!==i.id&&(e.approximation="ohlc")}function u(t){var i=t.options;i.useOhlcData&&"highcharts-navigator-series"!==i.id&&h(this,{pointValKey:c.prototype.pointValKey,pointArrayMap:c.prototype.pointArrayMap,toYData:c.prototype.toYData})}var c=function(t){function e(){var i=null!==t&&t.apply(this,arguments)||this;return i.data=void 0,i.options=void 0,i.points=void 0,i}return r(e,t),e.compose=function(t){for(var i=[],e=1;e<arguments.length;e++)i[e-1]=arguments[e];o.pushUnique(p,t)&&(a(t,"afterSetOptions",d),a(t,"init",u))},e.prototype.getPointPath=function(i,e){var o=t.prototype.getPointPath.call(this,i,e),s=e.strokeWidth(),r=s%2/2,n=Math.round(i.plotX)-r,a=Math.round(i.shapeArgs.width/2),h=i.plotOpen;return null!==i.open&&(h=Math.round(i.plotOpen)+r,o.push(["M",n,h],["L",n-a,h]),t.prototype.extendStem.call(this,o,s/2,h)),o},e.prototype.pointAttribs=function(i,e){var o=t.prototype.pointAttribs.call(this,i,e),s=this.options;return delete o.fill,!i.options.color&&s.upColor&&i.open<i.close&&(o.stroke=s.upColor),o},e.prototype.toYData=function(t){return[t.open,t.high,t.low,t.close]},e.defaultOptions=l(n.defaultOptions,i),e}(n);return h(c.prototype,{pointClass:t,pointArrayMap:["open","high","low","close"]}),e.registerSeriesType("ohlc",c),c}),e(i,"Series/Candlestick/CandlestickSeriesDefaults.js",[i["Core/Defaults.js"],i["Core/Utilities.js"]],function(t,i){return t.defaultOptions,i.merge,{states:{hover:{lineWidth:2}},threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}}),e(i,"Series/Candlestick/CandlestickSeries.js",[i["Series/Candlestick/CandlestickSeriesDefaults.js"],i["Core/Defaults.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i,e,o){var s,r=this&&this.__extends||(s=function(t,i){return(s=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}s(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),n=i.defaultOptions,a=e.seriesTypes,h=a.column,l=a.ohlc,p=o.merge,d=function(i){function e(){var t=null!==i&&i.apply(this,arguments)||this;return t.data=void 0,t.options=void 0,t.points=void 0,t}return r(e,i),e.prototype.pointAttribs=function(t,i){var e=h.prototype.pointAttribs.call(this,t,i),o=this.options,s=t.open<t.close,r=o.lineColor||this.color,n=t.color||this.color;if(e["stroke-width"]=o.lineWidth,e.fill=t.options.color||s&&o.upColor||n,e.stroke=t.options.lineColor||s&&o.upLineColor||r,i){var a=o.states[i];e.fill=a.color||e.fill,e.stroke=a.lineColor||e.stroke,e["stroke-width"]=a.lineWidth||e["stroke-width"]}return e},e.prototype.drawPoints=function(){for(var t=this.points,i=this.chart,e=this.yAxis.reversed,o=0;o<t.length;o++){var s=t[o],r=s.graphic,n=void 0,a=void 0,h=void 0,l=void 0,p=void 0,d=void 0,u=void 0,c=void 0,f=void 0,g=void 0,v=!r;void 0!==s.plotY&&(r||(s.graphic=r=i.renderer.path().add(this.group)),this.chart.styledMode||r.attr(this.pointAttribs(s,s.selected&&"select")).shadow(this.options.shadow),u=r.strokeWidth()%2/2,c=Math.round(s.plotX)-u,h=Math.min(n=s.plotOpen,a=s.plotClose),l=Math.max(n,a),g=Math.round(s.shapeArgs.width/2),p=e?l!==s.yBottom:Math.round(h)!==Math.round(s.plotHigh),d=e?Math.round(h)!==Math.round(s.plotHigh):l!==s.yBottom,h=Math.round(h)+u,l=Math.round(l)+u,(f=[]).push(["M",c-g,l],["L",c-g,h],["L",c+g,h],["L",c+g,l],["Z"],["M",c,h],["L",c,p?Math.round(e?s.yBottom:s.plotHigh):h],["M",c,l],["L",c,d?Math.round(e?s.plotHigh:s.yBottom):l]),r[v?"attr":"animate"]({d:f}).addClass(s.getClassName(),!0))}},e.defaultOptions=p(l.defaultOptions,n.plotOptions,{tooltip:l.defaultOptions.tooltip},t),e}(l);return e.registerSeriesType("candlestick",d),d}),e(i,"Series/Flags/FlagsPoint.js",[i["Core/Series/SeriesRegistry.js"],i["Core/Utilities.js"]],function(t,i){var e,o=this&&this.__extends||(e=function(t,i){return(e=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function o(){this.constructor=t}e(t,i),t.prototype=null===i?Object.create(i):(o.prototype=i.prototype,new o)}),s=t.seriesTypes.column.prototype.pointClass,r=i.isNumber;return function(t){function i(){var i=null!==t&&t.apply(this,arguments)||this;return i.options=void 0,i.series=void 0,i.ttBelow=!1,i}return o(i,t),i.prototype.isValid=function(){return r(this.y)||void 0===this.y},i.prototype.hasNewShapeType=function(){var t=this.options.shape||this.series.options.shape;return this.graphic&&t&&t!==this.graphic.symbolKey},i}(s)}),e(i,"Series/Flags/FlagsSeriesDefaults.js",[],function(){return{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",tooltip:{pointFormat:"{point.text}"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd3ff"}},style:{fontSize:"0.7em",fontWeight:"bold"}}}),e(i,"Series/Flags/FlagsSymbols.js",[i["Core/Renderer/RendererRegistry.js"]],function(t){var i;return function(i){var e=[];function o(t,i,e,o,s){var r=s&&s.anchorX||t,n=s&&s.anchorY||i,a=this.circle(r-1,n-1,2,2);return a.push(["M",r,n],["L",t,i+o],["L",t,i],["L",t+e,i],["L",t+e,i+o],["L",t,i+o],["Z"]),a}function s(t,i){t[i+"pin"]=function(e,o,s,r,n){var a,h=n&&n.anchorX,l=n&&n.anchorY;if("circle"===i&&r>s&&(e-=Math.round((r-s)/2),s=r),a=t[i](e,o,s,r),h&&l){var p=h;if("circle"===i)p=e+s/2;else{var d=a[0],u=a[1];"M"===d[0]&&"L"===u[0]&&(p=(d[1]+u[1])/2)}var c=o>l?o:o+r;a.push(["M",p,c],["L",h,l]),a=a.concat(t.circle(h-1,l-1,2,2))}return a}}i.compose=function(i){if(-1===e.indexOf(i)){e.push(i);var r=i.prototype.symbols;r.flag=o,s(r,"circle"),s(r,"square")}var n=t.getRendererType();e.indexOf(n)&&e.push(n)}}(i||(i={})),i}),e(i,"Series/OnSeriesComposition.js",[i["Series/Column/ColumnSeries.js"],i["Core/Series/Series.js"],i["Core/Utilities.js"]],function(t,i,e){var o,s=t.prototype,r=i.prototype,n=e.defined,a=e.stableSort;return function(t){var i=[];function o(t){return r.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,t)}function h(){s.translate.apply(this);var t,i,e,o,r,h,l,p,d,u=this,c=u.options,f=u.chart,g=u.points,v=c.onSeries,x=v&&f.get(v),m=x&&x.options.step,y=x&&x.points,b=f.inverted,M=u.xAxis,S=u.yAxis,A=g.length-1,k=c.onKey||"y",C=y&&y.length,w=0;if(x&&x.visible&&C)for(w=(x.pointXOffset||0)+(x.barW||0)/2,p=x.currentDataGrouping,h=y[C-1].x+(p?p.totalRange:0),a(g,function(t,i){return t.x-i.x}),k="plot"+k[0].toUpperCase()+k.substr(1);C--&&g[A]&&"break"!==function(){if(r=y[C],(e=g[A]).y=r.y,r.x<=e.x&&void 0!==r[k]){if(e.x<=h&&(e.plotY=r[k],r.x<e.x&&!m&&(l=y[C+1])&&void 0!==l[k])){if(n(e.plotX)&&x.is("spline")){for(var o=[r.plotX||0,r.plotY||0],s=[l.plotX||0,l.plotY||0],a=(null===(t=r.controlPoints)||void 0===t?void 0:t.high)||o,p=(null===(i=l.controlPoints)||void 0===i?void 0:i.low)||s,u=function(t,i){return Math.pow(1-t,3)*o[i]+3*(1-t)*(1-t)*t*a[i]+3*(1-t)*t*t*p[i]+t*t*t*s[i]},c=0,f=1,v=void 0,b=0;b<100;b++){var M=(c+f)/2,w=u(M,0);if(null===w)break;if(.25>Math.abs(w-e.plotX)){v=M;break}w<e.plotX?c=M:f=M}n(v)&&(e.plotY=u(v,1),e.y=S.toValue(e.plotY,!0))}else d=(e.x-r.x)/(l.x-r.x),e.plotY+=d*(l[k]-r[k]),e.y+=d*(l.y-r.y)}if(A--,C++,A<0)return"break"}}(););g.forEach(function(t,i){var e;t.plotX+=w,(void 0===t.plotY||b)&&(t.plotX>=0&&t.plotX<=M.len?b?(t.plotY=M.translate(t.x,0,1,0,1),t.plotX=n(t.y)?S.translate(t.y,0,0,0,1):0):t.plotY=(M.opposite?0:u.yAxis.len)+M.offset:t.shapeArgs={}),(o=g[i-1])&&o.plotX===t.plotX&&(void 0===o.stackIndex&&(o.stackIndex=0),e=o.stackIndex+1),t.stackIndex=e}),this.onSeries=x}t.compose=function(t){if(e.pushUnique(i,t)){var s=t.prototype;s.getPlotBox=o,s.translate=h}return t},t.getPlotBox=o,t.translate=h}(o||(o={})),o}),e(i,"Series/Flags/FlagsSeries.js",[i["Series/Flags/FlagsPoint.js"],i["Series/Flags/FlagsSeriesDefaults.js"],i["Series/Flags/FlagsSymbols.js"],i["Core/Globals.js"],i["Series/OnSeriesComposition.js"],i["Core/Renderer/RendererUtilities.js"],i["Core/Series/SeriesRegistry.js"],i["Core/Renderer/SVG/SVGElement.js"],i["Core/Utilities.js"]],function(t,i,e,o,s,r,n,a,h){var l,p=this&&this.__extends||(l=function(t,i){return(l=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}l(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),d=o.noop,u=r.distribute,c=n.series,f=n.seriesTypes.column,g=h.addEvent,v=h.defined,x=h.extend,m=h.merge,y=h.objectEach,b=h.wrap,M=function(t){function o(){var i=null!==t&&t.apply(this,arguments)||this;return i.data=void 0,i.options=void 0,i.points=void 0,i}return p(o,t),o.prototype.animate=function(t){t&&this.setClip()},o.prototype.drawPoints=function(){var t,i,e,o,s,r,n,h,l,p,d,c=this.points,f=this.chart,g=f.renderer,x=f.inverted,M=this.options,S=M.y,A=this.yAxis,k={},C=[];for(o=c.length;o--;)s=c[o],p=(x?s.plotY:s.plotX)>this.xAxis.len,t=s.plotX,n=s.stackIndex,e=s.options.shape||M.shape,void 0!==(i=s.plotY)&&(i=s.plotY+S-(void 0!==n&&n*M.stackDistance)),s.anchorX=n?void 0:s.plotX,h=n?void 0:s.plotY,d="flag"!==e,r=s.graphic,void 0!==i&&t>=0&&!p?(r&&s.hasNewShapeType()&&(r=r.destroy()),r||(r=s.graphic=g.label("",null,null,e,null,null,M.useHTML).addClass("highcharts-point").add(this.markerGroup),s.graphic.div&&(s.graphic.div.point=s),r.isNew=!0),r.attr({align:d?"center":"left",width:M.width,height:M.height,"text-align":M.textAlign}),f.styledMode||r.attr(this.pointAttribs(s)).css(m(M.style,s.style)).shadow(M.shadow),t>0&&(t-=r.strokeWidth()%2),l={y:i,anchorY:h},M.allowOverlapX&&(l.x=t,l.anchorX=s.anchorX),r.attr({text:s.options.title||M.title||"A"})[r.isNew?"attr":"animate"](l),M.allowOverlapX||(k[s.plotX]?k[s.plotX].size=Math.max(k[s.plotX].size,r.width||0):k[s.plotX]={align:d?.5:0,size:r.width||0,target:t,anchorX:t}),s.tooltipPos=[t,i+A.pos-f.plotTop]):r&&(s.graphic=r.destroy());if(!M.allowOverlapX){var w=100;y(k,function(t){t.plotX=t.anchorX,C.push(t),w=Math.max(t.size,w)}),u(C,x?A.len:this.xAxis.len,w);for(var D=0;D<c.length;D++){var O=c[D],E=O.plotX,T=O.graphic,P=T&&k[E];P&&T&&(v(P.pos)?T[T.isNew?"attr":"animate"]({x:P.pos+(P.align||0)*P.size,anchorX:O.anchorX}).show().isNew=!1:T.hide().isNew=!0)}}M.useHTML&&this.markerGroup&&b(this.markerGroup,"on",function(t){return a.prototype.on.apply(t.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},o.prototype.drawTracker=function(){var i=this.points;t.prototype.drawTracker.call(this);for(var e=function(t){var e=t.graphic;e&&(t.unbindMouseOver&&t.unbindMouseOver(),t.unbindMouseOver=g(e.element,"mouseover",function(){t.stackIndex>0&&!t.raised&&(t._y=e.y,e.attr({y:t._y-8}),t.raised=!0);for(var o=0;o<i.length;o++){var s=i[o];s!==t&&s.raised&&s.graphic&&(s.graphic.attr({y:s._y}),s.raised=!1)}}))},o=0;o<i.length;o++)e(i[o])},o.prototype.pointAttribs=function(t,i){var e=this.options,o=t&&t.color||this.color,s=e.lineColor,r=t&&t.lineWidth,n=t&&t.fillColor||e.fillColor;return i&&(n=e.states[i].fillColor,s=e.states[i].lineColor,r=e.states[i].lineWidth),{fill:n||o,stroke:s||o,"stroke-width":r||e.lineWidth||0}},o.prototype.setClip=function(){c.prototype.setClip.apply(this,arguments),!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup&&this.markerGroup.clip(this.chart.sharedClips[this.sharedClipKey])},o.compose=e.compose,o.defaultOptions=m(f.defaultOptions,i),o}(f);return s.compose(M),x(M.prototype,{allowDG:!1,forceCrop:!0,invertible:!1,noSharedTooltip:!0,pointClass:t,sorted:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],buildKDTree:d,init:c.prototype.init}),n.registerSeriesType("flags",M),M}),e(i,"Core/Chart/StockChart.js",[i["Core/Chart/Chart.js"],i["Core/Templating.js"],i["Core/Defaults.js"],i["Stock/Navigator/NavigatorDefaults.js"],i["Stock/RangeSelector/RangeSelectorDefaults.js"],i["Stock/Scrollbar/ScrollbarDefaults.js"],i["Core/Utilities.js"]],function(t,i,e,o,s,r,n){var a,h=this&&this.__extends||(a=function(t,i){return(a=Object.setPrototypeOf||({__proto__:[]})instanceof Array&&function(t,i){t.__proto__=i}||function(t,i){for(var e in i)Object.prototype.hasOwnProperty.call(i,e)&&(t[e]=i[e])})(t,i)},function(t,i){if("function"!=typeof i&&null!==i)throw TypeError("Class extends value "+String(i)+" is not a constructor or null");function e(){this.constructor=t}a(t,i),t.prototype=null===i?Object.create(i):(e.prototype=i.prototype,new e)}),l=i.format,p=e.getOptions,d=n.addEvent,u=n.clamp,c=n.defined,f=n.extend,g=n.find,v=n.isNumber,x=n.isString,m=n.merge,y=n.pick,b=n.pushUnique,M=n.splat;function S(t,i){return"xAxis"===t?{minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0}:"yAxis"===t?{labels:{y:-2},opposite:y(i.opposite,!0),showLastLabel:!!(i.categories||"category"===i.type),title:{text:null}}:{}}function A(t,i){if("xAxis"===t){var e=y(i.navigator&&i.navigator.enabled,o.enabled,!0),s={type:"datetime",categories:void 0};return e&&(s.startOnTick=!1,s.endOnTick=!1),s}return{}}var k=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return h(i,t),i.prototype.init=function(i,e){var n=p(),a=i.xAxis,h=i.yAxis,l=y(i.navigator&&i.navigator.enabled,o.enabled,!0);i.xAxis=i.yAxis=void 0;var d=m({chart:{panning:{enabled:!0,type:"x"},zooming:{pinchType:"x",mouseWheel:{type:"x"}}},navigator:{enabled:l},scrollbar:{enabled:y(r.enabled,!0)},rangeSelector:{enabled:y(s.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:y(n.tooltip&&n.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},i,{isStock:!0});i.xAxis=a,i.yAxis=h,d.xAxis=M(i.xAxis||{}).map(function(t,e){return m(S("xAxis",t),n.xAxis,n.xAxis&&n.xAxis[e],t,A("xAxis",i))}),d.yAxis=M(i.yAxis||{}).map(function(t,i){return m(S("yAxis",t),n.yAxis,n.yAxis&&n.yAxis[i],t)}),t.prototype.init.call(this,d,e)},i.prototype.createAxis=function(i,e){return e.axis=m(S(i,e.axis),e.axis,A(i,this.userOptions)),t.prototype.createAxis.call(this,i,e)},i}(t);return d(t,"update",function(t){var i=t.options;"scrollbar"in i&&this.navigator&&(m(!0,this.options.scrollbar,i.scrollbar),this.navigator.update({}),delete i.scrollbar)}),function(t){var i=[];function e(t){if(this.crosshair&&this.crosshair.label&&this.crosshair.label.enabled&&this.cross&&v(this.min)&&v(this.max)){var i,e,o,s=this.chart,r=this.logarithmic,n=this.crosshair.label,a=this.horiz,h=this.opposite,p=this.left,d=this.top,u=this.width,c="inside"===this.options.tickPosition,g=!1!==this.crosshair.snap,x=t.e||this.cross&&this.cross.e,m=t.point,b=this.crossLabel,M=n.format,S="",A=0,k=this.min,C=this.max;r&&(k=r.lin2log(this.min),C=r.lin2log(this.max));var w=a?"center":h?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";b||(b=this.crossLabel=s.renderer.label("",0,void 0,n.shape||"callout").addClass("highcharts-crosshair-label highcharts-color-"+(m&&m.series?m.series.colorIndex:this.series[0]&&this.series[0].colorIndex)).attr({align:n.align||w,padding:y(n.padding,8),r:y(n.borderRadius,3),zIndex:2}).add(this.labelGroup),s.styledMode||b.attr({fill:n.backgroundColor||m&&m.series&&m.series.color||"#666666",stroke:n.borderColor||"","stroke-width":n.borderWidth||0}).css(f({color:"#ffffff",fontWeight:"normal",fontSize:"0.7em",textAlign:"center"},n.style||{}))),a?(i=g?(m.plotX||0)+p:x.chartX,e=d+(h?0:this.height)):(i=p+this.offset+(h?u:0),e=g?(m.plotY||0)+d:x.chartY),M||n.formatter||(this.dateTime&&(S="%b %d, %Y"),M="{value"+(S?":"+S:"")+"}");var D=g?this.isXAxis?m.x:m.y:this.toValue(a?x.chartX:x.chartY),O=m&&m.series?m.series.isPointInside(m):v(D)&&D>k&&D<C,E="";M?E=l(M,{value:D},s):n.formatter&&v(D)&&(E=n.formatter.call(this,D)),b.attr({text:E,x:i,y:e,visibility:O?"inherit":"hidden"});var T=b.getBBox();!v(b.x)||a||h||(i=b.x-T.width/2),v(b.y)&&(a?(c&&!h||!c&&h)&&(e=b.y-T.height):e=b.y-T.height/2),o=a?{left:p-T.x,right:p+this.width-T.x}:{left:"left"===this.labelAlign?p:0,right:"right"===this.labelAlign?p+this.width:s.chartWidth};var P=b.translateX||0;P<o.left&&(A=o.left-P),P+T.width>=o.right&&(A=-(P+T.width-o.right)),b.attr({x:i+A,y:e,anchorX:a?i:this.opposite?0:s.chartWidth,anchorY:a?this.opposite?s.chartHeight:0:e+T.height/2})}}function o(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())}function s(t){var i=this.chart,e=this.options,o=i._labelPanes=i._labelPanes||{},s=e.labels;if(i.options.isStock&&"yAxis"===this.coll){var r=e.top+","+e.height;!o[r]&&s.enabled&&(15===s.distance&&1===this.side&&(s.distance=0),void 0===s.align&&(s.align="right"),o[r]=this,t.align="right",t.preventDefault())}}function r(){var t=this.chart,i=this.options&&this.options.top+","+this.options.height;i&&t._labelPanes&&t._labelPanes[i]===this&&delete t._labelPanes[i]}function n(t){var i,e,o,s,r,n,a,h=this.isLinked&&!this.series&&this.linkedParent?this.linkedParent.series:this.series,l=this.chart,p=l.renderer,d=this.left,f=this.top,m=[],b=t.translatedValue,M=t.value,S=t.force,A=[];if(l.options.isStock&&!1!==t.acrossPanes&&"xAxis"===this.coll||"yAxis"===this.coll){t.preventDefault(),k="xAxis"===this.coll?"yAxis":"xAxis",A=v(C=this.options[k])?[l[k][C]]:x(C)?[l.get(C)]:h.map(function(t){return t[k]}),r=this.isXAxis?l.yAxis:l.xAxis;for(var k,C,w=0;w<r.length;w++){var D=r[w];if(!c(D.options.id)||-1===D.options.id.indexOf("navigator")){var O=D.isXAxis?"yAxis":"xAxis";this===(c(D.options[O])?l[O][D.options[O]]:l[O][0])&&A.push(D)}}n=A.length?[]:[this.isXAxis?l.yAxis[0]:l.xAxis[0]];for(var E=function(t){-1!==n.indexOf(t)||g(n,function(i){return i.pos===t.pos&&i.len===t.len})||n.push(t)},T=0,P=A;T<P.length;T++){var B=P[T];E(B)}if(v(a=y(b,this.translate(M||0,void 0,void 0,t.old)))){if(this.horiz)for(var j=0;j<n.length;j++){var B=n[j],G=void 0;s=(e=B.pos)+B.len,i=o=Math.round(a+this.transB),"pass"!==S&&(i<d||i>d+this.width)&&(S?i=o=u(i,d,d+this.width):G=!0),G||m.push(["M",i,e],["L",o,s])}else for(var R=0;R<n.length;R++){var B=n[R],G=void 0;o=(i=B.pos)+B.len,e=s=Math.round(f+this.height-a),"pass"!==S&&(e<f||e>f+this.height)&&(S?e=s=u(e,f,f+this.height):G=!0),G||m.push(["M",i,e],["L",o,s])}}t.path=m.length>0?p.crispPolyLine(m,t.lineWidth||1):void 0}}function a(t){if(this.chart.options.isStock){var i=void 0;this.is("column")||this.is("columnrange")?i={borderWidth:0,shadow:!1}:this.is("scatter")||this.is("sma")||(i={marker:{enabled:!1,radius:2}}),i&&(t.plotOptions[this.type]=m(t.plotOptions[this.type],i))}}function h(){var t=this.chart,i=this.options.dataGrouping;return!1!==this.allowDG&&i&&y(i.enabled,t.options.isStock)}function p(t,i){for(var e=0;e<t.length;e+=2){var o=t[e],s=t[e+1];o[1]===s[1]&&(o[1]=s[1]=Math.round(o[1])-i%2/2),o[2]===s[2]&&(o[2]=s[2]=Math.round(o[2])+i%2/2)}return t}t.compose=function(t,l,u){b(i,t)&&(d(t,"afterDrawCrosshair",e),d(t,"afterHideCrosshair",o),d(t,"autoLabelAlign",s),d(t,"destroy",r),d(t,"getPlotLinePath",n)),b(i,l)&&(l.prototype.forceCropping=h,d(l,"setOptions",a)),b(i,u)&&(u.prototype.crispPolyLine=p)},t.stockChart=function(i,e,o){return new t(i,e,o)}}(k||(k={})),k}),e(i,"masters/modules/stock.src.js",[i["Core/Globals.js"],i["Series/DataModifyComposition.js"],i["Stock/Navigator/Navigator.js"],i["Stock/RangeSelector/RangeSelector.js"],i["Stock/Scrollbar/Scrollbar.js"],i["Core/Axis/OrdinalAxis.js"],i["Series/OHLC/OHLCSeries.js"],i["Series/Flags/FlagsSeries.js"],i["Core/Chart/StockChart.js"]],function(t,i,e,o,s,r,n,a,h){t.Navigator=e,t.RangeSelector=o,t.Scrollbar=s,t.StockChart=t.stockChart=h.stockChart,i.compose(t.Series,t.Axis,t.Point),a.compose(t.Renderer),e.compose(t.Axis,t.Chart,t.Series),n.compose(t.Series),r.compose(t.Axis,t.Series,t.Chart),o.compose(t.Axis,t.Chart),s.compose(t.Axis),h.compose(t.Axis,t.Series,t.SVGRenderer)})});//# sourceMappingURL=stock.js.map